#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
/*
 * WriteDuringRead.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/ActorCollection.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/Atomic.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WriteDuringReadWorkload : TestWorkload {
	static constexpr auto NAME = "WriteDuringRead";

	double testDuration, slowModeStart;
	int numOps;
	bool rarelyCommit, adjacentKeys;
	PerfIntCounter transactions, retries;
	std::map<Key, Value> memoryDatabase;
	std::map<Key, Value> lastCommittedDatabase;
	KeyRangeMap<int> changeCount;
	int minNode, nodes;
	double initialKeyDensity;
	AsyncTrigger finished;
	KeyRange conflictRange;
	std::pair<int, int> valueSizeRange;
	int maxClearSize;
	CoalescedKeyRangeMap<bool> addedConflicts;
	bool useSystemKeys;
	std::string keyPrefix;
	int64_t maximumTotalData;
	int64_t maximumDataWritten;

	int64_t dataWritten = 0;

	bool success;
	Database extraDB;
	bool useExtraDB;

	WriteDuringReadWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), success(true) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		slowModeStart = getOption(options, "slowModeStart"_sr, 1000.0);
		numOps = getOption(options, "numOps"_sr, 21);
		rarelyCommit = getOption(options, "rarelyCommit"_sr, false);
		maximumTotalData = getOption(options, "maximumTotalData"_sr, 3e6);
		maximumDataWritten = getOption(options, "maximumDataWritten"_sr, std::numeric_limits<int64_t>::max());
		minNode = getOption(options, "minNode"_sr, 0);
		useSystemKeys = getOption(options, "useSystemKeys"_sr, deterministicRandom()->random01() < 0.5);
		adjacentKeys = deterministicRandom()->random01() < 0.5;
		initialKeyDensity = deterministicRandom()->random01(); // This fraction of keys are present before the first
		                                                       // transaction (and after an unknown result)
		valueSizeRange = std::make_pair(
		    0,
		    std::min<int>(deterministicRandom()->randomInt(0, 4 << deterministicRandom()->randomInt(0, 16)),
		                  CLIENT_KNOBS->VALUE_SIZE_LIMIT * 1.2));
		if (adjacentKeys) {
			nodes = std::min<int64_t>(deterministicRandom()->randomInt(1, 4 << deterministicRandom()->randomInt(0, 14)),
			                          CLIENT_KNOBS->KEY_SIZE_LIMIT * 1.2);
		} else {
			nodes = deterministicRandom()->randomInt(1, 4 << deterministicRandom()->randomInt(0, 20));
		}

		dataWritten = 0;
		int newNodes = std::min<int>(nodes, maximumTotalData / (getKeyForIndex(nodes).size() + valueSizeRange.second));
		minNode = std::max(minNode, nodes - newNodes);
		nodes = newNodes;

		CODE_PROBE(adjacentKeys && (nodes + minNode) > CLIENT_KNOBS->KEY_SIZE_LIMIT,
		           "WriteDuringReadWorkload testing large keys");

		useExtraDB = g_network->isSimulated() && !g_simulator->extraDatabases.empty();
		if (useExtraDB) {
			ASSERT(g_simulator->extraDatabases.size() == 1);
			extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0], wcx.defaultTenant);
			useSystemKeys = false;
		}

		if (useSystemKeys && deterministicRandom()->random01() < 0.5) {
			keyPrefix = "\xff\x01";
		} else {
			keyPrefix = "\x02";
		}

		maxClearSize = 1 << deterministicRandom()->randomInt(0, 20);
		conflictRange = KeyRangeRef("\xfe"_sr, "\xfe\x00"_sr);
		if (clientId == 0)
			TraceEvent("RYWConfiguration")
			    .detail("Nodes", nodes)
			    .detail("InitialKeyDensity", initialKeyDensity)
			    .detail("AdjacentKeys", adjacentKeys)
			    .detail("ValueSizeMin", valueSizeRange.first)
			    .detail("ValueSizeMax", valueSizeRange.second)
			    .detail("MaxClearSize", maxClearSize);
	}

																#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via setupImpl()
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class SetupImplActor>
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class SetupImplActorState {
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	SetupImplActorState(WriteDuringReadWorkload* const& self,Database const& cx) 
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : self(self),
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   cx(cx)
															#line 135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("setupImpl", reinterpret_cast<unsigned long>(this));

	}
	~SetupImplActorState() 
	{
		fdb_probe_actor_destroy("setupImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (self->useSystemKeys && cx->defaultTenant.present() && self->keyPrefix < systemKeys.begin)
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenant(cx.getReference(), cx->defaultTenant.get());
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<SetupImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetupImplActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupImplActor, 0, TenantMapEntry >*>(static_cast<SetupImplActor*>(this)));
															#line 161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupImplActorState();
		static_cast<SetupImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<SetupImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupImplActorState(); static_cast<SetupImplActor*>(this)->destroy(); return 0; }
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<SetupImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupImplActorState();
		static_cast<SetupImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->keyPrefix = entry.prefix.withSuffix(self->keyPrefix).toString();
															#line 201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(TenantMapEntry && entry,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->keyPrefix = entry.prefix.withSuffix(self->keyPrefix).toString();
															#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupImplActor*>(this)->actor_wait_state > 0) static_cast<SetupImplActor*>(this)->actor_wait_state = 0;
		static_cast<SetupImplActor*>(this)->ActorCallback< SetupImplActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< SetupImplActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("setupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupImplActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("setupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupImplActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("setupImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via setupImpl()
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class SetupImplActor final : public Actor<Void>, public ActorCallback< SetupImplActor, 0, TenantMapEntry >, public FastAllocated<SetupImplActor>, public SetupImplActorState<SetupImplActor> {
															#line 299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<SetupImplActor>::operator new;
	using FastAllocated<SetupImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4799595906371850240UL, 14151164285556186880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupImplActor, 0, TenantMapEntry >;
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	SetupImplActor(WriteDuringReadWorkload* const& self,Database const& cx) 
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   SetupImplActorState<SetupImplActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setupImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16982838002940512512UL, 1452700113894795776UL);
		ActorExecutionContextHelper __helper(static_cast<SetupImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setupImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setupImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupImplActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> setupImpl( WriteDuringReadWorkload* const& self, Database const& cx ) {
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new SetupImplActor(self, cx));
															#line 348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Future<Void> setup(Database const& cx) override { return setupImpl(this, cx); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return loadAndRun(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
	}

	Key memoryGetKey(std::map<Key, Value>* db, KeySelector key) const {
		std::map<Key, Value>::iterator iter;
		if (key.orEqual)
			iter = db->upper_bound(key.getKey());
		else
			iter = db->lower_bound(key.getKey());

		int offset = key.offset - 1;
		while (offset > 0) {
			if (iter == db->end())
				return useSystemKeys ? allKeys.end : normalKeys.end;
			++iter;
			--offset;
		}
		while (offset < 0) {
			if (iter == db->begin())
				return allKeys.begin;
			--iter;
			++offset;
		}
		if (iter == db->end())
			return useSystemKeys ? allKeys.end : normalKeys.end;
		return iter->first;
	}

																#line 393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via getKeyAndCompare()
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetKeyAndCompareActor>
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetKeyAndCompareActorState {
															#line 399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetKeyAndCompareActorState(ReadYourWritesTransaction* const& tr,KeySelector const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getKeyAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 179 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGetKey(readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, key);
															#line 183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Key> __when_expr_0 = tr->getKey(key, snapshot);
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyAndCompareActor, 0, Key >*>(static_cast<GetKeyAndCompareActor*>(this)));
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetKeyAndCompareActorState();
				static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetKeyAndCompareActorState();
					static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Key const& _res,int loopDepth) 
	{
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Key res = _res;
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys && res > self->getKeyForIndex(self->nodes))
															#line 526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			res = allKeys.end;
															#line 530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetKeyWrongResult", randomID) .detail("Key", key.getKey()) .detail("Offset", key.offset) .detail("OrEqual", key.orEqual) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes) .detail("DbResult", res);
															#line 197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Key && _res,int loopDepth) 
	{
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Key res = _res;
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys && res > self->getKeyForIndex(self->nodes))
															#line 560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			res = allKeys.end;
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetKeyWrongResult", randomID) .detail("Key", key.getKey()) .detail("Offset", key.offset) .detail("OrEqual", key.orEqual) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes) .detail("DbResult", res);
															#line 197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(_res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyAndCompareActor*>(this)->ActorCallback< GetKeyAndCompareActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector key;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 179 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key memRes;
															#line 681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via getKeyAndCompare()
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetKeyAndCompareActor final : public Actor<Void>, public ActorCallback< GetKeyAndCompareActor, 0, Key >, public FastAllocated<GetKeyAndCompareActor>, public GetKeyAndCompareActorState<GetKeyAndCompareActor> {
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<GetKeyAndCompareActor>::operator new;
	using FastAllocated<GetKeyAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2512818365364440320UL, 911354666584646400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyAndCompareActor, 0, Key >;
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetKeyAndCompareActor(ReadYourWritesTransaction* const& tr,KeySelector const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   GetKeyAndCompareActorState<GetKeyAndCompareActor>(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8149137736939811840UL, 1143147249212726528UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyAndCompareActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getKeyAndCompare( ReadYourWritesTransaction* const& tr, KeySelector const& key, Snapshot const& snapshot, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetKeyAndCompareActor(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 735 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Standalone<VectorRef<KeyValueRef>> memoryGetRange(std::map<Key, Value>* db,
	                                                  KeySelector begin,
	                                                  KeySelector end,
	                                                  GetRangeLimits limit,
	                                                  Reverse reverse) {
		Key beginKey = memoryGetKey(db, begin);
		Key endKey = memoryGetKey(db, end);
		//TraceEvent("WDRGetRange").detail("Begin", beginKey).detail("End", endKey);
		if (beginKey >= endKey)
			return Standalone<VectorRef<KeyValueRef>>();

		auto beginIter = db->lower_bound(beginKey);
		auto endIter = db->lower_bound(endKey);

		Standalone<VectorRef<KeyValueRef>> results;
		if (reverse) {
			loop {
				if (beginIter == endIter || limit.reachedBy(results))
					break;

				--endIter;
				results.push_back_deep(results.arena(), KeyValueRef(endIter->first, endIter->second));
			}
		} else {
			for (; beginIter != endIter && !limit.reachedBy(results); ++beginIter)
				results.push_back_deep(results.arena(), KeyValueRef(beginIter->first, beginIter->second));
		}
		return results;
	}

																#line 770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via getRangeAndCompare()
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetRangeAndCompareActor>
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetRangeAndCompareActorState {
															#line 776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeAndCompareActorState(ReadYourWritesTransaction* const& tr,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limit,Snapshot const& snapshot,Reverse const& reverse,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   begin(begin),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   end(end),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   limit(limit),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   reverse(reverse),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getRangeAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGetRange( readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, begin, end, limit, reverse);
															#line 266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, limit, snapshot, reverse);
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state = 1;
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*>(static_cast<GetRangeAndCompareActor*>(this)));
															#line 832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 862 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 395 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& _res,int loopDepth) 
	{
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		RangeResult res = _res;
															#line 269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		int systemKeyCount = 0;
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		bool resized = false;
															#line 273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!reverse)
															#line 917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				int newSize = std::lower_bound( res.begin(), res.end(), self->getKeyForIndex(self->nodes), KeyValueRef::OrderByKey()) - res.begin();
															#line 279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (newSize != res.size())
															#line 923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res.resize(res.arena(), newSize);
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
			}
			else
			{
															#line 284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				for(;systemKeyCount < res.size();systemKeyCount++) {
															#line 285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (res[systemKeyCount].key < self->getKeyForIndex(self->nodes))
															#line 938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
						break;
					}
				}
															#line 287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (systemKeyCount > 0)
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res = RangeResultRef(VectorRef<KeyValueRef>(&res[systemKeyCount], res.size() - systemKeyCount), true);
															#line 290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
			}
		}
															#line 295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!limit.hasByteLimit() && systemKeyCount == 0)
															#line 957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() != memRes.size())
															#line 961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		else
		{
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() > memRes.size() || (res.size() < memRes.size() && !res.more) || (res.size() == 0 && res.more && !resized))
															#line 999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more) .detail("SystemKeyCount", systemKeyCount);
															#line 360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 1017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more);
															#line 385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && _res,int loopDepth) 
	{
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		RangeResult res = _res;
															#line 269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		int systemKeyCount = 0;
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		bool resized = false;
															#line 273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 1055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!reverse)
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				int newSize = std::lower_bound( res.begin(), res.end(), self->getKeyForIndex(self->nodes), KeyValueRef::OrderByKey()) - res.begin();
															#line 279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (newSize != res.size())
															#line 1065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res.resize(res.arena(), newSize);
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 1071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
			}
			else
			{
															#line 284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				for(;systemKeyCount < res.size();systemKeyCount++) {
															#line 285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (res[systemKeyCount].key < self->getKeyForIndex(self->nodes))
															#line 1080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
						break;
					}
				}
															#line 287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (systemKeyCount > 0)
															#line 1087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res = RangeResultRef(VectorRef<KeyValueRef>(&res[systemKeyCount], res.size() - systemKeyCount), true);
															#line 290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
			}
		}
															#line 295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!limit.hasByteLimit() && systemKeyCount == 0)
															#line 1099 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() != memRes.size())
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 1121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		else
		{
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() > memRes.size() || (res.size() < memRes.size() && !res.more) || (res.size() == 0 && res.more && !resized))
															#line 1141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more) .detail("SystemKeyCount", systemKeyCount);
															#line 360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 1159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more);
															#line 385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 1177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(_res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeAndCompareActor*>(this)->ActorCallback< GetRangeAndCompareActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector begin;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector end;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeLimits limit;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Reverse reverse;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> memRes;
															#line 1286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via getRangeAndCompare()
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetRangeAndCompareActor final : public Actor<Void>, public ActorCallback< GetRangeAndCompareActor, 0, RangeResult >, public FastAllocated<GetRangeAndCompareActor>, public GetRangeAndCompareActorState<GetRangeAndCompareActor> {
															#line 1291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<GetRangeAndCompareActor>::operator new;
	using FastAllocated<GetRangeAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8510371571715624192UL, 12915858247038752768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeAndCompareActor, 0, RangeResult >;
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeAndCompareActor(ReadYourWritesTransaction* const& tr,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limit,Snapshot const& snapshot,Reverse const& reverse,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 1308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeAndCompareActorState<GetRangeAndCompareActor>(tr, begin, end, limit, snapshot, reverse, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17567354558359962368UL, 17800240668702594560UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getRangeAndCompare( ReadYourWritesTransaction* const& tr, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limit, Snapshot const& snapshot, Reverse const& reverse, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetRangeAndCompareActor(tr, begin, end, limit, snapshot, reverse, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 1340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Optional<Value> memoryGet(std::map<Key, Value>* db, Key key) {
		auto iter = db->find(key);
		if (iter == db->end())
			return Optional<Value>();
		else
			return iter->second;
	}

																#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via getAndCompare()
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetAndCompareActor>
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetAndCompareActorState {
															#line 1359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetAndCompareActorState(ReadYourWritesTransaction* const& tr,Key const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 1382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("getAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGet(readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, key);
															#line 425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key, snapshot);
															#line 426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAndCompareActor*>(this)->actor_wait_state = 1;
															#line 426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAndCompareActor, 0, Optional<Value> >*>(static_cast<GetAndCompareActor*>(this)));
															#line 1409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 1439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 441 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetAndCompareActorState();
				static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 1455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetAndCompareActorState();
					static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& res,int loopDepth) 
	{
															#line 427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 1484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetWrongResult", randomID) .detail("Key", key) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes.present() ? memRes.get().size() : -1) .detail("DbResult", res.present() ? res.get().size() : -1) .detail("RywDisable", readYourWritesDisabled);
															#line 435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 1490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && res,int loopDepth) 
	{
															#line 427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 1508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetWrongResult", randomID) .detail("Key", key) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes.present() ? memRes.get().size() : -1) .detail("DbResult", res.present() ? res.get().size() : -1) .detail("RywDisable", readYourWritesDisabled);
															#line 435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 1514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndCompareActor*>(this)->ActorCallback< GetAndCompareActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key key;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Optional<Value> memRes;
															#line 1621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via getAndCompare()
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetAndCompareActor final : public Actor<Void>, public ActorCallback< GetAndCompareActor, 0, Optional<Value> >, public FastAllocated<GetAndCompareActor>, public GetAndCompareActorState<GetAndCompareActor> {
															#line 1626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<GetAndCompareActor>::operator new;
	using FastAllocated<GetAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14915553750433734144UL, 16965226922069044224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAndCompareActor, 0, Optional<Value> >;
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetAndCompareActor(ReadYourWritesTransaction* const& tr,Key const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 1643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   GetAndCompareActorState<GetAndCompareActor>(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6664611363522752512UL, 17833135999407791360UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAndCompareActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getAndCompare( ReadYourWritesTransaction* const& tr, Key const& key, Snapshot const& snapshot, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetAndCompareActor(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 1675 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 1680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via watchAndCompare()
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class WatchAndCompareActor>
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WatchAndCompareActorState {
															#line 1686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WatchAndCompareActorState(ReadYourWritesTransaction* const& tr,Key const& key,bool const& readYourWritesDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 1705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("watchAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~WatchAndCompareActorState() 
	{
		fdb_probe_actor_destroy("watchAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (readYourWritesDisabled)
															#line 1720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchAndCompareActorState();
				static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				changeNum = self->changeCount[key];
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGet(&self->memoryDatabase, key);
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 467 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (1)
															#line 1739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					StrictFuture<Void> __when_expr_0 = tr->watch(key);
															#line 468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (static_cast<WatchAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					StrictFuture<Void> __when_expr_1 = self->finished.onTrigger();
															#line 1749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<WatchAndCompareActor*>(this)->actor_wait_state = 1;
															#line 469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchAndCompareActor, 0, Void >*>(static_cast<WatchAndCompareActor*>(this)));
															#line 478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchAndCompareActor, 1, Void >*>(static_cast<WatchAndCompareActor*>(this)));
															#line 1756 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchAndCompareActorState();
		static_cast<WatchAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 1791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 498 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchAndCompareActorState();
				static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 1807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~WatchAndCompareActorState();
					static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 501 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchAndCompareActorState();
		static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (changeNum == self->changeCount[key])
															#line 1854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Triggered without changing") .detail("Key", key) .detail("Value", changeNum) .detail("DuringCommit", *doingCommit);
															#line 1858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (changeNum == self->changeCount[key])
															#line 1868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Triggered without changing") .detail("Key", key) .detail("Value", changeNum) .detail("DuringCommit", *doingCommit);
															#line 1872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Optional<Value> memRes2 = self->memoryGet(&self->memoryDatabase, key);
															#line 480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (memRes != memRes2)
															#line 1884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Changed without triggering") .detail("Key", key) .detail("Value1", memRes) .detail("Value2", memRes2);
															#line 1888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Optional<Value> memRes2 = self->memoryGet(&self->memoryDatabase, key);
															#line 480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (memRes != memRes2)
															#line 1900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Changed without triggering") .detail("Key", key) .detail("Value1", memRes) .detail("Value2", memRes2);
															#line 1904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchAndCompareActor*>(this)->actor_wait_state > 0) static_cast<WatchAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<WatchAndCompareActor*>(this)->ActorCallback< WatchAndCompareActor, 0, Void >::remove();
		static_cast<WatchAndCompareActor*>(this)->ActorCallback< WatchAndCompareActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchAndCompareActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchAndCompareActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key key;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int changeNum;
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Optional<Value> memRes;
															#line 2049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via watchAndCompare()
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WatchAndCompareActor final : public Actor<Void>, public ActorCallback< WatchAndCompareActor, 0, Void >, public ActorCallback< WatchAndCompareActor, 1, Void >, public FastAllocated<WatchAndCompareActor>, public WatchAndCompareActorState<WatchAndCompareActor> {
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<WatchAndCompareActor>::operator new;
	using FastAllocated<WatchAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9734581527311878912UL, 1006488750579798528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchAndCompareActor, 0, Void >;
friend struct ActorCallback< WatchAndCompareActor, 1, Void >;
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WatchAndCompareActor(ReadYourWritesTransaction* const& tr,Key const& key,bool const& readYourWritesDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 2072 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   WatchAndCompareActorState<WatchAndCompareActor>(tr, key, readYourWritesDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14783106384540347648UL, 12163028697870592000UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchAndCompareActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> watchAndCompare( ReadYourWritesTransaction* const& tr, Key const& key, bool const& readYourWritesDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new WatchAndCompareActor(tr, key, readYourWritesDisabled, self, doingCommit, memLimit));
															#line 2104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 2109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via commitAndUpdateMemory()
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class CommitAndUpdateMemoryActor>
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class CommitAndUpdateMemoryActorState {
															#line 2115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	CommitAndUpdateMemoryActorState(ReadYourWritesTransaction* const& tr,WriteDuringReadWorkload* const& self,bool* const& cancelled,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,bool const& readAheadDisabled,bool const& useBatchPriority,bool* const& doingCommit,double* const& startTime,Key const& timebombStr) 
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   cancelled(cancelled),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readAheadDisabled(readAheadDisabled),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   useBatchPriority(useBatchPriority),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(startTime),
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebombStr(timebombStr)
															#line 2140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this));

	}
	~CommitAndUpdateMemoryActorState() 
	{
		fdb_probe_actor_destroy("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!readYourWritesDisabled && !*cancelled)
															#line 2156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					KeyRangeMap<bool> transactionConflicts;
															#line 520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					tr->getWriteConflicts(&transactionConflicts);
															#line 522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto transactionRanges = transactionConflicts.ranges();
															#line 523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto addedRanges = self->addedConflicts.ranges();
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto transactionIter = transactionRanges.begin();
															#line 525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto addedIter = addedRanges.begin();
															#line 527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					bool failed = false;
															#line 528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					for(;transactionIter != transactionRanges.end() && addedIter != addedRanges.end();) {
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						if (transactionIter->begin() != addedIter->begin() || transactionIter->value() != addedIter->value())
															#line 2176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
						{
															#line 531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent(SevError, "WriteConflictError") .detail("TransactionKey", transactionIter->begin()) .detail("AddedKey", addedIter->begin()) .detail("TransactionVal", transactionIter->value()) .detail("AddedVal", addedIter->value());
															#line 536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							failed = true;
															#line 2182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
						}
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						++transactionIter;
															#line 539 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						++addedIter;
															#line 2188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					}
															#line 542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (transactionIter != transactionRanges.end() || addedIter != addedRanges.end())
															#line 2192 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
															#line 543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						failed = true;
															#line 2196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					}
															#line 546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (failed)
															#line 2200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
															#line 547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						TraceEvent(SevError, "WriteConflictRangeError").log();
															#line 548 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						for(transactionIter = transactionRanges.begin();transactionIter != transactionRanges.end();++transactionIter) {
															#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent("WCRTransaction") .detail("Range", transactionIter.range()) .detail("Value", transactionIter.value());
															#line 2208 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
						}
															#line 554 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						for(addedIter = addedRanges.begin();addedIter != addedRanges.end();++addedIter) {
															#line 555 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent("WCRAdded").detail("Range", addedIter.range()).detail("Value", addedIter.value());
															#line 2214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
						}
					}
				}
															#line 560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				txnSize = tr->getApproximateSize();
															#line 561 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				committedDB = self->memoryDatabase;
															#line 562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*doingCommit = true;
															#line 563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2228 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state = 1;
															#line 563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*>(static_cast<CommitAndUpdateMemoryActor*>(this)));
															#line 2233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 594 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_transaction_cancelled || e.code() == error_code_used_during_commit)
															#line 2263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*cancelled = true;
															#line 2267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_transaction_cancelled)
															#line 2271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(commit_unknown_result(), loopDepth);
															#line 2275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 2279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 600 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), loopDepth);
															#line 2283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*doingCommit = false;
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 566 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 2307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 2311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 2315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 577 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 2319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 2323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 2327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 2331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->addWriteConflictRange(self->conflictRange);
															#line 583 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 584 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*startTime = now();
															#line 586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = committedDB;
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<CommitAndUpdateMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndUpdateMemoryActorState(); static_cast<CommitAndUpdateMemoryActor*>(this)->destroy(); return 0; }
															#line 2351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<CommitAndUpdateMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*doingCommit = false;
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 566 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 2369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 2373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 2377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 577 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 2381 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 2385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 2389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 2393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->addWriteConflictRange(self->conflictRange);
															#line 583 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 584 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*startTime = now();
															#line 586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = committedDB;
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<CommitAndUpdateMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndUpdateMemoryActorState(); static_cast<CommitAndUpdateMemoryActor*>(this)->destroy(); return 0; }
															#line 2413 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<CommitAndUpdateMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state > 0) static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<CommitAndUpdateMemoryActor*>(this)->ActorCallback< CommitAndUpdateMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* cancelled;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readAheadDisabled;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool useBatchPriority;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double* startTime;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key timebombStr;
															#line 560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t txnSize;
															#line 561 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::map<Key, Value> committedDB;
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via commitAndUpdateMemory()
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class CommitAndUpdateMemoryActor final : public Actor<Void>, public ActorCallback< CommitAndUpdateMemoryActor, 0, Void >, public FastAllocated<CommitAndUpdateMemoryActor>, public CommitAndUpdateMemoryActorState<CommitAndUpdateMemoryActor> {
															#line 2525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<CommitAndUpdateMemoryActor>::operator new;
	using FastAllocated<CommitAndUpdateMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5453003930690706432UL, 12316561235095882752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitAndUpdateMemoryActor, 0, Void >;
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	CommitAndUpdateMemoryActor(ReadYourWritesTransaction* const& tr,WriteDuringReadWorkload* const& self,bool* const& cancelled,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,bool const& readAheadDisabled,bool const& useBatchPriority,bool* const& doingCommit,double* const& startTime,Key const& timebombStr) 
															#line 2542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   CommitAndUpdateMemoryActorState<CommitAndUpdateMemoryActor>(tr, self, cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, doingCommit, startTime, timebombStr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4231613749852679424UL, 5657626562256922112UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitAndUpdateMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> commitAndUpdateMemory( ReadYourWritesTransaction* const& tr, WriteDuringReadWorkload* const& self, bool* const& cancelled, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, bool const& readAheadDisabled, bool const& useBatchPriority, bool* const& doingCommit, double* const& startTime, Key const& timebombStr ) {
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new CommitAndUpdateMemoryActor(tr, self, cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, doingCommit, startTime, timebombStr));
															#line 2574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 604 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Value getRandomValue() {
		return Value(
		    std::string(deterministicRandom()->randomInt(valueSizeRange.first, valueSizeRange.second + 1), 'x'));
	}

	// Prevent a write only transaction whose commit was previously cancelled from being reordered after this
	// transaction
																#line 2586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via writeBarrier()
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class WriteBarrierActor>
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WriteBarrierActorState {
															#line 2592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteBarrierActorState(Database const& cx) 
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   tr(cx)
															#line 2601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("writeBarrier", reinterpret_cast<unsigned long>(this));

	}
	~WriteBarrierActorState() 
	{
		fdb_probe_actor_destroy("writeBarrier", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 2616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.addWriteConflictRange(allKeys);
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<WriteBarrierActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteBarrierActor*>(this)->actor_wait_state = 1;
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteBarrierActor, 0, Void >*>(static_cast<WriteBarrierActor*>(this)));
															#line 2658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<WriteBarrierActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteBarrierActor*>(this)->actor_wait_state = 2;
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteBarrierActor, 1, Void >*>(static_cast<WriteBarrierActor*>(this)));
															#line 2687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WriteBarrierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBarrierActorState(); static_cast<WriteBarrierActor*>(this)->destroy(); return 0; }
															#line 2702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<WriteBarrierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WriteBarrierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBarrierActorState(); static_cast<WriteBarrierActor*>(this)->destroy(); return 0; }
															#line 2714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<WriteBarrierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteBarrierActor*>(this)->actor_wait_state > 0) static_cast<WriteBarrierActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBarrierActor*>(this)->ActorCallback< WriteBarrierActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteBarrierActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteBarrierActor*>(this)->actor_wait_state > 0) static_cast<WriteBarrierActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBarrierActor*>(this)->ActorCallback< WriteBarrierActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteBarrierActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Transaction tr;
															#line 2888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via writeBarrier()
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WriteBarrierActor final : public Actor<Void>, public ActorCallback< WriteBarrierActor, 0, Void >, public ActorCallback< WriteBarrierActor, 1, Void >, public FastAllocated<WriteBarrierActor>, public WriteBarrierActorState<WriteBarrierActor> {
															#line 2893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<WriteBarrierActor>::operator new;
	using FastAllocated<WriteBarrierActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7263264148343549184UL, 15393879176392549632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteBarrierActor, 0, Void >;
friend struct ActorCallback< WriteBarrierActor, 1, Void >;
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteBarrierActor(Database const& cx) 
															#line 2911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   WriteBarrierActorState<WriteBarrierActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12408030041787207680UL, 1824477430591930112UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeBarrier");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteBarrierActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteBarrierActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> writeBarrier( Database const& cx ) {
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new WriteBarrierActor(cx));
															#line 2944 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 2949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via loadAndRun()
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class LoadAndRunActor>
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class LoadAndRunActorState {
															#line 2955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	LoadAndRunActorState(Database const& cx,WriteDuringReadWorkload* const& self) 
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(now())
															#line 2966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("loadAndRun", reinterpret_cast<unsigned long>(this));

	}
	~LoadAndRunActorState() 
	{
		fdb_probe_actor_destroy("loadAndRun", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 2981 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadAndRunActorState();
		static_cast<LoadAndRunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->writeBarrier(cx);
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LoadAndRunActor*>(this)->actor_wait_state = 1;
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 0, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i = 0;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		keysPerBatch = std::min<int64_t>(1000, 1 + CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT / 6 / (self->getKeyForIndex(self->nodes).size() + self->valueSizeRange.second));
															#line 638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = std::map<Key, Value>();
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 3033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i = 0;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		keysPerBatch = std::min<int64_t>(1000, 1 + CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT / 6 / (self->getKeyForIndex(self->nodes).size() + self->valueSizeRange.second));
															#line 638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = std::map<Key, Value>();
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 3048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = self->memoryDatabase;
															#line 682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 3136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(i < self->nodes))
															#line 3152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 640 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr = Transaction(cx);
															#line 641 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 3160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i += keysPerBatch;
															#line 3182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (now() - startTime > self->testDuration || self->dataWritten >= self->maximumDataWritten)
															#line 3199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<LoadAndRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadAndRunActorState(); static_cast<LoadAndRunActor*>(this)->destroy(); return 0; }
															#line 3203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<LoadAndRunActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~LoadAndRunActorState();
				static_cast<LoadAndRunActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (self->useSystemKeys)
															#line 3211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 3215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			txnSize = 0;
															#line 649 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (i == 0)
															#line 3221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				tr.clear(normalKeys);
															#line 3225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			int end = std::min(self->nodes, i + keysPerBatch);
															#line 654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.clear(KeyRangeRef(self->getKeyForIndex(i), self->getKeyForIndex(end)));
															#line 655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->memoryDatabase.erase(self->memoryDatabase.lower_bound(self->getKeyForIndex(i)), self->memoryDatabase.lower_bound(self->getKeyForIndex(end)));
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int j = i;j < end;j++) {
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (deterministicRandom()->random01() < self->initialKeyDensity)
															#line 3237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					Key key = self->getKeyForIndex(j);
															#line 661 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (key.size() <= getMaxWriteKeySize(key, false))
															#line 3243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
															#line 662 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						Value value = self->getRandomValue();
															#line 663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						value = value.substr(0, std::min<int>(value.size(), CLIENT_KNOBS->VALUE_SIZE_LIMIT));
															#line 665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						self->memoryDatabase[key] = value;
															#line 666 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						tr.set(key, value);
															#line 667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						int64_t rowSize = key.expectedSize() + value.expectedSize();
															#line 668 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						txnSize += rowSize;
															#line 3257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					}
				}
			}
															#line 672 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 672 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 2;
															#line 672 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 1, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 3307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 3;
															#line 677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 2, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 3327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 3336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(now() - startTime > self->slowModeStart || (g_network->isSimulated() && g_simulator->speedUpSimulation) ? 1.0 : 0.1);
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<LoadAndRunActor*>(this)->actor_wait_state = 4;
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 3, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->randomTransaction( (self->useExtraDB && deterministicRandom()->random01() < 0.5) ? self->extraDB : cx, self, startTime);
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 5;
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 4, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->randomTransaction( (self->useExtraDB && deterministicRandom()->random01() < 0.5) ? self->extraDB : cx, self, startTime);
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 5;
															#line 691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 4, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont2(int loopDepth) 
	{
															#line 700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (now() - startTime > self->testDuration || self->dataWritten >= self->maximumDataWritten)
															#line 3670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!static_cast<LoadAndRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadAndRunActorState(); static_cast<LoadAndRunActor*>(this)->destroy(); return 0; }
															#line 3674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			new (&static_cast<LoadAndRunActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadAndRunActorState();
			static_cast<LoadAndRunActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() != error_code_not_committed)
															#line 3689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 697 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 3693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double startTime;
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int i;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int keysPerBatch;
															#line 640 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Transaction tr;
															#line 648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t txnSize;
															#line 3819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via loadAndRun()
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class LoadAndRunActor final : public Actor<Void>, public ActorCallback< LoadAndRunActor, 0, Void >, public ActorCallback< LoadAndRunActor, 1, Void >, public ActorCallback< LoadAndRunActor, 2, Void >, public ActorCallback< LoadAndRunActor, 3, Void >, public ActorCallback< LoadAndRunActor, 4, Void >, public FastAllocated<LoadAndRunActor>, public LoadAndRunActorState<LoadAndRunActor> {
															#line 3824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<LoadAndRunActor>::operator new;
	using FastAllocated<LoadAndRunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11734805860833311744UL, 13084745042488529408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadAndRunActor, 0, Void >;
friend struct ActorCallback< LoadAndRunActor, 1, Void >;
friend struct ActorCallback< LoadAndRunActor, 2, Void >;
friend struct ActorCallback< LoadAndRunActor, 3, Void >;
friend struct ActorCallback< LoadAndRunActor, 4, Void >;
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	LoadAndRunActor(Database const& cx,WriteDuringReadWorkload* const& self) 
															#line 3845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   LoadAndRunActorState<LoadAndRunActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1948779402819391744UL, 14849708037289523712UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadAndRun");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadAndRunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadAndRunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadAndRunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadAndRunActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LoadAndRunActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> loadAndRun( Database const& cx, WriteDuringReadWorkload* const& self ) {
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new LoadAndRunActor(cx, self));
															#line 3881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Key getRandomKey() { return getKeyForIndex(deterministicRandom()->randomInt(0, nodes)); }

	Key getKeyForIndex(int idx) {
		idx += minNode;
		if (adjacentKeys) {
			return Key(keyPrefix + (idx ? std::string(idx, '\x00') : ""));
		} else {
			return Key(keyPrefix + format("%010d", idx));
		}
	}

	Key versionStampKeyForIndex(int idx) {
		Key result = KeyRef(getKeyForIndex(idx).toString() + std::string(14, '\x00'));
		int32_t pos = deterministicRandom()->randomInt(0, result.size() - 13);
		pos = littleEndian32(pos);
		uint8_t* data = mutateString(result);
		memcpy(data + result.size() - sizeof(int32_t), &pos, sizeof(int32_t));
		return result;
	}

	Key getRandomVersionStampKey() { return versionStampKeyForIndex(deterministicRandom()->randomInt(0, nodes)); }

	KeySelector getRandomKeySelector() {
		int scale = 1 << deterministicRandom()->randomInt(0, 14);
		return KeySelectorRef(
		    getRandomKey(), deterministicRandom()->random01() < 0.5, deterministicRandom()->randomInt(-scale, scale));
	}

	GetRangeLimits getRandomLimits() {
		int kind = deterministicRandom()->randomInt(0, 3);
		return GetRangeLimits(
		    (kind & 1) ? GetRangeLimits::ROW_LIMIT_UNLIMITED
		               : deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(1, 10)),
		    (kind & 2) ? GetRangeLimits::BYTE_LIMIT_UNLIMITED
		               : deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(1, 15)));
	}

	KeyRange getRandomRange(int sizeLimit) {
		int startLocation = deterministicRandom()->randomInt(0, nodes);
		int scale = deterministicRandom()->randomInt(
		    0, deterministicRandom()->randomInt(2, 5) * deterministicRandom()->randomInt(2, 5));
		int endLocation = startLocation + deterministicRandom()->randomInt(
		                                      0, 1 + std::min(sizeLimit, std::min(nodes - startLocation, 1 << scale)));

		return KeyRangeRef(getKeyForIndex(startLocation), getKeyForIndex(endLocation));
	}

	Value applyAtomicOp(Optional<StringRef> existingValue, Value value, MutationRef::Type type) {
		Arena arena;
		if (type == MutationRef::SetValue)
			return value;
		else if (type == MutationRef::AddValue)
			return doLittleEndianAdd(existingValue, value, arena);
		else if (type == MutationRef::AppendIfFits)
			return doAppendIfFits(existingValue, value, arena);
		else if (type == MutationRef::And)
			return doAndV2(existingValue, value, arena);
		else if (type == MutationRef::Or)
			return doOr(existingValue, value, arena);
		else if (type == MutationRef::Xor)
			return doXor(existingValue, value, arena);
		else if (type == MutationRef::Max)
			return doMax(existingValue, value, arena);
		else if (type == MutationRef::Min)
			return doMinV2(existingValue, value, arena);
		else if (type == MutationRef::ByteMin)
			return doByteMin(existingValue, value, arena);
		else if (type == MutationRef::ByteMax)
			return doByteMax(existingValue, value, arena);
		ASSERT(false);
		return Value();
	}

																#line 3959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
// This generated class is to be used only via randomTransaction()
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class RandomTransactionActor>
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class RandomTransactionActorState {
															#line 3965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	RandomTransactionActorState(Database const& cx,WriteDuringReadWorkload* const& self,double const& testStartTime) 
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   testStartTime(testStartTime),
															#line 780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   tr(cx),
															#line 781 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(deterministicRandom()->random01() < 0.5),
															#line 782 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readAheadDisabled(deterministicRandom()->random01() < 0.5),
															#line 783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(deterministicRandom()->random01() < 0.5),
															#line 784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   useBatchPriority(deterministicRandom()->random01() < 0.5),
															#line 785 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebomb((FLOW_KNOBS->MAX_BUGGIFIED_DELAY == 0.0 && deterministicRandom()->random01() < 0.01) ? deterministicRandom()->randomInt64(1, 6000) : 0),
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   operations(),
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   commits(false),
															#line 791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   watches(),
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   changeNum(1),
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(false),
															#line 794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   waitLocation(0),
															#line 795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(now()),
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGetKey(BUGGIFY),
															#line 798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGetRange(BUGGIFY),
															#line 799 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGet(BUGGIFY),
															#line 800 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableCommit(BUGGIFY),
															#line 801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableClearRange(BUGGIFY),
															#line 802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableClear(BUGGIFY),
															#line 803 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableWatch(BUGGIFY),
															#line 804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableWriteConflictRange(BUGGIFY),
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableDelay(BUGGIFY),
															#line 806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableReset(BUGGIFY),
															#line 807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableReadConflictRange(BUGGIFY),
															#line 808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableSet(BUGGIFY),
															#line 809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableAtomicOp(BUGGIFY),
															#line 811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebombStr(makeString(8))
															#line 4030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
	{
		fdb_probe_actor_create("randomTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RandomTransactionActorState() 
	{
		fdb_probe_actor_destroy("randomTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			uint8_t* data = mutateString(timebombStr);
															#line 813 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			memcpy(data, &timebomb, 8);
															#line 815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 4049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomTransactionActorState();
		static_cast<RandomTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = self->lastCommittedDatabase;
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 1104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 4076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RandomTransactionActorState();
		static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (now() - testStartTime > self->testDuration)
															#line 4095 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 4099 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RandomTransactionActorState();
			static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		memLimit = 1e8;
															#line 821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		cancelled = false;
															#line 822 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readYourWritesDisabled)
															#line 4111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 4119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 4123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 4127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 4135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 4139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 4143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
															#line 832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr.setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr.addWriteConflictRange(self->conflictRange);
															#line 834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 4155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		try {
															#line 836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			numWaits = deterministicRandom()->randomInt(1, 5);
															#line 837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			i = 0;
															#line 838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 4163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			operations.clear();
															#line 1074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			commits.clear(false);
															#line 1075 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			waitLocation = 0;
															#line 1076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			watches.clear();
															#line 1077 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->changeCount.insert(allKeys, 0);
															#line 1078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			doingCommit = false;
															#line 1080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_database_locked)
															#line 4210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 1081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->memoryDatabase = self->lastCommittedDatabase;
															#line 1082 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->addedConflicts.insert(allKeys, false);
															#line 1083 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RandomTransactionActorState();
				static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1085 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_not_committed || e.code() == error_code_commit_unknown_result || e.code() == error_code_transaction_too_large || e.code() == error_code_key_too_large || e.code() == error_code_value_too_large || e.code() == error_code_too_many_watches || cancelled)
															#line 4226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 1088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), std::max(0, loopDepth - 1));
															#line 4230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
			try {
															#line 1090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 1090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<RandomTransactionActor*>(this)->actor_wait_state = 7;
															#line 1090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 6, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 1064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(operations);
															#line 1064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 3;
															#line 1064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 2, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(i < numWaits && memLimit > 0))
															#line 4286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		numOps = deterministicRandom()->randomInt(1, self->numOps);
															#line 841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		j = 0;
															#line 842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 4296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (waitLocation < operations.size())
															#line 4318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 1057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			int waitOp = deterministicRandom()->randomInt(waitLocation, operations.size());
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_0 = operations[waitOp];
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RandomTransactionActor*>(this)->actor_wait_state = 1;
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 0, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(j < numOps && memLimit > 0))
															#line 4352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (commits.getResult().isError())
															#line 4358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		{
															#line 844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1loopBody1Catch1(commits.getResult().getError(), std::max(0, loopDepth - 2));
															#line 4362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		try {
															#line 846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			operationType = deterministicRandom()->randomInt(0, 21);
															#line 847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (operationType == 0 && !disableGetKey)
															#line 4369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				operations.push_back( self->getKeyAndCompare(&tr, self->getRandomKeySelector(), Snapshot{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
			else
			{
															#line 857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (operationType == 1 && !disableGetRange)
															#line 4379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					operations.push_back( self->getRangeAndCompare(&tr, self->getRandomKeySelector(), self->getRandomKeySelector(), self->getRandomLimits(), Snapshot{ deterministicRandom()->coinflip() }, Reverse{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
				else
				{
															#line 870 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (operationType == 2 && !disableGet)
															#line 4389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					{
															#line 871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						operations.push_back(self->getAndCompare(&tr, self->getRandomKey(), Snapshot{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
					}
					else
					{
															#line 879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						if (operationType == 3 && !disableCommit)
															#line 4399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
						{
															#line 880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							if (!self->rarelyCommit || deterministicRandom()->random01() < 1.0 / self->numOps)
															#line 4403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
							{
															#line 881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								Future<Void> commit = self->commitAndUpdateMemory(&tr, self, &cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, &doingCommit, &startTime, timebombStr);
															#line 891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								operations.push_back(commit);
															#line 892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								commits.add(commit);
															#line 4411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
							}
						}
						else
						{
															#line 894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							if (operationType == 4 && !disableClearRange)
															#line 4418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
							{
															#line 895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								KeyRange range = self->getRandomRange(self->maxClearSize);
															#line 896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								self->changeCount.insert(range, changeNum++);
															#line 897 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (noConflict)
															#line 4428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								{
															#line 900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								}
															#line 901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								tr.clear(range);
															#line 902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (!noConflict)
															#line 4438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								{
															#line 903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxClearKeySize(range.begin) + 1)), range.end.substr( 0, std::min<int>(range.end.size(), getMaxClearKeySize(range.end) + 1)));
															#line 908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->addedConflicts.insert(conflict, true);
															#line 4444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								}
															#line 910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								self->memoryDatabase.erase(self->memoryDatabase.lower_bound(range.begin), self->memoryDatabase.lower_bound(range.end));
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
							}
							else
							{
															#line 912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (operationType == 5 && !disableClear)
															#line 4454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								{
															#line 913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									Key key = self->getRandomKey();
															#line 914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->changeCount.insert(key, changeNum++);
															#line 915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (noConflict)
															#line 4464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									{
															#line 918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									}
															#line 919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									tr.clear(key);
															#line 920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (!noConflict && key.size() <= getMaxClearKeySize(key))
															#line 4474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									{
															#line 921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										self->addedConflicts.insert(key, true);
															#line 4478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									}
															#line 923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->memoryDatabase.erase(key);
															#line 4482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
								}
								else
								{
															#line 924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (operationType == 6 && !disableWatch)
															#line 4488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									{
															#line 925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										watches.push_back(self->watchAndCompare( &tr, self->getRandomKey(), readYourWritesDisabled, self, &doingCommit, &memLimit));
															#line 4492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
									}
									else
									{
															#line 927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										if (operationType == 7 && !disableWriteConflictRange)
															#line 4498 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
										{
															#line 928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											KeyRange range = self->getRandomRange(self->nodes);
															#line 930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											tr.addWriteConflictRange(range);
															#line 931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxKeySize(range.begin) + 1)), range.end.substr(0, std::min<int>(range.end.size(), getMaxKeySize(range.end) + 1)));
															#line 935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											self->addedConflicts.insert(conflict, true);
															#line 4508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
										}
										else
										{
															#line 936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											if (operationType == 8 && !disableDelay)
															#line 4514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
											{
															#line 937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												double maxTime = 6.0;
															#line 938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												if (timebomb > 0)
															#line 4520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
												{
															#line 939 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													maxTime = startTime + timebomb / 1000.0 - now();
															#line 4524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
												}
															#line 940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												operations.push_back( delay(deterministicRandom()->random01() * deterministicRandom()->random01() * deterministicRandom()->random01() * maxTime));
															#line 4528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
											}
											else
											{
															#line 943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												if (operationType == 9 && !disableReset)
															#line 4534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
												{
															#line 944 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													if (deterministicRandom()->random01() < 0.001)
															#line 4538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
													{
															#line 946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.reset();
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->memoryDatabase = self->lastCommittedDatabase;
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->addedConflicts.insert(allKeys, false);
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (readYourWritesDisabled)
															#line 4548 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														{
															#line 950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 4552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														}
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (snapshotRYWDisabled)
															#line 4556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														{
															#line 952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 4560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														}
															#line 953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (readAheadDisabled)
															#line 4564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														{
															#line 954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 4568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														}
															#line 955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (self->useSystemKeys)
															#line 4572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														{
															#line 956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														}
															#line 957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.addWriteConflictRange(self->conflictRange);
															#line 958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->addedConflicts.insert(self->conflictRange, true);
															#line 959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														startTime = now();
															#line 960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 4586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
													}
												}
												else
												{
															#line 962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													if (operationType == 10 && !disableReadConflictRange)
															#line 4593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
													{
															#line 963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														KeyRange range = self->getRandomRange(self->maxClearSize);
															#line 964 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.addReadConflictRange(range);
															#line 4599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
													}
													else
													{
															#line 965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (operationType == 11 && !disableAtomicOp)
															#line 4605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
														{
															#line 966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															if (!self->useSystemKeys && deterministicRandom()->random01() < 0.01)
															#line 4609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
															{
															#line 967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key versionStampKey = self->getRandomVersionStampKey();
															#line 968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																KeyRangeRef range = getVersionstampKeyRange(versionStampKey.arena(), versionStampKey, tr.getCachedReadVersion(), normalKeys.end);
															#line 973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(range, changeNum++);
															#line 975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.atomicOp(versionStampKey, value, MutationRef::SetVersionstampedKey);
															#line 976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.clear(range);
															#line 977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxClearKeySize(range.begin) + 1)), range.end.substr( 0, std::min<int>(range.end.size(), getMaxClearKeySize(range.end) + 1)));
															#line 982 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->addedConflicts.insert(conflict, true);
															#line 983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase.erase(self->memoryDatabase.lower_bound(range.begin), self->memoryDatabase.lower_bound(range.end));
															#line 4629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
															}
															else
															{
															#line 986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key key = self->getRandomKey();
															#line 987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																MutationRef::Type opType;
															#line 989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																switch (deterministicRandom()->randomInt(0, 8)) { case 0: opType = MutationRef::AddValue; break; case 1: opType = MutationRef::And; break; case 2: opType = MutationRef::Or; break; case 3: opType = MutationRef::Xor; break; case 4: opType = MutationRef::Max; break; case 5: opType = MutationRef::Min; break; case 6: opType = MutationRef::ByteMin; break; case 7: opType = MutationRef::ByteMax; break; };
															#line 1015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(key, changeNum++);
															#line 1016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 1018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (noConflict)
															#line 4647 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																{
															#line 1019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																}
															#line 1020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.atomicOp(key, value, opType);
															#line 1022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (!noConflict && key.size() <= getMaxWriteKeySize(key, self->useSystemKeys))
															#line 4657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																{
															#line 1023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	self->addedConflicts.insert(key, true);
															#line 4661 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																}
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Optional<Value> existing = self->memoryGet(&self->memoryDatabase, key);
															#line 1026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase[key] = self->applyAtomicOp(existing.present() ? Optional<StringRef>(existing.get()) : Optional<StringRef>(), value, opType);
															#line 4667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
															}
														}
														else
														{
															#line 1032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															if (operationType > 11 && !disableSet)
															#line 4674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
															{
															#line 1033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key key = self->getRandomKey();
															#line 1034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 1035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(key, changeNum++);
															#line 1036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 1038 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (noConflict)
															#line 4686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																{
															#line 1039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																}
															#line 1040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.set(key, value);
															#line 1041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (!noConflict && key.size() <= getMaxWriteKeySize(key, self->useSystemKeys))
															#line 4696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																{
															#line 1042 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	self->addedConflicts.insert(key, true);
															#line 4700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
																}
															#line 1045 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase[key] = value;
															#line 4704 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1loopBody1loopBody1loopBody1cont47(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		j++;
															#line 4745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 4755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(doingCommit);
															#line 4759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
			else
			{
															#line 1050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() != error_code_transaction_cancelled)
															#line 4765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				{
															#line 1051 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 2));
															#line 4769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
				}
			}
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont47(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i++;
															#line 4799 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.000001);
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 2;
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 1, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.000001);
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 2;
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 1, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		waitLocation = operations.size();
															#line 4915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		waitLocation = operations.size();
															#line 4924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		ASSERT(timebomb == 0 || 1000 * (now() - startTime) <= timebomb + 1);
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.debug_onIdle();
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 4;
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 3, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		ASSERT(timebomb == 0 || 1000 * (now() - startTime) <= timebomb + 1);
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.debug_onIdle();
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 4;
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 3, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.000001);
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 5;
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 4, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.000001);
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 5;
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 4, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(watches);
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 6;
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 5, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1(Void && _,int loopDepth) 
	{
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(watches);
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 6;
															#line 1069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 5, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->changeCount.insert(allKeys, 0);
															#line 5337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2(Void && _,int loopDepth) 
	{
															#line 1070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->changeCount.insert(allKeys, 0);
															#line 5346 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1098 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = self->lastCommittedDatabase;
															#line 1099 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 5432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_transaction_timed_out)
															#line 5442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			{
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(timebomb != 0 && 1000 * (now() - startTime) >= timebomb - 1);
															#line 1094 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), std::max(0, loopDepth - 1));
															#line 5448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
			}
															#line 1096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double testStartTime;
															#line 780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 781 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 782 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readAheadDisabled;
															#line 783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool useBatchPriority;
															#line 785 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t timebomb;
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::vector<Future<Void>> operations;
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ActorCollection commits;
															#line 791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::vector<Future<Void>> watches;
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int changeNum;
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool doingCommit;
															#line 794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int waitLocation;
															#line 795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double startTime;
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGetKey;
															#line 798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGetRange;
															#line 799 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGet;
															#line 800 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableCommit;
															#line 801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableClearRange;
															#line 802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableClear;
															#line 803 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableWatch;
															#line 804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableWriteConflictRange;
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableDelay;
															#line 806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableReset;
															#line 807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableReadConflictRange;
															#line 808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableSet;
															#line 809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableAtomicOp;
															#line 811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key timebombStr;
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t memLimit;
															#line 821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool cancelled;
															#line 836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int numWaits;
															#line 837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int i;
															#line 840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int numOps;
															#line 841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int j;
															#line 846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int operationType;
															#line 5636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
};
// This generated class is to be used only via randomTransaction()
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class RandomTransactionActor final : public Actor<Void>, public ActorCallback< RandomTransactionActor, 0, Void >, public ActorCallback< RandomTransactionActor, 1, Void >, public ActorCallback< RandomTransactionActor, 2, Void >, public ActorCallback< RandomTransactionActor, 3, Void >, public ActorCallback< RandomTransactionActor, 4, Void >, public ActorCallback< RandomTransactionActor, 5, Void >, public ActorCallback< RandomTransactionActor, 6, Void >, public FastAllocated<RandomTransactionActor>, public RandomTransactionActorState<RandomTransactionActor> {
															#line 5641 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
public:
	using FastAllocated<RandomTransactionActor>::operator new;
	using FastAllocated<RandomTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2727277805083454208UL, 16553826090219246592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomTransactionActor, 0, Void >;
friend struct ActorCallback< RandomTransactionActor, 1, Void >;
friend struct ActorCallback< RandomTransactionActor, 2, Void >;
friend struct ActorCallback< RandomTransactionActor, 3, Void >;
friend struct ActorCallback< RandomTransactionActor, 4, Void >;
friend struct ActorCallback< RandomTransactionActor, 5, Void >;
friend struct ActorCallback< RandomTransactionActor, 6, Void >;
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	RandomTransactionActor(Database const& cx,WriteDuringReadWorkload* const& self,double const& testStartTime) 
															#line 5664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
		 : Actor<Void>(),
		   RandomTransactionActorState<RandomTransactionActor>(cx, self, testStartTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15887765483757040128UL, 8877054762753181952UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RandomTransactionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RandomTransactionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RandomTransactionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RandomTransactionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RandomTransactionActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> randomTransaction( Database const& cx, WriteDuringReadWorkload* const& self, double const& testStartTime ) {
															#line 779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new RandomTransactionActor(cx, self, testStartTime));
															#line 5702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp"
}

#line 1106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
};

WorkloadFactory<WriteDuringReadWorkload> WriteDuringReadWorkloadFactory;
