#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
/*
 * RestoreFromBlob.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/BlobStoreWorkload.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RestoreFromBlobWorkload : TestWorkload {
	double restoreAfter;
	Key backupTag;
	Standalone<StringRef> backupURL;
	WaitForComplete waitForComplete{ false };

	static constexpr auto NAME = "RestoreFromBlob";

	RestoreFromBlobWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		restoreAfter = getOption(options, "restoreAfter"_sr, 10.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		auto backupURLString = getOption(options, "backupURL"_sr, "http://0.0.0.0:10000"_sr).toString();
		auto accessKeyEnvVar = getOption(options, "accessKeyVar"_sr, "BLOB_ACCESS_KEY"_sr).toString();
		auto secretKeyEnvVar = getOption(options, "secretKeyVar"_sr, "BLOB_SECRET_KEY"_sr).toString();
		bool provideKeys = getOption(options, "provideKeys"_sr, false);
		waitForComplete.set(getOption(options, "waitForComplete"_sr, true));
		if (provideKeys) {
			updateBackupURL(backupURLString, accessKeyEnvVar, "<access_key>", secretKeyEnvVar, "<secret_key>");
		}
		backupURL = backupURLString;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

																#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
template <class _startActor>
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
class _startActorState {
															#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	_startActorState(Database const& cx,RestoreFromBlobWorkload* const& self) 
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		 : cx(cx),
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		   self(self),
															#line 57 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		   backupAgent()
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->restoreAfter);
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		config = __config;
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (config.tenantMode == TenantMode::REQUIRED)
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		{
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, getSystemBackupRanges(), self->waitForComplete));
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			addDefaultBackupRanges(restoreRanges);
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, restoreRanges, self->waitForComplete));
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (config.tenantMode == TenantMode::REQUIRED)
															#line 254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		{
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, getSystemBackupRanges(), self->waitForComplete));
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			addDefaultBackupRanges(restoreRanges);
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, restoreRanges, self->waitForComplete));
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when2(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		restoreRanges.push_back_deep(restoreRanges.arena(), normalKeys);
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, restoreRanges, self->waitForComplete));
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		restoreRanges.push_back_deep(restoreRanges.arena(), normalKeys);
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(backupAgent.restore( cx, {}, self->backupTag, self->backupURL, {}, restoreRanges, self->waitForComplete));
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	Database cx;
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	RestoreFromBlobWorkload* self;
															#line 57 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	FileBackupAgent backupAgent;
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	DatabaseConfiguration config;
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 678 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10185604349453712384UL, 937256331660740864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	_startActor(Database const& cx,RestoreFromBlobWorkload* const& self) 
															#line 699 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, RestoreFromBlobWorkload* const& self ) {
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 735 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreFromBlob.actor.g.cpp"
}

#line 77 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreFromBlob.actor.cpp"

	Future<Void> start(Database const& cx) override { return clientId ? Void() : _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<RestoreFromBlobWorkload> RestoreFromBlobWorkloadFactory;
