#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
/*
 * QueuePush.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <vector>

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const int keyBytes = 16;

struct QueuePushWorkload : TestWorkload {
	static constexpr auto NAME = "QueuePush";

	int actorCount, valueBytes;
	double testDuration;
	bool forward;
	std::string valueString;
	Key endingKey, startingKey;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries;
	DDSketch<double> commitLatencies, GRVLatencies;

	QueuePushWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), commitLatencies(), GRVLatencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		actorCount = getOption(options, "actorCount"_sr, 50);

		valueBytes = getOption(options, "valueBytes"_sr, 96);
		valueString = std::string(valueBytes, 'x');

		forward = getOption(options, "forward"_sr, true);

		endingKey = "9999999900000001"_sr;
		startingKey = "0000000000000001"_sr;
	}

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		int writes = transactions.getValue();
		m.emplace_back("Measured Duration", duration, Averaged::True);
		m.emplace_back("Operations/sec", writes / duration, Averaged::False);
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());

		m.emplace_back("Mean GRV Latency (ms)", 1000 * GRVLatencies.mean(), Averaged::True);
		m.emplace_back("Median GRV Latency (ms, averaged)", 1000 * GRVLatencies.median(), Averaged::True);
		m.emplace_back("90% GRV Latency (ms, averaged)", 1000 * GRVLatencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% GRV Latency (ms, averaged)", 1000 * GRVLatencies.percentile(0.98), Averaged::True);

		m.emplace_back("Mean Commit Latency (ms)", 1000 * commitLatencies.mean(), Averaged::True);
		m.emplace_back("Median Commit Latency (ms, averaged)", 1000 * commitLatencies.median(), Averaged::True);
		m.emplace_back("90% Commit Latency (ms, averaged)", 1000 * commitLatencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Commit Latency (ms, averaged)", 1000 * commitLatencies.percentile(0.98), Averaged::True);

		m.emplace_back("Bytes written/sec", (writes * (keyBytes + valueBytes)) / duration, Averaged::False);
	}

	static Key keyForIndex(int base, int offset) { return StringRef(format("%08x%08x", base, offset)); }

	static std::pair<int, int> valuesForKey(KeyRef value) {
		int base, offset;
		ASSERT(value.size() == 16);

		if (sscanf(value.substr(0, 8).toString().c_str(), "%x", &base) &&
		    sscanf(value.substr(8, 8).toString().c_str(), "%x", &offset)) {
			return std::make_pair(base, offset);
		} else
			// SOMEDAY: what should this really be?  Should we rely on exceptions for control flow here?
			throw client_invalid_operation();
	}

																#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
template <class _startActor>
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
class _startActorState {
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
public:
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	_startActorState(Database const& cx,QueuePushWorkload* const& self) 
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		 : cx(cx),
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		   self(self)
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			for(int i = 0;i < self->actorCount;i++) {
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
				self->clients.push_back(self->writeClient(cx, self));
															#line 130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			}
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(waitForAll(self->clients), self->testDuration, Void());
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->clients.clear();
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->clients.clear();
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	Database cx;
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	QueuePushWorkload* self;
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5340717479357033216UL, 10600925719000083712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	_startActor(Database const& cx,QueuePushWorkload* const& self) 
															#line 289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, QueuePushWorkload* const& self ) {
															#line 96 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
}

#line 105 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"

																#line 326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
// This generated class is to be used only via writeClient()
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
template <class WriteClientActor>
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
class WriteClientActorState {
															#line 332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
public:
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	WriteClientActorState(Database const& cx,QueuePushWorkload* const& self) 
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		 : cx(cx),
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		   self(self)
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
	{
		fdb_probe_actor_create("writeClient", reinterpret_cast<unsigned long>(this));

	}
	~WriteClientActorState() 
	{
		fdb_probe_actor_destroy("writeClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			;
															#line 356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteClientActorState();
		static_cast<WriteClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		tr = Transaction(cx);
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		;
															#line 388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		++self->transactions;
															#line 397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			start = now();
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 1;
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 0, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 423 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 5;
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 4, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->GRVLatencies.addSample(now() - start);
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = Key();
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (self->forward)
															#line 484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Key> __when_expr_1 = tr.getKey(lastLessThan(self->endingKey), Snapshot::True);
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 1, Key >*>(static_cast<WriteClientActor*>(this)));
															#line 495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Key> __when_expr_2 = tr.getKey(firstGreaterThan(self->startingKey), Snapshot::True);
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 2, Key >*>(static_cast<WriteClientActor*>(this)));
															#line 509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->GRVLatencies.addSample(now() - start);
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = Key();
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (self->forward)
															#line 523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Key> __when_expr_1 = tr.getKey(lastLessThan(self->endingKey), Snapshot::True);
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 1, Key >*>(static_cast<WriteClientActor*>(this)));
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			StrictFuture<Key> __when_expr_2 = tr.getKey(firstGreaterThan(self->startingKey), Snapshot::True);
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 2, Key >*>(static_cast<WriteClientActor*>(this)));
															#line 548 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		std::pair<int, int> unpacked = valuesForKey(lastKey);
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (self->forward)
															#line 635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			tr.set(keyForIndex(unpacked.first + unpacked.second, deterministicRandom()->randomInt(1, 1000)), StringRef(self->valueString));
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
		else
		{
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			tr.set(keyForIndex(unpacked.first - unpacked.second, deterministicRandom()->randomInt(1, 1000)), StringRef(self->valueString));
															#line 645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		start = now();
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteClientActor*>(this)->actor_wait_state = 4;
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 3, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Key const& _lastKey,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = _lastKey;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (lastKey == StringRef())
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			lastKey = self->startingKey;
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Key && _lastKey,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = _lastKey;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (lastKey == StringRef())
															#line 685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			lastKey = self->startingKey;
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Key const& _lastKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_lastKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Key && _lastKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_lastKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont7(Key const& _lastKey,int loopDepth) 
	{
															#line 125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = _lastKey;
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (!normalKeys.contains(lastKey))
															#line 776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			lastKey = self->endingKey;
															#line 780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Key && _lastKey,int loopDepth) 
	{
															#line 125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		lastKey = _lastKey;
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		if (!normalKeys.contains(lastKey))
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
			lastKey = self->endingKey;
															#line 796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when2(Key const& _lastKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(_lastKey, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when2(Key && _lastKey,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(_lastKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->commitLatencies.addSample(now() - start);
															#line 881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		self->commitLatencies.addSample(now() - start);
															#line 890 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		++self->retries;
															#line 974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
		++self->retries;
															#line 983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	Database cx;
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	QueuePushWorkload* self;
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	Transaction tr;
															#line 111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	double start;
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	Key lastKey;
															#line 1073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
};
// This generated class is to be used only via writeClient()
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
class WriteClientActor final : public Actor<Void>, public ActorCallback< WriteClientActor, 0, Void >, public ActorCallback< WriteClientActor, 1, Key >, public ActorCallback< WriteClientActor, 2, Key >, public ActorCallback< WriteClientActor, 3, Void >, public ActorCallback< WriteClientActor, 4, Void >, public FastAllocated<WriteClientActor>, public WriteClientActorState<WriteClientActor> {
															#line 1078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
public:
	using FastAllocated<WriteClientActor>::operator new;
	using FastAllocated<WriteClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16432850786762921984UL, 3289892623058197760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteClientActor, 0, Void >;
friend struct ActorCallback< WriteClientActor, 1, Key >;
friend struct ActorCallback< WriteClientActor, 2, Key >;
friend struct ActorCallback< WriteClientActor, 3, Void >;
friend struct ActorCallback< WriteClientActor, 4, Void >;
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	WriteClientActor(Database const& cx,QueuePushWorkload* const& self) 
															#line 1099 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
		 : Actor<Void>(),
		   WriteClientActorState<WriteClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4567739696819474176UL, 14335318888042807040UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteClientActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteClientActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
[[nodiscard]] Future<Void> writeClient( Database const& cx, QueuePushWorkload* const& self ) {
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
	return Future<Void>(new WriteClientActor(cx, self));
															#line 1135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/QueuePush.actor.g.cpp"
}

#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/QueuePush.actor.cpp"
};

WorkloadFactory<QueuePushWorkload> QueuePushWorkloadFactory;
