#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
/*
 * MemoryLifetime.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/DeterministicRandom.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MemoryLifetime : KVWorkload {
	static constexpr auto NAME = "MemoryLifetime";
	double testDuration;
	std::vector<Future<Void>> clients;

	std::string valueString;

	MemoryLifetime(WorkloadContext const& wcx) : KVWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		valueString = std::string(maxValueBytes, '.');
	}

	Value randomValue() const {
		return StringRef((uint8_t*)valueString.c_str(),
		                 deterministicRandom()->randomInt(minValueBytes, maxValueBytes + 1));
	}

	KeySelector getRandomKeySelector() const {
		return KeySelectorRef(getRandomKey(),
		                      deterministicRandom()->random01() < 0.5,
		                      deterministicRandom()->randomInt(-nodeCount, nodeCount));
	}

	Standalone<KeyValueRef> operator()(uint64_t n) { return KeyValueRef(keyForIndex(n, false), randomValue()); }

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
template <class _setupActor>
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _setupActorState {
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_setupActorState(Database const& cx,MemoryLifetime* const& self) 
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		 : cx(cx),
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   self(self),
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   loadTime()
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bulkSetup(cx, self, self->nodeCount, loadTime);
															#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Database cx;
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	MemoryLifetime* self;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Promise<double> loadTime;
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9911808863884662016UL, 13439319834085823744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_setupActor(Database const& cx,MemoryLifetime* const& self) 
															#line 249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, MemoryLifetime* const& self ) {
															#line 62 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
}

#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"

																#line 286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
template <class _startActor>
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _startActorState {
															#line 292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_startActorState(Database const& cx,MemoryLifetime* const& self) 
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		 : cx(cx),
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   self(self),
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   startTime(now()),
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   tr(cx),
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   reverse(Reverse::False),
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		   snapshot(Snapshot::False)
															#line 309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			;
															#line 324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			int op = deterministicRandom()->randomInt(0, 4);
															#line 76 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (op == 0)
															#line 357 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			{
															#line 77 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				reverse.set(deterministicRandom()->coinflip());
															#line 78 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_startKey = self->getRandomKey();
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_queryRange = reverse ? KeyRangeRef(normalKeys.begin, keyAfter(getRange_startKey)) : KeyRangeRef(getRange_startKey, normalKeys.end);
															#line 82 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_randomStart = deterministicRandom()->random01();
															#line 83 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				getRange_newValue = self->randomValue();
															#line 84 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				snapshot.set(deterministicRandom()->coinflip());
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (getRange_randomStart)
															#line 373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
				{
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					tr.set(getRange_startKey, getRange_newValue);
															#line 377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
				}
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				if (op == 1)
															#line 395 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
				{
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_startKey = self->getRandomKey();
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_randomStart = deterministicRandom()->random01();
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					get_newValue = self->randomValue();
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					snapshot.set(deterministicRandom()->coinflip());
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (get_randomStart)
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
					{
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						tr.set(get_startKey, get_newValue);
															#line 411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
					}
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_3 = tr.get(get_startKey, snapshot);
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_3.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
					if (op == 2)
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
					{
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_selector = self->getRandomKeySelector();
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_randomStart = deterministicRandom()->random01();
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						getKey_newValue = self->randomValue();
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						snapshot.set(deterministicRandom()->coinflip());
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (getKey_randomStart)
															#line 441 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
						{
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
						}
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						StrictFuture<Key> __when_expr_6 = tr.getKey(getKey_selector, snapshot);
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_6.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Key >*>(static_cast<_startActor*>(this)));
															#line 456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
						if (op == 3)
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
						{
															#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							getAddress_startKey = self->getRandomKey();
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							StrictFuture<Standalone<VectorRef<const char*>>> __when_expr_9 = tr.getAddressesForKey(getAddress_startKey);
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
							if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_9.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
							__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*>(static_cast<_startActor*>(this)));
															#line 476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
							loopDepth = a_body1loopBody1cont18(loopDepth);
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (now() - startTime > self->testDuration)
															#line 528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 91 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.01);
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 555 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __getRange_res1,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getRange_res1 = __getRange_res1;
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __getRange_res1,int loopDepth) 
	{
		getRange_res1 = std::move(__getRange_res1);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getRange_randomStart)
															#line 643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getRange_startKey, getRange_newValue);
															#line 647 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getRange_randomStart)
															#line 667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getRange_startKey, getRange_newValue);
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(getRange_queryRange, GetRangeLimits(4000), snapshot, reverse);
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 95 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(RangeResult const& getRange_res2,int loopDepth) 
	{
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getRange_res1.size() == getRange_res2.size());
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getRange_res1.size();i++) {
															#line 99 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].key != getRange_res2[i].key)
															#line 770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			{
															#line 100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckKeyError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			}
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].value != getRange_res2[i].value)
															#line 780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			{
															#line 110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckValueError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 786 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && getRange_res2,int loopDepth) 
	{
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getRange_res1.size() == getRange_res2.size());
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getRange_res1.size();i++) {
															#line 99 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].key != getRange_res2[i].key)
															#line 801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			{
															#line 100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckKeyError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			}
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			if (getRange_res1[i].value != getRange_res2[i].value)
															#line 811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			{
															#line 110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				TraceEvent(SevError, "MemoryLifetimeCheckValueError") .detail("Key1", printable(getRange_res1[i].key)) .detail("Key2", printable(getRange_res2[i].key)) .detail("Value1", getRange_res1[i].value.size()) .detail("Value2", getRange_res2[i].value.size()) .detail("I", i) .detail("Size", getRange_res2.size());
															#line 117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
				ASSERT(false);
															#line 817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& getRange_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(getRange_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && getRange_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(getRange_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.01);
															#line 130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> const& __get_res1,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		get_res1 = __get_res1;
															#line 927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> && __get_res1,int loopDepth) 
	{
		get_res1 = std::move(__get_res1);
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (get_randomStart)
															#line 1006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(get_startKey, get_newValue);
															#line 1010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr.get(get_startKey, snapshot);
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont13cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 1021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (get_randomStart)
															#line 1030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(get_startKey, get_newValue);
															#line 1034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr.get(get_startKey, snapshot);
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont13cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 1045 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont13cont2(Optional<Value> const& get_res2,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(get_res1 == get_res2);
															#line 1129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont2(Optional<Value> && get_res2,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(get_res1 == get_res2);
															#line 1138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1when1(Optional<Value> const& get_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont2(get_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1when1(Optional<Value> && get_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont2(std::move(get_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(0.01);
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont16when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Key const& __getKey_res1,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getKey_res1 = __getKey_res1;
															#line 1246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Key && __getKey_res1,int loopDepth) 
	{
		getKey_res1 = std::move(__getKey_res1);
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getKey_randomStart)
															#line 1325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 1329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Key> __when_expr_8 = tr.getKey(getKey_selector, snapshot);
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont16cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Key >*>(static_cast<_startActor*>(this)));
															#line 1340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (getKey_randomStart)
															#line 1349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		{
															#line 147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			tr.set(getKey_selector.getKey(), getKey_newValue);
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Key> __when_expr_8 = tr.getKey(getKey_selector, snapshot);
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont16cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Key >*>(static_cast<_startActor*>(this)));
															#line 1364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont16cont2(Key const& getKey_res2,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getKey_res1 == getKey_res2);
															#line 1448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont2(Key && getKey_res2,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		ASSERT(getKey_res1 == getKey_res2);
															#line 1457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1when1(Key const& getKey_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont2(getKey_res2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont16cont1when1(Key && getKey_res2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16cont2(std::move(getKey_res2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(0.01);
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont19when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 1556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4(Standalone<VectorRef<const char*>> const& __getAddress_res1,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		getAddress_res1 = __getAddress_res1;
															#line 1565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Standalone<VectorRef<const char*>> && __getAddress_res1,int loopDepth) 
	{
		getAddress_res1 = std::move(__getAddress_res1);
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Standalone<VectorRef<const char*>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont19cont1(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getAddress_res1.size();i++) {
															#line 159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			ASSERT(NetworkAddress::parseOptional(getAddress_res1[i]).present());
															#line 1646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19cont1(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
		for(int i = 0;i < getAddress_res1.size();i++) {
															#line 159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
			ASSERT(NetworkAddress::parseOptional(getAddress_res1[i]).present());
															#line 1658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Database cx;
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	MemoryLifetime* self;
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	double startTime;
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Reverse reverse;
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Snapshot snapshot;
															#line 78 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getRange_startKey;
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	KeyRange getRange_queryRange;
															#line 82 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool getRange_randomStart;
															#line 83 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value getRange_newValue;
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	RangeResult getRange_res1;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key get_startKey;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool get_randomStart;
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value get_newValue;
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Optional<Value> get_res1;
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	KeySelector getKey_selector;
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	bool getKey_randomStart;
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Value getKey_newValue;
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getKey_res1;
															#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Key getAddress_startKey;
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	Standalone<VectorRef<const char*>> getAddress_res1;
															#line 1881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, RangeResult >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, RangeResult >, public ActorCallback< _startActor, 3, Optional<Value> >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Optional<Value> >, public ActorCallback< _startActor, 6, Key >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Key >, public ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1886 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17433159513746982144UL, 8788887740770670592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, RangeResult >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, RangeResult >;
friend struct ActorCallback< _startActor, 3, Optional<Value> >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Optional<Value> >;
friend struct ActorCallback< _startActor, 6, Key >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Key >;
friend struct ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	_startActor(Database const& cx,MemoryLifetime* const& self) 
															#line 1914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Key >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Key >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Standalone<VectorRef<const char*>> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, MemoryLifetime* const& self ) {
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MemoryLifetime.actor.g.cpp"
}

#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/MemoryLifetime.actor.cpp"
};

WorkloadFactory<MemoryLifetime> MemoryLifetimeWorkloadFactory;
