#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
/*
 * IncrementalBackup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Arena.h"
#include "flow/serialize.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct IncrementalBackupWorkload : TestWorkload {
	static constexpr auto NAME = "IncrementalBackup";

	Standalone<StringRef> backupDir;
	Standalone<StringRef> tag;
	FileBackupAgent backupAgent;
	bool submitOnly;
	bool restoreOnly;
	bool waitForBackup;
	int waitRetries;
	bool stopBackup;
	bool checkBeginVersion;
	bool clearBackupAgentKeys;
	Standalone<StringRef> blobManifestUrl;

	IncrementalBackupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupDir = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
		tag = getOption(options, "tag"_sr, "default"_sr);
		submitOnly = getOption(options, "submitOnly"_sr, false);
		restoreOnly = getOption(options, "restoreOnly"_sr, false);
		waitForBackup = getOption(options, "waitForBackup"_sr, false);
		waitRetries = getOption(options, "waitRetries"_sr, -1);
		stopBackup = getOption(options, "stopBackup"_sr, false);
		checkBeginVersion = getOption(options, "checkBeginVersion"_sr, false);
		clearBackupAgentKeys = getOption(options, "clearBackupAgentKeys"_sr, false);
		blobManifestUrl = getOption(options, "blobManifestUrl"_sr, ""_sr);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId) {
			return Void();
		}
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId) {
			return true;
		}
		return _check(cx, this);
	}

																#line 82 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _checkActor>
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActorState {
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self)
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->waitForBackup)
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 84 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->backupAgent.changePause(cx, false);
															#line 84 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 84 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->stopBackup)
															#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			try {
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				TraceEvent("IBackupDiscontinueBackup").log();
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_10 = self->backupAgent.discontinueBackup(cx, self->tag);
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1when1(__when_expr_10.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 11;
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 10, Void >*>(static_cast<_checkActor*>(this)));
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		v = Version();
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tr = Transaction(cx);
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 91 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(v, tr.getReadVersion());
															#line 91 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 91 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Void >*>(static_cast<_checkActor*>(this)));
															#line 360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries = 0;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		;
															#line 551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 99 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupWaitContainer").log();
															#line 100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 571 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 606 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!backupContainer.isValid())
															#line 625 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckListContainersAttempt").log();
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_4 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, std::vector<std::string> >*>(static_cast<_checkActor*>(this)));
															#line 638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont2(int loopDepth) 
	{
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<bool> __when_expr_5 = backupContainer->exists();
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, bool >*>(static_cast<_checkActor*>(this)));
															#line 734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(int loopDepth) 
	{
															#line 106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (containers.size())
															#line 745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			backupContainer = IBackupContainer::openContainer(containers.front(), {}, {});
															#line 749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont6(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (e)
															#line 838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(5.0);
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 851 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool const& __e,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		e = __e;
															#line 860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(bool && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		tries++;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_7 = backupContainer->describeBackup(true);
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, BackupDescription >*>(static_cast<_checkActor*>(this)));
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupVersionGate") .detail("MaxLogEndVersion", desc.maxLogEnd.present() ? desc.maxLogEnd.get() : invalidVersion) .detail("ContiguousLogEndVersion", desc.contiguousLogEnd.present() ? desc.contiguousLogEnd.get() : invalidVersion) .detail("TargetVersion", v);
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 1072 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(5.0);
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 9;
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 8, Void >*>(static_cast<_checkActor*>(this)));
															#line 1083 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		desc = __desc;
															#line 1097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4loopBody1cont2(int loopDepth) 
	{
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (desc.contiguousLogEnd.get() >= v)
															#line 1176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->waitRetries != -1 && tries > self->waitRetries)
															#line 1182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_9 = delay(5.0);
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Void >*>(static_cast<_checkActor*>(this)));
															#line 1195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont4loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _checkActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont4loopBody1cont5(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _checkActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupDiscontinueBackupException").error(e);
															#line 146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _checkActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 85 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version v;
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction tr;
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	bool e;
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	int tries;
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	BackupDescription desc;
															#line 1535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Void >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, std::vector<std::string> >, public ActorCallback< _checkActor, 5, bool >, public ActorCallback< _checkActor, 6, Void >, public ActorCallback< _checkActor, 7, BackupDescription >, public ActorCallback< _checkActor, 8, Void >, public ActorCallback< _checkActor, 9, Void >, public ActorCallback< _checkActor, 10, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8572334825276227584UL, 8398654921961364736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Void >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, std::vector<std::string> >;
friend struct ActorCallback< _checkActor, 5, bool >;
friend struct ActorCallback< _checkActor, 6, Void >;
friend struct ActorCallback< _checkActor, 7, BackupDescription >;
friend struct ActorCallback< _checkActor, 8, Void >;
friend struct ActorCallback< _checkActor, 9, Void >;
friend struct ActorCallback< _checkActor, 10, Void >;
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_checkActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 1567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, BackupDescription >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _checkActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _checkActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _checkActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
}

#line 153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

																#line 1614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
template <class _startActor>
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActorState {
															#line 1620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActorState(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		 : cx(cx),
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   self(self),
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		   backupRanges()
															#line 1631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 1653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		addDefaultBackupRanges(backupRanges);
															#line 159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->submitOnly)
															#line 1678 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSubmitAttempt").log();
															#line 1682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			try {
															#line 162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				Optional<std::string> blobManifestUrl;
															#line 163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!self->blobManifestUrl.empty())
															#line 1688 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				{
															#line 164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					blobManifestUrl = self->blobManifestUrl.toString();
															#line 1692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				}
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->backupAgent.submitBackup(cx, self->backupDir, {}, 0, 1e8, self->tag.toString(), backupRanges, true, StopWhenDone::False, UsePartitionedLog::False, IncrementalBackupOnly::True, {}, blobManifestUrl);
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		config = __config;
															#line 1723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->restoreOnly)
															#line 1802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (self->clearBackupAgentKeys)
															#line 1806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				clearTr = Transaction(cx);
															#line 191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				;
															#line 1812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				loopDepth = a_body1cont2loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont9(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupSubmitSuccess").log();
															#line 1831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSubmitError").error(e);
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 1843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupContainer = Reference<IBackupContainer>();
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupUID = UID();
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = invalidVersion;
															#line 206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(self->backupAgent.waitBackup( cx, self->tag.toString(), StopWhenDone::False, &backupContainer, &backupUID));
															#line 206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont9when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			clearTr.clear(fileBackupPrefixRange);
															#line 196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = clearTr.commit();
															#line 196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 2024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = clearTr.onError(e);
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 2066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = a_body1cont11loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 208 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (self->checkBeginVersion)
															#line 2277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeys").log();
															#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			;
															#line 2285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = a_body1cont11loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersAttempt").log();
															#line 238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<std::vector<std::string>> __when_expr_8 = IBackupContainer::listContainers(self->backupDir.toString(), {});
															#line 238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, std::vector<std::string> >*>(static_cast<_startActor*>(this)));
															#line 2383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1(int loopDepth) 
	{
		try {
															#line 213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_5 = tr->get(writeRecoveryKey);
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont11loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupReadSystemKeysError").error(e);
															#line 230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (e.code() == error_code_key_not_found)
															#line 2454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
															#line 233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr->onError(e);
															#line 233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 2469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1cont2(int loopDepth) 
	{
															#line 216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_6 = tr->get(snapshotEndVersionKey);
															#line 216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont11loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 2491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Optional<Value> const& __writeFlag,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		writeFlag = __writeFlag;
															#line 2500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(Optional<Value> && __writeFlag,int loopDepth) 
	{
		writeFlag = std::move(__writeFlag);
		loopDepth = a_body1cont11loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11loopBody1cont3(int loopDepth) 
	{
															#line 217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckSpecialKeys") .detail("WriteRecoveryValue", writeFlag.present() ? writeFlag.get().toString() : "N/A") .detail("EndVersionValue", versionValue.present() ? versionValue.get().toString() : "N/A");
															#line 220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!versionValue.present())
															#line 2581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupCheckSpecialKeysFailure").log();
															#line 223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			return a_body1cont11loopBody1Catch1(key_not_found(), loopDepth);
															#line 2587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		}
															#line 225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		beginVersion = BinaryReader::fromStringRef<Version>(versionValue.get(), Unversioned());
															#line 226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupCheckBeginVersion").detail("Version", beginVersion);
															#line 2593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		return a_body1cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11loopBody1cont2when1(Optional<Value> const& __versionValue,int loopDepth) 
	{
															#line 216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		versionValue = __versionValue;
															#line 2602 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1cont2when1(Optional<Value> && __versionValue,int loopDepth) 
	{
		versionValue = std::move(__versionValue);
		loopDepth = a_body1cont11loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
															#line 240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupStartListContainersSuccess") .detail("Size", containers.size()) .detail("First", containers.front());
															#line 243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		backupURL = Key(containers.front());
															#line 245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		for( auto r : backupRanges ) {
															#line 248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (config.tenantMode != TenantMode::REQUIRED || !r.intersects(getSystemBackupRanges()))
															#line 2778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			{
															#line 249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				restoreRange.push_back_deep(restoreRange.arena(), r);
															#line 2782 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			}
			else
			{
															#line 251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef normalKeyRange = r & normalKeys;
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				KeyRangeRef systemKeyRange = r & systemKeys;
															#line 253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!normalKeyRange.empty())
															#line 2792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				{
															#line 254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					restoreRange.push_back_deep(restoreRange.arena(), normalKeyRange);
															#line 2796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				}
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
				if (!systemKeyRange.empty())
															#line 2800 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				{
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
					systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 2804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
				}
			}
		}
															#line 261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (!systemRestoreRange.empty())
															#line 2810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		{
															#line 262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			TraceEvent("IBackupSystemRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			StrictFuture<Void> __when_expr_9 = success(self->backupAgent.restore(cx, cx, "system_restore"_sr, backupURL, {}, systemRestoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion));
															#line 263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		containers = __containers;
															#line 2837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
															#line 280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreAttempt").detail("BeginVersion", beginVersion);
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		StrictFuture<Void> __when_expr_10 = success(self->backupAgent.restore(cx, cx, Key(self->tag.toString()), backupURL, {}, restoreRange, WaitForComplete::True, invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::True, InconsistentSnapshotOnly::False, beginVersion));
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont11(Void const& _,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11(Void && _,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
		TraceEvent("IBackupRestoreSuccess").log();
															#line 3030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Database cx;
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	IncrementalBackupWorkload* self;
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	DatabaseConfiguration config;
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Transaction clearTr;
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	UID backupUID;
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Version beginVersion;
															#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> writeFlag;
															#line 216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Optional<Value> versionValue;
															#line 238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	std::vector<std::string> containers;
															#line 243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Key backupURL;
															#line 245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRange;
															#line 246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRange;
															#line 3140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Optional<Value> >, public ActorCallback< _startActor, 6, Optional<Value> >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, std::vector<std::string> >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17024133765536460032UL, 17656986943432695040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Optional<Value> >;
friend struct ActorCallback< _startActor, 6, Optional<Value> >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, std::vector<std::string> >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	_startActor(Database const& cx,IncrementalBackupWorkload* const& self) 
															#line 3172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, IncrementalBackupWorkload* const& self ) {
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IncrementalBackup.actor.g.cpp"
}

#line 301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/IncrementalBackup.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<IncrementalBackupWorkload> IncrementalBackupWorkloadFactory;
