#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
/*
 * BackupAndParallelRestoreCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/RestoreWorkerInterface.actor.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbserver/RestoreCommon.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define TEST_ABORT_FASTRESTORE 0

// A workload which test the correctness of backup and restore process
struct BackupAndParallelRestoreCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "BackupAndParallelRestoreCorrectness";
	double backupAfter, restoreAfter, abortAndRestartAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag;
	int backupRangesCount, backupRangeLengthMax;
	bool differentialBackup, performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	static int backupAgentRequests;
	LockDB locked{ false };
	bool allowPauses;
	bool shareLogRange;
	UsePartitionedLog usePartitionedLogs{ false };
	Key addPrefix, removePrefix; // Original key will be first applied removePrefix and then applied addPrefix
	// CAVEAT: When removePrefix is used, we must ensure every key in backup have the removePrefix

	std::map<Standalone<KeyRef>, Standalone<ValueRef>> dbKVs;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupAndParallelRestoreCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		backupRangesCount = getOption(options, "backupRangesCount"_sr, 5);
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              deterministicRandom()->random01() < 0.5
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		agentRequest = getOption(options, "simBackupAgents"_sr, true);
		allowPauses = getOption(options, "allowPauses"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);
		usePartitionedLogs.set(getOption(options, "usePartitionedLogs"_sr, deterministicRandom()->coinflip()));
		addPrefix = getOption(options, "addPrefix"_sr, ""_sr);
		removePrefix = getOption(options, "removePrefix"_sr, ""_sr);

		KeyRef beginRange;
		KeyRef endRange;
		UID randomID = nondeterministicRandom()->randomUniqueID();

		// Correctness is not clean for addPrefix feature yet. Uncomment below to enable the test
		// Generate addPrefix
		// if (addPrefix.size() == 0 && removePrefix.size() == 0) {
		// 	if (deterministicRandom()->random01() < 0.5) { // Generate random addPrefix
		// 		int len = deterministicRandom()->randomInt(1, 100);
		// 		std::string randomStr = deterministicRandom()->randomAlphaNumeric(len);
		// 		TraceEvent("BackupAndParallelRestoreCorrectness")
		// 		    .detail("GenerateAddPrefix", randomStr)
		// 		    .detail("Length", len)
		// 		    .detail("StrLen", randomStr.size());
		// 		addPrefix = Key(randomStr);
		// 	}
		// }
		TraceEvent("BackupAndParallelRestoreCorrectness")
		    .detail("AddPrefix", addPrefix)
		    .detail("RemovePrefix", removePrefix);
		ASSERT(addPrefix.size() == 0 && removePrefix.size() == 0);
		// Do not support removePrefix right now because we must ensure all backup keys have the removePrefix
		// otherwise, test will fail because fast restore will simply add the removePrefix to every key in the end.
		ASSERT(removePrefix.size() == 0);

		if (shareLogRange) {
			bool beforePrefix = sharedRandomNumber & 1;
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(normalKeys.begin, "\xfe\xff\xfe"_sr));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc("\x00\x00\x01"_sr), normalKeys.end));
		} else if (backupRangesCount <= 0) {
			backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
		} else {
			// Add backup ranges
			std::set<std::string> rangeEndpoints;
			while (rangeEndpoints.size() < backupRangesCount * 2) {
				rangeEndpoints.insert(deterministicRandom()->randomAlphaNumeric(
				    deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
			}

			// Create ranges from the keys, in order, to prevent overlaps
			std::vector<std::string> sortedEndpoints(rangeEndpoints.begin(), rangeEndpoints.end());
			sort(sortedEndpoints.begin(), sortedEndpoints.end());
			for (auto i = sortedEndpoints.begin(); i != sortedEndpoints.end(); ++i) {
				const std::string& start = *i++;
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(start, *i));

				// Track the added range
				TraceEvent("BARW_BackupCorrectnessRange", randomID)
				    .detail("RangeBegin", (beginRange < endRange) ? printable(beginRange) : printable(endRange))
				    .detail("RangeEnd", (beginRange < endRange) ? printable(endRange) : printable(beginRange));
			}
		}
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		TraceEvent(SevInfo, "BARW_Param").detail("Locked", locked);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupAfter", backupAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("RestoreAfter", restoreAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("PerformRestore", performRestore);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupTag", printable(backupTag).c_str());
		TraceEvent(SevInfo, "BARW_Param").detail("BackupRangesCount", backupRangesCount);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupRangeLengthMax", backupRangeLengthMax);
		TraceEvent(SevInfo, "BARW_Param").detail("AbortAndRestartAfter", abortAndRestartAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("DifferentialBackup", differentialBackup);
		TraceEvent(SevInfo, "BARW_Param").detail("StopDifferentialAfter", stopDifferentialAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("AgentRequest", agentRequest);

		return _start(cx, this);
	}

	bool hasPrefix() const { return addPrefix != ""_sr || removePrefix != ""_sr; }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
// This generated class is to be used only via changePaused()
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
template <class ChangePausedActor>
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class ChangePausedActorState {
															#line 180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	ChangePausedActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		 : cx(cx),
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   backupAgent(backupAgent)
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("changePaused", reinterpret_cast<unsigned long>(this));

	}
	~ChangePausedActorState() 
	{
		fdb_probe_actor_destroy("changePaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			;
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangePausedActorState();
		static_cast<ChangePausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, true);
															#line 174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 1;
															#line 174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 0, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Database cx;
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
};
// This generated class is to be used only via changePaused()
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class ChangePausedActor final : public Actor<Void>, public ActorCallback< ChangePausedActor, 0, Void >, public ActorCallback< ChangePausedActor, 1, Void >, public ActorCallback< ChangePausedActor, 2, Void >, public ActorCallback< ChangePausedActor, 3, Void >, public FastAllocated<ChangePausedActor>, public ChangePausedActorState<ChangePausedActor> {
															#line 663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
	using FastAllocated<ChangePausedActor>::operator new;
	using FastAllocated<ChangePausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9609782571601566464UL, 16054267793653751808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangePausedActor, 0, Void >;
friend struct ActorCallback< ChangePausedActor, 1, Void >;
friend struct ActorCallback< ChangePausedActor, 2, Void >;
friend struct ActorCallback< ChangePausedActor, 3, Void >;
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	ChangePausedActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   ChangePausedActorState<ChangePausedActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5431177707453768448UL, 12966551901980677120UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changePaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangePausedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangePausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangePausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangePausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> changePaused( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	return Future<Void>(new ChangePausedActor(cx, backupAgent));
															#line 718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
}

#line 180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"

																#line 723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
// This generated class is to be used only via statusLoop()
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
template <class StatusLoopActor>
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class StatusLoopActorState {
															#line 729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	StatusLoopActorState(Database const& cx,std::string const& tag) 
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		 : cx(cx),
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   tag(tag),
															#line 182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   agent()
															#line 740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	~StatusLoopActorState() 
	{
		fdb_probe_actor_destroy("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			;
															#line 755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusLoopActorState();
		static_cast<StatusLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_0 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 787 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 0, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::string const& status,int loopDepth) 
	{
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		puts(status.c_str());
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(2.0);
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::string && status,int loopDepth) 
	{
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		puts(status.c_str());
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(2.0);
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::string const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::string && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Database cx;
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	std::string tag;
															#line 182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	FileBackupAgent agent;
															#line 1001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
};
// This generated class is to be used only via statusLoop()
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class StatusLoopActor final : public Actor<Void>, public ActorCallback< StatusLoopActor, 0, std::string >, public ActorCallback< StatusLoopActor, 1, Void >, public FastAllocated<StatusLoopActor>, public StatusLoopActorState<StatusLoopActor> {
															#line 1006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
	using FastAllocated<StatusLoopActor>::operator new;
	using FastAllocated<StatusLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14320929097880300544UL, 5015530884358308608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusLoopActor, 0, std::string >;
friend struct ActorCallback< StatusLoopActor, 1, Void >;
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	StatusLoopActor(Database const& cx,std::string const& tag) 
															#line 1024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   StatusLoopActorState<StatusLoopActor>(cx, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1858547908313483776UL, 2242404897950274816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusLoopActor, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusLoopActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> statusLoop( Database const& cx, std::string const& tag ) {
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	return Future<Void>(new StatusLoopActor(cx, tag));
															#line 1057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
}

#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"

																#line 1062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
// This generated class is to be used only via doBackup()
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
template <class DoBackupActor>
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class DoBackupActorState {
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	DoBackupActorState(BackupAndParallelRestoreCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		 : self(self),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   startDelay(startDelay),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   cx(cx),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   tag(tag),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   backupRanges(backupRanges),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   submitted(submitted),
															#line 198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			try {
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			try {
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		status = statusLoop(cx, tag.toString());
															#line 1287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent->submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), tag.toString(), backupRanges, true, StopWhenDone{ !stopDifferentialDelay }, self->usePartitionedLogs);
															#line 224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 1293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		submitted.send(Void());
															#line 243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (stopDifferentialDelay)
															#line 1444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = stopDifferentialFuture;
															#line 246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_10 = backupAgent->waitBackup(cx, tag.toString(), StopWhenDone::True);
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont9when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 1603 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 1612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 1616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				lastBackupUID = UID();
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 1635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 1667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 1671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				lastBackupUID = UID();
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 1690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitForRestorable", randomID) .detail("Tag", backupTag.tagName) .detail("Result", BackupAgentBase::getStateText(resultWait));
															#line 265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restorable = false;
															#line 266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (lastBackupContainer)
															#line 1836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			fdesc = lastBackupContainer->describeBackup();
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = ready(fdesc);
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont10Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		resultWait = __resultWait;
															#line 1863 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_LastBackupContainer", randomID) .detail("BackupTag", printable(tag)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("LastBackupUID", lastBackupUID) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("Restorable", restorable);
															#line 286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (resultWait == EBackupState::STATE_ABORTED)
															#line 1944 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
		}
		else
		{
															#line 289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (!lastBackupContainer)
															#line 1951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent(SevError, "BARW_MissingBackupContainer", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("WaitStatus", resultWait);
															#line 294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				printf("BackupCorrectnessMissingBackupContainer   tag: %s  status: %s\n", printable(tag).c_str(), BackupAgentBase::getStateText(resultWait));
															#line 1957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			else
			{
															#line 299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (!restorable)
															#line 1963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				{
															#line 300 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					TraceEvent(SevError, "BARW_NotRestorable", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("BackupFolder", lastBackupContainer->getURL()) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					printf("BackupCorrectnessNotRestorable:  tag: %s\n", printable(tag).c_str());
															#line 1969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				}
			}
		}
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (startDelay)
															#line 1975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("Restorable", restorable);
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag.toString());
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont10Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 1999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont10Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont4when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!fdesc.isError())
															#line 2014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			desc = fdesc.get();
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!fdesc.isError())
															#line 2041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			desc = fdesc.get();
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont6(int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 2151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 2162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		statusText = std::string();
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_11 = backupAgent->getStatus(cx, ShowErrors::True, tag.toString());
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 2535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		statusValue = __statusValue;
															#line 2544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont1(std::string const& _statusText,int loopDepth) 
	{
															#line 345 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		statusText = _statusText;
															#line 348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 2627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(std::string && _statusText,int loopDepth) 
	{
															#line 345 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		statusText = _statusText;
															#line 348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 2643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(std::string const& _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(std::string && _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	BackupAndParallelRestoreCorrectnessWorkload* self;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	double startDelay;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Database cx;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key tag;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	double stopDifferentialDelay;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	UID randomID;
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	std::string backupContainer;
															#line 222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> status;
															#line 253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	KeyBackedTag backupTag;
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	UID lastBackupUID;
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	EBackupState resultWait;
															#line 265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	bool restorable;
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<BackupDescription> fdesc;
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	BackupDescription desc;
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	EBackupState statusValue;
															#line 342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	std::string statusText;
															#line 2768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
};
// This generated class is to be used only via doBackup()
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, EBackupState >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, Void >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, EBackupState >, public ActorCallback< DoBackupActor, 11, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 2773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15678192539649578240UL, 17738965275555809536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, EBackupState >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, Void >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, EBackupState >;
friend struct ActorCallback< DoBackupActor, 11, std::string >;
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	DoBackupActor(BackupAndParallelRestoreCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 2801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, EBackupState >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, EBackupState >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupAndParallelRestoreCorrectnessWorkload* const& self, double const& startDelay, FileBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay, Promise<Void> const& submitted ) {
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted));
															#line 2844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
}

#line 355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"

	// This actor attempts to restore the database without clearing the keyspace.
	// TODO: Enable this function in correctness test
																#line 2851 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
// This generated class is to be used only via attemptDirtyRestore()
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
template <class AttemptDirtyRestoreActor>
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class AttemptDirtyRestoreActorState {
															#line 2857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	AttemptDirtyRestoreActorState(BackupAndParallelRestoreCorrectnessWorkload* const& self,Database const& cx,FileBackupAgent* const& backupAgent,Standalone<StringRef> const& lastBackupContainer,UID const& randomID) 
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		 : self(self),
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   cx(cx),
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   lastBackupContainer(lastBackupContainer),
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   randomID(randomID),
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   tr(cx),
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   rowCount(0)
															#line 2876 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("attemptDirtyRestore", reinterpret_cast<unsigned long>(this));

	}
	~AttemptDirtyRestoreActorState() 
	{
		fdb_probe_actor_destroy("attemptDirtyRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			;
															#line 2891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AttemptDirtyRestoreActorState();
		static_cast<AttemptDirtyRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (rowCount > 0)
															#line 2914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
			try {
															#line 379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent(SevError, "MXFastRestore").detail("RestoreFunction", "ShouldChangeToMyOwnRestoreLogic");
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success(backupAgent->restore(cx, cx, self->backupTag, KeyRef(lastBackupContainer), {}, WaitForComplete::True, ::invalidVersion, Verbose::True, normalKeys, Key(), Key(), self->locked));
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 3;
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 2, Void >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 2928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, 1);
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 2963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 2;
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 1, Void >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 3005 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& existingRows,int loopDepth) 
	{
															#line 368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		rowCount = existingRows.size();
															#line 3020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && existingRows,int loopDepth) 
	{
															#line 368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		rowCount = existingRows.size();
															#line 3029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& existingRows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(existingRows, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && existingRows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(existingRows), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!static_cast<AttemptDirtyRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AttemptDirtyRestoreActorState(); static_cast<AttemptDirtyRestoreActor*>(this)->destroy(); return 0; }
															#line 3200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		new (&static_cast<AttemptDirtyRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AttemptDirtyRestoreActorState();
		static_cast<AttemptDirtyRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 395 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_restore_destination_not_empty)
															#line 3219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent(SevError, "BARW_RestoreAllowedOverwrittingDatabase", randomID).log();
															#line 393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(false);
															#line 3241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent(SevError, "BARW_RestoreAllowedOverwrittingDatabase", randomID).log();
															#line 393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(false);
															#line 3252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	BackupAndParallelRestoreCorrectnessWorkload* self;
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Database cx;
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Standalone<StringRef> lastBackupContainer;
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	UID randomID;
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Transaction tr;
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	int rowCount;
															#line 3359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
};
// This generated class is to be used only via attemptDirtyRestore()
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class AttemptDirtyRestoreActor final : public Actor<Void>, public ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >, public ActorCallback< AttemptDirtyRestoreActor, 1, Void >, public ActorCallback< AttemptDirtyRestoreActor, 2, Void >, public FastAllocated<AttemptDirtyRestoreActor>, public AttemptDirtyRestoreActorState<AttemptDirtyRestoreActor> {
															#line 3364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
	using FastAllocated<AttemptDirtyRestoreActor>::operator new;
	using FastAllocated<AttemptDirtyRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2649269847076360960UL, 6654336284751685376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >;
friend struct ActorCallback< AttemptDirtyRestoreActor, 1, Void >;
friend struct ActorCallback< AttemptDirtyRestoreActor, 2, Void >;
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	AttemptDirtyRestoreActor(BackupAndParallelRestoreCorrectnessWorkload* const& self,Database const& cx,FileBackupAgent* const& backupAgent,Standalone<StringRef> const& lastBackupContainer,UID const& randomID) 
															#line 3383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   AttemptDirtyRestoreActorState<AttemptDirtyRestoreActor>(self, cx, backupAgent, lastBackupContainer, randomID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15385393307141582336UL, 13597647653183750656UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("attemptDirtyRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> attemptDirtyRestore( BackupAndParallelRestoreCorrectnessWorkload* const& self, Database const& cx, FileBackupAgent* const& backupAgent, Standalone<StringRef> const& lastBackupContainer, UID const& randomID ) {
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	return Future<Void>(new AttemptDirtyRestoreActor(self, cx, backupAgent, lastBackupContainer, randomID));
															#line 3417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
}

#line 403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"

																#line 3422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
template <class _startActor>
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class _startActorState {
															#line 3428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	_startActorState(Database const& cx,BackupAndParallelRestoreCorrectnessWorkload* const& self) 
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		 : cx(cx),
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   self(self),
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   backupAgent(),
															#line 406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   extraBackup(),
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   restoreIndex(0),
															#line 409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		   tr2(cx)
															#line 3447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("PerformRestore", self->performRestore) .detail("BackupAfter", self->backupAfter) .detail("RestoreAfter", self->restoreAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (self->allowPauses && BUGGIFY)
															#line 3464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				cp = changePaused(cx, &backupAgent);
															#line 3468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
															#line 424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (self->agentRequest)
															#line 3472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				BackupAndParallelRestoreCorrectnessWorkload::backupAgentRequests++;
															#line 3476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			try {
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				startRestore = delay(self->restoreAfter);
															#line 432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(self->backupAfter);
															#line 432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 786 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupAndParallelRestoreCorrectness").error(e).GetLastError();
															#line 787 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		b = doBackup( self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 3554 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = submitted.getFuture();
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		b = doBackup( self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 3587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = submitted.getFuture();
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3600 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 3689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = b;
															#line 458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 3695 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 3715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 3724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_3 = keyBackedTag.getOrThrow(cx.getReference());
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3814 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 3819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_database_locked)
															#line 3829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 3833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (self->performRestore)
															#line 3837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 3841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		logUid = uidFlag.first;
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Key> __when_expr_4 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Key >*>(static_cast<_startActor*>(this)));
															#line 3972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		logUid = uidFlag.first;
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Key> __when_expr_4 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Key >*>(static_cast<_startActor*>(this)));
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_5 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 4081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Key const& __destUidValue,int loopDepth) 
	{
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		destUidValue = __destUidValue;
															#line 4090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Key && __destUidValue,int loopDepth) 
	{
		destUidValue = std::move(__destUidValue);
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!self->locked && BUGGIFY)
															#line 4169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2", randomID).detail("Tag", printable(self->backupTag));
															#line 4173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			try {
															#line 483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				extraBackup = backupAgent.submitBackup(cx, "file://simfdb/backups/"_sr, {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), self->backupTag.toString(), self->backupRanges, true, StopWhenDone::True, UsePartitionedLog::False);
															#line 4177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = a_body1cont11cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont11cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont11cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont11cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1when1(Reference<IBackupContainer> const& __lastBackupContainer,int loopDepth) 
	{
															#line 474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		lastBackupContainer = __lastBackupContainer;
															#line 4197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Reference<IBackupContainer> && __lastBackupContainer,int loopDepth) 
	{
		lastBackupContainer = std::move(__lastBackupContainer);
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
															#line 502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		CODE_PROBE(!startRestore.isReady(), "Restore starts at specified time");
															#line 503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_6 = startRestore;
															#line 503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 4285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont4(int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2Exception", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 4303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 498 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 4307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont11cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont7(Void const& _,int loopDepth) 
	{
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 4336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 4340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				printf("TODO: Check if restore can succeed if dirty restore is performed first\n");
															#line 4344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = success(ManagementAPI::changeConfig(cx.getReference(), "backup_worker_enabled:=0", true));
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont7(Void && _,int loopDepth) 
	{
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 4369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.5)
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				printf("TODO: Check if restore can succeed if dirty restore is performed first\n");
															#line 4377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = success(ManagementAPI::changeConfig(cx.getReference(), "backup_worker_enabled:=0", true));
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont8(int loopDepth) 
	{
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (extraBackup.isValid())
															#line 4477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_WaitExtraBackup", randomID).detail("BackupTag", printable(self->backupTag));
															#line 4481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			try {
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_17 = extraBackup;
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont8Catch1(actor_cancelled(), loopDepth);
															#line 4487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont11cont8Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont11cont8when1(__when_expr_17.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 4492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont11cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont11cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont11cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont9(Void const& _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { for (auto& kvrange : self->backupRanges) tr->clear(kvrange); return Void(); });
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont9(Void && _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { for (auto& kvrange : self->backupRanges) tr->clear(kvrange); return Void(); });
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont11(Void const& _,int loopDepth) 
	{
															#line 526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BAFRW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag));
															#line 532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), {});
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_9 = container->describeBackup();
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4625 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 4630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11(Void && _,int loopDepth) 
	{
															#line 526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BAFRW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag));
															#line 532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), {});
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_9 = container->describeBackup();
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 4650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont11cont1(BackupDescription const& desc,int loopDepth) 
	{
															#line 535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(self->usePartitionedLogs == desc.partitioned);
															#line 536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(desc.minRestorableVersion.present());
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		targetVersion = -1;
															#line 539 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 4740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 4744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 4748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			else
			{
															#line 542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 4754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				{
															#line 543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 4758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				}
				else
				{
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					if (deterministicRandom()->random01() < 0.5 && desc.minRestorableVersion.get() < desc.contiguousLogEnd.get())
															#line 4764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
					{
															#line 552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
						targetVersion = deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.contiguousLogEnd.get());
															#line 4768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
					}
				}
			}
		}
															#line 557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BAFRW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("MinRestorableVersion", desc.minRestorableVersion.get()) .detail("MaxRestorableVersion", desc.maxRestorableVersion.get()) .detail("ContiguousLogEnd", desc.contiguousLogEnd.get()) .detail("TargetVersion", targetVersion);
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BackupAndParallelRestoreWorkload") .detail("PrepareRestores", self->backupRanges.size()) .detail("AddPrefix", self->addPrefix) .detail("RemovePrefix", self->removePrefix);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = backupAgent.submitParallelRestore(cx, self->backupTag, self->backupRanges, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), targetVersion, self->locked, randomID, self->addPrefix, self->removePrefix);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4785 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont11cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont1(BackupDescription && desc,int loopDepth) 
	{
															#line 535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(self->usePartitionedLogs == desc.partitioned);
															#line 536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		ASSERT(desc.minRestorableVersion.present());
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		targetVersion = -1;
															#line 539 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 4805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 4809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 4813 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			else
			{
															#line 542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 4819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				{
															#line 543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 4823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
				}
				else
				{
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
					if (deterministicRandom()->random01() < 0.5 && desc.minRestorableVersion.get() < desc.contiguousLogEnd.get())
															#line 4829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
					{
															#line 552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
						targetVersion = deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.contiguousLogEnd.get());
															#line 4833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
					}
				}
			}
		}
															#line 557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BAFRW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("MinRestorableVersion", desc.minRestorableVersion.get()) .detail("MaxRestorableVersion", desc.maxRestorableVersion.get()) .detail("ContiguousLogEnd", desc.contiguousLogEnd.get()) .detail("TargetVersion", targetVersion);
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BackupAndParallelRestoreWorkload") .detail("PrepareRestores", self->backupRanges.size()) .detail("AddPrefix", self->addPrefix) .detail("RemovePrefix", self->removePrefix);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = backupAgent.submitParallelRestore(cx, self->backupTag, self->backupRanges, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), targetVersion, self->locked, randomID, self->addPrefix, self->removePrefix);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont11cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4855 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont1(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont1(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont11cont2(Void const& _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BackupAndParallelRestoreWorkload") .detail("TriggerRestore", "Setting up restoreRequestTriggerKey");
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (BUGGIFY && TEST_ABORT_FASTRESTORE)
															#line 4941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "FastRestore").detail("Buggify", "NotImplementedYet");
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = delay(deterministicRandom()->randomInt(0, 10));
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont11cont2when1(__when_expr_11.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont2(Void && _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BackupAndParallelRestoreWorkload") .detail("TriggerRestore", "Setting up restoreRequestTriggerKey");
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (BUGGIFY && TEST_ABORT_FASTRESTORE)
															#line 4970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "FastRestore").detail("Buggify", "NotImplementedYet");
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = delay(deterministicRandom()->randomInt(0, 10));
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4978 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont11cont2when1(__when_expr_11.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 4983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont11cont9(int loopDepth) 
	{
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("FastRestoreWorkload").detail("WaitForRestoreToFinish", randomID);
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_14 = backupAgent.parallelRestoreFinish(cx, randomID, UnlockDB{ !self->hasPrefix() });
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch2(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont11cont9when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 5081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restoreIndex = 0;
															#line 5090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restoreIndex = 0;
															#line 5099 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont11cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont11cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1(int loopDepth) 
	{
															#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!(restoreIndex < restores.size()))
															#line 5196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
			return a_body1cont11cont11cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<FileBackupAgent::ERestoreState> __when_expr_12 = backupAgent.abortRestore(cx, restoreTags[restoreIndex]);
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch2(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11cont10loopBody1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >*>(static_cast<_startActor*>(this)));
															#line 5209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont11cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont1(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 5231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_13 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->clear(self->backupRanges[restoreIndex]); return Void(); });
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11cont10loopBody1cont1when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont10loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont1(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 5256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_13 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->clear(self->backupRanges[restoreIndex]); return Void(); });
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch2(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11cont10loopBody1cont1when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont10loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1when1(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont1(rs, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1when1(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont1(std::move(rs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont11cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont11cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont11cont10loopBody1cont3(int loopDepth) 
	{
															#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		restoreIndex++;
															#line 5356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont11cont11cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont11cont10loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont11cont10loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont11cont11(Void const& _,int loopDepth) 
	{
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("FastRestoreWorkload").detail("RestoreFinished", randomID);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		for( auto& restore : restores ) {
															#line 617 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			ASSERT(!restore.isError());
															#line 5456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (self->hasPrefix())
															#line 5460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_15 = transformRestoredDatabase(cx, self->backupRanges, self->addPrefix, self->removePrefix);
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont11cont11when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11(Void && _,int loopDepth) 
	{
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("FastRestoreWorkload").detail("RestoreFinished", randomID);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		for( auto& restore : restores ) {
															#line 617 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			ASSERT(!restore.isError());
															#line 5489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (self->hasPrefix())
															#line 5493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_15 = transformRestoredDatabase(cx, self->backupRanges, self->addPrefix, self->removePrefix);
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch2(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont11cont11when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont11cont11cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont3(Void const& _,int loopDepth) 
	{
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = unlockDatabase(cx, randomID);
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont11cont11cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 5606 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont3(Void && _,int loopDepth) 
	{
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = unlockDatabase(cx, randomID);
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5617 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch2(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont11cont11cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 5622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont11cont11cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont11cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont11cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont11cont12(int loopDepth) 
	{
															#line 650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		backupAgentKey = uidPrefixKey(logRangesRange.begin, logUid);
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		backupLogValuesKey = destUidValue.withPrefix(backupLogKeys.begin);
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		backupLatestVersionsPath = destUidValue.withPrefix(backupLatestVersionsPrefix);
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		backupLatestVersionsKey = uidPrefixKey(backupLatestVersionsPath, logUid);
															#line 654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		displaySystemKeys = 0;
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		;
															#line 5803 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13(int loopDepth) 
	{
															#line 640 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_AbortBackupExtra", randomID).detail("BackupTag", printable(self->backupTag));
															#line 5812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_18 = backupAgent.abortBackup(cx, self->backupTag.toString());
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont13Catch1(actor_cancelled(), loopDepth);
															#line 5818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont11cont13Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont13when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 5823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont13Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont13Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_ExtraBackupException", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 5845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont11cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont11cont14cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont13cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_AbortBackupExtraException", randomID).error(e);
															#line 645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 5970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			{
															#line 646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				return a_body1Catch2(e, loopDepth);
															#line 5974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont11cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont13cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont13Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont13Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont13Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont13Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont13Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont13Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont13Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont11cont13cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12cont1(int loopDepth) 
	{
															#line 769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (displaySystemKeys)
															#line 6090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_28 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch2(__when_expr_28.getError(), loopDepth); else return a_body1cont11cont12cont1when1(__when_expr_28.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 29;
															#line 770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< _startActor, 28, Void >*>(static_cast<_startActor*>(this)));
															#line 6101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1(int loopDepth) 
	{
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_CheckLeftoverKeys", randomID).detail("BackupTag", printable(self->backupTag));
															#line 6124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		try {
															#line 663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			tr->reset();
															#line 664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_CheckLeftoverTasks", randomID).detail("BackupTag", printable(self->backupTag));
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<int64_t> __when_expr_19 = backupAgent.getTaskCount(tr);
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont11cont12loopBody1when1(__when_expr_19.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, int64_t >*>(static_cast<_startActor*>(this)));
															#line 6141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent("BARW_CheckException", randomID).error(e);
															#line 765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_27 = tr->onError(e);
															#line 765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch2(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1Catch1when1(__when_expr_27.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 28;
															#line 765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< _startActor, 27, Void >*>(static_cast<_startActor*>(this)));
															#line 6185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2(int loopDepth) 
	{
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		waitCycles = 0;
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		;
															#line 6202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont12loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		taskCount = __taskCount;
															#line 6211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont12loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1cont11cont12loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont11cont12loopBody1cont3(int loopDepth) 
	{
															#line 697 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (taskCount)
															#line 6290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 699 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BARW_NonzeroTaskCount", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverLogTasks: %ld\n", (long)taskCount);
															#line 6298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_23 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont3when1(__when_expr_23.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 24;
															#line 706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _startActor, 23, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont12loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		waitCycles++;
															#line 676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_NonzeroTaskWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_20 = delay(5.0);
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_20.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1cont2loopBody1when1(__when_expr_20.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 21;
															#line 686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _startActor, 20, Void >*>(static_cast<_startActor*>(this)));
															#line 6338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont12loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_21 = tr->commit();
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1cont2loopBody1cont1when1(__when_expr_21.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 22;
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _startActor, 21, Void >*>(static_cast<_startActor*>(this)));
															#line 6367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_21 = tr->commit();
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1cont2loopBody1cont1when1(__when_expr_21.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 22;
															#line 687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _startActor, 21, Void >*>(static_cast<_startActor*>(this)));
															#line 6383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _startActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_22 = backupAgent.getTaskCount(tr);
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1cont2loopBody1cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 23;
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _startActor, 22, int64_t >*>(static_cast<_startActor*>(this)));
															#line 6476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 688 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_22 = backupAgent.getTaskCount(tr);
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont12loopBody1cont2loopBody1cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 23;
															#line 689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _startActor, 22, int64_t >*>(static_cast<_startActor*>(this)));
															#line 6494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< _startActor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< _startActor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont3(int64_t const& _taskCount,int loopDepth) 
	{
															#line 690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		taskCount = _taskCount;
															#line 692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!taskCount)
															#line 6580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
			return a_body1cont11cont12loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont11cont12loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont3(int64_t && _taskCount,int loopDepth) 
	{
															#line 690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		taskCount = _taskCount;
															#line 692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!taskCount)
															#line 6594 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
			return a_body1cont11cont12loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont11cont12loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont2when1(int64_t const& _taskCount,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont3(_taskCount, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont2loopBody1cont2when1(int64_t && _taskCount,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont2loopBody1cont3(std::move(_taskCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 22, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 22, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< _startActor, 22, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont12loopBody1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< _startActor, 22, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont11cont12loopBody1cont4(RangeResult const& agentValues,int loopDepth) 
	{
															#line 710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 6681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 711 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 6695 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 728 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 6702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_24 = tr->get(backupLatestVersionsKey);
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont4when1(__when_expr_24.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 25;
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _startActor, 24, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 6713 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont4(RangeResult && agentValues,int loopDepth) 
	{
															#line 710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 6722 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 711 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 6736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 728 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 6743 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_24 = tr->get(backupLatestVersionsKey);
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont4when1(__when_expr_24.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 25;
															#line 731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _startActor, 24, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 6754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont3when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont4(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont3when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont4(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 23, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 23, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont12loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< _startActor, 23, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont12loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< _startActor, 23, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont11cont12loopBody1cont6(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 6838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 733 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 6842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		else
		{
															#line 738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 6848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_25 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont6when1(__when_expr_25.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 26;
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< _startActor, 25, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6859 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont6(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 6868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 733 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 6872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		else
		{
															#line 738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 6878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_25 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont6when1(__when_expr_25.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 26;
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< _startActor, 25, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont4when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont6(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont4when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont6(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 24, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 24, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont12loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< _startActor, 24, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont12loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< _startActor, 24, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont11cont12loopBody1cont10(RangeResult const& versions,int loopDepth) 
	{
															#line 743 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 6973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_26 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont10when1(__when_expr_26.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 27;
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< _startActor, 26, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 6984 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont12loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont10(RangeResult && versions,int loopDepth) 
	{
															#line 743 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 6998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_26 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont12loopBody1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont12loopBody1cont10when1(__when_expr_26.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 27;
															#line 744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< _startActor, 26, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 7009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont12loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont6when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont10(versions, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont6when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont10(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 25, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 25, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont12loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< _startActor, 25, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont12loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< _startActor, 25, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont11cont12loopBody1cont10cont1(int loopDepth) 
	{
		return a_body1cont11cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont10cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 7104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 7112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		else
		{
															#line 758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 7118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont12loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont10cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 7128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 7136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		else
		{
															#line 758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 7142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont12loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont10when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont10cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1cont10when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont10cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 26, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 26, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont12loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< _startActor, 26, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont12loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< _startActor, 26, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont11cont12loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< _startActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< _startActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont11cont12cont2(int loopDepth) 
	{
															#line 773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		TraceEvent("BARW_Complete", randomID).detail("BackupTag", printable(self->backupTag));
															#line 776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 7316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 777 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			BackupAndParallelRestoreCorrectnessWorkload::backupAgentRequests--;
															#line 7320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
															#line 781 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
		if ((g_simulator->backupAgents == ISimulator::BackupAgentType::BackupToFile) && (!BackupAndParallelRestoreCorrectnessWorkload::backupAgentRequests))
															#line 7324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		{
															#line 783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
			g_simulator->backupAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 7328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< _startActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< _startActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont11cont12cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Database cx;
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	BackupAndParallelRestoreCorrectnessWorkload* self;
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	FileBackupAgent backupAgent;
															#line 406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> extraBackup;
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	UID randomID;
															#line 408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	int restoreIndex;
															#line 409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	ReadYourWritesTransaction tr2;
															#line 420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> cp;
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> startRestore;
															#line 435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Future<Void> b;
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	KeyBackedTag keyBackedTag;
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	UID logUid;
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key destUidValue;
															#line 474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Version targetVersion;
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	std::vector<Future<Version>> restores;
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	std::vector<Standalone<StringRef>> restoreTags;
															#line 650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key backupAgentKey;
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key backupLogValuesKey;
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key backupLatestVersionsPath;
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Key backupLatestVersionsKey;
															#line 654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	int displaySystemKeys;
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	int64_t taskCount;
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	int waitCycles;
															#line 7486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, UidAndAbortedFlagT >, public ActorCallback< _startActor, 4, Key >, public ActorCallback< _startActor, 5, Reference<IBackupContainer> >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, BackupDescription >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, Void >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, Void >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, Void >, public ActorCallback< _startActor, 19, int64_t >, public ActorCallback< _startActor, 20, Void >, public ActorCallback< _startActor, 21, Void >, public ActorCallback< _startActor, 22, int64_t >, public ActorCallback< _startActor, 23, RangeResult >, public ActorCallback< _startActor, 24, Optional<Value> >, public ActorCallback< _startActor, 25, RangeResult >, public ActorCallback< _startActor, 26, RangeResult >, public ActorCallback< _startActor, 27, Void >, public ActorCallback< _startActor, 28, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 7491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7399932467904799232UL, 13891071261206789376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, UidAndAbortedFlagT >;
friend struct ActorCallback< _startActor, 4, Key >;
friend struct ActorCallback< _startActor, 5, Reference<IBackupContainer> >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, BackupDescription >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, Void >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, Void >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, Void >;
friend struct ActorCallback< _startActor, 19, int64_t >;
friend struct ActorCallback< _startActor, 20, Void >;
friend struct ActorCallback< _startActor, 21, Void >;
friend struct ActorCallback< _startActor, 22, int64_t >;
friend struct ActorCallback< _startActor, 23, RangeResult >;
friend struct ActorCallback< _startActor, 24, Optional<Value> >;
friend struct ActorCallback< _startActor, 25, RangeResult >;
friend struct ActorCallback< _startActor, 26, RangeResult >;
friend struct ActorCallback< _startActor, 27, Void >;
friend struct ActorCallback< _startActor, 28, Void >;
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	_startActor(Database const& cx,BackupAndParallelRestoreCorrectnessWorkload* const& self) 
															#line 7536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Key >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, BackupDescription >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, FileBackupAgent::ERestoreState >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, int64_t >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _startActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< _startActor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< _startActor, 22, int64_t >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< _startActor, 23, RangeResult >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< _startActor, 24, Optional<Value> >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< _startActor, 25, RangeResult >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< _startActor, 26, RangeResult >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< _startActor, 27, Void >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< _startActor, 28, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupAndParallelRestoreCorrectnessWorkload* const& self ) {
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 7596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.g.cpp"
}

#line 791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndParallelRestoreCorrectness.actor.cpp"
};

int BackupAndParallelRestoreCorrectnessWorkload::backupAgentRequests = 0;

WorkloadFactory<BackupAndParallelRestoreCorrectnessWorkload> BackupAndParallelRestoreCorrectnessWorkloadFactory;
