#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
/*
 * RestoreRoleCommon.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file declares common struct and functions shared by restore roles, i.e.,
// RestoreController, RestoreLoader, RestoreApplier

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_RestoreRoleCommon_G_H)
#define FDBSERVER_RestoreRoleCommon_G_H
#include "fdbserver/RestoreRoleCommon.actor.g.h"
#elif !defined(FDBSERVER_RestoreRoleCommon_H)
#define FDBSERVER_RestoreRoleCommon_H

#include <sstream>
#include "flow/SystemMonitor.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/Notified.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/Stats.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/RestoreWorkerInterface.actor.h"
#include "fdbserver/RestoreUtil.h"

#include "flow/actorcompiler.h" // has to be last include

struct RestoreRoleInterface;
struct RestoreLoaderInterface;
struct RestoreApplierInterface;

struct RestoreRoleData;
struct RestoreControllerData;

struct RestoreSimpleRequest;

// Key is the (version, subsequence) of parsed backup mutations.
// Value MutationsVec is the vector of parsed backup mutations.
// For old mutation logs, the subsequence number is always 0.
// For partitioned mutation logs, each mutation has a unique LogMessageVersion.
// Note for partitioned logs, one LogMessageVersion can have multiple mutations,
// because a clear mutation may be split into several smaller clear mutations by
// backup workers.
using VersionedMutationsMap = std::map<LogMessageVersion, MutationsVec>;

															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> isSchedulable( Reference<RestoreRoleData> const& self, int const& actorBatchIndex, std::string const& name );

#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> handleHeartbeat( RestoreSimpleRequest const& req, UID const& id );

#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
															#line 73 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> handleInitVersionBatchRequest( RestoreVersionBatchRequest const& req, Reference<RestoreRoleData> const& self );

#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
void handleFinishRestoreRequest(const RestoreFinishRequest& req, Reference<RestoreRoleData> self);

class RoleVersionBatchState {
public:
	static const int INVALID = -1;

	virtual int get() const { return vbState; }

	virtual void operator=(int newState) { vbState = newState; }

	explicit RoleVersionBatchState() : vbState(INVALID) {}
	explicit RoleVersionBatchState(int newState) : vbState(newState) {}

	virtual ~RoleVersionBatchState() = default;

	int vbState;
};

struct RestoreRoleData : NonCopyable, public ReferenceCounted<RestoreRoleData> {
public:
	RestoreRole role;
	UID nodeID;
	int nodeIndex;

	double cpuUsage;
	double memory;
	double residentMemory;

	AsyncTrigger checkMemory;
	int delayedActors; // actors that are delayed to release because of low memory

	std::map<UID, RestoreLoaderInterface> loadersInterf; // UID: loaderInterf's id
	std::map<UID, RestoreApplierInterface> appliersInterf; // UID: applierInterf's id
	Promise<Void> recruitedRoles; // sent when loaders and appliers are recruited

	NotifiedVersion versionBatchId; // The index of the version batch that has been initialized and put into pipeline
	NotifiedVersion finishedBatch; // The highest batch index all appliers have applied mutations

	RestoreRoleData()
	  : role(RestoreRole::Invalid), cpuUsage(0.0), memory(0.0), residentMemory(0.0), delayedActors(0) {};

	virtual ~RestoreRoleData() = default;

	UID id() const { return nodeID; }

	virtual void initVersionBatch(int batchIndex) = 0;
	virtual void resetPerRestoreRequest() = 0;
	virtual int getVersionBatchState(int batchIndex) const = 0;
	virtual void setVersionBatchState(int batchIndex, int vbState) = 0;

	void clearInterfaces() {
		loadersInterf.clear();
		appliersInterf.clear();
	}

	virtual std::string describeNode() const = 0;
};

void updateProcessStats(Reference<RestoreRoleData> self);
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> updateProcessMetrics( Reference<RestoreRoleData> const& self );

#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> traceProcessMetrics( Reference<RestoreRoleData> const& self, std::string const& role );

#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RestoreRoleCommon.actor.g.h"
[[nodiscard]] Future<Void> traceRoleVersionBatchProgress( Reference<RestoreRoleData> const& self, std::string const& role );

#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RestoreRoleCommon.actor.h"

#include "flow/unactorcompiler.h"
#endif
