#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
/*
 * Status.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbclient/json_spirit/json_spirit_value.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/BlobManagerInterface.h"
#include "flow/genericactors.actor.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BlobWorkerInterface.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbserver/Status.actor.h"
#include "flow/ITrace.h"
#include "flow/ProtocolVersion.h"
#include "flow/Trace.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/WorkerInterface.actor.h"
#include <time.h>
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/ConsistencyScanInterface.actor.h"
#include "flow/UnitTest.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/StorageWiggleMetrics.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const char* RecoveryStatus::names[] = { "reading_coordinated_state",
	                                    "locking_coordinated_state",
	                                    "locking_old_transaction_servers",
	                                    "reading_transaction_system_state",
	                                    "configuration_missing",
	                                    "configuration_never_created",
	                                    "configuration_invalid",
	                                    "recruiting_transaction_servers",
	                                    "initializing_transaction_servers",
	                                    "recovery_transaction",
	                                    "writing_coordinated_state",
	                                    "accepting_commits",
	                                    "all_logs_recruited",
	                                    "storage_recovered",
	                                    "fully_recovered" };
static_assert(sizeof(RecoveryStatus::names) == sizeof(RecoveryStatus::names[0]) * RecoveryStatus::END,
              "RecoveryStatus::names[] size");
const char* RecoveryStatus::descriptions[] = {
	// reading_coordinated_state
	"Requesting information from coordination servers. Verify that a majority of coordination server processes are "
	"active.",
	// locking_coordinated_state
	"Locking coordination state. Verify that a majority of coordination server processes are active.",
	// locking_old_transaction_servers
	"Locking old transaction servers. Verify that at least one transaction server from the previous generation is "
	"running.",
	// reading_transaction_system_state
	"Recovering transaction server state. Verify that the transaction server processes are active.",
	// configuration_missing
	"There appears to be a database, but its configuration does not appear to be initialized.",
	// configuration_never_created
	"The coordinator(s) have no record of this database. Either the coordinator addresses are incorrect, the "
	"coordination state on those machines is missing, or no database has been created.",
	// configuration_invalid
	"The database configuration is invalid. Set a new, valid configuration to recover the database.",
	// recruiting_transaction_servers
	"Recruiting new transaction servers.",
	// initializing_transaction_servers
	"Initializing new transaction servers and recovering transaction logs.",
	// recovery_transaction
	"Performing recovery transaction.",
	// writing_coordinated_state
	"Writing coordinated state. Verify that a majority of coordination server processes are active.",
	// accepting_commits
	"Accepting commits.",
	// all_logs_recruited
	"Accepting commits. All logs recruited.",
	// storage_recovered
	"Accepting commits. All storage servers are reading from the new logs.",
	// fully_recovered
	"Recovery complete."
};
static_assert(sizeof(RecoveryStatus::descriptions) == sizeof(RecoveryStatus::descriptions[0]) * RecoveryStatus::END,
              "RecoveryStatus::descriptions[] size");

// From Ratekeeper.actor.cpp
extern int limitReasonEnd;
extern const char* limitReasonName[];
extern const char* limitReasonDesc[];

typedef std::map<std::string, TraceEventFields> EventMap;

struct StorageServerStatusInfo : public StorageServerMetaInfo {
	EventMap eventMap;
	StorageServerStatusInfo(const StorageServerMetaInfo& info) : StorageServerMetaInfo(info, info.metadata) {}
};

															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latestEventOnWorker()
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkerActor>
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActorState {
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActorState(WorkerInterface const& worker,std::string const& eventName) 
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : worker(worker),
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkerActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<TraceEventFields>> __when_expr_0 = errorOr(timeoutError(worker.eventLogRequest.getReply(req), 2.0));
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 1;
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*>(static_cast<LatestEventOnWorkerActor*>(this)));
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (eventTrace.isError())
															#line 245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(Optional<TraceEventFields>()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(Optional<TraceEventFields>());
			this->~LatestEventOnWorkerActorState();
			static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkerActor*>(this)->SAV<Optional<TraceEventFields>>::futures) { (void)(eventTrace.get()); this->~LatestEventOnWorkerActorState(); static_cast<LatestEventOnWorkerActor*>(this)->destroy(); return 0; }
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkerActor*>(this)->SAV< Optional<TraceEventFields> >::value()) Optional<TraceEventFields>(eventTrace.get());
		this->~LatestEventOnWorkerActorState();
		static_cast<LatestEventOnWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> const& eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(eventTrace, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<TraceEventFields> && eventTrace,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(eventTrace), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkerActor*>(this)->ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,ErrorOr<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerInterface worker;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latestEventOnWorker()
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkerActor final : public Actor<Optional<TraceEventFields>>, public ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >, public FastAllocated<LatestEventOnWorkerActor>, public LatestEventOnWorkerActorState<LatestEventOnWorkerActor> {
															#line 349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatestEventOnWorkerActor>::operator new;
	using FastAllocated<LatestEventOnWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11266641860155223552UL, 16498201912743141376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TraceEventFields>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkerActor(WorkerInterface const& worker,std::string const& eventName) 
															#line 366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<TraceEventFields>>(),
		   LatestEventOnWorkerActorState<LatestEventOnWorkerActor>(worker, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7106470683888923648UL, 11063323833140639488UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkerActor, 0, ErrorOr<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Optional<TraceEventFields>> latestEventOnWorker( WorkerInterface const& worker, std::string const& eventName ) {
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<TraceEventFields>>(new LatestEventOnWorkerActor(worker, eventName));
															#line 399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latestEventOnWorkers()
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatestEventOnWorkersActor>
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActorState {
															#line 411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActorState(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : workers(workers),
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventName(eventName)
															#line 420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	~LatestEventOnWorkersActorState() 
	{
		fdb_probe_actor_destroy("latestEventOnWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				eventTraces = std::vector<Future<ErrorOr<TraceEventFields>>>();
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for(int c = 0;c < workers.size();c++) {
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					EventLogRequest req = eventName.size() > 0 ? EventLogRequest(Standalone<StringRef>(eventName)) : EventLogRequest();
															#line 147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					eventTraces.push_back(errorOr(timeoutError(workers[c].interf.eventLogRequest.getReply(req), 2.0)));
															#line 442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(eventTraces);
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatestEventOnWorkersActor, 0, Void >*>(static_cast<LatestEventOnWorkersActor*>(this)));
															#line 453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(e.code() == error_code_actor_cancelled);
															#line 173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::string> failed;
															#line 153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		WorkerEvents results;
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < eventTraces.size();i++) {
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const ErrorOr<TraceEventFields>& v = eventTraces[i].get();
															#line 157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (v.isError())
															#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				failed.insert(workers[i].interf.address().toString());
															#line 159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = TraceEventFields();
															#line 556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				results[workers[i].interf.address()] = v.get();
															#line 562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::pair<WorkerEvents, std::set<std::string>> val;
															#line 166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.first = results;
															#line 167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		val.second = failed;
															#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatestEventOnWorkersActor*>(this)->SAV<Optional<std::pair<WorkerEvents, std::set<std::string>>>>::futures) { (void)(val); this->~LatestEventOnWorkersActorState(); static_cast<LatestEventOnWorkersActor*>(this)->destroy(); return 0; }
															#line 573 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatestEventOnWorkersActor*>(this)->SAV< Optional<std::pair<WorkerEvents, std::set<std::string>>> >::value()) Optional<std::pair<WorkerEvents, std::set<std::string>>>(val);
		this->~LatestEventOnWorkersActorState();
		static_cast<LatestEventOnWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state > 0) static_cast<LatestEventOnWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<LatestEventOnWorkersActor*>(this)->ActorCallback< LatestEventOnWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatestEventOnWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::string eventName;
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<ErrorOr<TraceEventFields>>> eventTraces;
															#line 662 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latestEventOnWorkers()
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatestEventOnWorkersActor final : public Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>, public ActorCallback< LatestEventOnWorkersActor, 0, Void >, public FastAllocated<LatestEventOnWorkersActor>, public LatestEventOnWorkersActorState<LatestEventOnWorkersActor> {
															#line 667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatestEventOnWorkersActor>::operator new;
	using FastAllocated<LatestEventOnWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5678578351429894144UL, 17601311799062106624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatestEventOnWorkersActor, 0, Void >;
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatestEventOnWorkersActor(std::vector<WorkerDetails> const& workers,std::string const& eventName) 
															#line 684 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(),
		   LatestEventOnWorkersActorState<LatestEventOnWorkersActor>(workers, eventName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17131304875114139904UL, 5790865631530653952UL);
		ActorExecutionContextHelper __helper(static_cast<LatestEventOnWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latestEventOnWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latestEventOnWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatestEventOnWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestEventOnWorkers( std::vector<WorkerDetails> const& workers, std::string const& eventName ) {
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>>(new LatestEventOnWorkersActor(workers, eventName));
															#line 717 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
static Future<Optional<std::pair<WorkerEvents, std::set<std::string>>>> latestErrorOnWorkers(
    std::vector<WorkerDetails> workers) {
	return latestEventOnWorkers(workers, "");
}

static Optional<WorkerDetails> getWorker(std::vector<WorkerDetails> const& workers, NetworkAddress const& address) {
	try {
		for (int c = 0; c < workers.size(); c++)
			if (address == workers[c].interf.address())
				return workers[c];
		return Optional<WorkerDetails>();
	} catch (Error&) {
		return Optional<WorkerDetails>();
	}
}

static Optional<WorkerDetails> getWorker(std::map<NetworkAddress, WorkerDetails> const& workersMap,
                                         NetworkAddress const& address) {
	auto itr = workersMap.find(address);
	if (itr == workersMap.end()) {
		return Optional<WorkerDetails>();
	}

	return itr->second;
}

class StatusCounter {
public:
	StatusCounter() : hz(0), roughness(0), counter(0) {}
	StatusCounter(double hz, double roughness, int64_t counter) : hz(hz), roughness(roughness), counter(counter) {}
	StatusCounter(const std::string& parsableText) { parseText(parsableText); }

	StatusCounter& parseText(const std::string& parsableText) {
		sscanf(parsableText.c_str(), "%lf %lf %" SCNd64 "", &hz, &roughness, &counter);
		return *this;
	}

	StatusCounter& updateValues(const StatusCounter& statusCounter) {
		double hzNew = hz + statusCounter.hz;
		double roughnessNew = (hz + statusCounter.hz) ? (roughness * hz + statusCounter.roughness * statusCounter.hz) /
		                                                    (hz + statusCounter.hz)
		                                              : 0.0;
		int64_t counterNew = counter + statusCounter.counter;
		hz = hzNew;
		roughness = roughnessNew;
		counter = counterNew;
		return *this;
	}

	JsonBuilderObject getStatus() const {
		JsonBuilderObject statusObject;
		statusObject["hz"] = hz;
		statusObject["roughness"] = roughness;
		statusObject["counter"] = counter;
		return statusObject;
	}

	double getHz() { return hz; }

	double getRoughness() { return roughness; }

	int64_t getCounter() { return counter; }

protected:
	double hz;
	double roughness;
	int64_t counter;
};

static JsonBuilderObject getError(const TraceEventFields& errorFields) {
	JsonBuilderObject statusObj;
	try {
		if (errorFields.size()) {
			double time = atof(errorFields.getValue("Time").c_str());
			statusObj["time"] = time;

			statusObj["raw_log_message"] = errorFields.toString();

			std::string type = errorFields.getValue("Type");
			statusObj["type"] = type;

			std::string description = type;
			std::string errorName;
			if (errorFields.tryGetValue("Error", errorName)) {
				statusObj["name"] = errorName;
				description += ": " + errorName;
			} else
				statusObj["name"] = "process_error";

			struct tm* timeinfo;
			time_t t = (time_t)time;
			timeinfo = localtime(&t);
			char buffer[128];
			strftime(buffer, 128, "%c", timeinfo);
			description += " at " + std::string(buffer);

			statusObj["description"] = description;
		}
	} catch (Error& e) {
		TraceEvent(SevError, "StatusGetErrorError").error(e).detail("RawError", errorFields.toString());
	}
	return statusObj;
}

namespace {

void reportCgroupCpuStat(JsonBuilderObject& object, const TraceEventFields& eventFields) {
	JsonBuilderObject cgroupCpuStatObj;
	std::string val;
	if (eventFields.tryGetValue("NrPeriods", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_periods", val);
	}
	if (eventFields.tryGetValue("NrThrottled", val)) {
		cgroupCpuStatObj.setKeyRawNumber("nr_throttled", val);
	}
	if (eventFields.tryGetValue("ThrottledTime", val)) {
		cgroupCpuStatObj.setKeyRawNumber("throttled_time", val);
	}
	if (!cgroupCpuStatObj.empty()) {
		object["cgroup_cpu_stat"] = cgroupCpuStatObj;
	}
}

JsonBuilderObject machineStatusFetcher(WorkerEvents mMetrics,
                                       std::vector<WorkerDetails> workers,
                                       Optional<DatabaseConfiguration> configuration,
                                       std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject machineMap;
	double metric;
	int failed = 0;

	// map from machine networkAddress to datacenter ID
	std::map<NetworkAddress, std::string> dcIds;
	std::map<NetworkAddress, LocalityData> locality;
	std::map<std::string, bool> excludedMap;
	std::map<std::string, int32_t> workerContribMap;
	std::map<std::string, JsonBuilderObject> machineJsonMap;

	for (auto const& worker : workers) {
		locality[worker.interf.address()] = worker.interf.locality;
		if (worker.interf.locality.dcId().present())
			dcIds[worker.interf.address()] = worker.interf.locality.dcId().get().printable();
	}

	for (auto it = mMetrics.begin(); it != mMetrics.end(); it++) {

		if (!it->second.size()) {
			continue;
		}

		JsonBuilderObject statusObj; // Represents the status for a machine
		const TraceEventFields& event = it->second;

		try {
			std::string address = it->first.ip.toString();
			// We will use the "physical" calculated machine ID here to limit exposure to machineID repurposing
			std::string machineId = event.getValue("MachineID");

			// If this machine ID does not already exist in the machineMap, add it
			if (!machineJsonMap.contains(machineId)) {
				statusObj["machine_id"] = machineId;

				if (dcIds.contains(it->first)) {
					statusObj["datacenter_id"] = dcIds[it->first];
				}

				if (locality.contains(it->first)) {
					statusObj["locality"] = locality[it->first].toJSON<JsonBuilderObject>();
				}

				statusObj["address"] = address;

				JsonBuilderObject memoryObj;
				memoryObj.setKeyRawNumber("total_bytes", event.getValue("TotalMemory"));
				memoryObj.setKeyRawNumber("committed_bytes", event.getValue("CommittedMemory"));
				memoryObj.setKeyRawNumber("free_bytes", event.getValue("AvailableMemory"));
				statusObj["memory"] = memoryObj;

#ifdef __linux__
				reportCgroupCpuStat(statusObj, event);
#endif // __linux__

				JsonBuilderObject cpuObj;
				double cpuSeconds = event.getDouble("CPUSeconds");
				double elapsed = event.getDouble("Elapsed");
				if (elapsed > 0) {
					cpuObj["logical_core_utilization"] = std::max(0.0, std::min(cpuSeconds / elapsed, 1.0));
				}
				statusObj["cpu"] = cpuObj;

				JsonBuilderObject networkObj;
				networkObj["megabits_sent"] = JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsSent"));
				networkObj["megabits_received"] =
				    JsonBuilderObject().setKeyRawNumber("hz", event.getValue("MbpsReceived"));

				metric = event.getDouble("RetransSegs");
				JsonBuilderObject retransSegsObj;
				if (elapsed > 0) {
					retransSegsObj["hz"] = metric / elapsed;
				}
				networkObj["tcp_segments_retransmitted"] = retransSegsObj;
				statusObj["network"] = networkObj;

				if (configuration.present()) {
					excludedMap[machineId] =
					    true; // Will be set to false below if this or any later process is not excluded
				}

				workerContribMap[machineId] = 0;
				machineJsonMap[machineId] = statusObj;
			}

			bool excludedServer = true;
			// If the machine is already marked as not excluded, because at least one process was found to not be
			// excluded, we can stop checking further servers on this machine.
			if (configuration.present() && excludedMap[machineId]) {
				NetworkAddressList tempList;
				tempList.address = it->first;
				// Check if the locality data is present and if so, make use of it.
				auto localityData = LocalityData();
				if (locality.contains(it->first)) {
					localityData = locality[it->first];
				}

				// The isExcludedServer method already contains a check for the excluded localities.
				excludedServer = configuration.get().isExcludedServer(tempList, localityData);
			}

			// If any server is not excluded, set the overall exclusion status of the machine to false.
			if (!excludedServer) {
				excludedMap[machineId] = false;
			}
			workerContribMap[machineId]++;
		} catch (Error&) {
			++failed;
		}
	}

	// Add the status json for each machine with tracked values
	for (auto& mapPair : machineJsonMap) {
		auto& machineId = mapPair.first;
		auto& jsonItem = machineJsonMap[machineId];
		jsonItem["excluded"] = excludedMap[machineId];
		jsonItem["contributing_workers"] = workerContribMap[machineId];
		machineMap[machineId] = jsonItem;
	}

	if (failed > 0)
		incomplete_reasons->insert("Cannot retrieve all machine status information.");

	return machineMap;
}

} // anonymous namespace

JsonBuilderObject getLagObject(int64_t versions) {
	JsonBuilderObject lag;
	lag["versions"] = versions;
	lag["seconds"] = versions / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
	return lag;
}

static JsonBuilderObject getBounceImpactInfo(int recoveryStatusCode) {
	JsonBuilderObject bounceImpact;

	if (recoveryStatusCode == RecoveryStatus::fully_recovered) {
		bounceImpact["can_clean_bounce"] = true;
	} else {
		bounceImpact["can_clean_bounce"] = false;
		bounceImpact["reason"] = "cluster hasn't fully recovered yet";
	}

	return bounceImpact;
}

struct MachineMemoryInfo {
	double memoryUsage; // virtual memory usage
	double rssUsage; // RSS memory usage
	double aggregateLimit;

	MachineMemoryInfo() : memoryUsage(0), rssUsage(0), aggregateLimit(0) {}

	bool valid() { return memoryUsage >= 0; }
	void invalidate() { memoryUsage = -1; }
};

struct RolesInfo {
	std::multimap<NetworkAddress, JsonBuilderObject> roles;

	JsonBuilderObject addLatencyStatistics(TraceEventFields const& metrics) {
		JsonBuilderObject latencyStats;
		latencyStats.setKeyRawNumber("count", metrics.getValue("Count"));
		latencyStats.setKeyRawNumber("min", metrics.getValue("Min"));
		latencyStats.setKeyRawNumber("max", metrics.getValue("Max"));
		latencyStats.setKeyRawNumber("median", metrics.getValue("Median"));
		latencyStats.setKeyRawNumber("mean", metrics.getValue("Mean"));
		latencyStats.setKeyRawNumber("p25", metrics.getValue("P25"));
		latencyStats.setKeyRawNumber("p90", metrics.getValue("P90"));
		latencyStats.setKeyRawNumber("p95", metrics.getValue("P95"));
		latencyStats.setKeyRawNumber("p99", metrics.getValue("P99"));
		latencyStats.setKeyRawNumber("p99.9", metrics.getValue("P99.9"));

		return latencyStats;
	}

	JsonBuilderObject addLatencyBandInfo(TraceEventFields const& metrics) {
		JsonBuilderObject latencyBands;
		std::map<std::string, JsonBuilderObject> bands;

		for (auto itr = metrics.begin(); itr != metrics.end(); ++itr) {
			std::string band;
			if (itr->first.substr(0, 4) == "Band") {
				band = itr->first.substr(4);
			} else if (itr->first == "Filtered") {
				band = "filtered";
			} else {
				continue;
			}

			latencyBands[band] = StatusCounter(itr->second).getCounter();
		}

		return latencyBands;
	}

	JsonBuilderObject& addRole(NetworkAddress address, std::string const& role, UID id) {
		JsonBuilderObject obj;
		obj["id"] = id.shortString();
		obj["role"] = role;
		return roles.insert(std::make_pair(address, obj))->second;
	}

	JsonBuilderObject& addRole(std::string const& role,
	                           StorageServerStatusInfo& iface,
	                           Version maxTLogVersion,
	                           double* pDataLagSeconds) {
		JsonBuilderObject obj;
		EventMap const& metrics = iface.eventMap;
		double dataLagSeconds = -1.0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		obj["tss"] = iface.isTss();
		if (iface.metadata.present()) {
			obj["storage_metadata"] = iface.metadata.get().toJSON();
			// printf("%s\n", metadataObj.getJson().c_str());
		}

		try {
			TraceEventFields const& storageMetrics = metrics.at("StorageMetrics");

			obj.setKeyRawNumber("stored_bytes", storageMetrics.getValue("BytesStored"));
			obj.setKeyRawNumber("kvstore_used_bytes", storageMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", storageMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", storageMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", storageMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("kvstore_total_size", storageMetrics.getValue("KvstoreSizeTotal"));
			obj.setKeyRawNumber("kvstore_total_nodes", storageMetrics.getValue("KvstoreNodeTotal"));
			obj.setKeyRawNumber("kvstore_inline_keys", storageMetrics.getValue("KvstoreInlineKey"));
			obj["input_bytes"] = StatusCounter(storageMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(storageMetrics.getValue("BytesDurable")).getStatus();
			obj.setKeyRawNumber("query_queue_max", storageMetrics.getValue("QueryQueueMax"));
			obj["total_queries"] = StatusCounter(storageMetrics.getValue("QueryQueue")).getStatus();
			obj["finished_queries"] = StatusCounter(storageMetrics.getValue("FinishedQueries")).getStatus();
			obj["low_priority_queries"] = StatusCounter(storageMetrics.getValue("LowPriorityQueries")).getStatus();
			obj["bytes_queried"] = StatusCounter(storageMetrics.getValue("BytesQueried")).getStatus();
			obj["keys_queried"] = StatusCounter(storageMetrics.getValue("RowsQueried")).getStatus();
			obj["mutation_bytes"] = StatusCounter(storageMetrics.getValue("MutationBytes")).getStatus();
			obj["mutations"] = StatusCounter(storageMetrics.getValue("Mutations")).getStatus();
			obj.setKeyRawNumber("local_rate", storageMetrics.getValue("LocalRate"));
			obj["fetched_versions"] = StatusCounter(storageMetrics.getValue("FetchedVersions")).getStatus();
			obj["fetches_from_logs"] = StatusCounter(storageMetrics.getValue("FetchesFromLogs")).getStatus();
			obj["rocksdb_version"] = storageMetrics.getValue("RocksDBVersion");

			Version version = storageMetrics.getInt64("Version");
			Version durableVersion = storageMetrics.getInt64("DurableVersion");

			obj["data_version"] = version;
			obj["durable_version"] = durableVersion;

			int64_t versionLag = storageMetrics.getInt64("VersionLag");
			if (maxTLogVersion > 0) {
				// It's possible that the storage server hasn't talked to the logs recently, in which case it may not be
				// aware of how far behind it is. To account for that, we also compute the version difference between
				// each storage server and the tlog with the largest version.
				//
				// Because this data is only logged periodically, this difference will likely be an overestimate for the
				// lag. We subtract off the logging interval in order to make this estimate a bounded underestimate
				// instead.
				versionLag = std::max<int64_t>(
				    versionLag,
				    maxTLogVersion - version - SERVER_KNOBS->STORAGE_LOGGING_DELAY * SERVER_KNOBS->VERSIONS_PER_SECOND);
			}

			TraceEventFields const& readLatencyMetrics = metrics.at("ReadLatencyMetrics");
			if (readLatencyMetrics.size()) {
				obj["read_latency_statistics"] = addLatencyStatistics(readLatencyMetrics);
			}

			TraceEventFields const& readLatencyBands = metrics.at("ReadLatencyBands");
			if (readLatencyBands.size()) {
				obj["read_latency_bands"] = addLatencyBandInfo(readLatencyBands);
			}

			obj["data_lag"] = getLagObject(versionLag);
			obj["durability_lag"] = getLagObject(version - durableVersion);
			dataLagSeconds = versionLag / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;

			TraceEventFields const& busiestReadTag = metrics.at("BusiestReadTag");
			if (busiestReadTag.size()) {
				int64_t tagCost = busiestReadTag.getInt64("TagCost");
				if (tagCost > 0) {
					JsonBuilderObject busiestReadTagObj;
					busiestReadTagObj["tag"] = busiestReadTag.getValue("Tag");
					busiestReadTagObj["cost"] = tagCost;
					busiestReadTagObj["fractional_cost"] = busiestReadTag.getValue("FractionalBusyness");
					obj["busiest_read_tag"] = busiestReadTagObj;
				}
			}

			TraceEventFields const& busiestWriteTag = metrics.at("BusiestWriteTag");
			if (busiestWriteTag.size()) {
				int64_t tagCost = busiestWriteTag.getInt64("TagCost");

				if (tagCost > 0) {
					JsonBuilderObject busiestWriteTagObj;

					int64_t totalCost = busiestWriteTag.getInt64("TotalCost");
					ASSERT(totalCost > 0);

					busiestWriteTagObj["tag"] = busiestWriteTag.getValue("Tag");
					busiestWriteTagObj["fractional_cost"] = (double)tagCost / totalCost;

					double elapsed = busiestWriteTag.getDouble("Elapsed");
					if (elapsed > 0) {
						JsonBuilderObject estimatedCostObj;
						estimatedCostObj["hz"] = tagCost / elapsed;
						busiestWriteTagObj["estimated_cost"] = estimatedCostObj;
					}

					obj["busiest_write_tag"] = busiestWriteTagObj;
				}
			}

			TraceEventFields const& rocksdbMetrics = metrics.at("RocksDBMetrics");
			if (rocksdbMetrics.size()) {
				JsonBuilderObject rocksdbMetricsObj;
				rocksdbMetricsObj.setKeyRawNumber("block_cache_hits", rocksdbMetrics.getValue("BlockCacheHits"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_misses", rocksdbMetrics.getValue("BlockCacheMisses"));
				rocksdbMetricsObj.setKeyRawNumber("pending_compaction_bytes",
				                                  rocksdbMetrics.getValue("EstPendCompactBytes"));
				rocksdbMetricsObj.setKeyRawNumber("memtable_bytes", rocksdbMetrics.getValue("AllMemtablesBytes"));
				rocksdbMetricsObj.setKeyRawNumber("sst_reader_bytes",
				                                  rocksdbMetrics.getValue("EstimateSstReaderBytes"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_usage", rocksdbMetrics.getValue("BlockCacheUsage"));
				rocksdbMetricsObj.setKeyRawNumber("block_cache_limit", rocksdbMetrics.getValue("BlockCacheSize"));
				rocksdbMetricsObj.setKeyRawNumber("throttled_commits", rocksdbMetrics.getValue("CommitDelayed"));
				rocksdbMetricsObj.setKeyRawNumber("write_stall_microseconds", rocksdbMetrics.getValue("StallMicros"));

				obj["rocksdb_metrics"] = std::move(rocksdbMetricsObj);
			}

		} catch (AttributeNotFoundError& e) {
			TraceEvent(SevWarnAlways, "StorageServerStatusJson").detail("MissingAttribute", e.getMissingAttribute());
		}
		if (pDataLagSeconds) {
			*pDataLagSeconds = dataLagSeconds;
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role,
	                           TLogInterface& iface,
	                           EventMap const& metrics,
	                           Version* pMetricVersion) {
		JsonBuilderObject obj;
		Version metricVersion = 0;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& tlogMetrics = metrics.at("TLogMetrics");

			obj.setKeyRawNumber("kvstore_used_bytes", tlogMetrics.getValue("KvstoreBytesUsed"));
			obj.setKeyRawNumber("kvstore_free_bytes", tlogMetrics.getValue("KvstoreBytesFree"));
			obj.setKeyRawNumber("kvstore_available_bytes", tlogMetrics.getValue("KvstoreBytesAvailable"));
			obj.setKeyRawNumber("kvstore_total_bytes", tlogMetrics.getValue("KvstoreBytesTotal"));
			obj.setKeyRawNumber("queue_disk_used_bytes", tlogMetrics.getValue("QueueDiskBytesUsed"));
			obj.setKeyRawNumber("queue_disk_free_bytes", tlogMetrics.getValue("QueueDiskBytesFree"));
			obj.setKeyRawNumber("queue_disk_available_bytes", tlogMetrics.getValue("QueueDiskBytesAvailable"));
			obj.setKeyRawNumber("queue_disk_total_bytes", tlogMetrics.getValue("QueueDiskBytesTotal"));
			obj["input_bytes"] = StatusCounter(tlogMetrics.getValue("BytesInput")).getStatus();
			obj["durable_bytes"] = StatusCounter(tlogMetrics.getValue("BytesDurable")).getStatus();
			metricVersion = tlogMetrics.getInt64("Version");
			obj["data_version"] = metricVersion;
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found)
				throw e;
		}
		if (pMetricVersion)
			*pMetricVersion = metricVersion;
		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	JsonBuilderObject& addRole(std::string const& role, CommitProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			TraceEventFields const& commitLatencyMetrics = metrics.at("CommitLatencyMetrics");
			if (commitLatencyMetrics.size()) {
				obj["commit_latency_statistics"] = addLatencyStatistics(commitLatencyMetrics);
			}

			TraceEventFields const& commitLatencyBands = metrics.at("CommitLatencyBands");
			if (commitLatencyBands.size()) {
				obj["commit_latency_bands"] = addLatencyBandInfo(commitLatencyBands);
			}

			TraceEventFields const& commitBatchingWindowSize = metrics.at("CommitBatchingWindowSize");
			if (commitBatchingWindowSize.size()) {
				obj["commit_batching_window_size"] = addLatencyStatistics(commitBatchingWindowSize);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}

	// Returns a json object encoding a snapshot of grv proxy statistics
	JsonBuilderObject& addRole(std::string const& role, GrvProxyInterface& iface, EventMap const& metrics) {
		JsonBuilderObject obj;
		obj["id"] = iface.id().shortString();
		obj["role"] = role;
		try {
			JsonBuilderObject priorityStats;

			// GRV Latency metrics are grouped according to priority (currently batch or default).
			// Other priorities can be added in the future.
			TraceEventFields const& grvLatencyMetrics = metrics.at("GRVLatencyMetrics");
			if (grvLatencyMetrics.size()) {
				priorityStats["default"] = addLatencyStatistics(grvLatencyMetrics);
			}

			TraceEventFields const& grvBatchMetrics = metrics.at("GRVBatchLatencyMetrics");
			if (grvBatchMetrics.size()) {
				priorityStats["batch"] = addLatencyStatistics(grvBatchMetrics);
			}

			// Add GRV Latency metrics (for all priorities) to parent node.
			if (priorityStats.size()) {
				obj["grv_latency_statistics"] = priorityStats;
			}

			TraceEventFields const& grvLatencyBands = metrics.at("GRVLatencyBands");
			if (grvLatencyBands.size()) {
				obj["grv_latency_bands"] = addLatencyBandInfo(grvLatencyBands);
			}
		} catch (Error& e) {
			if (e.code() != error_code_attribute_not_found) {
				throw e;
			}
		}

		return roles.insert(std::make_pair(iface.address(), obj))->second;
	}
	template <class InterfaceType>
	JsonBuilderObject& addRole(std::string const& role, InterfaceType& iface) {
		return addRole(iface.address(), role, iface.id());
	}
	JsonBuilderObject& addCoordinatorRole(NetworkAddress addr) {
		JsonBuilderObject obj;
		obj["role"] = "coordinator";
		return roles.insert(std::make_pair(addr, obj))->second;
	}
	JsonBuilderArray getStatusForAddress(NetworkAddress a) {
		JsonBuilderArray v;
		auto it = roles.lower_bound(a);
		while (it != roles.end() && it->first == a) {
			v.push_back(it->second);
			++it;
		}
		return v;
	}
};

															#line 1307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via processStatusFetcher()
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ProcessStatusFetcherActor>
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActorState {
															#line 1314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,std::vector<BlobWorkerInterface> const& blobWorkers,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   pMetrics(pMetrics),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mMetrics(mMetrics),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   nMetrics(nMetrics),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   errors(errors),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileOpenErrors(traceFileOpenErrors),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   programStarts(programStarts),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   processIssues(processIssues),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServers(storageServers),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tLogs(tLogs),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   commitProxies(commitProxies),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   grvProxies(grvProxies),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   blobWorkers(blobWorkers),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   coordinators(coordinators),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   coordinatorAddresses(coordinatorAddresses),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   cx(cx),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   healthyZone(healthyZone),
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   processMap(),
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tracefileOpenErrorMap(),
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   traceFileErrorsItr()
															#line 1365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ProcessStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("processStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			traceFileErrorsItr = traceFileOpenErrors.begin();
															#line 1380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		machineMemoryUsage = std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>();
															#line 816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = std::vector<WorkerDetails>::iterator();
															#line 817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 1407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(traceFileErrorsItr != traceFileOpenErrors.end()))
															#line 1423 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1431 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 0, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			try {
															#line 796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (traceFileErrorsItr->second.size())
															#line 1491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			try {
															#line 796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				const TraceEventFields& event = traceFileErrorsItr->second;
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string fileName = event.getValue("Filename");
															#line 798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject msgObj = JsonString::makeMessage( "file_open_error", format("Could not open file '%s' (%s).", fileName.c_str(), event.getValue("Error").c_str()) .c_str());
															#line 802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				msgObj["file_name"] = fileName;
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tracefileOpenErrorMap[traceFileErrorsItr->first.toString()] = msgObj;
															#line 1504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++traceFileErrorsItr;
															#line 1599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("file_open_error details could not be retrieved");
															#line 1623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles = RolesInfo();
															#line 842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("master", db->get().master);
															#line 843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("cluster_controller", db->get().clusterInterface.clientInterface);
															#line 845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().distributor.present())
															#line 1657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("data_distributor", db->get().distributor.get());
															#line 1661 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 1665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("ratekeeper", db->get().ratekeeper.get());
															#line 1669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled && db->get().blobManager.present())
															#line 1673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_manager", db->get().blobManager.get());
															#line 1677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled && db->get().blobMigrator.present())
															#line 1681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_migrator", db->get().blobMigrator.get());
															#line 1685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().consistencyScan.present())
															#line 1689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 862 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("consistency_scan", db->get().consistencyScan.get());
															#line 1693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 865 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (db->get().client.encryptKeyProxy.present())
															#line 1697 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("encrypt_key_proxy", db->get().client.encryptKeyProxy.get());
															#line 1701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 869 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : db->get().logSystemConfig.tLogs ) {
															#line 870 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 1709 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 1713 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = std::vector<OldTLogConf>::const_iterator();
															#line 878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogs = db->get().logSystemConfig.oldTLogs;
															#line 879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		oldTLogIter = oldTLogs.begin();
															#line 1723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 1739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 1, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 1752 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1774 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		memInfo = machineMemoryUsage.insert(std::make_pair(workerItr->interf.locality.machineId(), MachineMemoryInfo())) .first;
															#line 1819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& programStart = programStarts[workerItr->interf.address()];
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (memInfo->second.valid())
															#line 1829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetrics.size() > 0 && programStart.size() > 0)
															#line 1833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.memoryUsage += processMetrics.getDouble("Memory");
															#line 830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.rssUsage += processMetrics.getDouble("ResidentMemory");
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.aggregateLimit += programStart.getDouble("MemoryLimit");
															#line 1841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memInfo->second.invalidate();
															#line 1847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 1939 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			memInfo->second.invalidate();
															#line 1949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( const auto& coordinator : coordinatorAddresses ) {
															#line 896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addCoordinatorRole(coordinator);
															#line 1979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator();
															#line 900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commit_proxy = commitProxies.begin();
															#line 1985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(oldTLogIter != oldTLogs.end()))
															#line 2001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& tLogSet : oldTLogIter->tLogs ) {
															#line 881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.tLogs ) {
															#line 882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 2011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("log", it.interf());
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 886 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto& it : tLogSet.logRouters ) {
															#line 887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (it.present())
															#line 2022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					roles.addRole("router", it.interf());
															#line 2026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 2, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++oldTLogIter;
															#line 2070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont13(int loopDepth) 
	{
															#line 905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator();
															#line 906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxy = grvProxies.begin();
															#line 2156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(commit_proxy != commitProxies.end()))
															#line 2172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("commit_proxy", commit_proxy->first, commit_proxy->second);
															#line 902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 3, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++commit_proxy;
															#line 2218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13cont1(int loopDepth) 
	{
															#line 911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		log = std::vector<std::pair<TLogInterface, EventMap>>::iterator();
															#line 912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = 0;
															#line 915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		log = tLogs.begin();
															#line 2306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1(int loopDepth) 
	{
															#line 906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(grvProxy != grvProxies.end()))
															#line 2322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("grv_proxy", grvProxy->first, grvProxy->second);
															#line 908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 4, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++grvProxy;
															#line 2368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13cont2(int loopDepth) 
	{
															#line 922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ss = std::vector<StorageServerStatusInfo>::iterator();
															#line 923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ssLag = std::map<NetworkAddress, double>();
															#line 924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		lagSeconds = double();
															#line 925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ss = storageServers.begin();
															#line 2458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1(int loopDepth) 
	{
															#line 915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(log != tLogs.end()))
															#line 2474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 916 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		Version tLogVersion = 0;
															#line 917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("log", log->first, log->second, &tLogVersion);
															#line 918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		maxTLogVersion = std::max(maxTLogVersion, tLogVersion);
															#line 919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_5 = yield();
															#line 919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont1loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 5, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++log;
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont13cont3(int loopDepth) 
	{
															#line 933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res = std::vector<ResolverInterface>::const_iterator();
															#line 934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		resolvers = db->get().resolvers;
															#line 935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res = resolvers.begin();
															#line 2612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1(int loopDepth) 
	{
															#line 925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(ss != storageServers.end()))
															#line 2628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 926 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("storage", *ss, maxTLogVersion, &lagSeconds);
															#line 927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lagSeconds != -1.0)
															#line 2636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ssLag[ss->address()] = lagSeconds;
															#line 2640 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_6 = yield();
															#line 930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont2loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 7;
															#line 930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 6, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++ss;
															#line 2682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont13cont4(int loopDepth) 
	{
															#line 940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (configuration.present() && configuration.get().blobGranulesEnabled)
															#line 2766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			RangeForbody1cont13cont4Iterator0 = std::begin(blobWorkers);
															#line 2770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont4loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont13cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1(int loopDepth) 
	{
															#line 935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(res != resolvers.end()))
															#line 2791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		roles.addRole("resolver", *res);
															#line 937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_7 = yield();
															#line 937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont3loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 8;
															#line 937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 7, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++res;
															#line 2837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont13cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont13cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont13cont5(int loopDepth) 
	{
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		workerItr = workers.begin();
															#line 2921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont13cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont6(int loopDepth) 
	{
		loopDepth = a_body1cont13cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1(int loopDepth) 
	{
															#line 941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(RangeForbody1cont13cont4Iterator0 != std::end(blobWorkers)))
															#line 2943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto blobWorker = *RangeForbody1cont13cont4Iterator0;
															#line 2949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			roles.addRole("blob_worker", blobWorker);
															#line 943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_8 = yield();
															#line 943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont4loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 9;
															#line 943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 8, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 2962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont13cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont1(int loopDepth) 
	{
															#line 941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++RangeForbody1cont13cont4Iterator0;
															#line 2985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont13cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont13cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont13cont7(int loopDepth) 
	{
															#line 1142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ProcessStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(processMap); this->~ProcessStatusFetcherActorState(); static_cast<ProcessStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 3081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ProcessStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(processMap)); // state_var_RVO
		this->~ProcessStatusFetcherActorState();
		static_cast<ProcessStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1(int loopDepth) 
	{
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(workerItr != workers.end()))
															#line 3100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1cont13cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_9 = yield();
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont5loopBody1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 10;
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ProcessStatusFetcherActor, 9, Void >*>(static_cast<ProcessStatusFetcherActor*>(this)));
															#line 3113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 3135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 3149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 3157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 3161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 980 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 3185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 981 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 982 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 995 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 997 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 1000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 1001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 1004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 1005 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 1006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 1008 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 1010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 1011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 1012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 1013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 1014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 1015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 1016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 1017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 1018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 1019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 1021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 1022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 1023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1042 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1045 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 1053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
				}
			}
															#line 1061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1063 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1084 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			try {
															#line 1123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1cont13cont5loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj = JsonBuilderObject();
															#line 3437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			ASSERT(pMetrics.contains(workerItr->interf.address()));
															#line 953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			NetworkAddress address = workerItr->interf.address();
															#line 954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& processMetrics = pMetrics[workerItr->interf.address()];
															#line 955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["address"] = address.toString();
															#line 956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject memoryObj;
															#line 958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics.size() > 0)
															#line 3451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string zoneID = processMetrics.getValue("ZoneID");
															#line 960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["fault_domain"] = zoneID;
															#line 961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.present() && healthyZone == workerItr->interf.locality.zoneId())
															#line 3459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["under_maintenance"] = true;
															#line 3463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::string MachineID = processMetrics.getValue("MachineID");
															#line 966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["machine_id"] = MachineID;
															#line 968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["locality"] = workerItr->interf.locality.toJSON<JsonBuilderObject>();
															#line 970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj.setKeyRawNumber("uptime_seconds", processMetrics.getValue("UptimeSeconds"));
															#line 973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double processMetricsElapsed = processMetrics.getDouble("Elapsed");
															#line 974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double cpuSeconds = processMetrics.getDouble("CPUSeconds");
															#line 975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskIdleSeconds = processMetrics.getDouble("DiskIdleSeconds");
															#line 976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskReads = processMetrics.getDouble("DiskReads");
															#line 977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double diskWrites = processMetrics.getDouble("DiskWrites");
															#line 979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject diskObj;
															#line 980 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (processMetricsElapsed > 0)
															#line 3487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 981 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject cpuObj;
															#line 982 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					cpuObj["usage_cores"] = std::max(0.0, cpuSeconds / processMetricsElapsed);
															#line 983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObj["cpu"] = cpuObj;
															#line 985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["busy"] = std::max(0.0, std::min((processMetricsElapsed - diskIdleSeconds) / processMetricsElapsed, 1.0));
															#line 988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject readsObj;
															#line 989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("counter", processMetrics.getValue("DiskReadsCount"));
															#line 990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						readsObj["hz"] = diskReads / processMetricsElapsed;
															#line 3507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					readsObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskReadSectors"));
															#line 994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					JsonBuilderObject writesObj;
															#line 995 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("counter", processMetrics.getValue("DiskWritesCount"));
															#line 996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (processMetricsElapsed > 0)
															#line 3517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 997 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						writesObj["hz"] = diskWrites / processMetricsElapsed;
															#line 3521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					writesObj.setKeyRawNumber("sectors", processMetrics.getValue("DiskWriteSectors"));
															#line 1000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["reads"] = readsObj;
															#line 1001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					diskObj["writes"] = writesObj;
															#line 3529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 1004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("total_bytes", processMetrics.getValue("DiskTotalBytes"));
															#line 1005 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				diskObj.setKeyRawNumber("free_bytes", processMetrics.getValue("DiskFreeBytes"));
															#line 1006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["disk"] = diskObj;
															#line 1008 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject networkObj;
															#line 1010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj.setKeyRawNumber("current_connections", processMetrics.getValue("CurrentConnections"));
															#line 1011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_established;
															#line 1012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_established.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsEstablished"));
															#line 1013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_established"] = connections_established;
															#line 1014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connections_closed;
															#line 1015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connections_closed.setKeyRawNumber("hz", processMetrics.getValue("ConnectionsClosed"));
															#line 1016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connections_closed"] = connections_closed;
															#line 1017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject connection_errors;
															#line 1018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				connection_errors.setKeyRawNumber("hz", processMetrics.getValue("ConnectionErrors"));
															#line 1019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["connection_errors"] = connection_errors;
															#line 1021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_sent;
															#line 1022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_sent.setKeyRawNumber("hz", processMetrics.getValue("MbpsSent"));
															#line 1023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_sent"] = megabits_sent;
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject megabits_received;
															#line 1026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				megabits_received.setKeyRawNumber("hz", processMetrics.getValue("MbpsReceived"));
															#line 1027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["megabits_received"] = megabits_received;
															#line 1029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject tls_policy_failures;
															#line 1030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tls_policy_failures.setKeyRawNumber("hz", processMetrics.getValue("TLSPolicyFailures"));
															#line 1031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				networkObj["tls_policy_failures"] = tls_policy_failures;
															#line 1033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["network"] = networkObj;
															#line 1035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("used_bytes", processMetrics.getValue("Memory"));
															#line 1036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("rss_bytes", processMetrics.getValue("ResidentMemory"));
															#line 1037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				memoryObj.setKeyRawNumber("unused_allocated_memory", processMetrics.getValue("UnusedAllocatedMemory"));
															#line 3585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t memoryLimit = 0;
															#line 1041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (programStarts.contains(address))
															#line 3591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1042 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto const& programStartEvent = programStarts.at(address);
															#line 1044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (programStartEvent.size() > 0)
															#line 3597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1045 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryLimit = programStartEvent.getInt64("MemoryLimit");
															#line 1046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj.setKey("limit_bytes", memoryLimit);
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string version;
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("Version", version))
															#line 3607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["version"] = version;
															#line 3611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
															#line 1053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string commandLine;
															#line 1054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (programStartEvent.tryGetValue("CommandLine", commandLine))
															#line 3617 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						statusObj["command_line"] = commandLine;
															#line 3621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
				}
			}
															#line 1061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mMetrics.contains(address) && mMetrics[address].size())
															#line 3627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double availableMemory;
															#line 1063 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				availableMemory = mMetrics[address].getDouble("AvailableMemory");
															#line 1065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto machineMemInfo = machineMemoryUsage[workerItr->interf.locality.machineId()];
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (machineMemInfo.valid() && memoryLimit > 0)
															#line 3637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					ASSERT(machineMemInfo.aggregateLimit > 0);
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					int64_t memory = (availableMemory + machineMemInfo.rssUsage) * memoryLimit / machineMemInfo.aggregateLimit;
															#line 1070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					memoryObj["available_bytes"] = std::min<int64_t>(std::max<int64_t>(memory, 0), memoryLimit);
															#line 3645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["memory"] = memoryObj;
															#line 1076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderArray messages;
															#line 1078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (errors.contains(address) && errors[address].size())
															#line 3654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(getError(errors.at(address)));
															#line 3658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1084 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string strAddress = address.toString();
															#line 1087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto issue : processIssues[strAddress] ) {
															#line 1088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(issue);
															#line 3666 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (tracefileOpenErrorMap.contains(strAddress))
															#line 3670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(tracefileOpenErrorMap[strAddress]);
															#line 3674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (ssLag[address] >= 60)
															#line 3678 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages.push_back(JsonString::makeMessage( "storage_server_lagging", format("Storage server lagging by %lld seconds.", (int64_t)ssLag[address]).c_str()));
															#line 3682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["messages"] = messages;
															#line 1106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["roles"] = roles.getStatusForAddress(address);
															#line 1108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (configuration.present())
															#line 3690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["excluded"] = configuration.get().isExcludedServer(workerItr->interf.addresses(), workerItr->interf.locality);
															#line 3694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_type"] = workerItr->processClass.toString();
															#line 1114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["class_source"] = workerItr->processClass.sourceString();
															#line 1115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (workerItr->degraded)
															#line 3702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["degraded"] = true;
															#line 3706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& networkMetrics = nMetrics[workerItr->interf.address()];
															#line 1120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			double networkMetricsElapsed = networkMetrics.getDouble("Elapsed");
															#line 3712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			try {
															#line 1123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double runLoopBusy = networkMetrics.getDouble("PriorityStarvedBelow1");
															#line 1124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj["run_loop_busy"] = runLoopBusy / networkMetricsElapsed;
															#line 3718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1cont13cont5loopBody1cont23(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont13cont5loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ProcessStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStatusFetcherActor*>(this)->ActorCallback< ProcessStatusFetcherActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont13cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont13cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ProcessStatusFetcherActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont13cont5loopBody1cont3(int loopDepth) 
	{
															#line 1140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		processMap[printable(workerItr->interf.locality.processId())] = statusObj;
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++workerItr;
															#line 3816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve all process status information.");
															#line 3834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont13cont5loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Cannot retrieve run loop busyness.");
															#line 3856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont13cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont23(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont13cont5loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont5loopBody1cont24(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents mMetrics;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents nMetrics;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents errors;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents traceFileOpenErrors;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents programStarts;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, std::vector<JsonBuilderObject>> processIssues;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> storageServers;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>> tLogs;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>> commitProxies;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>> grvProxies;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<BlobWorkerInterface> blobWorkers;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ServerCoordinators coordinators;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<NetworkAddress> coordinatorAddresses;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> configuration;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<Key> healthyZone;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject processMap;
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<std::string, JsonBuilderObject> tracefileOpenErrorMap;
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents::iterator traceFileErrorsItr;
															#line 815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo> machineMemoryUsage;
															#line 816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails>::iterator workerItr;
															#line 819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, MachineMemoryInfo>::iterator memInfo;
															#line 840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RolesInfo roles;
															#line 877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf>::const_iterator oldTLogIter;
															#line 878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<OldTLogConf> oldTLogs;
															#line 899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<CommitProxyInterface, EventMap>>::iterator commit_proxy;
															#line 905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<GrvProxyInterface, EventMap>>::iterator grvProxy;
															#line 911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<TLogInterface, EventMap>>::iterator log;
															#line 912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Version maxTLogVersion;
															#line 922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo>::iterator ss;
															#line 923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::map<NetworkAddress, double> ssLag;
															#line 924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double lagSeconds;
															#line 933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface>::const_iterator res;
															#line 934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<ResolverInterface> resolvers;
															#line 941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	decltype(std::begin(std::declval<std::vector<BlobWorkerInterface>>())) RangeForbody1cont13cont4Iterator0;
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 3973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via processStatusFetcher()
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ProcessStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ProcessStatusFetcherActor, 0, Void >, public ActorCallback< ProcessStatusFetcherActor, 1, Void >, public ActorCallback< ProcessStatusFetcherActor, 2, Void >, public ActorCallback< ProcessStatusFetcherActor, 3, Void >, public ActorCallback< ProcessStatusFetcherActor, 4, Void >, public ActorCallback< ProcessStatusFetcherActor, 5, Void >, public ActorCallback< ProcessStatusFetcherActor, 6, Void >, public ActorCallback< ProcessStatusFetcherActor, 7, Void >, public ActorCallback< ProcessStatusFetcherActor, 8, Void >, public ActorCallback< ProcessStatusFetcherActor, 9, Void >, public FastAllocated<ProcessStatusFetcherActor>, public ProcessStatusFetcherActorState<ProcessStatusFetcherActor> {
															#line 3978 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ProcessStatusFetcherActor>::operator new;
	using FastAllocated<ProcessStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4632420535797527296UL, 962581113840449792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessStatusFetcherActor, 0, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 1, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 2, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 3, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 4, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 5, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 6, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 7, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 8, Void >;
friend struct ActorCallback< ProcessStatusFetcherActor, 9, Void >;
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ProcessStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerEvents const& pMetrics,WorkerEvents const& mMetrics,WorkerEvents const& nMetrics,WorkerEvents const& errors,WorkerEvents const& traceFileOpenErrors,WorkerEvents const& programStarts,std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues,std::vector<StorageServerStatusInfo> const& storageServers,std::vector<std::pair<TLogInterface, EventMap>> const& tLogs,std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies,std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies,std::vector<BlobWorkerInterface> const& blobWorkers,ServerCoordinators const& coordinators,std::vector<NetworkAddress> const& coordinatorAddresses,Database const& cx,Optional<DatabaseConfiguration> const& configuration,Optional<Key> const& healthyZone,std::set<std::string>* const& incomplete_reasons) 
															#line 4004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   ProcessStatusFetcherActorState<ProcessStatusFetcherActor>(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, blobWorkers, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16236183218422400512UL, 108313917293822208UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ProcessStatusFetcherActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> processStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerEvents const& pMetrics, WorkerEvents const& mMetrics, WorkerEvents const& nMetrics, WorkerEvents const& errors, WorkerEvents const& traceFileOpenErrors, WorkerEvents const& programStarts, std::map<std::string, std::vector<JsonBuilderObject>> const& processIssues, std::vector<StorageServerStatusInfo> const& storageServers, std::vector<std::pair<TLogInterface, EventMap>> const& tLogs, std::vector<std::pair<CommitProxyInterface, EventMap>> const& commitProxies, std::vector<std::pair<GrvProxyInterface, EventMap>> const& grvProxies, std::vector<BlobWorkerInterface> const& blobWorkers, ServerCoordinators const& coordinators, std::vector<NetworkAddress> const& coordinatorAddresses, Database const& cx, Optional<DatabaseConfiguration> const& configuration, Optional<Key> const& healthyZone, std::set<std::string>* const& incomplete_reasons ) {
															#line 762 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ProcessStatusFetcherActor(db, workers, pMetrics, mMetrics, nMetrics, errors, traceFileOpenErrors, programStarts, processIssues, storageServers, tLogs, commitProxies, grvProxies, blobWorkers, coordinators, coordinatorAddresses, cx, configuration, healthyZone, incomplete_reasons));
															#line 4046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject grayFailureStatus(const std::unordered_map<NetworkAddress, double>& excludedDegradedServers) {
	JsonBuilderObject status;
	JsonBuilderArray excludedServers;
	for (const auto& [excludedServer, time] : excludedDegradedServers) {
		JsonBuilderObject server;
		server["address"] = excludedServer.toString();
		server["time"] = time;
		excludedServers.push_back(server);
	}
	status["excluded_servers"] = excludedServers;
	return status;
}

static JsonBuilderObject clientStatusFetcher(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderObject clientStatus;

	int64_t clientCount = 0;
	// Here we handle versions and maxSupportedProtocols, the issues will be handled in getClientIssuesAsMessages
	std::map<Standalone<ClientVersionRef>, OpenDatabaseRequest::Samples> supportedVersions;
	std::map<Key, OpenDatabaseRequest::Samples> maxSupportedProtocol;

	for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
		if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
			iter = clientStatusMap->erase(iter);
			continue;
		}

		clientCount += iter->second.second.clientCount;
		for (const auto& [version, samples] : iter->second.second.supportedVersions) {
			supportedVersions[version] += samples;
		}
		for (const auto& [protocol, samples] : iter->second.second.maxProtocolSupported) {
			maxSupportedProtocol[protocol] += samples;
		}
		++iter;
	}

	clientStatus["count"] = clientCount;

	JsonBuilderArray versionsArray = JsonBuilderArray();
	for (const auto& [clientVersionRef, samples] : supportedVersions) {
		JsonBuilderObject ver;
		ver["count"] = (int64_t)samples.count;
		ver["client_version"] = clientVersionRef.clientVersion.toString();
		ver["protocol_version"] = clientVersionRef.protocolVersion.toString();
		ver["source_version"] = clientVersionRef.sourceVersion.toString();

		JsonBuilderArray clients = JsonBuilderArray();
		for (const auto& [networkAddress, trackLogGroup] : samples.samples) {
			JsonBuilderObject cli;
			cli["address"] = networkAddress.toString();
			cli["log_group"] = trackLogGroup.toString();
			clients.push_back(cli);
		}

		auto iter = maxSupportedProtocol.find(clientVersionRef.protocolVersion);
		if (iter != std::end(maxSupportedProtocol)) {
			JsonBuilderArray maxClients = JsonBuilderArray();
			for (const auto& [networkAddress, trackLogGroup] : iter->second.samples) {
				JsonBuilderObject cli;
				cli["address"] = networkAddress.toString();
				cli["log_group"] = trackLogGroup.toString();
				maxClients.push_back(cli);
			}
			ver["max_protocol_count"] = iter->second.count;
			ver["max_protocol_clients"] = maxClients;
			maxSupportedProtocol.erase(clientVersionRef.protocolVersion);
		}

		ver["connected_clients"] = clients;
		versionsArray.push_back(ver);
	}

	if (versionsArray.size() > 0) {
		clientStatus["supported_versions"] = versionsArray;
	}

	return clientStatus;
}

															#line 4132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class RecoveryStateStatusFetcherActor>
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActorState {
															#line 4139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActorState(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker),
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workerCount(workerCount),
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusCode(statusCode),
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   message(),
															#line 1233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx)
															#line 4160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~RecoveryStateStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mdActiveGensF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME)))), 1.0);
															#line 1239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mdF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME)))), 1.0);
															#line 1243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				mDBAvailableF = timeoutError(ccWorker.interf.eventLogRequest.getReply(EventLogRequest(StringRef( getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME)))), 1.0);
															#line 1247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				rvF = errorOr(timeoutError(tr.getReadVersion(), 1.0));
															#line 1250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(mdActiveGensF) && success(mdF) && success(rvF) && success(mDBAvailableF);
															#line 1250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*>(static_cast<RecoveryStateStatusFetcherActor*>(this)));
															#line 4193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (message.empty())
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Recovery Status unavailable.");
															#line 4226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~RecoveryStateStatusFetcherActorState(); static_cast<RecoveryStateStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 4230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<RecoveryStateStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~RecoveryStateStatusFetcherActorState();
		static_cast<RecoveryStateStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
		else
		{
															#line 1271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& md = mdF.get();
															#line 1253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int mStatusCode = md.getInt("StatusCode");
															#line 1254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode < 0 || mStatusCode >= RecoveryStatus::END)
															#line 4361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(attribute_not_found(), loopDepth);
															#line 4365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message = JsonString::makeMessage(RecoveryStatus::names[mStatusCode], RecoveryStatus::descriptions[mStatusCode]);
															#line 1259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*statusCode = mStatusCode;
															#line 1261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ErrorOr<Version> rv = rvF.get();
															#line 1262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& dbAvailableMsg = mDBAvailableF.get();
															#line 1263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dbAvailableMsg.size() > 0)
															#line 4377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t availableAtVersion = dbAvailableMsg.getInt64("AvailableAtVersion");
															#line 1265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!rv.isError())
															#line 4383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double lastRecoveredSecondsAgo = std::max((int64_t)0, (int64_t)(rv.get() - availableAtVersion)) / (double)SERVER_KNOBS->VERSIONS_PER_SECOND;
															#line 1268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["seconds_since_last_recovered"] = lastRecoveredSecondsAgo;
															#line 4389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
		else
		{
															#line 1271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["seconds_since_last_recovered"] = -1;
															#line 4396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mStatusCode == RecoveryStatus::recruiting_transaction_servers)
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredLogs = atoi(md.getValue("RequiredTLogs").c_str());
															#line 1277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredCommitProxies = atoi(md.getValue("RequiredCommitProxies").c_str());
															#line 1278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredGrvProxies = atoi(md.getValue("RequiredGrvProxies").c_str());
															#line 1279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int requiredResolvers = atoi(md.getValue("RequiredResolvers").c_str());
															#line 1283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_logs"] = requiredLogs;
															#line 1284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_commit_proxies"] = requiredCommitProxies;
															#line 1285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_grv_proxies"] = requiredGrvProxies;
															#line 1286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["required_resolvers"] = requiredResolvers;
															#line 4418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (mStatusCode == RecoveryStatus::locking_old_transaction_servers)
															#line 4424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				message["missing_logs"] = md.getValue("MissingIDs").c_str();
															#line 4428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& mdActiveGens = mdActiveGensF.get();
															#line 1295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (mdActiveGens.size())
															#line 4435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int activeGenerations = mdActiveGens.getInt("ActiveGenerations");
															#line 1297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			message["active_generations"] = activeGenerations;
															#line 4441 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<RecoveryStateStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<RecoveryStateStatusFetcherActor*>(this)->ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int workerCount;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* statusCode;
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdActiveGensF;
															#line 1239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mdF;
															#line 1243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> mDBAvailableF;
															#line 1248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<Version>> rvF;
															#line 4559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via recoveryStateStatusFetcher()
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class RecoveryStateStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >, public FastAllocated<RecoveryStateStatusFetcherActor>, public RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor> {
															#line 4564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator new;
	using FastAllocated<RecoveryStateStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7105137547340919296UL, 18161574297391066624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >;
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RecoveryStateStatusFetcherActor(Database const& cx,WorkerDetails const& ccWorker,WorkerDetails const& mWorker,int const& workerCount,std::set<std::string>* const& incomplete_reasons,int* const& statusCode) 
															#line 4581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   RecoveryStateStatusFetcherActorState<RecoveryStateStatusFetcherActor>(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2143522345445455872UL, 12399124894024078592UL);
		ActorExecutionContextHelper __helper(static_cast<RecoveryStateStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recoveryStateStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recoveryStateStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecoveryStateStatusFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> recoveryStateStatusFetcher( Database const& cx, WorkerDetails const& ccWorker, WorkerDetails const& mWorker, int const& workerCount, std::set<std::string>* const& incomplete_reasons, int* const& statusCode ) {
															#line 1226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new RecoveryStateStatusFetcherActor(cx, ccWorker, mWorker, workerCount, incomplete_reasons, statusCode));
															#line 4614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 4619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doGrvProbe()
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoGrvProbeActor>
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActorState {
															#line 4626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActorState(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : tr(tr),
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   priority(priority),
															#line 1316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   start(g_network->timer_monotonic())
															#line 4637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoGrvProbeActorState() 
	{
		fdb_probe_actor_destroy("doGrvProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 4652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (priority.present())
															#line 4685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(priority.get());
															#line 4689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->getReadVersion());
															#line 1325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4695 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 1;
															#line 1325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 0, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 2;
															#line 1328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoGrvProbeActor, 1, Void >*>(static_cast<DoGrvProbeActor*>(this)));
															#line 4729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoGrvProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoGrvProbeActorState(); static_cast<DoGrvProbeActor*>(this)->destroy(); return 0; }
															#line 4756 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoGrvProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoGrvProbeActorState();
		static_cast<DoGrvProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoGrvProbeActor*>(this)->actor_wait_state > 0) static_cast<DoGrvProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvProbeActor*>(this)->ActorCallback< DoGrvProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoGrvProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoGrvProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<FDBTransactionOptions::Option> priority;
															#line 1316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 4932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doGrvProbe()
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoGrvProbeActor final : public Actor<double>, public ActorCallback< DoGrvProbeActor, 0, Void >, public ActorCallback< DoGrvProbeActor, 1, Void >, public FastAllocated<DoGrvProbeActor>, public DoGrvProbeActorState<DoGrvProbeActor> {
															#line 4937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoGrvProbeActor>::operator new;
	using FastAllocated<DoGrvProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7708681086478767104UL, 4360760167697145088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoGrvProbeActor, 0, Void >;
friend struct ActorCallback< DoGrvProbeActor, 1, Void >;
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoGrvProbeActor(Transaction* const& tr,Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>()) 
															#line 4955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoGrvProbeActorState<DoGrvProbeActor>(tr, priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12695868933801491712UL, 15656792167232969216UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doGrvProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doGrvProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoGrvProbeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoGrvProbeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doGrvProbe( Transaction* const& tr, Optional<FDBTransactionOptions::Option> const& priority = Optional<FDBTransactionOptions::Option>() ) {
															#line 1313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoGrvProbeActor(tr, priority));
															#line 4989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 4994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doReadProbe()
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoReadProbeActor>
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActorState {
															#line 5001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActorState(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 5010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoReadProbeActorState() 
	{
		fdb_probe_actor_destroy("doReadProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 1;
															#line 1334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5084 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 5175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 1344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = tr->get("\xff/StatusJsonTestKey62793"_sr);
															#line 1344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 2;
															#line 1344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoReadProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoReadProbeActor*>(this)->actor_wait_state = 3;
															#line 1347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoReadProbeActor, 2, Void >*>(static_cast<DoReadProbeActor*>(this)));
															#line 5215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
															#line 1345 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
															#line 1345 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoReadProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoReadProbeActorState(); static_cast<DoReadProbeActor*>(this)->destroy(); return 0; }
															#line 5242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoReadProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoReadProbeActorState();
		static_cast<DoReadProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Standalone<StringRef>> && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoReadProbeActor*>(this)->actor_wait_state > 0) static_cast<DoReadProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadProbeActor*>(this)->ActorCallback< DoReadProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoReadProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoReadProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doReadProbe()
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoReadProbeActor final : public Actor<double>, public ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< DoReadProbeActor, 2, Void >, public FastAllocated<DoReadProbeActor>, public DoReadProbeActorState<DoReadProbeActor> {
															#line 5429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoReadProbeActor>::operator new;
	using FastAllocated<DoReadProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3513193802092962816UL, 11697953619943678720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< DoReadProbeActor, 2, Void >;
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoReadProbeActor(Future<double> const& grvProbe,Transaction* const& tr) 
															#line 5448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoReadProbeActorState<DoReadProbeActor>(grvProbe, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doReadProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18395811845136080640UL, 11329582461020487936UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doReadProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doReadProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoReadProbeActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoReadProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doReadProbe( Future<double> const& grvProbe, Transaction* const& tr ) {
															#line 1333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoReadProbeActor(grvProbe, tr));
															#line 5483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 5488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doCommitProbe()
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoCommitProbeActor>
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActorState {
															#line 5495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActorState(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : grvProbe(grvProbe),
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   sourceTr(sourceTr),
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(tr)
															#line 5506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoCommitProbeActorState() 
	{
		fdb_probe_actor_destroy("doCommitProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(grvProbe);
															#line 1354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 1;
															#line 1354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> const& grv,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5555 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5569 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<double> && grv,int loopDepth) 
	{
															#line 1355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (grv.isError())
															#line 5578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch1(grv.getError(), loopDepth);
															#line 5582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(sourceTr->getReadVersion().isReady());
															#line 1360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->setVersion(sourceTr->getReadVersion().get());
															#line 1361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->getDatabase()->ssVersionVectorCache = sourceTr->getDatabase()->ssVersionVectorCache;
															#line 1362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr->trState->readVersionObtainedFromGrvProxy = sourceTr->trState->readVersionObtainedFromGrvProxy;
															#line 1364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		start = g_network->timer_monotonic();
															#line 1366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		;
															#line 5596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(grv, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && grv,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(grv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->makeSelfConflicting();
															#line 1371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 2;
															#line 1371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 1, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 3;
															#line 1374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCommitProbeActor, 2, Void >*>(static_cast<DoCommitProbeActor*>(this)));
															#line 5730 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoCommitProbeActor*>(this)->SAV<double>::futures) { (void)(g_network->timer_monotonic() - start); this->~DoCommitProbeActorState(); static_cast<DoCommitProbeActor*>(this)->destroy(); return 0; }
															#line 5757 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoCommitProbeActor*>(this)->SAV< double >::value()) double(g_network->timer_monotonic() - start);
		this->~DoCommitProbeActorState();
		static_cast<DoCommitProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCommitProbeActor*>(this)->actor_wait_state > 0) static_cast<DoCommitProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoCommitProbeActor*>(this)->ActorCallback< DoCommitProbeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCommitProbeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCommitProbeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> grvProbe;
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* sourceTr;
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction* tr;
															#line 1364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double start;
															#line 5935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doCommitProbe()
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoCommitProbeActor final : public Actor<double>, public ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoCommitProbeActor, 1, Void >, public ActorCallback< DoCommitProbeActor, 2, Void >, public FastAllocated<DoCommitProbeActor>, public DoCommitProbeActorState<DoCommitProbeActor> {
															#line 5940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoCommitProbeActor>::operator new;
	using FastAllocated<DoCommitProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(850543811067153408UL, 14737275603210139648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoCommitProbeActor, 1, Void >;
friend struct ActorCallback< DoCommitProbeActor, 2, Void >;
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoCommitProbeActor(Future<double> const& grvProbe,Transaction* const& sourceTr,Transaction* const& tr) 
															#line 5959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<double>(),
		   DoCommitProbeActorState<DoCommitProbeActor>(grvProbe, sourceTr, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12181102828360946944UL, 14510411821951618048UL);
		ActorExecutionContextHelper __helper(static_cast<DoCommitProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCommitProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCommitProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCommitProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCommitProbeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCommitProbeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<double> doCommitProbe( Future<double> const& grvProbe, Transaction* const& sourceTr, Transaction* const& tr ) {
															#line 1353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<double>(new DoCommitProbeActor(grvProbe, sourceTr, tr));
															#line 5994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 5999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via doProbe()
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DoProbeActor>
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActorState {
															#line 6006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActorState(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : probe(probe),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(timeoutSeconds),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   prefix(prefix),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   description(description),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   probeObj(probeObj),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable)
															#line 6027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("doProbe", reinterpret_cast<unsigned long>(this));

	}
	~DoProbeActorState() 
	{
		fdb_probe_actor_destroy("doProbe", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<double>> __when_expr_0 = errorOr(probe);
															#line 1387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<DoProbeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(timeoutSeconds);
															#line 6048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<DoProbeActor*>(this)->actor_wait_state = 1;
															#line 1388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 0, ErrorOr<double> >*>(static_cast<DoProbeActor*>(this)));
															#line 1399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoProbeActor, 1, Void >*>(static_cast<DoProbeActor*>(this)));
															#line 6055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DoProbeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoProbeActorState(); static_cast<DoProbeActor*>(this)->destroy(); return 0; }
															#line 6078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DoProbeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoProbeActorState();
		static_cast<DoProbeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> const& result,int loopDepth) 
	{
															#line 1389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 6090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 6094 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 6098 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 6102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 6108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<double> && result,int loopDepth) 
	{
															#line 1389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (result.isError())
															#line 6118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (isAvailable != nullptr)
															#line 6122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*isAvailable = false;
															#line 6126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format( "Unable to retrieve latency probe information (%s: %s).", description, result.getError().what()));
															#line 6130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*probeObj)[format("%s_seconds", prefix).c_str()] = result.get();
															#line 6136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 6146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 6150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 6154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (isAvailable != nullptr)
															#line 6163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			*isAvailable = false;
															#line 6167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage(format("%s_probe_timeout", prefix).c_str(), format("Unable to %s after %d seconds.", description, timeoutSeconds).c_str()));
															#line 6171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoProbeActor*>(this)->actor_wait_state > 0) static_cast<DoProbeActor*>(this)->actor_wait_state = 0;
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 0, ErrorOr<double> >::remove();
		static_cast<DoProbeActor*>(this)->ActorCallback< DoProbeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,ErrorOr<double> && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 0, ErrorOr<double> >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoProbeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoProbeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<double> probe;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	const char* prefix;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	const char* description;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* probeObj;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 6313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via doProbe()
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DoProbeActor final : public Actor<Void>, public ActorCallback< DoProbeActor, 0, ErrorOr<double> >, public ActorCallback< DoProbeActor, 1, Void >, public FastAllocated<DoProbeActor>, public DoProbeActorState<DoProbeActor> {
															#line 6318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DoProbeActor>::operator new;
	using FastAllocated<DoProbeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2366490414648481536UL, 16028057015784927488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoProbeActor, 0, ErrorOr<double> >;
friend struct ActorCallback< DoProbeActor, 1, Void >;
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DoProbeActor(Future<double> const& probe,int const& timeoutSeconds,const char* const& prefix,const char* const& description,JsonBuilderObject* const& probeObj,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable = nullptr) 
															#line 6336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   DoProbeActorState<DoProbeActor>(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doProbe", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15729666029307177216UL, 15210686459627708928UL);
		ActorExecutionContextHelper __helper(static_cast<DoProbeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doProbe");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doProbe", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoProbeActor, 0, ErrorOr<double> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> doProbe( Future<double> const& probe, int const& timeoutSeconds, const char* const& prefix, const char* const& description, JsonBuilderObject* const& probeObj, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable = nullptr ) {
															#line 1379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new DoProbeActor(probe, timeoutSeconds, prefix, description, probeObj, messages, incomplete_reasons, isAvailable));
															#line 6369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 6374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via latencyProbeFetcher()
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LatencyProbeFetcherActor>
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActorState {
															#line 6381 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   isAvailable(isAvailable),
															#line 1416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trImmediate(cx),
															#line 1417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trDefault(cx),
															#line 1418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trBatch(cx),
															#line 1419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   trWrite(cx),
															#line 1421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 6404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LatencyProbeFetcherActorState() 
	{
		fdb_probe_actor_destroy("latencyProbeFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> immediateGrvProbe = doGrvProbe(&trImmediate, FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> defaultGrvProbe = doGrvProbe(&trDefault);
															#line 1426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> batchGrvProbe = doGrvProbe(&trBatch, FDBTransactionOptions::PRIORITY_BATCH);
															#line 1428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> readProbe = doReadProbe(immediateGrvProbe, &trImmediate);
															#line 1429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				Future<double> commitProbe = doCommitProbe(immediateGrvProbe, &trImmediate, &trWrite);
															#line 1431 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int timeoutSeconds = 5;
															#line 1433 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<Void>> probes;
															#line 1434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(immediateGrvProbe, timeoutSeconds, "immediate_priority_transaction_start", "start immediate priority transaction", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(defaultGrvProbe, timeoutSeconds, "transaction_start", "start default priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe(batchGrvProbe, timeoutSeconds, "batch_priority_transaction_start", "start batch priority transaction", &statusObj, messages, incomplete_reasons));
															#line 1456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back( doProbe(readProbe, timeoutSeconds, "read", "read", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				probes.push_back(doProbe( commitProbe, timeoutSeconds, "commit", "commit", &statusObj, messages, incomplete_reasons, isAvailable));
															#line 1461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(probes);
															#line 1461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 1;
															#line 1461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatencyProbeFetcherActor, 0, Void >*>(static_cast<LatencyProbeFetcherActor*>(this)));
															#line 6451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LatencyProbeFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LatencyProbeFetcherActorState(); static_cast<LatencyProbeFetcherActor*>(this)->destroy(); return 0; }
															#line 6480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LatencyProbeFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LatencyProbeFetcherActorState();
		static_cast<LatencyProbeFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve latency probe information (%s).", e.what()));
															#line 6501 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state > 0) static_cast<LatencyProbeFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyProbeFetcherActor*>(this)->ActorCallback< LatencyProbeFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatencyProbeFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool* isAvailable;
															#line 1416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trImmediate;
															#line 1417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trDefault;
															#line 1418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trBatch;
															#line 1419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction trWrite;
															#line 1421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 6630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via latencyProbeFetcher()
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LatencyProbeFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LatencyProbeFetcherActor, 0, Void >, public FastAllocated<LatencyProbeFetcherActor>, public LatencyProbeFetcherActorState<LatencyProbeFetcherActor> {
															#line 6635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LatencyProbeFetcherActor>::operator new;
	using FastAllocated<LatencyProbeFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13568749712321477632UL, 10920323086936359168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatencyProbeFetcherActor, 0, Void >;
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LatencyProbeFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons,bool* const& isAvailable) 
															#line 6652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LatencyProbeFetcherActorState<LatencyProbeFetcherActor>(cx, messages, incomplete_reasons, isAvailable),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11104724659914187008UL, 14391616900010405120UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyProbeFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latencyProbeFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latencyProbeFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatencyProbeFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> latencyProbeFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons, bool* const& isAvailable ) {
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LatencyProbeFetcherActor(cx, messages, incomplete_reasons, isAvailable));
															#line 6685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 6690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class VersionEpochStatusFetcherActor>
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActorState {
															#line 6697 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActorState(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 1474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   message()
															#line 6708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~VersionEpochStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 6726 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<VersionEpochStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(message); this->~VersionEpochStatusFetcherActorState(); static_cast<VersionEpochStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 6755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<VersionEpochStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(message)); // state_var_RVO
		this->~VersionEpochStatusFetcherActorState();
		static_cast<VersionEpochStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1498 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve version epoch information (%s).", e.what()));
															#line 6776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(versionEpochKey), 5.0);
															#line 1482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6813 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6855 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*>(static_cast<VersionEpochStatusFetcherActor*>(this)));
															#line 6860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6885 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && versionEpochVal,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["enabled"] = versionEpochVal.present();
															#line 1484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!versionEpochVal.present())
															#line 6896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochVal.get(), Unversioned());
															#line 1488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		message["epoch"] = std::to_string(versionEpoch);
															#line 6904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(versionEpochVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && versionEpochVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(versionEpochVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<VersionEpochStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<VersionEpochStatusFetcherActor*>(this)->ActorCallback< VersionEpochStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject message;
															#line 1476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 7092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via versionEpochStatusFetcher()
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class VersionEpochStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< VersionEpochStatusFetcherActor, 1, Void >, public FastAllocated<VersionEpochStatusFetcherActor>, public VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor> {
															#line 7097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<VersionEpochStatusFetcherActor>::operator new;
	using FastAllocated<VersionEpochStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7778179264802761472UL, 6679553120981820928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< VersionEpochStatusFetcherActor, 1, Void >;
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	VersionEpochStatusFetcherActor(Database const& cx,std::set<std::string>* const& incomplete_reasons) 
															#line 7115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   VersionEpochStatusFetcherActorState<VersionEpochStatusFetcherActor>(cx, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5224719475858352128UL, 5273280573928800768UL);
		ActorExecutionContextHelper __helper(static_cast<VersionEpochStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("versionEpochStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("versionEpochStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VersionEpochStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> versionEpochStatusFetcher( Database const& cx, std::set<std::string>* const& incomplete_reasons ) {
															#line 1472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new VersionEpochStatusFetcherActor(cx, incomplete_reasons));
															#line 7149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 7154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ConsistencyCheckStatusFetcherActor>
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActorState {
															#line 7161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 7172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 7190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyCheckStatusFetcherActorState(); static_cast<ConsistencyCheckStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 7219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ConsistencyCheckStatusFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyCheckStatusFetcherActorState();
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1539 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve consistency check settings (%s).", e.what()));
															#line 7240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = timeoutError(BUGGIFY ? Never() : tr.get(fdbShouldConsistencyCheckBeSuspended), 5.0);
															#line 1513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7282 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("consistencycheck_suspendkey_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(fdbShouldConsistencyCheckBeSuspended).c_str()) .c_str()));
															#line 7321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 1532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*>(static_cast<ConsistencyCheckStatusFetcherActor*>(this)));
															#line 7333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool ccSuspend = ccSuspendVal.present() ? BinaryReader::fromStringRef<bool>(ccSuspendVal.get(), Unversioned()) : false;
															#line 1518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ccSuspend)
															#line 7366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("consistencycheck_disabled", "Consistency checker is disabled."));
															#line 7370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ccSuspendVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ccSuspendVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ccSuspendVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckStatusFetcherActor*>(this)->ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 7559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via consistencyCheckStatusFetcher()
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ConsistencyCheckStatusFetcherActor final : public Actor<Void>, public ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >, public FastAllocated<ConsistencyCheckStatusFetcherActor>, public ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor> {
															#line 7564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator new;
	using FastAllocated<ConsistencyCheckStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15709241502746058752UL, 14306724849675448064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >;
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ConsistencyCheckStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 7582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   ConsistencyCheckStatusFetcherActorState<ConsistencyCheckStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4551706905108231424UL, 2658363125606068224UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyCheckStatusFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> consistencyCheckStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new ConsistencyCheckStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 7616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct LogRangeAndUID {
	KeyRange range;
	UID destID;

	LogRangeAndUID(KeyRange const& range, UID const& destID) : range(range), destID(destID) {}

	bool operator<(LogRangeAndUID const& r) const {
		if (range.begin != r.range.begin)
			return range.begin < r.range.begin;
		if (range.end != r.range.end)
			return range.end < r.range.end;
		return destID < r.destID;
	}
};

															#line 7636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LogRangeWarningFetcherActor>
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActorState {
															#line 7643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons)
															#line 7654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LogRangeWarningFetcherActorState() 
	{
		fdb_probe_actor_destroy("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = Transaction(cx);
															#line 1564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				timeoutFuture = timeoutError(Future<Void>(Never()), 5.0);
															#line 1565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 7674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LogRangeWarningFetcherActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogRangeWarningFetcherActorState(); static_cast<LogRangeWarningFetcherActor*>(this)->destroy(); return 0; }
															#line 7703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LogRangeWarningFetcherActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogRangeWarningFetcherActorState();
		static_cast<LogRangeWarningFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1624 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve log ranges (%s).", e.what()));
															#line 7724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1569 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1571 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			existingDestUidValues = tr.getRange(KeyRangeRef(destUidLookupPrefix, strinc(destUidLookupPrefix)), CLIENT_KNOBS->TOO_MANY);
															#line 1573 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			existingLogRanges = tr.getRange(logRangesRange, CLIENT_KNOBS->TOO_MANY);
															#line 1574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = (success(existingDestUidValues) && success(existingLogRanges)) || timeoutFuture;
															#line 1574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 1;
															#line 1574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 0, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 7805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("duplicate_mutation_fetch_timeout", format("Timed out trying to fetch `%s` from the database.", printable(destUidLookupPrefix).c_str()) .c_str()));
															#line 7809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 3;
															#line 1619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 2, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1577 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					break;
				}
															#line 1605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<LogRangeAndUID> loggingRanges;
															#line 1577 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingLogRanges.get() ) {
															#line 1578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logDestination;
															#line 1579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid;
															#line 1580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRef logRangeBegin = logRangesDecodeKey(it.key, &logUid);
															#line 1581 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			Key logRangeEnd = logRangesDecodeValue(it.value, &logDestination);
															#line 1582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			loggingRanges.insert(LogRangeAndUID(KeyRangeRef(logRangeBegin, logRangeEnd), logUid));
															#line 7910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::set<std::pair<Key, Key>> existingRanges;
															#line 1586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& it : existingDestUidValues.get() ) {
															#line 1587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			KeyRange range = BinaryReader::fromStringRef<KeyRange>(it.key.removePrefix(destUidLookupPrefix), IncludeVersion());
															#line 1589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			UID logUid = BinaryReader::fromStringRef<UID>(it.value, Unversioned());
															#line 1590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (loggingRanges.contains(LogRangeAndUID(range, logUid)))
															#line 7922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::pair<Key, Key> rangePair = std::make_pair(range.begin, range.end);
															#line 1592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (existingRanges.contains(rangePair))
															#line 7928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					std::string rangeDescription = (range == getDefaultBackupSharedRange()) ? "the default backup set" : format("`%s` - `%s`", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 1598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					messages->push_back(JsonString::makeMessage( "duplicate_mutation_streams", format("Backup and DR are not sharing the same stream of mutations for %s", rangeDescription.c_str()) .c_str()));
															#line 7934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					break;
				}
															#line 1605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				existingRanges.insert(rangePair);
															#line 7939 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit() || timeoutFuture;
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 2;
															#line 1608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogRangeWarningFetcherActor, 1, Void >*>(static_cast<LogRangeWarningFetcherActor*>(this)));
															#line 7951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state > 0) static_cast<LogRangeWarningFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LogRangeWarningFetcherActor*>(this)->ActorCallback< LogRangeWarningFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LogRangeWarningFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 1563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> timeoutFuture;
															#line 1571 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingDestUidValues;
															#line 1573 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> existingLogRanges;
															#line 8232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via logRangeWarningFetcher()
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LogRangeWarningFetcherActor final : public Actor<Void>, public ActorCallback< LogRangeWarningFetcherActor, 0, Void >, public ActorCallback< LogRangeWarningFetcherActor, 1, Void >, public ActorCallback< LogRangeWarningFetcherActor, 2, Void >, public FastAllocated<LogRangeWarningFetcherActor>, public LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor> {
															#line 8237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LogRangeWarningFetcherActor>::operator new;
	using FastAllocated<LogRangeWarningFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7146946867492562688UL, 8223098996653266688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogRangeWarningFetcherActor, 0, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 1, Void >;
friend struct ActorCallback< LogRangeWarningFetcherActor, 2, Void >;
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LogRangeWarningFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 8256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Void>(),
		   LogRangeWarningFetcherActorState<LogRangeWarningFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16741679886096178432UL, 1377216152642019584UL);
		ActorExecutionContextHelper __helper(static_cast<LogRangeWarningFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logRangeWarningFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logRangeWarningFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LogRangeWarningFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<Void> logRangeWarningFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 1559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Void>(new LogRangeWarningFetcherActor(cx, messages, incomplete_reasons));
															#line 8291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct ProtocolVersionData {
	ProtocolVersion runningProtocolVersion;
	ProtocolVersion newestProtocolVersion;
	ProtocolVersion lowestCompatibleProtocolVersion;
	ProtocolVersionData() : runningProtocolVersion(currentProtocolVersion()) {}

	ProtocolVersionData(uint64_t newestProtocolVersionValue, uint64_t lowestCompatibleProtocolVersionValue)
	  : runningProtocolVersion(currentProtocolVersion()), newestProtocolVersion(newestProtocolVersionValue),
	    lowestCompatibleProtocolVersion(lowestCompatibleProtocolVersionValue) {}
};

															#line 8307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetNewestProtocolVersionActor>
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActorState {
															#line 8314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActorState(Database const& cx,WorkerDetails const& ccWorker) 
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   ccWorker(ccWorker)
															#line 8323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetNewestProtocolVersionActorState() 
	{
		fdb_probe_actor_destroy("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				swVersionF = timeoutError( ccWorker.interf.eventLogRequest.getReply(EventLogRequest("SWVersionCompatibilityChecked"_sr)), 1.0);
															#line 1648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(swVersionF);
															#line 1648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 1;
															#line 1648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNewestProtocolVersionActor, 0, Void >*>(static_cast<GetNewestProtocolVersionActor*>(this)));
															#line 8348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 1660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionStatusFailed").error(e);
															#line 1662 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData()); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData());
			this->~GetNewestProtocolVersionActorState();
			static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1649 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1649 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		const TraceEventFields& swVersionTrace = swVersionF.get();
															#line 1650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t newestProtocolVersionValue = std::stoull(swVersionTrace.getValue("NewestProtocolVersion").c_str(), nullptr, 16);
															#line 1652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t lowestCompatibleProtocolVersionValue = std::stoull(swVersionTrace.getValue("LowestCompatibleProtocolVersion").c_str(), nullptr, 16);
															#line 1655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetNewestProtocolVersionActor*>(this)->SAV<ProtocolVersionData>::futures) { (void)(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue)); this->~GetNewestProtocolVersionActorState(); static_cast<GetNewestProtocolVersionActor*>(this)->destroy(); return 0; }
															#line 8430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetNewestProtocolVersionActor*>(this)->SAV< ProtocolVersionData >::value()) ProtocolVersionData(ProtocolVersionData(newestProtocolVersionValue, lowestCompatibleProtocolVersionValue));
		this->~GetNewestProtocolVersionActorState();
		static_cast<GetNewestProtocolVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNewestProtocolVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNewestProtocolVersionActor*>(this)->ActorCallback< GetNewestProtocolVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNewestProtocolVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ccWorker;
															#line 1645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> swVersionF;
															#line 8519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getNewestProtocolVersion()
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetNewestProtocolVersionActor final : public Actor<ProtocolVersionData>, public ActorCallback< GetNewestProtocolVersionActor, 0, Void >, public FastAllocated<GetNewestProtocolVersionActor>, public GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor> {
															#line 8524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetNewestProtocolVersionActor>::operator new;
	using FastAllocated<GetNewestProtocolVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13147506309804975360UL, 17512244974516128768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ProtocolVersionData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNewestProtocolVersionActor, 0, Void >;
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetNewestProtocolVersionActor(Database const& cx,WorkerDetails const& ccWorker) 
															#line 8541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<ProtocolVersionData>(),
		   GetNewestProtocolVersionActorState<GetNewestProtocolVersionActor>(cx, ccWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10890173716684436736UL, 2976883552386424576UL);
		ActorExecutionContextHelper __helper(static_cast<GetNewestProtocolVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNewestProtocolVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNewestProtocolVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNewestProtocolVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<ProtocolVersionData> getNewestProtocolVersion( Database const& cx, WorkerDetails const& ccWorker ) {
															#line 1642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<ProtocolVersionData>(new GetNewestProtocolVersionActor(cx, ccWorker));
															#line 8574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

struct LoadConfigurationResult {
	bool fullReplication;
	Optional<Key> healthyZone;
	double healthyZoneSeconds;
	bool rebalanceDDIgnored;
	// FIXME: possible convert it to int if upgrade value can be resolved?
	std::string rebalanceDDIgnoreHex; // any or combination of 0, 1, 2, see DDIgnore;
	bool dataDistributionDisabled;

	LoadConfigurationResult()
	  : fullReplication(true), healthyZoneSeconds(0), rebalanceDDIgnored(false), dataDistributionDisabled(false) {}
};

															#line 8592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via loadConfiguration()
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LoadConfigurationActor>
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActorState {
															#line 8599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   status_incomplete_reasons(status_incomplete_reasons),
															#line 1681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 1682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   loadResult(),
															#line 1683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 1684 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   getConfTimeout(delay(5.0))
															#line 8618 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~LoadConfigurationActorState() 
	{
		fdb_probe_actor_destroy("loadConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 8633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LoadConfigurationActor*>(this)->SAV<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>::futures) { (void)(std::make_pair(result, loadResult)); this->~LoadConfigurationActorState(); static_cast<LoadConfigurationActor*>(this)->destroy(); return 0; }
															#line 8656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LoadConfigurationActor*>(this)->SAV< std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>> >::value()) std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>(std::make_pair(result, loadResult));
		this->~LoadConfigurationActorState();
		static_cast<LoadConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1688 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 8677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 1691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH);
															#line 1690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getConfTimeout;
															#line 8687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 1;
															#line 1691 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 0, RangeResult >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 1, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 3;
															#line 1767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 4, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1713 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ASSERT(result.present());
															#line 1714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		replicasFutures = std::vector<Future<Optional<Value>>>();
															#line 1715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& region : result.get().regions ) {
															#line 1716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			replicasFutures.push_back(tr.get(datacenterReplicasKeyFor(region.dcId)));
															#line 8757 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		healthyZoneValue = tr.get(healthyZoneKey);
															#line 1719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		rebalanceDDIgnored = tr.get(rebalanceDDIgnoreKey);
															#line 1720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		ddModeKey = tr.get(dataDistributionModeKey);
															#line 1723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(replicasFutures) && success(healthyZoneValue) && success(rebalanceDDIgnored) && success(ddModeKey);
															#line 1722 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 1760 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = getConfTimeout;
															#line 8773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 2;
															#line 1723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 2, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 1760 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadConfigurationActor, 3, Void >*>(static_cast<LoadConfigurationActor*>(this)));
															#line 8780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
															#line 1692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1699 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
															#line 1692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		DatabaseConfiguration configuration;
															#line 1693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.size() == SERVER_KNOBS->CONFIGURATION_ROWS_TO_FETCH)
															#line 8816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			status_incomplete_reasons->insert("Too many configuration parameters set.");
															#line 8820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			configuration.fromKeyValues((VectorRef<KeyValueRef>)res);
															#line 8826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1699 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result = configuration;
															#line 8830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8839 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!result.present())
															#line 8859 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back(JsonString::makeMessage("unreadable_configuration", "Unable to read database configuration."));
															#line 8863 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 1706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 8869 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 0, RangeResult >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1726 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 9010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1730 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 9014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1733 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 9023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1737 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 9029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 9033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 9039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1742 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 9045 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 9053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 9057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 9061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1751 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1752 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 9071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 9075 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 9080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
															#line 1725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int unreplicated = 0;
															#line 1726 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < result.get().regions.size();i++) {
															#line 1727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!replicasFutures[i].get().present() || decodeDatacenterReplicasValue(replicasFutures[i].get().get()) < result.get().storageTeamSize)
															#line 9093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1730 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				unreplicated++;
															#line 9097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1733 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		LoadConfigurationResult res;
															#line 1734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.fullReplication = (!unreplicated || (result.get().usableRegions == 1 && unreplicated < result.get().regions.size()));
															#line 1736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (healthyZoneValue.get().present())
															#line 9106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1737 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto healthyZone = decodeHealthyZoneValue(healthyZoneValue.get().get());
															#line 1738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (healthyZone.first == ignoreSSFailuresZoneString)
															#line 9112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.healthyZone = healthyZone.first;
															#line 9116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (healthyZone.second > tr.getReadVersion().get())
															#line 9122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZone = healthyZone.first;
															#line 1742 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					res.healthyZoneSeconds = (healthyZone.second - tr.getReadVersion().get()) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 9128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		res.rebalanceDDIgnored = rebalanceDDIgnored.get().present();
															#line 1747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (res.rebalanceDDIgnored)
															#line 9136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			res.rebalanceDDIgnoreHex = rebalanceDDIgnored.get().get().toHexString();
															#line 9140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ddModeKey.get().present())
															#line 9144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1751 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			BinaryReader rd(ddModeKey.get().get(), Unversioned());
															#line 1752 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int currentMode;
															#line 1753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			rd >> currentMode;
															#line 1754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (currentMode == 0)
															#line 9154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				res.dataDistributionDisabled = true;
															#line 9158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		loadResult = res;
															#line 9163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
															#line 1761 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 9172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
															#line 1761 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		messages->push_back( JsonString::makeMessage("full_replication_timeout", "Unable to read datacenter replicas."));
															#line 9181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 2, Void >::remove();
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadConfigurationActor*>(this)->actor_wait_state > 0) static_cast<LoadConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<LoadConfigurationActor*>(this)->ActorCallback< LoadConfigurationActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadConfigurationActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadConfigurationActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* status_incomplete_reasons;
															#line 1681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<DatabaseConfiguration> result;
															#line 1682 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<LoadConfigurationResult> loadResult;
															#line 1683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 1684 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getConfTimeout;
															#line 1714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<Value>>> replicasFutures;
															#line 1718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> healthyZoneValue;
															#line 1719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> rebalanceDDIgnored;
															#line 1720 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> ddModeKey;
															#line 9416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via loadConfiguration()
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LoadConfigurationActor final : public Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>, public ActorCallback< LoadConfigurationActor, 0, RangeResult >, public ActorCallback< LoadConfigurationActor, 1, Void >, public ActorCallback< LoadConfigurationActor, 2, Void >, public ActorCallback< LoadConfigurationActor, 3, Void >, public ActorCallback< LoadConfigurationActor, 4, Void >, public FastAllocated<LoadConfigurationActor>, public LoadConfigurationActorState<LoadConfigurationActor> {
															#line 9421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LoadConfigurationActor>::operator new;
	using FastAllocated<LoadConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4720861433312344064UL, 15201486608933993472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadConfigurationActor, 0, RangeResult >;
friend struct ActorCallback< LoadConfigurationActor, 1, Void >;
friend struct ActorCallback< LoadConfigurationActor, 2, Void >;
friend struct ActorCallback< LoadConfigurationActor, 3, Void >;
friend struct ActorCallback< LoadConfigurationActor, 4, Void >;
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LoadConfigurationActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& status_incomplete_reasons) 
															#line 9442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(),
		   LoadConfigurationActorState<LoadConfigurationActor>(cx, messages, status_incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(440137498882600448UL, 6960115472849028608UL);
		ActorExecutionContextHelper __helper(static_cast<LoadConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadConfigurationActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadConfigurationActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadConfigurationActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>> loadConfiguration( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& status_incomplete_reasons ) {
															#line 1679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::pair<Optional<DatabaseConfiguration>, Optional<LoadConfigurationResult>>>(new LoadConfigurationActor(cx, messages, status_incomplete_reasons));
															#line 9477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject configurationFetcher(Optional<DatabaseConfiguration> conf,
                                              ServerCoordinators coordinators,
                                              std::set<std::string>* incomplete_reasons) {
	JsonBuilderObject statusObj;
	try {
		if (conf.present()) {
			DatabaseConfiguration configuration = conf.get();
			statusObj.addContents(configuration.toJSON());

			JsonBuilderArray excludedServersArr;
			std::set<AddressExclusion> excludedServers = configuration.getExcludedServers();
			for (std::set<AddressExclusion>::iterator it = excludedServers.begin(); it != excludedServers.end(); it++) {
				JsonBuilderObject statusObj;
				statusObj["address"] = it->toString();
				excludedServersArr.push_back(statusObj);
			}
			std::set<std::string> excludedLocalities = configuration.getExcludedLocalities();
			for (const auto& it : excludedLocalities) {
				JsonBuilderObject statusObj;
				statusObj["locality"] = it;
				excludedServersArr.push_back(statusObj);
			}
			statusObj["excluded_servers"] = excludedServersArr;
		}
		int count = coordinators.clientLeaderServers.size();
		statusObj["coordinators_count"] = count;
	} catch (Error& e) {
		if (e.code() == error_code_actor_cancelled) {
			throw;
		}
		incomplete_reasons->insert("Could not retrieve all configuration status information.");
	}
	return statusObj;
}

															#line 9517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via dataStatusFetcher()
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class DataStatusFetcherActor>
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActorState {
															#line 9524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActorState(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : ddWorker(ddWorker),
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   configuration(configuration),
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   minStorageReplicasRemaining(minStorageReplicasRemaining),
															#line 1811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObjData()
															#line 9537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~DataStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("dataStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1814 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::vector<Future<TraceEventFields>> futures;
															#line 1817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStarting"_sr)), 1.0));
															#line 1819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 1.0));
															#line 1821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0));
															#line 1823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlight"_sr)), 1.0));
															#line 1825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				futures.push_back( timeoutError(ddWorker.interf.eventLogRequest.getReply(EventLogRequest("TotalDataInFlightRemote"_sr)), 1.0));
															#line 1828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(futures);
															#line 1828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 1828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<DataStatusFetcherActor*>(this)));
															#line 9572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
		this->~DataStatusFetcherActorState();
		static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9618 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
															#line 1830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 9664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 9676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1855 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 9692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1865 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 9697 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1867 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 9705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1873 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 9715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
				continue;
			}
															#line 1878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 9731 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 9737 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1885 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 9741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1890 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 9756 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1897 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 9766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 9772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 9782 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 1904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 9788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 9798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 1909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 9804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
						{
															#line 1910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 9812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
						}
						else
						{
															#line 1913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 9818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
							{
															#line 1914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1916 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 9826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
							}
							else
							{
															#line 1917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 9832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
								{
															#line 1918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 9840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
								}
								else
								{
															#line 1921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 9846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
									{
															#line 1922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 9854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
									}
									else
									{
															#line 1925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 9860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
										{
															#line 1926 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 9868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
										}
										else
										{
															#line 1929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 9874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
											{
															#line 1930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 9880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
											}
											else
											{
															#line 1932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 9886 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
												{
															#line 1933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 9894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
												}
												else
												{
															#line 1936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 9900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
													{
															#line 1937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1939 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 9908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
													}
													else
													{
															#line 1940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 9914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
														{
															#line 1941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 9920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 9937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 9945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 9949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 9954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 9958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 9964 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 9968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 9974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
															#line 1830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields startingStats = dataInfo[0];
															#line 1831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields dataStats = dataInfo[1];
															#line 1833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (startingStats.size() && startingStats.getValue("State") != "Active")
															#line 9987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["name"] = "initializing";
															#line 1836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["description"] = "(Re)initializing automatic data distribution";
															#line 1837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData["state"] = stateSectionObj;
															#line 1838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!static_cast<DataStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObjData); this->~DataStatusFetcherActorState(); static_cast<DataStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 9999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			new (&static_cast<DataStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObjData)); // state_var_RVO
			this->~DataStatusFetcherActorState();
			static_cast<DataStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields md = dataInfo[2];
															#line 1844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t partitionsInFlight = 0;
															#line 1845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int movingHighestPriority = 1000;
															#line 1846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (md.size())
															#line 10013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t partitionsInQueue = md.getInt64("InQueue");
															#line 1848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t averagePartitionSize = md.getInt64("AverageShardSize");
															#line 1849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			partitionsInFlight = md.getInt64("InFlight");
															#line 1850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			movingHighestPriority = md.getInt("HighestPriority");
															#line 1852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (averagePartitionSize >= 0)
															#line 10025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject moving_data;
															#line 1854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_queue_bytes"] = partitionsInQueue * averagePartitionSize;
															#line 1855 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["in_flight_bytes"] = partitionsInFlight * averagePartitionSize;
															#line 1856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data.setKeyRawNumber("total_written_bytes", md.getValue("BytesWritten"));
															#line 1857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				moving_data["highest_priority"] = movingHighestPriority;
															#line 1860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["moving_data"] = moving_data;
															#line 1861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObjData["average_partition_size_bytes"] = averagePartitionSize;
															#line 10041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 1865 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (dataStats.size())
															#line 10046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 1866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("total_kv_size_bytes", dataStats.getValue("TotalSizeBytes"));
															#line 1867 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("system_kv_size_bytes", dataStats.getValue("SystemSizeBytes"));
															#line 1868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObjData.setKeyRawNumber("partitions_count", dataStats.getValue("Shards"));
															#line 10054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 1871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderArray teamTrackers;
															#line 1872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 3;i < 5;i++) {
															#line 1873 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			const TraceEventFields& inFlight = dataInfo[i];
															#line 1874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (inFlight.size() == 0)
															#line 10064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
				continue;
			}
															#line 1878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int replicas = configuration.storageTeamSize;
															#line 1879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			bool primary = inFlight.getInt("Primary");
															#line 1880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int highestPriority = inFlight.getInt("HighestPriority");
															#line 1882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (movingHighestPriority < SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 10076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				highestPriority = movingHighestPriority;
															#line 10080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (partitionsInFlight > 0)
															#line 10086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1885 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					highestPriority = std::max<int>(highestPriority, SERVER_KNOBS->PRIORITY_MERGE_SHARD);
															#line 10090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject team_tracker;
															#line 1889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker["primary"] = primary;
															#line 1890 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("in_flight_bytes", inFlight.getValue("TotalBytes"));
															#line 1891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			team_tracker.setKeyRawNumber("unhealthy_servers", inFlight.getValue("UnhealthyServers"));
															#line 1893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			JsonBuilderObject stateSectionObj;
															#line 1894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 10105 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["healthy"] = false;
															#line 1896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["name"] = "missing_data";
															#line 1897 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				stateSectionObj["description"] = "No replicas remain of some data";
															#line 1898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				replicas = 0;
															#line 10115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_1_LEFT)
															#line 10121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1900 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["healthy"] = false;
															#line 1901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["name"] = "healing";
															#line 1902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					stateSectionObj["description"] = "Only one replica remains of some data";
															#line 1903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					replicas = 1;
															#line 10131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
				else
				{
															#line 1904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_2_LEFT)
															#line 10137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 1905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["healthy"] = false;
															#line 1906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["name"] = "healing";
															#line 1907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						stateSectionObj["description"] = "Only two replicas remain of some data";
															#line 1908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						replicas = 2;
															#line 10147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 1909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY)
															#line 10153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
						{
															#line 1910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["healthy"] = false;
															#line 1911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["name"] = "healing";
															#line 1912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							stateSectionObj["description"] = "Restoring replication factor";
															#line 10161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
						}
						else
						{
															#line 1913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
							if (highestPriority >= SERVER_KNOBS->PRIORITY_POPULATE_REGION)
															#line 10167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
							{
															#line 1914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["healthy"] = true;
															#line 1915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["name"] = "healthy_populating_region";
															#line 1916 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								stateSectionObj["description"] = "Populating remote region";
															#line 10175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
							}
							else
							{
															#line 1917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
								if (highestPriority >= SERVER_KNOBS->PRIORITY_MERGE_SHARD)
															#line 10181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
								{
															#line 1918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["healthy"] = true;
															#line 1919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["name"] = "healthy_repartitioning";
															#line 1920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									stateSectionObj["description"] = "Repartitioning";
															#line 10189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
								}
								else
								{
															#line 1921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
									if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT)
															#line 10195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
									{
															#line 1922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["healthy"] = true;
															#line 1923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["name"] = "optimizing_team_collections";
															#line 1924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										stateSectionObj["description"] = "Optimizing team collections";
															#line 10203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
									}
									else
									{
															#line 1925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
										if (highestPriority >= SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER)
															#line 10209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
										{
															#line 1926 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["healthy"] = true;
															#line 1927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["name"] = "healthy_removing_server";
															#line 1928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											stateSectionObj["description"] = "Removing storage server";
															#line 10217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
										}
										else
										{
															#line 1929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
											if (highestPriority == SERVER_KNOBS->PRIORITY_TEAM_HEALTHY)
															#line 10223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
											{
															#line 1930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["healthy"] = true;
															#line 1931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												stateSectionObj["name"] = "healthy";
															#line 10229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
											}
											else
											{
															#line 1932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
												if (highestPriority == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 10235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
												{
															#line 1933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["healthy"] = true;
															#line 1934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["name"] = "healthy_perpetual_wiggle";
															#line 1935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													stateSectionObj["description"] = "Wiggling storage server";
															#line 10243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
												}
												else
												{
															#line 1936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
													if (highestPriority >= SERVER_KNOBS->PRIORITY_RECOVER_MOVE)
															#line 10249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
													{
															#line 1937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["healthy"] = true;
															#line 1938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["name"] = "healthy_rebalancing";
															#line 1939 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														stateSectionObj["description"] = "Rebalancing";
															#line 10257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
													}
													else
													{
															#line 1940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
														if (highestPriority >= 0)
															#line 10263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
														{
															#line 1941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["healthy"] = true;
															#line 1942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															stateSectionObj["name"] = "healthy";
															#line 10269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
															#line 1947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			stateSectionObj["min_replicas_remaining"] = replicas;
															#line 1949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (!stateSectionObj.empty())
															#line 10286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				team_tracker["state"] = stateSectionObj;
															#line 1951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				teamTrackers.push_back(team_tracker);
															#line 1952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (primary)
															#line 10294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					statusObjData["state"] = stateSectionObj;
															#line 10298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (primary)
															#line 10303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 1961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + replicas;
															#line 10307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
			else
			{
															#line 1962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (replicas > 0)
															#line 10313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				{
															#line 1963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					*minStorageReplicasRemaining = std::max(*minStorageReplicasRemaining, 0) + 1;
															#line 10317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
		}
															#line 1966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObjData["team_trackers"] = teamTrackers;
															#line 10323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont41(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataInfo, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && dataInfo,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataInfo), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<DataStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<DataStatusFetcherActor*>(this)->ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont41(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails ddWorker;
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* minStorageReplicasRemaining;
															#line 1811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObjData;
															#line 10424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via dataStatusFetcher()
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class DataStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >, public FastAllocated<DataStatusFetcherActor>, public DataStatusFetcherActorState<DataStatusFetcherActor> {
															#line 10429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<DataStatusFetcherActor>::operator new;
	using FastAllocated<DataStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14379337177835140608UL, 6144942842659438080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >;
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	DataStatusFetcherActor(WorkerDetails const& ddWorker,DatabaseConfiguration const& configuration,int* const& minStorageReplicasRemaining) 
															#line 10446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   DataStatusFetcherActorState<DataStatusFetcherActor>(ddWorker, configuration, minStorageReplicasRemaining),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14405987564440952576UL, 17712536245104413440UL);
		ActorExecutionContextHelper __helper(static_cast<DataStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dataStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dataStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> dataStatusFetcher( WorkerDetails const& ddWorker, DatabaseConfiguration const& configuration, int* const& minStorageReplicasRemaining ) {
															#line 1808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new DataStatusFetcherActor(ddWorker, configuration, minStorageReplicasRemaining));
															#line 10479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 1976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 10484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getServerMetrics()
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface, class GetServerMetricsActor>
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActorState {
															#line 10491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActorState(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : servers(servers),
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   eventNames(eventNames),
															#line 1982 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   futures()
															#line 10504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetServerMetricsActorState() 
	{
		fdb_probe_actor_destroy("getServerMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto s : servers ) {
															#line 1984 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto name : eventNames ) {
															#line 1985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					futures.push_back(latestEventOnWorker(address_workers[s.address()], s.id().toString() + "/" + name));
															#line 10523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
			}
															#line 1989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 1989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 1;
															#line 1989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetServerMetricsActor, 0, Void >*>(static_cast<GetServerMetricsActor*>(this)));
															#line 10535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1995 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1997 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 1998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 1999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2005 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		std::vector<std::pair<iface, EventMap>> results;
															#line 1992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		auto futureItr = futures.begin();
															#line 1994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 1995 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			EventMap serverResults;
															#line 1996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( auto name : eventNames ) {
															#line 1997 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				ASSERT(futureItr != futures.end());
															#line 1998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				serverResults[name] = futureItr->get().present() ? futureItr->get().get() : TraceEventFields();
															#line 1999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				++futureItr;
															#line 10606 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results.emplace_back(servers[i], serverResults);
															#line 10610 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2005 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetServerMetricsActor*>(this)->SAV<std::vector<std::pair<iface, EventMap>>>::futures) { (void)(results); this->~GetServerMetricsActorState(); static_cast<GetServerMetricsActor*>(this)->destroy(); return 0; }
															#line 10614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetServerMetricsActor*>(this)->SAV< std::vector<std::pair<iface, EventMap>> >::value()) std::vector<std::pair<iface, EventMap>>(results);
		this->~GetServerMetricsActorState();
		static_cast<GetServerMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetServerMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetServerMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerMetricsActor*>(this)->ActorCallback< GetServerMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetServerMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetServerMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<iface> servers;
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::string> eventNames;
															#line 1982 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<TraceEventFields>>> futures;
															#line 10705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getServerMetrics()
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetServerMetricsActor final : public Actor<std::vector<std::pair<iface, EventMap>>>, public ActorCallback< GetServerMetricsActor<iface>, 0, Void >, public FastAllocated<GetServerMetricsActor<iface>>, public GetServerMetricsActorState<iface, GetServerMetricsActor<iface>> {
															#line 10712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetServerMetricsActor<iface>>::operator new;
	using FastAllocated<GetServerMetricsActor<iface>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18437655862821863168UL, 13006877409436286976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<iface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetServerMetricsActor<iface>, 0, Void >;
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetServerMetricsActor(std::vector<iface> const& servers,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,std::vector<std::string> const& eventNames) 
															#line 10729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<iface, EventMap>>>(),
		   GetServerMetricsActorState<iface, GetServerMetricsActor<iface>>(servers, address_workers, eventNames),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10378310344083509504UL, 12687082714580923648UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getServerMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getServerMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetServerMetricsActor<iface>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class iface>
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<iface, EventMap>>> getServerMetrics( std::vector<iface> const& servers, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, std::vector<std::string> const& eventNames ) {
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<iface, EventMap>>>(new GetServerMetricsActor<iface>(servers, address_workers, eventNames));
															#line 10764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

namespace {

const std::vector<std::string> STORAGE_SERVER_METRICS_LIST{ "StorageMetrics", "ReadLatencyMetrics", "ReadLatencyBands",
	                                                        "BusiestReadTag", "BusiestWriteTag",    "RocksDBMetrics" };

} // namespace

															#line 10776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetStorageServerStatusInfosActor>
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActorState {
															#line 10783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActorState(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : storageMetadatas(storageMetadatas),
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers),
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 2019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   servers()
															#line 10796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServerStatusInfosActorState() 
	{
		fdb_probe_actor_destroy("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers.reserve(storageMetadatas.size());
															#line 2021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			for( const auto& meta : storageMetadatas ) {
															#line 2022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				servers.push_back(StorageServerStatusInfo(meta));
															#line 10815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			results = std::vector<std::pair<StorageServerStatusInfo, EventMap>>();
															#line 2025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(results, getServerMetrics(servers, address_workers, STORAGE_SERVER_METRICS_LIST));
															#line 2025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 1;
															#line 2025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*>(static_cast<GetStorageServerStatusInfosActor*>(this)));
															#line 10828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 2027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			servers[i].eventMap = std::move(results[i].second);
															#line 10871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetStorageServerStatusInfosActor*>(this)->SAV<std::vector<StorageServerStatusInfo>>::futures) { (void)(servers); this->~GetStorageServerStatusInfosActorState(); static_cast<GetStorageServerStatusInfosActor*>(this)->destroy(); return 0; }
															#line 10875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetStorageServerStatusInfosActor*>(this)->SAV< std::vector<StorageServerStatusInfo> >::value()) std::vector<StorageServerStatusInfo>(std::move(servers)); // state_var_RVO
		this->~GetStorageServerStatusInfosActorState();
		static_cast<GetStorageServerStatusInfosActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerStatusInfosActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerStatusInfosActor*>(this)->ActorCallback< GetStorageServerStatusInfosActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerMetaInfo> storageMetadatas;
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 2019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<StorageServerStatusInfo> servers;
															#line 2024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<std::pair<StorageServerStatusInfo, EventMap>> results;
															#line 10968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getStorageServerStatusInfos()
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetStorageServerStatusInfosActor final : public Actor<std::vector<StorageServerStatusInfo>>, public ActorCallback< GetStorageServerStatusInfosActor, 0, Void >, public FastAllocated<GetStorageServerStatusInfosActor>, public GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor> {
															#line 10973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetStorageServerStatusInfosActor>::operator new;
	using FastAllocated<GetStorageServerStatusInfosActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12170212360422146304UL, 12346460851425012480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerStatusInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServerStatusInfosActor, 0, Void >;
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetStorageServerStatusInfosActor(std::vector<StorageServerMetaInfo> const& storageMetadatas,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers,WorkerDetails const& rkWorker) 
															#line 10990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<StorageServerStatusInfo>>(),
		   GetStorageServerStatusInfosActorState<GetStorageServerStatusInfosActor>(storageMetadatas, address_workers, rkWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14011788060670041344UL, 4151862449577500672UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerStatusInfosActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServerStatusInfos");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServerStatusInfos", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServerStatusInfosActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<StorageServerStatusInfo>> getStorageServerStatusInfos( std::vector<StorageServerMetaInfo> const& storageMetadatas, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers, WorkerDetails const& rkWorker ) {
															#line 2015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<StorageServerStatusInfo>>(new GetStorageServerStatusInfosActor(storageMetadatas, address_workers, rkWorker));
															#line 11023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 11028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetTLogsAndMetricsActor>
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActorState {
															#line 11035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogsAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2035 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::vector<TLogInterface> servers = db->get().logSystemConfig.allPresentLogs();
															#line 2036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<TLogInterface, EventMap>>> __when_expr_0 = getServerMetrics(servers, address_workers, std::vector<std::string>{ "TLogMetrics" });
															#line 2036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11063 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*>(static_cast<GetTLogsAndMetricsActor*>(this)));
															#line 11068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11091 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetTLogsAndMetricsActor*>(this)->SAV<std::vector<std::pair<TLogInterface, EventMap>>>::futures) { (void)(results); this->~GetTLogsAndMetricsActorState(); static_cast<GetTLogsAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetTLogsAndMetricsActor*>(this)->SAV< std::vector<std::pair<TLogInterface, EventMap>> >::value()) std::vector<std::pair<TLogInterface, EventMap>>(results);
		this->~GetTLogsAndMetricsActorState();
		static_cast<GetTLogsAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TLogInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetTLogsAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogsAndMetricsActor*>(this)->ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,std::vector<std::pair<TLogInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getTLogsAndMetrics()
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetTLogsAndMetricsActor final : public Actor<std::vector<std::pair<TLogInterface, EventMap>>>, public ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >, public FastAllocated<GetTLogsAndMetricsActor>, public GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor> {
															#line 11195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetTLogsAndMetricsActor>::operator new;
	using FastAllocated<GetTLogsAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5554984449108885248UL, 5026498709873926656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TLogInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >;
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetTLogsAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<TLogInterface, EventMap>>>(),
		   GetTLogsAndMetricsActorState<GetTLogsAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7806185236702080000UL, 16667331025509920768UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogsAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogsAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogsAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogsAndMetricsActor, 0, std::vector<std::pair<TLogInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<TLogInterface, EventMap>>> getTLogsAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<TLogInterface, EventMap>>>(new GetTLogsAndMetricsActor(db, address_workers));
															#line 11245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// Returns list of tuples of grv proxy interfaces and their latency metrics
															#line 11251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetCommitProxiesAndMetricsActor>
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActorState {
															#line 11258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<CommitProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics( db->get().client.commitProxies, address_workers, std::vector<std::string>{ "CommitLatencyMetrics", "CommitLatencyBands", "CommitBatchingWindowSize" });
															#line 2046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*>(static_cast<GetCommitProxiesAndMetricsActor*>(this)));
															#line 11289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2051 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2051 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<CommitProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetCommitProxiesAndMetricsActorState(); static_cast<GetCommitProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetCommitProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<CommitProxyInterface, EventMap>> >::value()) std::vector<std::pair<CommitProxyInterface, EventMap>>(results);
		this->~GetCommitProxiesAndMetricsActorState();
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<CommitProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesAndMetricsActor*>(this)->ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,std::vector<std::pair<CommitProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getCommitProxiesAndMetrics()
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetCommitProxiesAndMetricsActor final : public Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>, public ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >, public FastAllocated<GetCommitProxiesAndMetricsActor>, public GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor> {
															#line 11416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetCommitProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16505758386253785856UL, 716313600183421184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >;
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetCommitProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11433 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<CommitProxyInterface, EventMap>>>(),
		   GetCommitProxiesAndMetricsActorState<GetCommitProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1575106491018932224UL, 2149067258200158208UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesAndMetricsActor, 0, std::vector<std::pair<CommitProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<CommitProxyInterface, EventMap>>> getCommitProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<CommitProxyInterface, EventMap>>>(new GetCommitProxiesAndMetricsActor(db, address_workers));
															#line 11466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 11471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetGrvProxiesAndMetricsActor>
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActorState {
															#line 11478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   address_workers(address_workers)
															#line 11487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	~GetGrvProxiesAndMetricsActorState() 
	{
		fdb_probe_actor_destroy("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::vector<std::pair<GrvProxyInterface, EventMap>>> __when_expr_0 = getServerMetrics(db->get().client.grvProxies, address_workers, std::vector<std::string>{ "GRVLatencyMetrics", "GRVLatencyBands", "GRVBatchLatencyMetrics" });
															#line 2057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 1;
															#line 2057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*>(static_cast<GetGrvProxiesAndMetricsActor*>(this)));
															#line 11509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
															#line 2061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
															#line 2061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV<std::vector<std::pair<GrvProxyInterface, EventMap>>>::futures) { (void)(results); this->~GetGrvProxiesAndMetricsActorState(); static_cast<GetGrvProxiesAndMetricsActor*>(this)->destroy(); return 0; }
															#line 11544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetGrvProxiesAndMetricsActor*>(this)->SAV< std::vector<std::pair<GrvProxyInterface, EventMap>> >::value()) std::vector<std::pair<GrvProxyInterface, EventMap>>(results);
		this->~GetGrvProxiesAndMetricsActorState();
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<GrvProxyInterface, EventMap>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state > 0) static_cast<GetGrvProxiesAndMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<GetGrvProxiesAndMetricsActor*>(this)->ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> const& value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,std::vector<std::pair<GrvProxyInterface, EventMap>> && value) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*,Error err) 
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> address_workers;
															#line 11631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getGrvProxiesAndMetrics()
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetGrvProxiesAndMetricsActor final : public Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>, public ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >, public FastAllocated<GetGrvProxiesAndMetricsActor>, public GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor> {
															#line 11636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator new;
	using FastAllocated<GetGrvProxiesAndMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(107949530295863296UL, 15941989136214718976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >;
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetGrvProxiesAndMetricsActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) 
															#line 11653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<std::vector<std::pair<GrvProxyInterface, EventMap>>>(),
		   GetGrvProxiesAndMetricsActorState<GetGrvProxiesAndMetricsActor>(db, address_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16916602236672483840UL, 15447554200206271744UL);
		ActorExecutionContextHelper __helper(static_cast<GetGrvProxiesAndMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getGrvProxiesAndMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getGrvProxiesAndMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetGrvProxiesAndMetricsActor, 0, std::vector<std::pair<GrvProxyInterface, EventMap>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<std::vector<std::pair<GrvProxyInterface, EventMap>>> getGrvProxiesAndMetrics( Reference<AsyncVar<ServerDBInfo>> const& db, std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers ) {
															#line 2054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<std::vector<std::pair<GrvProxyInterface, EventMap>>>(new GetGrvProxiesAndMetricsActor(db, address_workers));
															#line 11686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2063 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

// Returns the number of zones eligible for recruiting new tLogs after zone failures, to maintain the current
// replication factor.
static int getExtraTLogEligibleZones(const std::vector<WorkerDetails>& workers,
                                     const DatabaseConfiguration& configuration) {
	std::set<StringRef> allZones;
	std::map<Key, std::set<StringRef>> dcId_zone;
	for (auto const& worker : workers) {
		if (worker.processClass.machineClassFitness(ProcessClass::TLog) < ProcessClass::NeverAssign &&
		    !configuration.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
			allZones.insert(worker.interf.locality.zoneId().get());
			if (worker.interf.locality.dcId().present()) {
				dcId_zone[worker.interf.locality.dcId().get()].insert(worker.interf.locality.zoneId().get());
			}
		}
	}

	if (configuration.regions.size() == 0) {
		return allZones.size() - std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize);
	}

	int extraTlogEligibleZones = 0;
	int regionsWithNonNegativePriority = 0;
	int maxRequiredReplicationFactor =
	    std::max(configuration.remoteTLogReplicationFactor,
	             std::max(configuration.tLogReplicationFactor, configuration.storageTeamSize));
	for (const auto& region : configuration.regions) {
		if (region.priority >= 0) {
			int eligible = dcId_zone[region.dcId].size() - maxRequiredReplicationFactor;

			// FIXME: does not take into account fallback satellite policies
			if (region.satelliteTLogReplicationFactor > 0 && configuration.usableRegions > 1) {
				int totalSatelliteEligible = 0;
				for (const auto& sat : region.satellites) {
					totalSatelliteEligible += dcId_zone[sat.dcId].size();
				}
				eligible = std::min<int>(eligible, totalSatelliteEligible - region.satelliteTLogReplicationFactor);
			}
			if (eligible >= 0) {
				regionsWithNonNegativePriority++;
			}
			extraTlogEligibleZones = std::max(extraTlogEligibleZones, eligible);
		}
	}
	if (regionsWithNonNegativePriority > 1) {
		// If the database is replicated across multiple regions, we can afford to lose one entire region without
		// losing data.
		extraTlogEligibleZones++;
	}
	return extraTlogEligibleZones;
}

JsonBuilderObject getPerfLimit(TraceEventFields const& ratekeeper, double transPerSec, double tpsLimit) {
	int reason = ratekeeper.getInt("Reason");
	JsonBuilderObject perfLimit;

	if (transPerSec > tpsLimit * 0.8) {
		// If reason is known, set qos.performance_limited_by, otherwise omit
		if (reason >= 0 && reason < limitReasonEnd) {
			perfLimit = JsonString::makeMessage(limitReasonName[reason], limitReasonDesc[reason]);
			std::string reason_server_id = ratekeeper.getValue("ReasonServerID");
			if (!reason_server_id.empty())
				perfLimit["reason_server_id"] = reason_server_id;
		}
	} else {
		perfLimit = JsonString::makeMessage("workload", "The database is not being saturated by the workload.");
	}

	if (!perfLimit.empty()) {
		perfLimit["reason_id"] = reason;
	}

	return perfLimit;
}

															#line 11765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via workloadStatusFetcher()
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class WorkloadStatusFetcherActor>
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActorState {
															#line 11772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActorState(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,JsonBuilderObject* const& tenants,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   mWorker(mWorker),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   rkWorker(rkWorker),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   qos(qos),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   data_overlay(data_overlay),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tenants(tenants),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   operationsObj(),
															#line 2150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   bytesObj(),
															#line 2151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   keysObj()
															#line 11803 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("workloadStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				commitProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				grvProxyStatFutures = std::vector<Future<TraceEventFields>>();
															#line 2157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				std::map<NetworkAddress, WorkerDetails> workersMap;
															#line 2158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto const& w : workers ) {
															#line 2159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					workersMap[w.interf.address()] = w;
															#line 11827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				}
															#line 2161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.commitProxies ) {
															#line 2162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 2164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						commitProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("ProxyMetrics"_sr)), 1.0));
															#line 11839 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 2167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
				}
															#line 2169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				for( auto& p : db->get().client.grvProxies ) {
															#line 2170 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					auto worker = getWorker(workersMap, p.address());
															#line 2171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
					if (worker.present())
															#line 11854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					{
															#line 2172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						grvProxyStatFutures.push_back(timeoutError( worker.get().interf.eventLogRequest.getReply(EventLogRequest("GrvProxyMetrics"_sr)), 1.0));
															#line 11858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
					else
					{
															#line 2175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
						return a_body1Catch2(all_alternatives_failed(), loopDepth);
															#line 11864 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
					}
				}
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<std::vector<TraceEventFields>> __when_expr_0 = getAll(commitProxyStatFutures);
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11876 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 2239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			f1 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdate"_sr)), 1.0);
															#line 2241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			f2 = timeoutError(rkWorker.interf.eventLogRequest.getReply(EventLogRequest("RkUpdateBatch"_sr)), 1.0);
															#line 2243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(f1) && success(f2);
															#line 2243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 2, Void >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2233 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2234 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown mutations, conflicts, and transactions state.");
															#line 11941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::vector<TraceEventFields>> __when_expr_1 = getAll(grvProxyStatFutures);
															#line 2178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 11963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> const& __commitProxyStats,int loopDepth) 
	{
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		commitProxyStats = __commitProxyStats;
															#line 11972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<TraceEventFields> && __commitProxyStats,int loopDepth) 
	{
		commitProxyStats = std::move(__commitProxyStats);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnStartOut;
															#line 2181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnSystemPriorityStartOut;
															#line 2182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnDefaultPriorityStartOut;
															#line 2183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnBatchPriorityStartOut;
															#line 2185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutations;
															#line 2186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter mutationBytes;
															#line 2187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnConflicts;
															#line 2188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnRejectedForQueuedTooLong;
															#line 2189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnCommitOutSuccess;
															#line 2190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnKeyLocationOut;
															#line 2191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter txnMemoryErrors;
															#line 2193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& gps : grvProxyStats ) {
															#line 2194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnStartOut.updateValues(StatusCounter(gps.getValue("TxnStartOut")));
															#line 2195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnSystemPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnSystemPriorityStartOut")));
															#line 2196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnDefaultPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnDefaultPriorityStartOut")));
															#line 2197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnBatchPriorityStartOut.updateValues(StatusCounter(gps.getValue("TxnBatchPriorityStartOut")));
															#line 2198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(gps.getValue("TxnRequestErrors")));
															#line 12083 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& cps : commitProxyStats ) {
															#line 2202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			mutations.updateValues(StatusCounter(cps.getValue("Mutations")));
															#line 2203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			mutationBytes.updateValues(StatusCounter(cps.getValue("MutationBytes")));
															#line 2204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnConflicts.updateValues(StatusCounter(cps.getValue("TxnConflicts")));
															#line 2205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnRejectedForQueuedTooLong.updateValues(StatusCounter(cps.getValue("TxnRejectedForQueuedTooLong")));
															#line 2206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnCommitOutSuccess.updateValues(StatusCounter(cps.getValue("TxnCommitOutSuccess")));
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnKeyLocationOut.updateValues(StatusCounter(cps.getValue("KeyServerLocationOut")));
															#line 2208 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("KeyServerLocationErrors")));
															#line 2209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			txnMemoryErrors.updateValues(StatusCounter(cps.getValue("TxnCommitErrors")));
															#line 12103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["writes"] = mutations.getStatus();
															#line 2213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["location_requests"] = txnKeyLocationOut.getStatus();
															#line 2214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["memory_errors"] = txnMemoryErrors.getStatus();
															#line 2215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["written"] = mutationBytes.getStatus();
															#line 2217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject transactions;
															#line 2218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["conflicted"] = txnConflicts.getStatus();
															#line 2219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started"] = txnStartOut.getStatus();
															#line 2220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["rejected_for_queued_too_long"] = txnRejectedForQueuedTooLong.getStatus();
															#line 2221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_immediate_priority"] = txnSystemPriorityStartOut.getStatus();
															#line 2222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_default_priority"] = txnDefaultPriorityStartOut.getStatus();
															#line 2223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["started_batch_priority"] = txnBatchPriorityStartOut.getStatus();
															#line 2224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		transactions["committed"] = txnCommitOutSuccess.getStatus();
															#line 2226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["transactions"] = transactions;
															#line 2228 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (commitProxyStats.size() > 0)
															#line 12133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*tenants)["num_tenants"] = commitProxyStats[0].getUint64("NumTenants");
															#line 12137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> const& __grvProxyStats,int loopDepth) 
	{
															#line 2178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		grvProxyStats = __grvProxyStats;
															#line 12147 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<TraceEventFields> && __grvProxyStats,int loopDepth) 
	{
		grvProxyStats = std::move(__grvProxyStats);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,std::vector<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
															#line 2324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_3 = storageServerFuture;
															#line 2324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 12242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont11Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont11when1(__when_expr_3.get(), loopDepth); };
			static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<WorkloadStatusFetcherActor*>(this)));
															#line 12247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown performance state.");
															#line 12271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 2244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 2244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields ratekeeper = f1.get();
															#line 2245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEventFields batchRatekeeper = f2.get();
															#line 2247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bool autoThrottlingEnabled = ratekeeper.getInt("AutoThrottlingEnabled");
															#line 2248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double tpsLimit = ratekeeper.getDouble("TPSLimit");
															#line 2249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTpsLimit = batchRatekeeper.getDouble("TPSLimit");
															#line 2250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double transPerSec = ratekeeper.getDouble("ReleasedTPS");
															#line 2251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double batchTransPerSec = ratekeeper.getDouble("ReleasedBatchTPS");
															#line 2252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTags = ratekeeper.getInt("TagsAutoThrottled");
															#line 2253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyRead = ratekeeper.getInt("TagsAutoThrottledBusyRead");
															#line 2254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int autoThrottledTagsBusyWrite = ratekeeper.getInt("TagsAutoThrottledBusyWrite");
															#line 2255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int manualThrottledTags = ratekeeper.getInt("TagsManuallyThrottled");
															#line 2256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int ssCount = ratekeeper.getInt("StorageServers");
															#line 2257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int tlogCount = ratekeeper.getInt("TLogs");
															#line 2258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceStorageServer = ratekeeper.getInt64("WorstFreeSpaceStorageServer");
															#line 2259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		int64_t worstFreeSpaceTLog = ratekeeper.getInt64("WorstFreeSpaceTLog");
															#line 2260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*data_overlay).setKeyRawNumber("total_disk_used_bytes", ratekeeper.getValue("TotalDiskUsageBytes"));
															#line 2262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (ssCount > 0)
															#line 12448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_storage_server"] = std::max(worstFreeSpaceStorageServer, (int64_t)0);
															#line 2265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_storage_server", ratekeeper.getValue("WorstStorageServerQueue"));
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("limiting_queue_bytes_storage_server", ratekeeper.getValue("LimitingStorageServerQueue"));
															#line 2269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerVersionLag"));
															#line 2270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_data_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerVersionLag"));
															#line 2272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["worst_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("WorstStorageServerDurabilityLag"));
															#line 2274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["limiting_durability_lag_storage_server"] = getLagObject(ratekeeper.getInt64("LimitingStorageServerDurabilityLag"));
															#line 12464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (tlogCount > 0)
															#line 12468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*data_overlay)["least_operating_space_bytes_log_server"] = std::max(worstFreeSpaceTLog, (int64_t)0);
															#line 2280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos).setKeyRawNumber("worst_queue_bytes_log_server", ratekeeper.getValue("WorstTLogQueue"));
															#line 12474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2283 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["transactions_per_second_limit"] = tpsLimit;
															#line 2284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_transactions_per_second_limit"] = batchTpsLimit;
															#line 2285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["released_transactions_per_second"] = transPerSec;
															#line 2286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["batch_released_transactions_per_second"] = batchTransPerSec;
															#line 2288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject throttledTagsObj;
															#line 2289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject autoThrottledTagsObj;
															#line 2290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["count"] = autoThrottledTags;
															#line 2291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_read"] = autoThrottledTagsBusyRead;
															#line 2292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		autoThrottledTagsObj["busy_write"] = autoThrottledTagsBusyWrite;
															#line 2293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (autoThrottlingEnabled)
															#line 12496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 0;
															#line 12500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			autoThrottledTagsObj["recommended_only"] = 1;
															#line 12506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["auto"] = autoThrottledTagsObj;
															#line 2301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject manualThrottledTagsObj;
															#line 2302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		manualThrottledTagsObj["count"] = manualThrottledTags;
															#line 2303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		throttledTagsObj["manual"] = manualThrottledTagsObj;
															#line 2305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		(*qos)["throttled_tags"] = throttledTagsObj;
															#line 2307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject perfLimit = getPerfLimit(ratekeeper, transPerSec, tpsLimit);
															#line 2308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!perfLimit.empty())
															#line 12522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["performance_limited_by"] = perfLimit;
															#line 12526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject batchPerfLimit = getPerfLimit(batchRatekeeper, transPerSec, batchTpsLimit);
															#line 2313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!batchPerfLimit.empty())
															#line 12532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			(*qos)["batch_performance_limited_by"] = batchPerfLimit;
															#line 12536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 2358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["operations"] = operationsObj;
															#line 2359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["keys"] = keysObj;
															#line 2360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["bytes"] = bytesObj;
															#line 2362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<WorkloadStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~WorkloadStatusFetcherActorState(); static_cast<WorkloadStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 12640 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<WorkloadStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~WorkloadStatusFetcherActorState();
		static_cast<WorkloadStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown read state.");
															#line 12661 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 12732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1cont11Catch1(storageServers.getError(), loopDepth);
															#line 12736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readRequests;
															#line 2330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter reads;
															#line 2331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readKeys;
															#line 2332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter readBytes;
															#line 2333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StatusCounter lowPriorityReads;
															#line 2335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEventFields const& storageMetrics = ss.eventMap.at("StorageMetrics");
															#line 2338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (storageMetrics.size() > 0)
															#line 12754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readRequests.updateValues(StatusCounter(storageMetrics.getValue("QueryQueue")));
															#line 2340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				reads.updateValues(StatusCounter(storageMetrics.getValue("FinishedQueries")));
															#line 2341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readKeys.updateValues(StatusCounter(storageMetrics.getValue("RowsQueried")));
															#line 2342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				readBytes.updateValues(StatusCounter(storageMetrics.getValue("BytesQueried")));
															#line 2343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				lowPriorityReads.updateValues(StatusCounter(storageMetrics.getValue("LowPriorityQueries")));
															#line 12766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["read_requests"] = readRequests.getStatus();
															#line 2348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["reads"] = reads.getStatus();
															#line 2349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		keysObj["read"] = readKeys.getStatus();
															#line 2350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		bytesObj["read"] = readBytes.getStatus();
															#line 2351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		operationsObj["low_priority_reads"] = lowPriorityReads.getStatus();
															#line 12779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<WorkloadStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadStatusFetcherActor*>(this)->ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> db;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails mWorker;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerDetails rkWorker;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* qos;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* data_overlay;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject* tenants;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject operationsObj;
															#line 2150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject bytesObj;
															#line 2151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject keysObj;
															#line 2155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> commitProxyStatFutures;
															#line 2156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<TraceEventFields>> grvProxyStatFutures;
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> commitProxyStats;
															#line 2178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<TraceEventFields> grvProxyStats;
															#line 2239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f1;
															#line 2241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<TraceEventFields> f2;
															#line 12910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via workloadStatusFetcher()
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class WorkloadStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >, public ActorCallback< WorkloadStatusFetcherActor, 2, Void >, public ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >, public FastAllocated<WorkloadStatusFetcherActor>, public WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor> {
															#line 12915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<WorkloadStatusFetcherActor>::operator new;
	using FastAllocated<WorkloadStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15223635207393902336UL, 10817847148936496896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 2, Void >;
friend struct ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >;
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkloadStatusFetcherActor(Reference<AsyncVar<ServerDBInfo>> const& db,std::vector<WorkerDetails> const& workers,WorkerDetails const& mWorker,WorkerDetails const& rkWorker,JsonBuilderObject* const& qos,JsonBuilderObject* const& data_overlay,JsonBuilderObject* const& tenants,std::set<std::string>* const& incomplete_reasons,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture) 
															#line 12935 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   WorkloadStatusFetcherActorState<WorkloadStatusFetcherActor>(db, workers, mWorker, rkWorker, qos, data_overlay, tenants, incomplete_reasons, storageServerFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1285460558980581376UL, 3509738831502872832UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workloadStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workloadStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 0, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 1, std::vector<TraceEventFields> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkloadStatusFetcherActor, 3, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> workloadStatusFetcher( Reference<AsyncVar<ServerDBInfo>> const& db, std::vector<WorkerDetails> const& workers, WorkerDetails const& mWorker, WorkerDetails const& rkWorker, JsonBuilderObject* const& qos, JsonBuilderObject* const& data_overlay, JsonBuilderObject* const& tenants, std::set<std::string>* const& incomplete_reasons, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture ) {
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new WorkloadStatusFetcherActor(db, workers, mWorker, rkWorker, qos, data_overlay, tenants, incomplete_reasons, storageServerFuture));
															#line 12971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 12976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ClusterSummaryStatisticsFetcherActor>
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActorState {
															#line 12983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActorState(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : pMetrics(pMetrics),
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   storageServerFuture(storageServerFuture),
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tlogFuture(tlogFuture),
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj()
															#line 12998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	~ClusterSummaryStatisticsFetcherActorState() 
	{
		fdb_probe_actor_destroy("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				cacheStatistics = JsonBuilderObject();
															#line 2374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<ErrorOr<std::vector<StorageServerStatusInfo>>> __when_expr_0 = storageServerFuture;
															#line 2374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 1;
															#line 2374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~ClusterSummaryStatisticsFetcherActorState(); static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->destroy(); return 0; }
															#line 13052 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~ClusterSummaryStatisticsFetcherActorState();
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert("Unknown cache statistics.");
															#line 13073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
															#line 2376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 13088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 13092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2381 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 13116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
															#line 2376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!storageServers.present())
															#line 13139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(storageServers.getError(), loopDepth);
															#line 13143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheHitsHz = 0;
															#line 2381 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double storageCacheMissesHz = 0;
															#line 2383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& ss : storageServers.get() ) {
															#line 2384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(ss.address());
															#line 2385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheHitsHz += hits / elapsed;
															#line 2390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				storageCacheMissesHz += misses / elapsed;
															#line 13167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["storage_hit_rate"] = (storageCacheMissesHz == 0) ? 1.0 : storageCacheHitsHz / (storageCacheHitsHz + storageCacheMissesHz);
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> __when_expr_1 = tlogFuture;
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 2;
															#line 2397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*>(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)));
															#line 13181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<StorageServerStatusInfo>> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,ErrorOr<std::vector<StorageServerStatusInfo>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
															#line 2399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2413 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13300 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
															#line 2399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!tlogServers.present())
															#line 13309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			return a_body1Catch2(tlogServers.getError(), loopDepth);
															#line 13313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheHitsHz = 0;
															#line 2404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		double logCacheMissesHz = 0;
															#line 2406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& log : tlogServers.get() ) {
															#line 2407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto processMetrics = pMetrics.find(log.first.address());
															#line 2408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (processMetrics != pMetrics.end())
															#line 13325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t hits = processMetrics->second.getInt64("CacheHits");
															#line 2410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int64_t misses = processMetrics->second.getInt64("CacheMisses");
															#line 2411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				double elapsed = processMetrics->second.getDouble("Elapsed");
															#line 2412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheHitsHz += hits / elapsed;
															#line 2413 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				logCacheMissesHz += misses / elapsed;
															#line 13337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		cacheStatistics["log_hit_rate"] = (logCacheMissesHz == 0) ? 1.0 : logCacheHitsHz / (logCacheHitsHz + logCacheMissesHz);
															#line 2419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["page_cache"] = cacheStatistics;
															#line 13344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(tlogServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && tlogServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tlogServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state > 0) static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> const& value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> && value) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*,Error err) 
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	WorkerEvents pMetrics;
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<StorageServerStatusInfo>>> storageServerFuture;
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> tlogFuture;
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject cacheStatistics;
															#line 13449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via clusterSummaryStatisticsFetcher()
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ClusterSummaryStatisticsFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >, public ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >, public FastAllocated<ClusterSummaryStatisticsFetcherActor>, public ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor> {
															#line 13454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator new;
	using FastAllocated<ClusterSummaryStatisticsFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(411737670135835136UL, 3267426752901550848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >;
friend struct ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >;
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ClusterSummaryStatisticsFetcherActor(WorkerEvents const& pMetrics,Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture,Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture,std::set<std::string>* const& incomplete_reasons) 
															#line 13472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   ClusterSummaryStatisticsFetcherActorState<ClusterSummaryStatisticsFetcherActor>(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10444091789670181888UL, 658604576535158016UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterSummaryStatisticsFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterSummaryStatisticsFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterSummaryStatisticsFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 0, ErrorOr<std::vector<StorageServerStatusInfo>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterSummaryStatisticsFetcherActor, 1, ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> clusterSummaryStatisticsFetcher( WorkerEvents const& pMetrics, Future<ErrorOr<std::vector<StorageServerStatusInfo>>> const& storageServerFuture, Future<ErrorOr<std::vector<std::pair<TLogInterface, EventMap>>>> const& tlogFuture, std::set<std::string>* const& incomplete_reasons ) {
															#line 2365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new ClusterSummaryStatisticsFetcherActor(pMetrics, storageServerFuture, tlogFuture, incomplete_reasons));
															#line 13506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 13511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via blobGranulesStatusFetcher()
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class BlobGranulesStatusFetcherActor>
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class BlobGranulesStatusFetcherActorState {
															#line 13518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranulesStatusFetcherActorState(Database const& cx,Optional<BlobManagerInterface> const& managerIntf,std::vector<BlobWorkerInterface> const& workers,std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap,std::set<std::string>* const& incompleteReason) 
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   managerIntf(managerIntf),
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   workers(workers),
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   addressWorkersMap(addressWorkersMap),
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incompleteReason(incompleteReason),
															#line 2437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   futures()
															#line 13537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~BlobGranulesStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["number_of_blob_workers"] = static_cast<int>(workers.size());
															#line 13552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			try {
															#line 2442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				config = BlobGranuleBackupConfig();
															#line 2443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<bool> __when_expr_0 = config.enabled().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobGranulesStatusFetcherActorState();
		static_cast<BlobGranulesStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<BlobGranulesStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~BlobGranulesStatusFetcherActorState(); static_cast<BlobGranulesStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 13594 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<BlobGranulesStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~BlobGranulesStatusFetcherActorState();
		static_cast<BlobGranulesStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incompleteReason->insert("Unknown blob worker stats");
															#line 13615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& backupEnabled,int loopDepth) 
	{
															#line 2444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_backup_enabled"] = backupEnabled;
															#line 2445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (backupEnabled)
															#line 13632 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = config.manifestUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool && backupEnabled,int loopDepth) 
	{
															#line 2444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_backup_enabled"] = backupEnabled;
															#line 2445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (backupEnabled)
															#line 13659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = config.manifestUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& backupEnabled,int loopDepth) 
	{
		loopDepth = a_body1cont2(backupEnabled, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && backupEnabled,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(backupEnabled), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (managerIntf.present())
															#line 13759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<TraceEventFields>> __when_expr_3 = timeoutError( latestEventOnWorker(addressWorkersMap[managerIntf.get().address()], "BlobManagerMetrics"), 2.0);
															#line 2453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(std::string const& manifestUrl,int loopDepth) 
	{
															#line 2447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_manifest_url"] = manifestUrl;
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = config.mutationLogsUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(std::string && manifestUrl,int loopDepth) 
	{
															#line 2447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_manifest_url"] = manifestUrl;
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = config.mutationLogsUrl().getD(SystemDBWriteLockedNow(cx.getReference()));
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 13811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& manifestUrl,int loopDepth) 
	{
		loopDepth = a_body1cont4(manifestUrl, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && manifestUrl,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(manifestUrl), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::string const& mlogsUrl,int loopDepth) 
	{
															#line 2449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_mlogs_url"] = mlogsUrl;
															#line 13895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(std::string && mlogsUrl,int loopDepth) 
	{
															#line 2449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_granules_mlogs_url"] = mlogsUrl;
															#line 13904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::string const& mlogsUrl,int loopDepth) 
	{
		loopDepth = a_body1cont5(mlogsUrl, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::string && mlogsUrl,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(mlogsUrl), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto& intf : workers ) {
															#line 2467 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			auto workerIntf = addressWorkersMap[intf.address()];
															#line 2468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			futures.push_back(latestEventOnWorker(workerIntf, "BlobWorkerMetrics"));
															#line 13992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_4 = timeoutError(waitForAll(futures), 2.0);
															#line 2471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*>(static_cast<BlobGranulesStatusFetcherActor*>(this)));
															#line 14003 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<TraceEventFields> const& fields,int loopDepth) 
	{
															#line 2455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (fields.present())
															#line 14012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_flush_version"] = fields.get().getUint64("LastFlushVersion");
															#line 2457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_dump_ts"] = fields.get().getUint64("LastManifestDumpTs");
															#line 2458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_seq_no"] = fields.get().getUint64("LastManifestSeqNo");
															#line 2459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_epoch"] = fields.get().getUint64("Epoch");
															#line 2460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_size_in_bytes"] = fields.get().getUint64("ManifestSizeInBytes");
															#line 2461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_truncation_version"] = fields.get().getUint64("LastMLogTruncationVersion");
															#line 14026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<TraceEventFields> && fields,int loopDepth) 
	{
															#line 2455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (fields.present())
															#line 14036 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_flush_version"] = fields.get().getUint64("LastFlushVersion");
															#line 2457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_dump_ts"] = fields.get().getUint64("LastManifestDumpTs");
															#line 2458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_seq_no"] = fields.get().getUint64("LastManifestSeqNo");
															#line 2459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_epoch"] = fields.get().getUint64("Epoch");
															#line 2460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_manifest_size_in_bytes"] = fields.get().getUint64("ManifestSizeInBytes");
															#line 2461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["last_truncation_version"] = fields.get().getUint64("LastMLogTruncationVersion");
															#line 14050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TraceEventFields> const& fields,int loopDepth) 
	{
		loopDepth = a_body1cont8(fields, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TraceEventFields> && fields,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(fields), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Optional<TraceEventFields> const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Optional<TraceEventFields> && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 2473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		totalRanges = 0;
															#line 2474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto future : futures ) {
															#line 2475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (future.get().present())
															#line 14139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto latestTrace = future.get().get();
															#line 2477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int numRanges = latestTrace.getInt("NumRangesAssigned");
															#line 2478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				totalRanges += numRanges;
															#line 2480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject workerStatusObj;
															#line 2481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["number_of_key_ranges"] = numRanges;
															#line 2482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["put_requests"] = StatusCounter(latestTrace.getValue("S3PutReqs")).getStatus();
															#line 2483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["get_requests"] = StatusCounter(latestTrace.getValue("S3GetReqs")).getStatus();
															#line 2484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["delete_requests"] = StatusCounter(latestTrace.getValue("S3DeleteReqs")).getStatus();
															#line 2485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["bytes_buffered"] = latestTrace.getInt64("MutationBytesBuffered");
															#line 2486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_raw"] = StatusCounter(latestTrace.getValue("CompressionBytesRaw")).getStatus();
															#line 2488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_final"] = StatusCounter(latestTrace.getValue("CompressionBytesFinal")).getStatus();
															#line 2490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj[latestTrace.getValue("ID")] = workerStatusObj;
															#line 14165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["number_of_key_ranges"] = totalRanges;
															#line 14170 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 2473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		totalRanges = 0;
															#line 2474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for( auto future : futures ) {
															#line 2475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (future.get().present())
															#line 14183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				auto latestTrace = future.get().get();
															#line 2477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				int numRanges = latestTrace.getInt("NumRangesAssigned");
															#line 2478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				totalRanges += numRanges;
															#line 2480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				JsonBuilderObject workerStatusObj;
															#line 2481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["number_of_key_ranges"] = numRanges;
															#line 2482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["put_requests"] = StatusCounter(latestTrace.getValue("S3PutReqs")).getStatus();
															#line 2483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["get_requests"] = StatusCounter(latestTrace.getValue("S3GetReqs")).getStatus();
															#line 2484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["delete_requests"] = StatusCounter(latestTrace.getValue("S3DeleteReqs")).getStatus();
															#line 2485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["bytes_buffered"] = latestTrace.getInt64("MutationBytesBuffered");
															#line 2486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_raw"] = StatusCounter(latestTrace.getValue("CompressionBytesRaw")).getStatus();
															#line 2488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				workerStatusObj["compression_bytes_final"] = StatusCounter(latestTrace.getValue("CompressionBytesFinal")).getStatus();
															#line 2490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				statusObj[latestTrace.getValue("ID")] = workerStatusObj;
															#line 14209 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
		}
															#line 2493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["number_of_key_ranges"] = totalRanges;
															#line 14214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobGranulesStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobGranulesStatusFetcherActor*>(this)->ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Optional<BlobManagerInterface> managerIntf;
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<BlobWorkerInterface> workers;
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::unordered_map<NetworkAddress, WorkerInterface> addressWorkersMap;
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incompleteReason;
															#line 2437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<Optional<TraceEventFields>>> futures;
															#line 2442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranuleBackupConfig config;
															#line 2473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int totalRanges;
															#line 14325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via blobGranulesStatusFetcher()
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class BlobGranulesStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >, public ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >, public ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >, public ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >, public ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >, public FastAllocated<BlobGranulesStatusFetcherActor>, public BlobGranulesStatusFetcherActorState<BlobGranulesStatusFetcherActor> {
															#line 14330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<BlobGranulesStatusFetcherActor>::operator new;
	using FastAllocated<BlobGranulesStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8411942490220616448UL, 1233267060977256448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >;
friend struct ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >;
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranulesStatusFetcherActor(Database const& cx,Optional<BlobManagerInterface> const& managerIntf,std::vector<BlobWorkerInterface> const& workers,std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap,std::set<std::string>* const& incompleteReason) 
															#line 14351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   BlobGranulesStatusFetcherActorState<BlobGranulesStatusFetcherActor>(cx, managerIntf, workers, addressWorkersMap, incompleteReason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13293766905701207552UL, 14914104356464938496UL);
		ActorExecutionContextHelper __helper(static_cast<BlobGranulesStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobGranulesStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobGranulesStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 3, Optional<TraceEventFields> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobGranulesStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> blobGranulesStatusFetcher( Database const& cx, Optional<BlobManagerInterface> const& managerIntf, std::vector<BlobWorkerInterface> const& workers, std::unordered_map<NetworkAddress, WorkerInterface> const& addressWorkersMap, std::set<std::string>* const& incompleteReason ) {
															#line 2430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new BlobGranulesStatusFetcherActor(cx, managerIntf, workers, addressWorkersMap, incompleteReason));
															#line 14388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2501 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 14393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via blobRestoreStatusFetcher()
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class BlobRestoreStatusFetcherActor>
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class BlobRestoreStatusFetcherActorState {
															#line 14400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestoreStatusFetcherActorState(Database const& db,std::set<std::string>* const& incompleteReason) 
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : db(db),
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incompleteReason(incompleteReason),
															#line 2503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(db)
															#line 14413 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~BlobRestoreStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 14429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRestoreStatusFetcherActorState();
		static_cast<BlobRestoreStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<BlobRestoreStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~BlobRestoreStatusFetcherActorState(); static_cast<BlobRestoreStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 14458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<BlobRestoreStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~BlobRestoreStatusFetcherActorState();
		static_cast<BlobRestoreStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2533 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incompleteReason->insert("Unable to query blob restore status");
															#line 14479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			config = BlobGranuleRestoreConfig();
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<BlobRestorePhase> __when_expr_0 = config.phase().getD(&tr, Snapshot::False, BlobRestorePhase::UNINIT);
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 2529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 7;
															#line 2529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (phase > BlobRestorePhase::UNINIT)
															#line 14580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["blob_full_restore_phase"] = phase;
															#line 2516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<int> __when_expr_1 = config.progress().getD(&tr);
															#line 2516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& __phase,int loopDepth) 
	{
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		phase = __phase;
															#line 14607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && __phase,int loopDepth) 
	{
		phase = std::move(__phase);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(int const& progress,int loopDepth) 
	{
															#line 2517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_progress"] = progress;
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = config.phaseStartTs().getD(&tr, phase);
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int && progress,int loopDepth) 
	{
															#line 2517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_progress"] = progress;
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = config.phaseStartTs().getD(&tr, phase);
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int const& progress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(progress, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int && progress,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(progress), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int64_t const& phaseStartTs,int loopDepth) 
	{
															#line 2519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_start_ts"] = phaseStartTs;
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = config.phaseStartTs().getD(&tr, BlobRestorePhase::INIT);
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(int64_t && phaseStartTs,int loopDepth) 
	{
															#line 2519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_phase_start_ts"] = phaseStartTs;
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<int64_t> __when_expr_3 = config.phaseStartTs().getD(&tr, BlobRestorePhase::INIT);
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14830 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(int64_t const& phaseStartTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(phaseStartTs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(int64_t && phaseStartTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(phaseStartTs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int64_t const& startTs,int loopDepth) 
	{
															#line 2521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_start_ts"] = startTs;
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_4 = config.error().getD(&tr);
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(int64_t && startTs,int loopDepth) 
	{
															#line 2521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_start_ts"] = startTs;
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<std::string> __when_expr_4 = config.error().getD(&tr);
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 14941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(int64_t const& startTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(startTs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(int64_t && startTs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(startTs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(std::string const& error,int loopDepth) 
	{
															#line 2523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_error"] = error;
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Version> __when_expr_5 = config.targetVersion().getD(&tr);
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 15034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::string && error,int loopDepth) 
	{
															#line 2523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_error"] = error;
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Version> __when_expr_5 = config.targetVersion().getD(&tr);
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 6;
															#line 2524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*>(static_cast<BlobRestoreStatusFetcherActor*>(this)));
															#line 15052 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(std::string const& error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(error, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(std::string && error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(error), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont8(Version const& targetVersion,int loopDepth) 
	{
															#line 2525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_version"] = targetVersion;
															#line 15136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Version && targetVersion,int loopDepth) 
	{
															#line 2525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj["blob_full_restore_version"] = targetVersion;
															#line 15145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Version const& targetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(targetVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Version && targetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(targetVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<BlobRestoreStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRestoreStatusFetcherActor*>(this)->ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database db;
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incompleteReason;
															#line 2503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 2511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobGranuleRestoreConfig config;
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestorePhase phase;
															#line 15337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via blobRestoreStatusFetcher()
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class BlobRestoreStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >, public ActorCallback< BlobRestoreStatusFetcherActor, 1, int >, public ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >, public ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >, public ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >, public ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >, public ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >, public FastAllocated<BlobRestoreStatusFetcherActor>, public BlobRestoreStatusFetcherActorState<BlobRestoreStatusFetcherActor> {
															#line 15342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<BlobRestoreStatusFetcherActor>::operator new;
	using FastAllocated<BlobRestoreStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15183258263941090816UL, 1210010083446032896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 1, int >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >;
friend struct ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >;
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	BlobRestoreStatusFetcherActor(Database const& db,std::set<std::string>* const& incompleteReason) 
															#line 15365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   BlobRestoreStatusFetcherActorState<BlobRestoreStatusFetcherActor>(db, incompleteReason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3301679672762546944UL, 427005505404888576UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRestoreStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobRestoreStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobRestoreStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 3, int64_t >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 4, std::string >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 5, Version >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BlobRestoreStatusFetcherActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] static Future<JsonBuilderObject> blobRestoreStatusFetcher( Database const& db, std::set<std::string>* const& incompleteReason ) {
															#line 2502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new BlobRestoreStatusFetcherActor(db, incompleteReason));
															#line 15404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

static JsonBuilderObject tlogFetcher(int* logFaultTolerance,
                                     const std::vector<TLogSet>& tLogs,
                                     std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderObject statusObj;
	JsonBuilderArray logsObj;
	Optional<int32_t> sat_log_replication_factor, sat_log_write_anti_quorum, sat_log_fault_tolerance,
	    log_replication_factor, log_write_anti_quorum, log_fault_tolerance, remote_log_replication_factor,
	    remote_log_fault_tolerance;

	int minFaultTolerance = 1000;
	int localSetsWithNonNegativeFaultTolerance = 0;

	for (const auto& tLogSet : tLogs) {
		if (tLogSet.tLogs.size() == 0) {
			// We can have LogSets where there are no tLogs but some LogRouters. It's the way
			// recruiting is implemented for old LogRouters in TagPartitionedLogSystem, where
			// it adds an empty LogSet for missing locality.
			continue;
		}

		int failedLogs = 0;
		for (auto& log : tLogSet.tLogs) {
			JsonBuilderObject logObj;
			bool failed = !log.present() || !address_workers.contains(log.interf().address());
			logObj["id"] = log.id().shortString();
			logObj["healthy"] = !failed;
			if (log.present()) {
				logObj["address"] = log.interf().address().toString();
			}
			logsObj.push_back(logObj);
			if (failed) {
				failedLogs++;
			}
		}

		if (tLogSet.isLocal) {
			ASSERT_WE_THINK(tLogSet.tLogReplicationFactor > 0);
			int currentFaultTolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
			if (currentFaultTolerance >= 0) {
				localSetsWithNonNegativeFaultTolerance++;
			}

			if (tLogSet.locality == tagLocalitySatellite) {
				// FIXME: This hack to bump satellite fault tolerance, is to make it consistent
				//  with 6.2.
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance + 1);
			} else {
				minFaultTolerance = std::min(minFaultTolerance, currentFaultTolerance);
			}
		}

		if (tLogSet.isLocal && tLogSet.locality == tagLocalitySatellite) {
			sat_log_replication_factor = tLogSet.tLogReplicationFactor;
			sat_log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			sat_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else if (tLogSet.isLocal) {
			log_replication_factor = tLogSet.tLogReplicationFactor;
			log_write_anti_quorum = tLogSet.tLogWriteAntiQuorum;
			log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - tLogSet.tLogWriteAntiQuorum - failedLogs;
		} else {
			remote_log_replication_factor = tLogSet.tLogReplicationFactor;
			remote_log_fault_tolerance = tLogSet.tLogReplicationFactor - 1 - failedLogs;
		}
	}
	if (minFaultTolerance == 1000) {
		// just in case we do not have any tlog sets
		minFaultTolerance = 0;
	}
	if (localSetsWithNonNegativeFaultTolerance > 1) {
		minFaultTolerance++;
	}
	*logFaultTolerance = std::min(*logFaultTolerance, minFaultTolerance);
	statusObj["log_interfaces"] = logsObj;
	// We may lose logs in this log generation, storage servers may never be able to catch up this log
	// generation.
	statusObj["possibly_losing_data"] = minFaultTolerance < 0;

	if (sat_log_replication_factor.present())
		statusObj["satellite_log_replication_factor"] = sat_log_replication_factor.get();
	if (sat_log_write_anti_quorum.present())
		statusObj["satellite_log_write_anti_quorum"] = sat_log_write_anti_quorum.get();
	if (sat_log_fault_tolerance.present())
		statusObj["satellite_log_fault_tolerance"] = sat_log_fault_tolerance.get();

	if (log_replication_factor.present())
		statusObj["log_replication_factor"] = log_replication_factor.get();
	if (log_write_anti_quorum.present())
		statusObj["log_write_anti_quorum"] = log_write_anti_quorum.get();
	if (log_fault_tolerance.present())
		statusObj["log_fault_tolerance"] = log_fault_tolerance.get();

	if (remote_log_replication_factor.present())
		statusObj["remote_log_replication_factor"] = remote_log_replication_factor.get();
	if (remote_log_fault_tolerance.present())
		statusObj["remote_log_fault_tolerance"] = remote_log_fault_tolerance.get();

	return statusObj;
}

static JsonBuilderArray tlogFetcher(int* logFaultTolerance,
                                    Reference<AsyncVar<ServerDBInfo>> db,
                                    std::unordered_map<NetworkAddress, WorkerInterface> const& address_workers) {
	JsonBuilderArray tlogsArray;
	JsonBuilderObject tlogsStatus;

	// First, fetch from the current TLog generation.
	tlogsStatus = tlogFetcher(logFaultTolerance, db->get().logSystemConfig.tLogs, address_workers);
	tlogsStatus["epoch"] = db->get().logSystemConfig.epoch;
	tlogsStatus["current"] = true;
	if (db->get().logSystemConfig.recoveredAt.present()) {
		tlogsStatus["begin_version"] = db->get().logSystemConfig.recoveredAt.get();
	}
	tlogsArray.push_back(tlogsStatus);

	// fetch all the old generations of TLogs.
	for (auto it : db->get().logSystemConfig.oldTLogs) {
		JsonBuilderObject oldTlogsStatus = tlogFetcher(logFaultTolerance, it.tLogs, address_workers);
		oldTlogsStatus["epoch"] = it.epoch;
		oldTlogsStatus["current"] = false;
		oldTlogsStatus["begin_version"] = it.epochBegin;
		oldTlogsStatus["end_version"] = it.epochEnd;
		tlogsArray.push_back(oldTlogsStatus);
	}
	return tlogsArray;
}

static JsonBuilderObject faultToleranceStatusFetcher(DatabaseConfiguration configuration,
                                                     ServerCoordinators coordinators,
                                                     const std::vector<NetworkAddress>& coordinatorAddresses,
                                                     const std::vector<WorkerDetails>& workers,
                                                     int extraTlogEligibleZones,
                                                     int minStorageReplicasRemaining,
                                                     int oldLogFaultTolerance,
                                                     int fullyReplicatedRegions,
                                                     bool underMaintenance) {
	JsonBuilderObject statusObj;

	// without losing data
	int32_t maxZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, false);
	if (underMaintenance) {
		maxZoneFailures--;
	}
	int maxCoordinatorFailures = (coordinators.clientLeaderServers.size() - 1) / 2;

	std::map<NetworkAddress, StringRef> workerZones;
	for (const auto& worker : workers) {
		workerZones[worker.interf.address()] = worker.interf.locality.zoneId().orDefault(""_sr);
	}
	std::map<StringRef, int> coordinatorZoneCounts;
	for (const auto& coordinator : coordinatorAddresses) {
		auto zone = workerZones[coordinator];
		coordinatorZoneCounts[zone] += 1;
	}
	std::vector<std::pair<StringRef, int>> coordinatorZones(coordinatorZoneCounts.begin(), coordinatorZoneCounts.end());
	std::sort(coordinatorZones.begin(),
	          coordinatorZones.end(),
	          [](const std::pair<StringRef, int>& lhs, const std::pair<StringRef, int>& rhs) {
		          return lhs.second > rhs.second;
	          });
	int lostCoordinators = 0;
	int maxCoordinatorZoneFailures = 0;
	for (auto zone : coordinatorZones) {
		lostCoordinators += zone.second;
		if (lostCoordinators > maxCoordinatorFailures) {
			break;
		}
		maxCoordinatorZoneFailures += 1;
	}
	// max zone failures that we can tolerate to not lose data
	int zoneFailuresWithoutLosingData = std::min(maxZoneFailures, maxCoordinatorZoneFailures);

	if (minStorageReplicasRemaining >= 0) {
		zoneFailuresWithoutLosingData = std::min(zoneFailuresWithoutLosingData, minStorageReplicasRemaining - 1);
	}

	// oldLogFaultTolerance means max failures we can tolerate to lose logs data. -1 means we lose data or
	// availability.
	zoneFailuresWithoutLosingData = std::max(std::min(zoneFailuresWithoutLosingData, oldLogFaultTolerance), -1);
	statusObj["max_zone_failures_without_losing_data"] = zoneFailuresWithoutLosingData;

	int32_t maxAvaiabilityZoneFailures = configuration.maxZoneFailuresTolerated(fullyReplicatedRegions, true);
	if (underMaintenance) {
		maxAvaiabilityZoneFailures--;
	}

	statusObj["max_zone_failures_without_losing_availability"] = std::max(
	    std::min(maxAvaiabilityZoneFailures, std::min(extraTlogEligibleZones, zoneFailuresWithoutLosingData)), -1);
	return statusObj;
}

static std::string getIssueDescription(std::string name) {
	if (name == "incorrect_cluster_file_contents") {
		return "Cluster file contents do not match current cluster connection string. Verify the cluster file and "
		       "its "
		       "parent directory are writable and that the cluster file has not been overwritten externally.";
	}

	// FIXME: name and description will be the same unless the message is 'incorrect_cluster_file_contents', which
	// is currently the only possible message
	return name;
}

static std::map<std::string, std::vector<JsonBuilderObject>> getProcessIssuesAsMessages(
    std::vector<ProcessIssues> const& issues) {
	std::map<std::string, std::vector<JsonBuilderObject>> issuesMap;

	try {
		for (auto processIssues : issues) {
			for (auto issue : processIssues.issues) {
				std::string issueStr = issue.toString();
				issuesMap[processIssues.address.toString()].push_back(
				    JsonString::makeMessage(issueStr.c_str(), getIssueDescription(issueStr).c_str()));
			}
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingProcessIssues").error(e);
		// swallow
	}

	return issuesMap;
}

static JsonBuilderArray getClientIssuesAsMessages(
    std::map<NetworkAddress, std::pair<double, OpenDatabaseRequest>>* clientStatusMap) {
	JsonBuilderArray issuesList;

	try {
		std::map<std::string, std::pair<int, std::vector<std::string>>> deduplicatedIssues;

		for (auto iter = clientStatusMap->begin(); iter != clientStatusMap->end();) {
			if (now() - iter->second.first >= 2 * SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL) {
				iter = clientStatusMap->erase(iter);
				continue;
			}

			for (const auto& [issueKey, samples] : iter->second.second.issues) {
				auto& t = deduplicatedIssues[issueKey.toString()];
				t.first += samples.count;
				for (const auto& sample : samples.samples) {
					t.second.push_back(formatIpPort(sample.first.ip, sample.first.port));
				}
			}
			++iter;
		}

		// FIXME: add the log_group in addition to the network address
		for (auto i : deduplicatedIssues) {
			JsonBuilderObject message = JsonString::makeMessage(i.first.c_str(), getIssueDescription(i.first).c_str());
			JsonBuilderArray addresses;
			for (auto addr : i.second.second) {
				addresses.push_back(addr);
			}

			message["count"] = i.second.first;
			message["addresses"] = addresses;
			issuesList.push_back(message);
		}
	} catch (Error& e) {
		TraceEvent(SevError, "ErrorParsingClientIssues").error(e);
		// swallow
	}

	return issuesList;
}

															#line 15674 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via layerStatusFetcher()
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LayerStatusFetcherActor>
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActorState {
															#line 15681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   result(),
															#line 2810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   json(result),
															#line 2811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tStart(now())
															#line 15698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LayerStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("layerStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2814 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr = ReadYourWritesTransaction(cx);
															#line 2815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				;
															#line 15716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2865 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.cleanOps();
															#line 2866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JsonBuilderObject statusObj;
															#line 2867 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		statusObj.addContents(result);
															#line 2868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		TraceEvent("LayerStatusFetcher") .detail("Duration", now() - tStart) .detail("StatusSize", statusObj.getFinalLength());
															#line 2871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LayerStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LayerStatusFetcherActorState(); static_cast<LayerStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 15753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LayerStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(statusObj);
		this->~LayerStatusFetcherActorState();
		static_cast<LayerStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusError").error(e);
															#line 2857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 15768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 15772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to retrieve layer status (%s).", e.what()));
															#line 2861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_error") = format("Unable to retrieve layer status (%s).", e.what());
															#line 2862 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json.create("_valid") = false;
															#line 15780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			int64_t timeout_ms = 3000;
															#line 2819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::TIMEOUT, StringRef((uint8_t*)&timeout_ms, sizeof(int64_t)));
															#line 2821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			std::string jsonPrefix = layerStatusMetaPrefixRange.begin.toString() + "json/";
															#line 2822 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(jsonPrefix, strinc(jsonPrefix)), 1000);
															#line 2822 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15819 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2822 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 15824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 2852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 5;
															#line 2852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 4, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 15866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& jsonLayers,int loopDepth) 
	{
															#line 2825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 15887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 15895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && jsonLayers,int loopDepth) 
	{
															#line 2825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docFutures = std::vector<Future<RangeResult>>();
															#line 2826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = int();
															#line 2827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		for(i = 0;i < jsonLayers.size();++i) {
															#line 2828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			docFutures.push_back( tr.getRange(KeyRangeRef(jsonLayers[i].value, strinc(jsonLayers[i].value)), 1000));
															#line 15910 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		result.clear();
															#line 2832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 2834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		i = 0;
															#line 15918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(jsonLayers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && jsonLayers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(jsonLayers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.create("_valid") = true;
															#line 16002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 2834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(i < docFutures.size()))
															#line 16018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = docFutures[i];
															#line 2835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		j = int();
															#line 2837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		j = 0;
															#line 16055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& __docs,int loopDepth) 
	{
															#line 2835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		docs = __docs;
															#line 16064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && __docs,int loopDepth) 
	{
		docs = std::move(__docs);
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++i;
															#line 16143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!(j < docs.size()))
															#line 16159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
			return a_body1loopBody1cont2loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		doc = json_spirit::mValue();
															#line 16165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 2840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			json_spirit::read_string(docs[j].value.toString(), doc);
															#line 2841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yield();
															#line 2841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 3;
															#line 2841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 2, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2837 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		++j;
															#line 16206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			TraceEvent(SevWarn, "LayerStatusBadJSON").detail("Key", docs[j].key);
															#line 16216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2842 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		json.absorb(doc.get_obj());
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 4;
															#line 2843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LayerStatusFetcherActor, 3, Void >*>(static_cast<LayerStatusFetcherActor*>(this)));
															#line 16258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LayerStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LayerStatusFetcherActor*>(this)->ActorCallback< LayerStatusFetcherActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LayerStatusFetcherActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	StatusObject result;
															#line 2810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JSONDoc json;
															#line 2811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	double tStart;
															#line 2814 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::vector<Future<RangeResult>> docFutures;
															#line 2826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int i;
															#line 2835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	RangeResult docs;
															#line 2836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int j;
															#line 2838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	json_spirit::mValue doc;
															#line 16562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via layerStatusFetcher()
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LayerStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LayerStatusFetcherActor, 0, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 1, RangeResult >, public ActorCallback< LayerStatusFetcherActor, 2, Void >, public ActorCallback< LayerStatusFetcherActor, 3, Void >, public ActorCallback< LayerStatusFetcherActor, 4, Void >, public FastAllocated<LayerStatusFetcherActor>, public LayerStatusFetcherActorState<LayerStatusFetcherActor> {
															#line 16567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LayerStatusFetcherActor>::operator new;
	using FastAllocated<LayerStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6848886531485647616UL, 4978264544700016640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LayerStatusFetcherActor, 0, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 1, RangeResult >;
friend struct ActorCallback< LayerStatusFetcherActor, 2, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 3, Void >;
friend struct ActorCallback< LayerStatusFetcherActor, 4, Void >;
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LayerStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 16588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LayerStatusFetcherActorState<LayerStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17036008822344536576UL, 14869839289433060096UL);
		ActorExecutionContextHelper __helper(static_cast<LayerStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("layerStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("layerStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LayerStatusFetcherActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> layerStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LayerStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 16625 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2873 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 16630 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via lockedStatusFetcher()
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class LockedStatusFetcherActor>
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActorState {
															#line 16637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActorState(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   incomplete_reasons(incomplete_reasons),
															#line 2877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   statusObj(),
															#line 2879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   timeoutSeconds(5),
															#line 2881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   getTimeout(delay(timeoutSeconds))
															#line 16656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	~LockedStatusFetcherActorState() 
	{
		fdb_probe_actor_destroy("lockedStatusFetcher", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 16671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2916 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<LockedStatusFetcherActor*>(this)->SAV<JsonBuilderObject>::futures) { (void)(statusObj); this->~LockedStatusFetcherActorState(); static_cast<LockedStatusFetcherActor*>(this)->destroy(); return 0; }
															#line 16694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<LockedStatusFetcherActor*>(this)->SAV< JsonBuilderObject >::value()) JsonBuilderObject(std::move(statusObj)); // state_var_RVO
		this->~LockedStatusFetcherActorState();
		static_cast<LockedStatusFetcherActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2885 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2886 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 16717 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		try {
															#line 2889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(databaseLockedKey);
															#line 2888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getTimeout;
															#line 16727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 1;
															#line 2889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 2898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 1, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 16734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			try {
															#line 2906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 16772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 2;
															#line 2906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LockedStatusFetcherActor, 2, Void >*>(static_cast<LockedStatusFetcherActor*>(this)));
															#line 16777 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& lockUID,int loopDepth) 
	{
															#line 2890 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 16804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 16810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 16816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && lockUID,int loopDepth) 
	{
															#line 2890 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (lockUID.present())
															#line 16826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = true;
															#line 2892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["lock_uid"] = BinaryReader::fromStringRef<UID>(lockUID.get().substr(10), Unversioned()).toString();
															#line 16832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		else
		{
															#line 2895 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			statusObj["locked"] = false;
															#line 16838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 16848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		incomplete_reasons->insert( format("Unable to determine if database is locked after %d seconds.", timeoutSeconds));
															#line 16857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >::remove();
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 16998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2911 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			incomplete_reasons->insert(format("Unable to determine if database is locked (%s).", e.what()));
															#line 17002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state > 0) static_cast<LockedStatusFetcherActor*>(this)->actor_wait_state = 0;
		static_cast<LockedStatusFetcherActor*>(this)->ActorCallback< LockedStatusFetcherActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LockedStatusFetcherActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	std::set<std::string>* incomplete_reasons;
															#line 2877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderObject statusObj;
															#line 2879 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Transaction tr;
															#line 2880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int timeoutSeconds;
															#line 2881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> getTimeout;
															#line 17127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via lockedStatusFetcher()
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class LockedStatusFetcherActor final : public Actor<JsonBuilderObject>, public ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >, public ActorCallback< LockedStatusFetcherActor, 1, Void >, public ActorCallback< LockedStatusFetcherActor, 2, Void >, public FastAllocated<LockedStatusFetcherActor>, public LockedStatusFetcherActorState<LockedStatusFetcherActor> {
															#line 17132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<LockedStatusFetcherActor>::operator new;
	using FastAllocated<LockedStatusFetcherActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5858112200423416832UL, 2250039934058094336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<JsonBuilderObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >;
friend struct ActorCallback< LockedStatusFetcherActor, 1, Void >;
friend struct ActorCallback< LockedStatusFetcherActor, 2, Void >;
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	LockedStatusFetcherActor(Database const& cx,JsonBuilderArray* const& messages,std::set<std::string>* const& incomplete_reasons) 
															#line 17151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<JsonBuilderObject>(),
		   LockedStatusFetcherActorState<LockedStatusFetcherActor>(cx, messages, incomplete_reasons),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14369978241092976128UL, 3028260835526008320UL);
		ActorExecutionContextHelper __helper(static_cast<LockedStatusFetcherActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockedStatusFetcher");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockedStatusFetcher", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockedStatusFetcherActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<JsonBuilderObject> lockedStatusFetcher( Database const& cx, JsonBuilderArray* const& messages, std::set<std::string>* const& incomplete_reasons ) {
															#line 2874 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<JsonBuilderObject>(new LockedStatusFetcherActor(cx, messages, incomplete_reasons));
															#line 17185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 17190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via getActivePrimaryDC()
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class GetActivePrimaryDCActor>
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActorState {
															#line 17197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActorState(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   fullyReplicatedRegions(fullyReplicatedRegions),
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   messages(messages),
															#line 2920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(cx),
															#line 2922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   readTimeout(delay(5))
															#line 17212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	~GetActivePrimaryDCActorState() 
	{
		fdb_probe_actor_destroy("getActivePrimaryDC", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 17227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2925 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (readTimeout.isReady())
															#line 17258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2926 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				return a_body1loopBody1Catch1(timed_out(), loopDepth);
															#line 17262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			fReplicaKeys = tr.getRange(datacenterReplicasKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			fPrimaryDatacenterKey = tr.get(primaryDatacenterKey);
															#line 2932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(success(fPrimaryDatacenterKey) && success(fReplicaKeys), 5);
															#line 2932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 1;
															#line 2932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 0, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 17281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 17303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				messages->push_back( JsonString::makeMessage("fetch_primary_dc_timeout", "Fetching primary DC timed out."));
															#line 2945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(Optional<Value>()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(Optional<Value>());
				this->~GetActivePrimaryDCActorState();
				static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 2;
															#line 2947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetActivePrimaryDCActor, 1, Void >*>(static_cast<GetActivePrimaryDCActor*>(this)));
															#line 17326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 17344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 17348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		*fullyReplicatedRegions = fReplicaKeys.get().size();
															#line 2936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!fPrimaryDatacenterKey.get().present())
															#line 17366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		{
															#line 2937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			messages->push_back( JsonString::makeMessage("primary_dc_missing", "Unable to determine primary datacenter."));
															#line 17370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		}
															#line 2940 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<GetActivePrimaryDCActor*>(this)->SAV<Optional<Value>>::futures) { (void)(fPrimaryDatacenterKey.get()); this->~GetActivePrimaryDCActorState(); static_cast<GetActivePrimaryDCActor*>(this)->destroy(); return 0; }
															#line 17374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<GetActivePrimaryDCActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(fPrimaryDatacenterKey.get());
		this->~GetActivePrimaryDCActorState();
		static_cast<GetActivePrimaryDCActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state > 0) static_cast<GetActivePrimaryDCActor*>(this)->actor_wait_state = 0;
		static_cast<GetActivePrimaryDCActor*>(this)->ActorCallback< GetActivePrimaryDCActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetActivePrimaryDCActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	int* fullyReplicatedRegions;
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	JsonBuilderArray* messages;
															#line 2920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Void> readTimeout;
															#line 2930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<RangeResult> fReplicaKeys;
															#line 2931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Future<Optional<Value>> fPrimaryDatacenterKey;
															#line 17564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
};
// This generated class is to be used only via getActivePrimaryDC()
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class GetActivePrimaryDCActor final : public Actor<Optional<Value>>, public ActorCallback< GetActivePrimaryDCActor, 0, Void >, public ActorCallback< GetActivePrimaryDCActor, 1, Void >, public FastAllocated<GetActivePrimaryDCActor>, public GetActivePrimaryDCActorState<GetActivePrimaryDCActor> {
															#line 17569 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
	using FastAllocated<GetActivePrimaryDCActor>::operator new;
	using FastAllocated<GetActivePrimaryDCActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18143631445478732544UL, 1754094193477972992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActivePrimaryDCActor, 0, Void >;
friend struct ActorCallback< GetActivePrimaryDCActor, 1, Void >;
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	GetActivePrimaryDCActor(Database const& cx,int* const& fullyReplicatedRegions,JsonBuilderArray* const& messages) 
															#line 17587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetActivePrimaryDCActorState<GetActivePrimaryDCActor>(cx, fullyReplicatedRegions, messages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11163384421170287360UL, 3820190715572017408UL);
		ActorExecutionContextHelper __helper(static_cast<GetActivePrimaryDCActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getActivePrimaryDC");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getActivePrimaryDC", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetActivePrimaryDCActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getActivePrimaryDC( Database const& cx, int* const& fullyReplicatedRegions, JsonBuilderArray* const& messages ) {
															#line 2919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	return Future<Optional<Value>>(new GetActivePrimaryDCActor(cx, fullyReplicatedRegions, messages));
															#line 17621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
}

#line 2952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"

															#line 17626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
namespace {
// This generated class is to be used only via readStorageWiggleMetrics()
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
template <class ReadStorageWiggleMetricsActor>
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
class ReadStorageWiggleMetricsActorState {
															#line 17633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
public:
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	ReadStorageWiggleMetricsActorState(Database const& cx,bool const& use_system_priority) 
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		 : cx(cx),
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 2956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 2957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   primaryV(),
															#line 2958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   remoteV(),
															#line 2959 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		   wiggleState()
															#line 17650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
	{
		fdb_probe_actor_create("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	~ReadStorageWiggleMetricsActorState() 
	{
		fdb_probe_actor_destroy("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			;
															#line 17665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (use_system_priority)
															#line 17696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			{
															#line 2963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
				tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 17700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			}
															#line 2965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(primaryV, wiggleState.storageWiggleMetrics(PrimaryRegion(true)).get(tr)) && store(remoteV, wiggleState.storageWiggleMetrics(PrimaryRegion(false)).get(tr));
															#line 2967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 1;
															#line 2967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 17715 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 2971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 2;
															#line 2971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*>(static_cast<ReadStorageWiggleMetricsActor*>(this)));
															#line 17744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 17759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
		if (!static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV<std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>>::futures) { (void)(std::make_pair(primaryV, remoteV)); this->~ReadStorageWiggleMetricsActorState(); static_cast<ReadStorageWiggleMetricsActor*>(this)->destroy(); return 0; }
															#line 17771 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/Status.actor.g.cpp"
		new (&static_cast<ReadStorageWiggleMetricsActor*>(this)->SAV< std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>> >::value()) std::pair<Optional<StorageWiggleMetrics>, Optional<StorageWiggleMetrics>>(std::make_pair(primaryV, remoteV));
		this->~ReadStorageWiggleMetricsActorState();
		static_cast<ReadStorageWiggleMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state > 0) static_cast<ReadStorageWiggleMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadStorageWiggleMetricsActor*>(this)->ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadStorageWiggleMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadStorageWiggleMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readStorageWiggleMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	Database cx;
															#line 2953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/Status.actor.cpp"
	bool use_system_priority;
															#line 2956 "/codebuild/output/src3820056