#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
#include "fdbclient/FDBTypes.h"
#ifdef WITH_ROCKSDB

#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/SystemData.h"
#include "flow/flow.h"
#include "flow/serialize.h"
#include <rocksdb/c.h>
#include <rocksdb/cache.h>
#include <rocksdb/advanced_cache.h>
#include <rocksdb/db.h>
#include <rocksdb/filter_policy.h>
#include <rocksdb/listener.h>
#include <rocksdb/metadata.h>
#include <rocksdb/options.h>
#include <rocksdb/perf_context.h>
#include <rocksdb/rate_limiter.h>
#include <rocksdb/advanced_options.h>
#include <rocksdb/slice_transform.h>
#include <rocksdb/statistics.h>
#include <rocksdb/table.h>
#include <rocksdb/utilities/checkpoint.h>
#include <rocksdb/utilities/table_properties_collectors.h>
#include <rocksdb/version.h>
#if defined __has_include
#if __has_include(<liburing.h>)
#include <liburing.h>
#endif
#endif
#include "fdbclient/SystemData.h"
#include "fdbserver/CoroFlow.h"
#include "fdbserver/FDBRocksDBVersion.h"
#include "flow/flow.h"
#include "flow/IThreadPool.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Histogram.h"
#include "flow/UnitTest.h"

#include <memory>
#include <tuple>
#include <vector>

#endif // WITH_ROCKSDB

#include "fdbserver/Knobs.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"
#include "flow/actorcompiler.h" // has to be last include

#ifdef WITH_ROCKSDB

// Enforcing rocksdb version.
static_assert((ROCKSDB_MAJOR == FDB_ROCKSDB_MAJOR && ROCKSDB_MINOR == FDB_ROCKSDB_MINOR &&
               ROCKSDB_PATCH == FDB_ROCKSDB_PATCH),
              "Unsupported rocksdb version.");

const std::string METADATA_SHARD_ID = "kvs-metadata";
const std::string DEFAULT_CF_NAME = "default"; // `specialKeys` is stored in this culoumn family.
const std::string manifestFilePrefix = "MANIFEST-";
const KeyRef shardMappingPrefix("\xff\xff/ShardMapping/"_sr);
const KeyRef compactionTimestampPrefix("\xff\xff/CompactionTimestamp/"_sr);
// TODO: move constants to a header file.
const KeyRef persistVersion = "\xff\xffVersion"_sr;
const StringRef SHARDED_ROCKSDB_HISTOGRAM_GROUP = "ShardedRocksDB"_sr;
const StringRef ROCKSDB_COMMIT_LATENCY_HISTOGRAM = "RocksDBCommitLatency"_sr;
const StringRef ROCKSDB_WRITE_ACTION_QUEUE_WAIT_HISTOGRAM = "RocksDBWriteActionQueueWait"_sr;
const StringRef ROCKSDB_ADD_SHARD_LATENCY_HISTOGRAM = "RocksDBAddShardLatency"_sr;
const StringRef ROCKSDB_REMOVE_SHARD_LATENCY_HISTOGRAM = "RocksDBRemoveShardLatency"_sr;
const StringRef ROCKSDB_READRANGE_LATENCY_HISTOGRAM = "RocksDBReadRangeLatency"_sr;
const StringRef ROCKSDB_READVALUE_LATENCY_HISTOGRAM = "RocksDBReadValueLatency"_sr;
const StringRef ROCKSDB_READPREFIX_LATENCY_HISTOGRAM = "RocksDBReadPrefixLatency"_sr;
const StringRef ROCKSDB_ITERATOR_CREATION_TIME_HISTOGRAM = "RocksDBIteratorCreationTime"_sr;
const StringRef ROCKSDB_READ_ACTION_QUEUE_WAIT_HISTOGRAM = "RocksDBReadActionQueueWait"_sr;

// RocksDB Internal stats.
const KeyRef ROCKSDB_STATS_HISTOGRAM_GROUP = "RocksDBInternalStats"_sr;

// Flush reason code:
// https://github.com/facebook/rocksdb/blob/63a5125a5220d953bf504daf33694f038403cc7c/include/rocksdb/listener.h#L164-L181
// This function needs to be updated when flush code changes.
const int ROCKSDB_NUM_FLUSH_REASONS = 14;

namespace {
struct PhysicalShard;
struct DataShard;
struct ReadIterator;
struct ShardedRocksDBKeyValueStore;

using rocksdb::BackgroundErrorReason;
using rocksdb::CompactionReason;
using rocksdb::FlushReason;

// Returns string representation of RocksDB background error reason.
// Error reason code:
// https://github.com/facebook/rocksdb/blob/12d798ac06bcce36be703b057d5f5f4dab3b270c/include/rocksdb/listener.h#L125
// This function needs to be updated when error code changes.
std::string getErrorReason(BackgroundErrorReason reason) {
	switch (reason) {
	case BackgroundErrorReason::kFlush:
		return format("%d Flush", reason);
	case BackgroundErrorReason::kCompaction:
		return format("%d Compaction", reason);
	case BackgroundErrorReason::kWriteCallback:
		return format("%d WriteCallback", reason);
	case BackgroundErrorReason::kMemTable:
		return format("%d MemTable", reason);
	case BackgroundErrorReason::kManifestWrite:
		return format("%d ManifestWrite", reason);
	case BackgroundErrorReason::kFlushNoWAL:
		return format("%d FlushNoWAL", reason);
	case BackgroundErrorReason::kManifestWriteNoWAL:
		return format("%d ManifestWriteNoWAL", reason);
	default:
		return format("%d Unknown", reason);
	}
}

															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via forwardError()
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class ForwardErrorActor>
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ForwardErrorActorState {
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ForwardErrorActorState(Future<int> const& input) 
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : input(input)
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("forwardError", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("forwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<int> __when_expr_0 = input;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<ForwardErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorActor, 0, int >*>(static_cast<ForwardErrorActor*>(this)));
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& errorCode,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (errorCode == error_code_success)
															#line 178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			this->~ForwardErrorActorState();
															#line 182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			static_cast<ForwardErrorActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		return a_body1Catch1(Error::fromCode(errorCode), loopDepth);
															#line 188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1(int && errorCode,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (errorCode == error_code_success)
															#line 196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			this->~ForwardErrorActorState();
															#line 200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			static_cast<ForwardErrorActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		return a_body1Catch1(Error::fromCode(errorCode), loopDepth);
															#line 206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(int const& errorCode,int loopDepth) 
	{
		loopDepth = a_body1cont1(errorCode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && errorCode,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(errorCode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorActor*>(this)->ActorCallback< ForwardErrorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<int> input;
															#line 287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via forwardError()
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ForwardErrorActor final : public Actor<Void>, public ActorCallback< ForwardErrorActor, 0, int >, public FastAllocated<ForwardErrorActor>, public ForwardErrorActorState<ForwardErrorActor> {
															#line 292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<ForwardErrorActor>::operator new;
	using FastAllocated<ForwardErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12280374247496083456UL, 2230864313094601728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorActor, 0, int >;
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ForwardErrorActor(Future<int> const& input) 
															#line 309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   ForwardErrorActorState<ForwardErrorActor>(input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1301226801814355968UL, 15803518444079550976UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] Future<Void> forwardError( Future<int> const& input ) {
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new ForwardErrorActor(input));
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

int getWriteStallState(const rocksdb::WriteStallCondition& condition) {
	if (condition == rocksdb::WriteStallCondition::kDelayed)
		return 0;
	if (condition == rocksdb::WriteStallCondition::kStopped)
		return 1;
	if (condition == rocksdb::WriteStallCondition::kNormal)
		return 2;

	// unexpected.
	return 3;
}

// RocksDB's reason string contains spaces and will break trace events.
// Reference https://sourcegraph.com/github.com/facebook/rocksdb/-/blob/db/flush_job.cc?L52
const char* getFlushReasonString(FlushReason flush_reason) {
	switch (flush_reason) {
	case FlushReason::kOthers:
		return "ReasonOthers";
	case FlushReason::kGetLiveFiles:
		return "ReasonGetLiveFiles";
	case FlushReason::kShutDown:
		return "ReasonShutdown";
	case FlushReason::kExternalFileIngestion:
		return "ReasonExternalFileIngestion";
	case FlushReason::kManualCompaction:
		return "ReasonManualCompaction";
	case FlushReason::kWriteBufferManager:
		return "ReasonWriteBufferManager";
	case FlushReason::kWriteBufferFull:
		return "ReasonWriteBufferFull";
	case FlushReason::kTest:
		return "ReasonTest";
	case FlushReason::kDeleteFiles:
		return "ReasonDeleteFiles";
	case FlushReason::kAutoCompaction:
		return "ReasonAutoCompaction";
	case FlushReason::kManualFlush:
		return "ReasonManualFlush";
	case FlushReason::kErrorRecovery:
		return "ReasonErrorRecovery";
	case FlushReason::kErrorRecoveryRetryFlush:
		return "ReasonErrorRecoveryRetryFlush";
	case FlushReason::kWalFull:
		return "ReasonWALFull";
	case FlushReason::kCatchUpAfterErrorRecovery:
		return "ReasonCatchUpAfterErrorRecovery";
	default:
		return "ReasonInvalid";
	}
}

class RocksDBEventListener : public rocksdb::EventListener {
public:
	RocksDBEventListener(UID id)
	  : logId(id), compactionReasons((int)CompactionReason::kNumOfReasons), flushReasons(ROCKSDB_NUM_FLUSH_REASONS),
	    numRangeDeletionsInTableFile(Histogram::getHistogram(ROCKSDB_STATS_HISTOGRAM_GROUP,
	                                                         "NumRangeDeletionsInTableFile"_sr,
	                                                         Histogram::Unit::bytes)),
	    numPointDeletionsInTableFile(Histogram::getHistogram(ROCKSDB_STATS_HISTOGRAM_GROUP,
	                                                         "NumPointDeletionsInTableFile"_sr,
	                                                         Histogram::Unit::bytes)),
	    numEntriesInTableFile(
	        Histogram::getHistogram(ROCKSDB_STATS_HISTOGRAM_GROUP, "NumEntriesInTableFile"_sr, Histogram::Unit::bytes)),
	    lastResetTime(now()) {}

	void OnStallConditionsChanged(const rocksdb::WriteStallInfo& info) override {
		auto curState = getWriteStallState(info.condition.cur);
		auto prevState = getWriteStallState(info.condition.prev);
		if (curState == 1) {
			TraceEvent(SevWarn, "WriteStallInfo", logId)
			    .detail("CF", info.cf_name)
			    .detail("CurrentState", curState)
			    .detail("PrevState", prevState);
		}
	}

	void OnFlushBegin(rocksdb::DB* db, const rocksdb::FlushJobInfo& info) override {
		flushTotal++;
		auto index = (int)info.flush_reason;
		if (index >= ROCKSDB_NUM_FLUSH_REASONS) {
			TraceEvent(SevWarn, "UnknownRocksDBFlushReason", logId)
			    .suppressFor(5.0)
			    .detail("Reason", static_cast<int>(info.flush_reason));
			return;
		}

		flushReasons[index]++;
	}

	void OnCompactionBegin(rocksdb::DB* db, const rocksdb::CompactionJobInfo& info) override {
		compactionTotal++;
		auto index = (int)info.compaction_reason;
		if (index >= (int)CompactionReason::kNumOfReasons) {
			TraceEvent(SevWarn, "UnknownRocksDBCompactionReason", logId)
			    .suppressFor(5.0)
			    .detail("Reason", static_cast<int>(info.compaction_reason));
			return;
		}
		compactionReasons[index]++;
	}

	void OnTableFileCreated(const rocksdb::TableFileCreationInfo& info) override {
		numRangeDeletionsInTableFile->sample(info.table_properties.num_range_deletions);
		numPointDeletionsInTableFile->sample(info.table_properties.num_deletions);
		numEntriesInTableFile->sample(info.table_properties.num_entries);
	}

	void logRecentRocksDBBackgroundWorkStats(UID ssId, std::string logReason = "PeriodicLog") {
		int flushCount = flushTotal.load(std::memory_order_relaxed);
		int compactionCount = compactionTotal.load(std::memory_order_relaxed);
		if (flushCount > 0) {
			TraceEvent e(SevInfo, "RocksDBFlushStats", logId);
			e.setMaxEventLength(20000);
			e.detail("LogReason", logReason);
			e.detail("StorageServerID", ssId);
			e.detail("DurationSeconds", now() - lastResetTime);
			e.detail("FlushCountTotal", flushCount);
			for (int i = 0; i < ROCKSDB_NUM_FLUSH_REASONS; ++i) {
				e.detail(getFlushReasonString((rocksdb::FlushReason)i), flushReasons[i]);
			}
		}
		if (compactionCount > 0) {
			TraceEvent e(SevInfo, "RocksDBCompactionStats", logId);
			e.setMaxEventLength(20000);
			e.detail("LogReason", logReason);
			e.detail("StorageServerID", ssId);
			e.detail("DurationSeconds", now() - lastResetTime);
			e.detail("CompactionTotal", compactionCount);
			for (int i = 0; i < (int)CompactionReason::kNumOfReasons; ++i) {
				e.detail(rocksdb::GetCompactionReasonString((rocksdb::CompactionReason)i), compactionReasons[i]);
			}
		}
		return;
	}

	void resetCounters() {
		flushTotal.store(0, std::memory_order_relaxed);
		compactionTotal.store(0, std::memory_order_relaxed);

		for (auto& flushCounter : flushReasons) {
			flushCounter.store(0, std::memory_order_relaxed);
		}

		for (auto& compactionCounter : compactionReasons) {
			compactionCounter.store(0, std::memory_order_relaxed);
		}
		lastResetTime = now();
	}

private:
	UID logId;

	std::vector<std::atomic_int> flushReasons;
	std::vector<std::atomic_int> compactionReasons;
	std::atomic_int flushTotal;
	std::atomic_int compactionTotal;

	// Histograms.
	Reference<Histogram> numRangeDeletionsInTableFile;
	Reference<Histogram> numPointDeletionsInTableFile;
	Reference<Histogram> numEntriesInTableFile;

	double lastResetTime;
};

// Background error handling is tested with Chaos test.
// TODO: Test background error in simulation. RocksDB doesn't use flow IO in simulation, which limits our ability to
// inject IO errors. We could implement rocksdb::FileSystem using flow IO to unblock simulation. Also, trace event is
// not available on background threads because trace event requires setting up special thread locals. Using trace event
// could potentially cause segmentation fault.
class RocksDBErrorListener : public rocksdb::EventListener {
public:
	RocksDBErrorListener() {};
	void OnBackgroundError(rocksdb::BackgroundErrorReason reason, rocksdb::Status* bg_error) override {
		if (!bg_error)
			return;
		TraceEvent(SevError, "ShardedRocksDBBGError")
		    .detail("Reason", getErrorReason(reason))
		    .detail("ShardedRocksDBSeverity", bg_error->severity())
		    .detail("Status", bg_error->ToString());

		std::unique_lock<std::mutex> lock(mutex);
		if (!errorPromise.isValid())
			return;
		// RocksDB generates two types of background errors, IO Error and Corruption
		// Error type and severity map could be found at
		// https://github.com/facebook/rocksdb/blob/2e09a54c4fb82e88bcaa3e7cfa8ccbbbbf3635d5/db/error_handler.cc#L138.
		// All background errors will be treated as storage engine failure. Send the error to storage server.
		if (bg_error->IsIOError()) {
			errorPromise.send(error_code_io_error);
		} else if (bg_error->IsCorruption()) {
			errorPromise.send(error_code_file_corrupt);
		} else {
			errorPromise.send(error_code_unknown_error);
		}
	}
	Future<int> getFuture() {
		std::unique_lock<std::mutex> lock(mutex);
		return errorPromise.getFuture();
	}
	~RocksDBErrorListener() {
		std::unique_lock<std::mutex> lock(mutex);
		if (!errorPromise.isValid())
			return;
		errorPromise.send(error_code_success);
	}

private:
	ThreadReturnPromise<int> errorPromise;
	std::mutex mutex;
};

// Collects range deletion count during table file creation. Marks table file for compaction if range deletion count
// exceeds threshold.
class CompactOnRangeDeletionCollector : public rocksdb::TablePropertiesCollector {
public:
	CompactOnRangeDeletionCollector(uint64_t numRangeDeletionsAllowed, std::atomic_uint* numFilesMarkedForCompaction)
	  : threshold(numRangeDeletionsAllowed), numFilesMarkedForCompaction(numFilesMarkedForCompaction) {
		ASSERT(numFilesMarkedForCompaction);
	}

	// AddUserKey() will be called when a new key/value pair is inserted into the
	// table.
	// @params key    the user key that is inserted into the table.
	// @params value  the value that is inserted into the table.
	// @params file_size  file size up to now
	// TODO: Consider collecting point deletion info.
	rocksdb::Status AddUserKey(const rocksdb::Slice& key,
	                           const rocksdb::Slice& value,
	                           rocksdb::EntryType type,
	                           rocksdb::SequenceNumber seq,
	                           uint64_t file_size) override {
		if (type == rocksdb::EntryType::kEntryRangeDeletion) {
			++numRangeDeletions;
		}
		return rocksdb::Status::OK();
	}

	// Finish() will be called when a table has already been built and is ready for writing the properties block.
	// @params properties  User will add their collected statistics to
	// `properties`.
	// Number of range deletion is included in rocksdb's table properties. No need to add a custom entry.
	rocksdb::Status Finish(rocksdb::UserCollectedProperties* /*properties*/) override {
		if (numRangeDeletions > threshold) {
			++(*numFilesMarkedForCompaction);
		}
		return rocksdb::Status::OK();
	};

	// Return the human-readable properties, where the key is property name and
	// the value is the human-readable form of value. No additional properties needed
	// for this collector.
	rocksdb::UserCollectedProperties GetReadableProperties() const override {
		return rocksdb::UserCollectedProperties();
	}

	// The name of the properties collector can be used for debugging purpose.
	const char* Name() const override { return "CompactOnRangeDeletionCollector"; }

	// EXPERIMENTAL Return whether the output file should be further compacted based on the threshold.
	bool NeedCompact() const override { return threshold > 0 && numRangeDeletions > threshold; }

private:
	uint64_t threshold = 0;
	uint64_t numRangeDeletions = 0;
	std::atomic_uint* numFilesMarkedForCompaction;
};

class CompactOnRangeDeletionCollectorFactory : public rocksdb::TablePropertiesCollectorFactory {
public:
	// A factory of a table property collector that marks a SST file as need-compaction when the number of range
	// deletions exceeds the threshold.
	// @param numRangeDeletionsAllowed,  triggers compaction range deletion count exceeds numRangeDeletionsAllowed.
	CompactOnRangeDeletionCollectorFactory(uint64_t numRangeDeletionsAllowed)
	  : threshold(numRangeDeletionsAllowed), numFilesMarkedForCompaction(0) {}

	~CompactOnRangeDeletionCollectorFactory() {}

	rocksdb::TablePropertiesCollector* CreateTablePropertiesCollector(
	    rocksdb::TablePropertiesCollectorFactory::Context context) override {
		return new CompactOnRangeDeletionCollector(threshold, &numFilesMarkedForCompaction);
	}

	uint getNumFilesMarkedForCompaction() { return numFilesMarkedForCompaction; }

	static const char* kClassName() { return "CompactOnRangeDeletionCollectorFactory"; }
	const char* Name() const override { return kClassName(); }

	std::string ToString() const override {
		return "CompactOnRangeDeletionCollectorFactory: " + std::to_string(threshold);
	}

	void logMetrics(bool reset) {
		TraceEvent("CompactOnRangeDeletionMetrics")
		    .detail("NumFilesMarkedForCompaction", numFilesMarkedForCompaction)
		    .detail("Threshold", threshold);
		if (reset) {
			numFilesMarkedForCompaction = 0;
		}
	}

private:
	const uint64_t threshold;
	std::atomic_uint numFilesMarkedForCompaction;
};
struct Counters {
	CounterCollection cc;
	Counter immediateThrottle;
	Counter failedToAcquire;
	Counter convertedRangeDeletions;

	Counters()
	  : cc("RocksDBCounters"), immediateThrottle("ImmediateThrottle", cc), failedToAcquire("FailedToAcquire", cc),
	    convertedRangeDeletions("ConvertedRangeDeletions", cc) {}
};

rocksdb::CompactionPri getCompactionPriority() {
	switch (SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_PRI) {
	case 0:
		return rocksdb::CompactionPri::kByCompensatedSize;
	case 1:
		return rocksdb::CompactionPri::kOldestLargestSeqFirst;
	case 2:
		return rocksdb::CompactionPri::kOldestSmallestSeqFirst;
	case 3:
		return rocksdb::CompactionPri::kMinOverlappingRatio;
	case 4:
		return rocksdb::CompactionPri::kRoundRobin;
	default:
		TraceEvent(SevWarn, "InvalidCompactionPriority")
		    .detail("KnobValue", SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_PRI);
		return rocksdb::CompactionPri::kMinOverlappingRatio;
	}
}

rocksdb::WALRecoveryMode getWalRecoveryMode() {
	switch (SERVER_KNOBS->ROCKSDB_WAL_RECOVERY_MODE) {
	case 0:
		return rocksdb::WALRecoveryMode::kTolerateCorruptedTailRecords;
	case 1:
		return rocksdb::WALRecoveryMode::kAbsoluteConsistency;
	case 2:
		return rocksdb::WALRecoveryMode::kPointInTimeRecovery;
	case 3:
		return rocksdb::WALRecoveryMode::kSkipAnyCorruptedRecords;
	default:
		TraceEvent(SevWarn, "InvalidWalRecoveryMode").detail("KnobValue", SERVER_KNOBS->ROCKSDB_WAL_RECOVERY_MODE);
		return rocksdb::WALRecoveryMode::kPointInTimeRecovery;
	}
}

// Encapsulation of shared states.
struct ShardedRocksDBState {
	bool closing = false;
	Counters counters;
	std::shared_ptr<rocksdb::Cache> blockCache = nullptr;
	std::shared_ptr<CompactOnRangeDeletionCollectorFactory> compactOnRangeDeletionFactory = nullptr;

	ShardedRocksDBState() {
		if (SERVER_KNOBS->SHARDED_ROCKSDB_BLOCK_CACHE_SIZE > 0) {
			blockCache =
			    rocksdb::NewLRUCache(SERVER_KNOBS->SHARDED_ROCKSDB_BLOCK_CACHE_SIZE,
			                         -1, /* num_shard_bits, default value:-1*/
			                         false, /* strict_capacity_limit, default value:false */
			                         SERVER_KNOBS->SHARDED_ROCKSDB_CACHE_HIGH_PRI_POOL_RATIO /* high_pri_pool_ratio */);
		}
		if (SERVER_KNOBS->SHARDED_ROCKSDB_COMPACT_ON_RANGE_DELETION_THRESHOLD > 0) {
			compactOnRangeDeletionFactory = std::make_shared<CompactOnRangeDeletionCollectorFactory>(
			    SERVER_KNOBS->SHARDED_ROCKSDB_COMPACT_ON_RANGE_DELETION_THRESHOLD);
		}
	}

	rocksdb::ColumnFamilyOptions getCFOptions() {
		rocksdb::ColumnFamilyOptions options;

		if (SERVER_KNOBS->ROCKSDB_LEVEL_COMPACTION_DYNAMIC_LEVEL_BYTES) {
			options.level_compaction_dynamic_level_bytes = SERVER_KNOBS->ROCKSDB_LEVEL_COMPACTION_DYNAMIC_LEVEL_BYTES;
			options.OptimizeLevelStyleCompaction(SERVER_KNOBS->SHARDED_ROCKSDB_MEMTABLE_BUDGET);
		}
		options.write_buffer_size = SERVER_KNOBS->SHARDED_ROCKSDB_WRITE_BUFFER_SIZE;
		options.max_write_buffer_number = SERVER_KNOBS->SHARDED_ROCKSDB_MAX_WRITE_BUFFER_NUMBER;
		options.target_file_size_base = SERVER_KNOBS->SHARDED_ROCKSDB_TARGET_FILE_SIZE_BASE;
		options.target_file_size_multiplier = SERVER_KNOBS->SHARDED_ROCKSDB_TARGET_FILE_SIZE_MULTIPLIER;

		if (SERVER_KNOBS->ROCKSDB_PERIODIC_COMPACTION_SECONDS > 0) {
			options.periodic_compaction_seconds = SERVER_KNOBS->ROCKSDB_PERIODIC_COMPACTION_SECONDS;
		}

		options.disable_auto_compactions = SERVER_KNOBS->ROCKSDB_DISABLE_AUTO_COMPACTIONS;
		options.memtable_protection_bytes_per_key = SERVER_KNOBS->ROCKSDB_MEMTABLE_PROTECTION_BYTES_PER_KEY;
		options.block_protection_bytes_per_key = SERVER_KNOBS->ROCKSDB_BLOCK_PROTECTION_BYTES_PER_KEY;
		options.paranoid_file_checks = SERVER_KNOBS->ROCKSDB_PARANOID_FILE_CHECKS;
		options.memtable_max_range_deletions = SERVER_KNOBS->SHARDED_ROCKSDB_MEMTABLE_MAX_RANGE_DELETIONS;
		if (SERVER_KNOBS->SHARD_SOFT_PENDING_COMPACT_BYTES_LIMIT > 0) {
			options.soft_pending_compaction_bytes_limit = SERVER_KNOBS->SHARD_SOFT_PENDING_COMPACT_BYTES_LIMIT;
		}
		if (SERVER_KNOBS->SHARD_HARD_PENDING_COMPACT_BYTES_LIMIT > 0) {
			options.hard_pending_compaction_bytes_limit = SERVER_KNOBS->SHARD_HARD_PENDING_COMPACT_BYTES_LIMIT;
		}

		if (compactOnRangeDeletionFactory) {
			options.table_properties_collector_factories.emplace_back(compactOnRangeDeletionFactory);
		}

		// Compact sstables when there's too much deleted stuff.
		if (SERVER_KNOBS->ROCKSDB_ENABLE_COMPACT_ON_DELETION) {
			// Creates a factory of a table property collector that marks a SST
			// file as need-compaction when it observe at least "D" deletion
			// entries in any "N" consecutive entries, or the ratio of tombstone
			// entries >= deletion_ratio.

			// @param sliding_window_size "N". Note that this number will be
			//     round up to the smallest multiple of 128 that is no less
			//     than the specified size.
			// @param deletion_trigger "D".  Note that even when "N" is changed,
			//     the specified number for "D" will not be changed.
			// @param deletion_ratio, if <= 0 or > 1, disable triggering compaction
			//     based on deletion ratio. Disabled by default.
			options.table_properties_collector_factories.emplace_back(
			    rocksdb::NewCompactOnDeletionCollectorFactory(SERVER_KNOBS->ROCKSDB_CDCF_SLIDING_WINDOW_SIZE,
			                                                  SERVER_KNOBS->ROCKSDB_CDCF_DELETION_TRIGGER,
			                                                  SERVER_KNOBS->ROCKSDB_CDCF_DELETION_RATIO));
		}

		rocksdb::BlockBasedTableOptions bbOpts;
		if (SERVER_KNOBS->SHARDED_ROCKSDB_PREFIX_LEN > 0) {
			// Prefix blooms are used during Seek.
			options.prefix_extractor.reset(rocksdb::NewFixedPrefixTransform(SERVER_KNOBS->SHARDED_ROCKSDB_PREFIX_LEN));

			// Also turn on bloom filters in the memtable.
			options.memtable_prefix_bloom_size_ratio = SERVER_KNOBS->SHARDED_ROCKSDB_MEMTABLE_BLOOM_FILTER_RATIO;

			// 5 -- Can be read by RocksDB's versions since 6.6.0. Full and partitioned
			// filters use a generally faster and more accurate Bloom filter
			// implementation, with a different schema.
			// https://github.com/facebook/rocksdb/blob/b77569f18bfc77fb1d8a0b3218f6ecf571bc4988/include/rocksdb/table.h#L391
			bbOpts.format_version = 5;

			// Create and apply a bloom filter using the 10 bits
			// which should yield a ~1% false positive rate:
			// https://github.com/facebook/rocksdb/wiki/RocksDB-Bloom-Filter#full-filters-new-format
			bbOpts.filter_policy.reset(rocksdb::NewBloomFilterPolicy(SERVER_KNOBS->SHARDED_ROCKSDB_BLOOM_FILTER_BITS));

			// The whole key blooms are only used for point lookups.
			// https://github.com/facebook/rocksdb/wiki/RocksDB-Bloom-Filter#prefix-vs-whole-key
			bbOpts.whole_key_filtering = false;
		}

		options.level0_file_num_compaction_trigger = SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_FILENUM_COMPACTION_TRIGGER;
		options.level0_slowdown_writes_trigger = SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_SLOWDOWN_WRITES_TRIGGER;
		options.level0_stop_writes_trigger = SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_STOP_WRITES_TRIGGER;

		bbOpts.cache_index_and_filter_blocks = SERVER_KNOBS->SHARDED_ROCKSDB_CACHE_INDEX_AND_FILTER_BLOCKS;
		bbOpts.pin_l0_filter_and_index_blocks_in_cache = SERVER_KNOBS->SHARDED_ROCKSDB_CACHE_INDEX_AND_FILTER_BLOCKS;
		bbOpts.cache_index_and_filter_blocks_with_high_priority =
		    SERVER_KNOBS->SHARDED_ROCKSDB_CACHE_INDEX_AND_FILTER_BLOCKS;
		bbOpts.block_cache = blockCache;

		options.table_factory.reset(rocksdb::NewBlockBasedTableFactory(bbOpts));

		options.compaction_pri = getCompactionPriority();

		return options;
	}

	rocksdb::ColumnFamilyOptions getCFOptionsForInactiveShard() {
		auto options = getCFOptions();
		// never slowdown ingest.
		options.level0_file_num_compaction_trigger = (1 << 30);
		options.level0_slowdown_writes_trigger = (1 << 30);
		options.level0_stop_writes_trigger = (1 << 30);
		options.soft_pending_compaction_bytes_limit = 0;
		options.hard_pending_compaction_bytes_limit = 0;

		// no auto compactions please. The application should issue a
		// manual compaction after all data is loaded into L0.
		options.disable_auto_compactions = true;
		// A manual compaction run should pick all files in L0 in
		// a single compaction run.
		options.max_compaction_bytes = (static_cast<uint64_t>(1) << 60);

		// It is better to have only 2 levels, otherwise a manual
		// compaction would compact at every possible level, thereby
		// increasing the total time needed for compactions.
		options.num_levels = 2;

		return options;
	}
};

rocksdb::ExportImportFilesMetaData getMetaData(const CheckpointMetaData& checkpoint) {
	rocksdb::ExportImportFilesMetaData metaData;
	if (checkpoint.getFormat() != DataMoveRocksCF) {
		return metaData;
	}

	RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
	metaData.db_comparator_name = rocksCF.dbComparatorName;

	for (const LiveFileMetaData& fileMetaData : rocksCF.sstFiles) {
		rocksdb::LiveFileMetaData liveFileMetaData;
		liveFileMetaData.relative_filename = fileMetaData.relative_filename;
		liveFileMetaData.directory = fileMetaData.directory;
		liveFileMetaData.file_number = fileMetaData.file_number;
		liveFileMetaData.file_type = static_cast<rocksdb::FileType>(fileMetaData.file_type);
		liveFileMetaData.size = fileMetaData.size;
		liveFileMetaData.temperature = static_cast<rocksdb::Temperature>(fileMetaData.temperature);
		liveFileMetaData.file_checksum = fileMetaData.file_checksum;
		liveFileMetaData.file_checksum_func_name = fileMetaData.file_checksum_func_name;
		liveFileMetaData.smallest_seqno = fileMetaData.smallest_seqno;
		liveFileMetaData.largest_seqno = fileMetaData.largest_seqno;
		liveFileMetaData.smallestkey = fileMetaData.smallestkey;
		liveFileMetaData.largestkey = fileMetaData.largestkey;
		liveFileMetaData.num_reads_sampled = fileMetaData.num_reads_sampled;
		liveFileMetaData.being_compacted = fileMetaData.being_compacted;
		liveFileMetaData.num_entries = fileMetaData.num_entries;
		liveFileMetaData.num_deletions = fileMetaData.num_deletions;
		liveFileMetaData.oldest_blob_file_number = fileMetaData.oldest_blob_file_number;
		liveFileMetaData.oldest_ancester_time = fileMetaData.oldest_ancester_time;
		liveFileMetaData.file_creation_time = fileMetaData.file_creation_time;
		liveFileMetaData.smallest = fileMetaData.smallest;
		liveFileMetaData.largest = fileMetaData.largest;
		liveFileMetaData.file_type = rocksdb::kTableFile;
		liveFileMetaData.epoch_number = fileMetaData.epoch_number;
		liveFileMetaData.name = fileMetaData.name;
		liveFileMetaData.db_path = fileMetaData.db_path;
		liveFileMetaData.column_family_name = fileMetaData.column_family_name;
		liveFileMetaData.level = fileMetaData.level;
		metaData.files.push_back(liveFileMetaData);
	}

	return metaData;
}

void populateMetaData(CheckpointMetaData* checkpoint, const rocksdb::ExportImportFilesMetaData* metaData) {
	RocksDBColumnFamilyCheckpoint rocksCF;
	if (metaData != nullptr) {
		rocksCF.dbComparatorName = metaData->db_comparator_name;
		for (const rocksdb::LiveFileMetaData& fileMetaData : metaData->files) {
			LiveFileMetaData liveFileMetaData;
			liveFileMetaData.relative_filename = fileMetaData.relative_filename;
			liveFileMetaData.directory = fileMetaData.directory;
			liveFileMetaData.file_number = fileMetaData.file_number;
			liveFileMetaData.file_type = static_cast<int>(fileMetaData.file_type);
			liveFileMetaData.size = fileMetaData.size;
			liveFileMetaData.temperature = static_cast<uint8_t>(fileMetaData.temperature);
			liveFileMetaData.file_checksum = fileMetaData.file_checksum;
			liveFileMetaData.file_checksum_func_name = fileMetaData.file_checksum_func_name;
			liveFileMetaData.smallest_seqno = fileMetaData.smallest_seqno;
			liveFileMetaData.largest_seqno = fileMetaData.largest_seqno;
			liveFileMetaData.smallestkey = fileMetaData.smallestkey;
			liveFileMetaData.largestkey = fileMetaData.largestkey;
			liveFileMetaData.num_reads_sampled = fileMetaData.num_reads_sampled;
			liveFileMetaData.being_compacted = fileMetaData.being_compacted;
			liveFileMetaData.num_entries = fileMetaData.num_entries;
			liveFileMetaData.num_deletions = fileMetaData.num_deletions;
			liveFileMetaData.oldest_blob_file_number = fileMetaData.oldest_blob_file_number;
			liveFileMetaData.oldest_ancester_time = fileMetaData.oldest_ancester_time;
			liveFileMetaData.file_creation_time = fileMetaData.file_creation_time;
			liveFileMetaData.smallest = fileMetaData.smallest;
			liveFileMetaData.largest = fileMetaData.largest;
			liveFileMetaData.epoch_number = fileMetaData.epoch_number;
			liveFileMetaData.name = fileMetaData.name;
			liveFileMetaData.db_path = fileMetaData.db_path;
			liveFileMetaData.column_family_name = fileMetaData.column_family_name;
			liveFileMetaData.level = fileMetaData.level;
			rocksCF.sstFiles.push_back(liveFileMetaData);
		}
	}
	checkpoint->setFormat(DataMoveRocksCF);
	checkpoint->serializedCheckpoint = ObjectWriter::toValue(rocksCF, IncludeVersion());
}

const rocksdb::Slice toSlice(StringRef s) {
	return rocksdb::Slice(reinterpret_cast<const char*>(s.begin()), s.size());
}

StringRef toStringRef(rocksdb::Slice s) {
	return StringRef(reinterpret_cast<const uint8_t*>(s.data()), s.size());
}

std::string getShardMappingKey(KeyRef key, StringRef prefix) {
	return prefix.toString() + key.toString();
}

void logRocksDBError(const rocksdb::Status& status, const std::string& method) {
	auto level = status.IsTimedOut() ? SevWarn : SevError;
	TraceEvent e(level, "ShardedRocksDBError");
	e.setMaxFieldLength(10000)
	    .detail("Error", status.ToString())
	    .detail("Method", method)
	    .detail("ShardedRocksDBSeverity", status.severity());
	if (status.IsIOError()) {
		e.detail("SubCode", status.subcode());
	}
}

// TODO: define shard ops.
enum class ShardOp {
	CREATE,
	OPEN,
	DESTROY,
	CLOSE,
	MODIFY_RANGE,
};

const char* ShardOpToString(ShardOp op) {
	switch (op) {
	case ShardOp::CREATE:
		return "CREATE";
	case ShardOp::OPEN:
		return "OPEN";
	case ShardOp::DESTROY:
		return "DESTROY";
	case ShardOp::CLOSE:
		return "CLOSE";
	case ShardOp::MODIFY_RANGE:
		return "MODIFY_RANGE";
	default:
		return "Unknown";
	}
}
void logShardEvent(StringRef name, ShardOp op, Severity severity = SevInfo, const std::string& message = "") {
	TraceEvent e(severity, "ShardedRocksDBKVSShardEvent");
	e.detail("ShardId", name).detail("Action", ShardOpToString(op));
	if (!message.empty()) {
		e.detail("Message", message);
	}
}
void logShardEvent(StringRef name,
                   KeyRangeRef range,
                   ShardOp op,
                   Severity severity = SevInfo,
                   const std::string& message = "") {
	TraceEvent e(severity, "ShardedRocksDBKVSShardEvent");
	e.detail("ShardId", name)
	    .detail("Action", ShardOpToString(op))
	    .detail("Begin", range.begin)
	    .detail("End", range.end);
	if (message != "") {
		e.detail("Message", message);
	}
}

Error statusToError(const rocksdb::Status& s) {
	if (s.IsIOError()) {
		return io_error();
	} else if (s.IsTimedOut()) {
		return key_value_store_deadline_exceeded();
	} else {
		return unknown_error();
	}
}

rocksdb::DBOptions getOptions() {
	rocksdb::DBOptions options;
	options.avoid_unnecessary_blocking_io = true;
	options.create_if_missing = true;
	options.atomic_flush = SERVER_KNOBS->ROCKSDB_ATOMIC_FLUSH;
	options.use_direct_io_for_flush_and_compaction = SERVER_KNOBS->SHARDED_ROCKSDB_USE_DIRECT_IO;
	if (SERVER_KNOBS->SHARDED_ROCKSDB_BACKGROUND_PARALLELISM > 0) {
		options.IncreaseParallelism(SERVER_KNOBS->SHARDED_ROCKSDB_BACKGROUND_PARALLELISM);
	}

	options.wal_recovery_mode = getWalRecoveryMode();
	options.max_open_files = SERVER_KNOBS->SHARDED_ROCKSDB_MAX_OPEN_FILES;
	options.delete_obsolete_files_period_micros = SERVER_KNOBS->ROCKSDB_DELETE_OBSOLETE_FILE_PERIOD * 1000000;
	options.max_total_wal_size = SERVER_KNOBS->ROCKSDB_MAX_TOTAL_WAL_SIZE;
	options.max_subcompactions = SERVER_KNOBS->SHARDED_ROCKSDB_MAX_SUBCOMPACTIONS;
	options.max_background_jobs = SERVER_KNOBS->SHARDED_ROCKSDB_MAX_BACKGROUND_JOBS;

	// The following two fields affect how archived logs will be deleted.
	// 1. If both set to 0, logs will be deleted asap and will not get into
	//    the archive.
	// 2. If WAL_ttl_seconds is 0 and WAL_size_limit_MB is not 0,
	//    WAL files will be checked every 10 min and if total size is greater
	//    then WAL_size_limit_MB, they will be deleted starting with the
	//    earliest until size_limit is met. All empty files will be deleted.
	// 3. If WAL_ttl_seconds is not 0 and WAL_size_limit_MB is 0, then
	//    WAL files will be checked every WAL_ttl_seconds / 2 and those that
	//    are older than WAL_ttl_seconds will be deleted.
	// 4. If both are not 0, WAL files will be checked every 10 min and both
	//    checks will be performed with ttl being first.
	options.WAL_ttl_seconds = SERVER_KNOBS->ROCKSDB_WAL_TTL_SECONDS;
	options.WAL_size_limit_MB = SERVER_KNOBS->ROCKSDB_WAL_SIZE_LIMIT_MB;

	options.db_write_buffer_size = SERVER_KNOBS->SHARDED_ROCKSDB_TOTAL_WRITE_BUFFER_SIZE;
	options.statistics = rocksdb::CreateDBStatistics();
	options.statistics->set_stats_level(rocksdb::kExceptHistogramOrTimers);
	options.db_log_dir = g_network->isSimulated() ? "" : SERVER_KNOBS->LOG_DIRECTORY;
	if (SERVER_KNOBS->ROCKSDB_LOG_LEVEL_DEBUG) {
		options.info_log_level = rocksdb::InfoLogLevel::DEBUG_LEVEL;
	}
	options.max_log_file_size = SERVER_KNOBS->ROCKSDB_MAX_LOG_FILE_SIZE;
	options.keep_log_file_num = SERVER_KNOBS->ROCKSDB_KEEP_LOG_FILE_NUM;

	options.skip_stats_update_on_db_open = SERVER_KNOBS->ROCKSDB_SKIP_STATS_UPDATE_ON_OPEN;
	options.skip_checking_sst_file_sizes_on_db_open = SERVER_KNOBS->ROCKSDB_SKIP_FILE_SIZE_CHECK_ON_OPEN;
	options.max_manifest_file_size = SERVER_KNOBS->ROCKSDB_MAX_MANIFEST_FILE_SIZE;

	if (SERVER_KNOBS->ROCKSDB_FULLFILE_CHECKSUM) {
		// We want this sst level checksum for many scenarios, such as compaction, backup, and physicalshardmove
		// https://github.com/facebook/rocksdb/wiki/Full-File-Checksum-and-Checksum-Handoff
		options.file_checksum_gen_factory = rocksdb::GetFileChecksumGenCrc32cFactory();
	}
	return options;
}

// Set some useful defaults desired for all reads.
rocksdb::ReadOptions getReadOptions() {
	rocksdb::ReadOptions options;
	options.background_purge_on_iterator_cleanup = true;
	options.auto_prefix_mode = (SERVER_KNOBS->SHARDED_ROCKSDB_PREFIX_LEN > 0);
	options.async_io = SERVER_KNOBS->SHARDED_ROCKSDB_READ_ASYNC_IO;
	return options;
}

struct ReadIterator {
	std::unique_ptr<rocksdb::Iterator> iter;
	double creationTime;
	KeyRange keyRange;
	std::unique_ptr<rocksdb::Slice> beginSlice, endSlice;

	ReadIterator(rocksdb::ColumnFamilyHandle* cf, rocksdb::DB* db)
	  : creationTime(now()), iter(db->NewIterator(getReadOptions(), cf)) {}

	ReadIterator(rocksdb::ColumnFamilyHandle* cf, rocksdb::DB* db, const KeyRange& range)
	  : creationTime(now()), keyRange(range) {
		auto options = getReadOptions();
		beginSlice = std::unique_ptr<rocksdb::Slice>(new rocksdb::Slice(toSlice(keyRange.begin)));
		options.iterate_lower_bound = beginSlice.get();
		endSlice = std::unique_ptr<rocksdb::Slice>(new rocksdb::Slice(toSlice(keyRange.end)));
		options.iterate_upper_bound = endSlice.get();
		iter = std::unique_ptr<rocksdb::Iterator>(db->NewIterator(options, cf));
	}
};

// Stores iterators for all shards for future reuse. One iterator is stored per shard.
class IteratorPool {
public:
	IteratorPool() {}

	std::shared_ptr<ReadIterator> getIterator(const std::string& id) {
		std::unique_lock<std::mutex> lock(mu);
		auto it = pool.find(id);
		if (it == pool.end()) {
			++numNewIterators;
			return nullptr;
		} else {
			auto ret = it->second;
			pool.erase(it);
			++numReusedIters;
			return ret;
		}
	}

	void returnIterator(const std::string& id, std::shared_ptr<ReadIterator> iterator) {
		ASSERT(iterator != nullptr);
		std::unique_lock<std::mutex> lock(mu);
		auto it = pool.find(id);
		if (it != pool.end()) {
			// An iterator already exist in the pool, replace it any way.
			++numReplacedIters;
		}
		pool[id] = iterator;
	}

	void refresh() {
		std::unique_lock<std::mutex> lock(mu);
		auto poolSize = pool.size();
		auto it = pool.begin();
		auto currTime = now();
		int refreshedIterCount = 0;
		while (it != pool.end()) {
			if (currTime - it->second->creationTime > SERVER_KNOBS->ROCKSDB_READ_RANGE_ITERATOR_REFRESH_TIME) {
				it = pool.erase(it);
				++refreshedIterCount;
			} else {
				++it;
			}
		}
		TraceEvent("RefreshIterators")
		    .suppressFor(5.0)
		    .detail("NumReplacedIterators", numReplacedIters)
		    .detail("NumReusedIterators", numReusedIters)
		    .detail("NumNewIterators", numNewIterators)
		    .detail("PoolSize", poolSize)
		    .detail("RefreshedIterators", refreshedIterCount);
		numReplacedIters = 0;
		numReusedIters = 0;
		numNewIterators = 0;
	}

	void clear() {
		std::unique_lock<std::mutex> lock(mu);
		pool.clear();
	}

	void update(const std::string& id) {
		std::unique_lock<std::mutex> lock(mu);
		auto it = pool.find(id);
		if (it != pool.end()) {
			it->second->iter->Refresh();
		}
	}

	void erase(const std::string& id) {
		std::unique_lock<std::mutex> lock(mu);
		pool.erase(id);
	}

private:
	std::mutex mu;
	std::unordered_map<std::string, std::shared_ptr<ReadIterator>> pool;
	uint64_t numReplacedIters = 0;
	uint64_t numReusedIters = 0;
	uint64_t numNewIterators = 0;
};

															#line 1165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowLockLogger()
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowLockLoggerActor>
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowLockLoggerActorState {
															#line 1171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLockLoggerActorState(const FlowLock* const& readLock,const FlowLock* const& fetchLock) 
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : readLock(readLock),
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   fetchLock(fetchLock)
															#line 1180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowLockLogger", reinterpret_cast<unsigned long>(this));

	}
	~FlowLockLoggerActorState() 
	{
		fdb_probe_actor_destroy("flowLockLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			;
															#line 1195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowLockLoggerActorState();
		static_cast<FlowLockLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->ROCKSDB_METRICS_DELAY);
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowLockLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowLockLoggerActor*>(this)->actor_wait_state = 1;
															#line 947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowLockLoggerActor, 0, Void >*>(static_cast<FlowLockLoggerActor*>(this)));
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent e("ShardedRocksDBFlowLock");
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadAvailable", readLock->available());
															#line 950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadActivePermits", readLock->activePermits());
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadWaiters", readLock->waiters());
															#line 952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchAvailable", fetchLock->available());
															#line 953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchActivePermits", fetchLock->activePermits());
															#line 954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchWaiters", fetchLock->waiters());
															#line 1253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent e("ShardedRocksDBFlowLock");
															#line 949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadAvailable", readLock->available());
															#line 950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadActivePermits", readLock->activePermits());
															#line 951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("ReadWaiters", readLock->waiters());
															#line 952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchAvailable", fetchLock->available());
															#line 953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchActivePermits", fetchLock->activePermits());
															#line 954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		e.detail("FetchWaiters", fetchLock->waiters());
															#line 1274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowLockLoggerActor*>(this)->actor_wait_state > 0) static_cast<FlowLockLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<FlowLockLoggerActor*>(this)->ActorCallback< FlowLockLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowLockLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowLockLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowLockLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowLockLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowLockLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowLockLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowLockLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	const FlowLock* readLock;
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	const FlowLock* fetchLock;
															#line 1358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowLockLogger()
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowLockLoggerActor final : public Actor<Void>, public ActorCallback< FlowLockLoggerActor, 0, Void >, public FastAllocated<FlowLockLoggerActor>, public FlowLockLoggerActorState<FlowLockLoggerActor> {
															#line 1363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowLockLoggerActor>::operator new;
	using FastAllocated<FlowLockLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4408507741878738432UL, 13324395552188872960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowLockLoggerActor, 0, Void >;
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLockLoggerActor(const FlowLock* const& readLock,const FlowLock* const& fetchLock) 
															#line 1380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowLockLoggerActorState<FlowLockLoggerActor>(readLock, fetchLock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowLockLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12599808689398097408UL, 15182406346863084288UL);
		ActorExecutionContextHelper __helper(static_cast<FlowLockLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowLockLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowLockLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowLockLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] Future<Void> flowLockLogger( const FlowLock* const& readLock, const FlowLock* const& fetchLock ) {
															#line 945 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowLockLoggerActor(readLock, fetchLock));
															#line 1412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

// DataShard represents a key range (logical shard) in FDB. A DataShard is assigned to a specific physical shard.
struct DataShard {
	DataShard(KeyRange range, PhysicalShard* physicalShard) : range(range), physicalShard(physicalShard) {}

	bool initialized() const;

	KeyRange range;
	PhysicalShard* physicalShard;
};

// PhysicalShard represent a collection of logical shards. A PhysicalShard could have one or more DataShards. A
// PhysicalShard is stored as a column family in rocksdb. Each PhysicalShard has its own iterator pool.
struct PhysicalShard {
	PhysicalShard(rocksdb::DB* db, std::string id, const rocksdb::ColumnFamilyOptions& options)
	  : db(db), id(id), cfOptions(options), isInitialized(false) {}
	PhysicalShard(rocksdb::DB* db, std::string id, rocksdb::ColumnFamilyHandle* handle)
	  : db(db), id(id), cf(handle), isInitialized(true) {
		ASSERT(cf);
	}

	rocksdb::Status init() {
		if (cf) {
			return rocksdb::Status::OK();
		}
		auto status = db->CreateColumnFamily(cfOptions, id, &cf);
		if (!status.ok()) {
			logRocksDBError(status, "AddCF");
			return status;
		}
		logShardEvent(id, ShardOp::OPEN);
		this->isInitialized.store(true);
		return status;
	}

	// Restore from the checkpoint.
	rocksdb::Status restore(const CheckpointMetaData& checkpoint) {
		const CheckpointFormat format = checkpoint.getFormat();
		rocksdb::Status status;
		if (format == DataMoveRocksCF) {
			ASSERT(cf == nullptr);
			rocksdb::ExportImportFilesMetaData metaData = getMetaData(checkpoint);
			if (metaData.files.empty()) {
				TraceEvent(SevInfo, "RocksDBRestoreEmptyShard")
				    .detail("ShardId", id)
				    .detail("CheckpointID", checkpoint.checkpointID);
				status = db->CreateColumnFamily(cfOptions, id, &cf);
			} else {
				TraceEvent(SevInfo, "RocksDBRestoreCF");
				rocksdb::ImportColumnFamilyOptions importOptions;
				importOptions.move_files = SERVER_KNOBS->ROCKSDB_IMPORT_MOVE_FILES;
				status = db->CreateColumnFamilyWithImport(cfOptions, id, importOptions, metaData, &cf);
				TraceEvent(SevInfo, "RocksDBRestoreCFEnd").detail("Status", status.ToString());
			}
		} else if (format == RocksDBKeyValues) {
			ASSERT(cf != nullptr);
			std::vector<std::string> sstFiles;
			const RocksDBCheckpointKeyValues rcp = getRocksKeyValuesCheckpoint(checkpoint);
			for (const auto& file : rcp.fetchedFiles) {
				if (file.path != emptySstFilePath) {
					sstFiles.push_back(file.path);
				}
			}

			TraceEvent(SevDebug, "RocksDBRestoreFiles")
			    .detail("Shard", id)
			    .detail("CheckpointID", checkpoint.checkpointID)
			    .detail("Files", describe(sstFiles));

			if (!sstFiles.empty()) {
				rocksdb::IngestExternalFileOptions ingestOptions;
				ingestOptions.move_files = SERVER_KNOBS->ROCKSDB_IMPORT_MOVE_FILES;
				ingestOptions.verify_checksums_before_ingest = SERVER_KNOBS->ROCKSDB_VERIFY_CHECKSUM_BEFORE_RESTORE;
				status = db->IngestExternalFile(cf, sstFiles, ingestOptions);
			} else {
				TraceEvent(SevWarn, "RocksDBServeRestoreEmptyRange")
				    .detail("ShardId", id)
				    .detail("RocksKeyValuesCheckpoint", rcp.toString())
				    .detail("Checkpoint", checkpoint.toString());
			}
			TraceEvent(SevInfo, "PhysicalShardRestoredFiles")
			    .detail("ShardId", id)
			    .detail("CFName", cf->GetName())
			    .detail("Checkpoint", checkpoint.toString())
			    .detail("RestoredFiles", describe(sstFiles));
		} else {
			throw not_implemented();
		}

		TraceEvent(status.ok() ? SevInfo : SevWarnAlways, "PhysicalShardRestoreEnd")
		    .detail("Status", status.ToString())
		    .detail("Shard", id)
		    .detail("CFName", cf == nullptr ? "" : cf->GetName())
		    .detail("Checkpoint", checkpoint.toString());
		if (status.ok()) {
			if (!this->isInitialized) {
				this->isInitialized.store(true);
			}
		}

		return status;
	}

	bool initialized() { return this->isInitialized.load(); }

	std::vector<KeyRange> getAllRanges() const {
		std::vector<KeyRange> res;
		for (const auto& [key, shard] : dataShards) {
			if (shard != nullptr) {
				res.push_back(shard->range);
			}
		}
		return res;
	}

	bool shouldFlush() {
		return SERVER_KNOBS->ROCKSDB_CF_RANGE_DELETION_LIMIT > 0 &&
		       numRangeDeletions > SERVER_KNOBS->ROCKSDB_CF_RANGE_DELETION_LIMIT;
	}

	std::string toString() {
		std::string ret = "[ID]: " + this->id + ", [CF]: ";
		if (initialized()) {
			ret += std::to_string(this->cf->GetID());
		} else {
			ret += "Not initialized";
		}
		return ret;
	}

	~PhysicalShard() {
		logShardEvent(id, ShardOp::CLOSE);
		isInitialized.store(false);

		// Deleting default column family is not allowed.
		if (deletePending && id != DEFAULT_CF_NAME) {
			auto s = db->DropColumnFamily(cf);
			if (!s.ok()) {
				logRocksDBError(s, "DestroyShard");
				logShardEvent(id, ShardOp::DESTROY, SevError, s.ToString());
				return;
			}
		}
		auto s = db->DestroyColumnFamilyHandle(cf);
		if (!s.ok()) {
			logRocksDBError(s, "DestroyCFHandle");
			logShardEvent(id, ShardOp::DESTROY, SevError, s.ToString());
			return;
		}
		logShardEvent(id, ShardOp::DESTROY);
	}

	rocksdb::DB* db;
	std::string id;
	rocksdb::ColumnFamilyOptions cfOptions;
	rocksdb::ColumnFamilyHandle* cf = nullptr;
	std::unordered_map<std::string, std::unique_ptr<DataShard>> dataShards;
	bool deletePending = false;
	std::atomic<bool> isInitialized;
	uint64_t numRangeDeletions = 0;
	double deleteTimeSec = 0.0;
	double lastCompactionTime = 0.0;
};

int readRangeInDb(PhysicalShard* shard,
                  const KeyRangeRef range,
                  int rowLimit,
                  int byteLimit,
                  RangeResult* result,
                  std::shared_ptr<IteratorPool> iteratorPool) {
	if (rowLimit == 0 || byteLimit == 0) {
		return 0;
	}

	int accumulatedBytes = 0;
	rocksdb::Status s;
	std::shared_ptr<ReadIterator> readIter = nullptr;

	bool reuseIterator = SERVER_KNOBS->SHARDED_ROCKSDB_REUSE_ITERATORS && iteratorPool != nullptr;
	if (g_network->isSimulated() &&
	    deterministicRandom()->random01() > SERVER_KNOBS->ROCKSDB_PROBABILITY_REUSE_ITERATOR_SIM) {
		// Reduce probability of reusing iterators in simulation.
		reuseIterator = false;
	}

	if (reuseIterator) {

		readIter = iteratorPool->getIterator(shard->id);
		if (readIter == nullptr) {
			readIter = std::make_shared<ReadIterator>(shard->cf, shard->db);
		}
	} else {
		readIter = std::make_shared<ReadIterator>(shard->cf, shard->db, range);
	}
	// When using a prefix extractor, ensure that keys are returned in order even if they cross
	// a prefix boundary.
	if (rowLimit >= 0) {
		auto* cursor = readIter->iter.get();
		cursor->Seek(toSlice(range.begin));
		while (cursor->Valid() && toStringRef(cursor->key()) < range.end) {
			KeyValueRef kv(toStringRef(cursor->key()), toStringRef(cursor->value()));
			accumulatedBytes += sizeof(KeyValueRef) + kv.expectedSize();
			result->push_back_deep(result->arena(), kv);
			// Calling `cursor->Next()` is potentially expensive, so short-circut here just in case.
			if (result->size() >= rowLimit || accumulatedBytes >= byteLimit) {
				break;
			}
			cursor->Next();
		}
		s = cursor->status();
	} else {
		auto* cursor = readIter->iter.get();
		cursor->SeekForPrev(toSlice(range.end));
		if (cursor->Valid() && toStringRef(cursor->key()) == range.end) {
			cursor->Prev();
		}
		while (cursor->Valid() && toStringRef(cursor->key()) >= range.begin) {
			KeyValueRef kv(toStringRef(cursor->key()), toStringRef(cursor->value()));
			accumulatedBytes += sizeof(KeyValueRef) + kv.expectedSize();
			result->push_back_deep(result->arena(), kv);
			// Calling `cursor->Prev()` is potentially expensive, so short-circuit here just in case.
			if (result->size() >= -rowLimit || accumulatedBytes >= byteLimit) {
				break;
			}
			cursor->Prev();
		}
		s = cursor->status();
	}

	if (!s.ok()) {
		logRocksDBError(s, "ReadRange");
		// The data written to the arena is not erased, which will leave RangeResult in a dirty state. The RangeResult
		// should never be returned to user.
		return -1;
	}
	if (reuseIterator) {
		iteratorPool->returnIterator(shard->id, readIter);
	}
	return accumulatedBytes;
}

// Manages physical shards and maintains logical shard mapping.
class ShardManager {
public:
	ShardManager(std::string path,
	             UID logId,
	             std::shared_ptr<ShardedRocksDBState> rState,
	             const rocksdb::DBOptions& options,
	             std::shared_ptr<RocksDBErrorListener> errorListener,
	             std::shared_ptr<RocksDBEventListener> eventListener,
	             Counters* cc,
	             std::shared_ptr<IteratorPool> iteratorPool)
	  : path(path), logId(logId), rState(rState), dbOptions(options), dataShardMap(nullptr, specialKeys.end),
	    counters(cc), iteratorPool(iteratorPool) {
		if (!g_network->isSimulated()) {
			// Generating trace events in non-FDB thread will cause errors. The event listener is tested with local FDB
			// cluster.
			dbOptions.listeners.push_back(errorListener);
			if (SERVER_KNOBS->LOGGING_ROCKSDB_BG_WORK_WHEN_IO_TIMEOUT ||
			    SERVER_KNOBS->LOGGING_ROCKSDB_BG_WORK_PROBABILITY > 0) {
				dbOptions.listeners.push_back(eventListener);
			}
		}
	}

																#line 1681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via shardMetricsLogger()
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class ShardMetricsLoggerActor>
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ShardMetricsLoggerActorState {
															#line 1687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardMetricsLoggerActorState(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager) 
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : rState(rState),
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   openFuture(openFuture),
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   shardManager(shardManager),
															#line 1225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   physicalShards(shardManager->getAllShards())
															#line 1700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("shardMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~ShardMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("shardMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = openFuture;
															#line 1229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 1229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardMetricsLoggerActor, 0, Void >*>(static_cast<ShardMetricsLoggerActor*>(this)));
															#line 1723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardMetricsLoggerActorState();
		static_cast<ShardMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<ShardMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardMetricsLoggerActorState(); static_cast<ShardMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 1752 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<ShardMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardMetricsLoggerActorState();
		static_cast<ShardMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 1765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 1276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "ShardedRocksShardMetricsLoggerError").errorUnsuppressed(e);
															#line 1769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 1785 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 1794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardMetricsLoggerActor*>(this)->ActorCallback< ShardMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->ROCKSDB_CF_METRICS_DELAY);
															#line 1231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state = 2;
															#line 1231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardMetricsLoggerActor, 1, Void >*>(static_cast<ShardMetricsLoggerActor*>(this)));
															#line 1898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 1920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		uint64_t numSstFiles = 0;
															#line 1237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( auto& [id, shard] : *physicalShards ) {
															#line 1238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shard->initialized())
															#line 1930 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 1241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			uint64_t liveDataSize = 0;
															#line 1242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(shard->db->GetIntProperty( shard->cf, rocksdb::DB::Properties::kEstimateLiveDataSize, &liveDataSize));
															#line 1245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent e(SevInfo, "PhysicalShardStats");
															#line 1246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("ShardId", id).detail("LiveDataSize", liveDataSize);
															#line 1249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdb::ColumnFamilyMetaData cfMetadata;
															#line 1250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shard->db->GetColumnFamilyMetaData(shard->cf, &cfMetadata);
															#line 1251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("NumFiles", cfMetadata.file_count);
															#line 1252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			numSstFiles += cfMetadata.file_count;
															#line 1253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string levelProp;
															#line 1254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			int numLevels = 0;
															#line 1255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = cfMetadata.levels.begin();it != cfMetadata.levels.end();++it) {
															#line 1256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::string propValue = "";
															#line 1257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				ASSERT(shard->db->GetProperty(shard->cf, rocksdb::DB::Properties::kCompressionRatioAtLevelPrefix + std::to_string(it->level), &propValue));
															#line 1261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				e.detail("Level" + std::to_string(it->level), std::to_string(it->size) + " " + propValue + " " + std::to_string(it->files.size()));
															#line 1263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (it->size > 0)
															#line 1964 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				{
															#line 1264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					++numLevels;
															#line 1968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				}
			}
															#line 1267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("NumLevels", numLevels);
															#line 1973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 1269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent(SevInfo, "KVSPhysialShardMetrics") .detail("NumActiveShards", shardManager->numActiveShards()) .detail("TotalPhysicalShards", shardManager->numPhysicalShards()) .detail("NumSstFiles", numSstFiles);
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 1986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		uint64_t numSstFiles = 0;
															#line 1237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( auto& [id, shard] : *physicalShards ) {
															#line 1238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shard->initialized())
															#line 1996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 1241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			uint64_t liveDataSize = 0;
															#line 1242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(shard->db->GetIntProperty( shard->cf, rocksdb::DB::Properties::kEstimateLiveDataSize, &liveDataSize));
															#line 1245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent e(SevInfo, "PhysicalShardStats");
															#line 1246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("ShardId", id).detail("LiveDataSize", liveDataSize);
															#line 1249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdb::ColumnFamilyMetaData cfMetadata;
															#line 1250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shard->db->GetColumnFamilyMetaData(shard->cf, &cfMetadata);
															#line 1251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("NumFiles", cfMetadata.file_count);
															#line 1252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			numSstFiles += cfMetadata.file_count;
															#line 1253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string levelProp;
															#line 1254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			int numLevels = 0;
															#line 1255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = cfMetadata.levels.begin();it != cfMetadata.levels.end();++it) {
															#line 1256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::string propValue = "";
															#line 1257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				ASSERT(shard->db->GetProperty(shard->cf, rocksdb::DB::Properties::kCompressionRatioAtLevelPrefix + std::to_string(it->level), &propValue));
															#line 1261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				e.detail("Level" + std::to_string(it->level), std::to_string(it->size) + " " + propValue + " " + std::to_string(it->files.size()));
															#line 1263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (it->size > 0)
															#line 2030 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				{
															#line 1264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					++numLevels;
															#line 2034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				}
			}
															#line 1267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			e.detail("NumLevels", numLevels);
															#line 2039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 1269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent(SevInfo, "KVSPhysialShardMetrics") .detail("NumActiveShards", shardManager->numActiveShards()) .detail("TotalPhysicalShards", shardManager->numPhysicalShards()) .detail("NumSstFiles", numSstFiles);
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ShardMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardMetricsLoggerActor*>(this)->ActorCallback< ShardMetricsLoggerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardMetricsLoggerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardMetricsLoggerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardMetricsLoggerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<ShardedRocksDBState> rState;
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<Void> openFuture;
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardManager* shardManager;
															#line 1225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unordered_map<std::string, std::shared_ptr<PhysicalShard>>* physicalShards;
															#line 2144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via shardMetricsLogger()
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ShardMetricsLoggerActor final : public Actor<Void>, public ActorCallback< ShardMetricsLoggerActor, 0, Void >, public ActorCallback< ShardMetricsLoggerActor, 1, Void >, public FastAllocated<ShardMetricsLoggerActor>, public ShardMetricsLoggerActorState<ShardMetricsLoggerActor> {
															#line 2149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<ShardMetricsLoggerActor>::operator new;
	using FastAllocated<ShardMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12752940325060596224UL, 8102833171838890752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardMetricsLoggerActor, 0, Void >;
friend struct ActorCallback< ShardMetricsLoggerActor, 1, Void >;
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardMetricsLoggerActor(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager) 
															#line 2167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   ShardMetricsLoggerActorState<ShardMetricsLoggerActor>(rState, openFuture, shardManager),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4725391609557280512UL, 11012859299712925952UL);
		ActorExecutionContextHelper __helper(static_cast<ShardMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardMetricsLoggerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> shardMetricsLogger( std::shared_ptr<ShardedRocksDBState> const& rState, Future<Void> const& openFuture, ShardManager* const& shardManager ) {
															#line 1222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new ShardMetricsLoggerActor(rState, openFuture, shardManager));
															#line 2200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 1281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	rocksdb::Status init() {
		const double start = now();
		// Open instance.
		TraceEvent(SevInfo, "ShardedRocksDBInitBegin", this->logId).detail("DataPath", path);
		if (SERVER_KNOBS->SHARDED_ROCKSDB_WRITE_RATE_LIMITER_BYTES_PER_SEC > 0) {
			rocksdb::RateLimiter::Mode mode;
			switch (SERVER_KNOBS->SHARDED_ROCKSDB_RATE_LIMITER_MODE) {
			case 0:
				mode = rocksdb::RateLimiter::Mode::kReadsOnly;
				break;
			case 1:
				mode = rocksdb::RateLimiter::Mode::kWritesOnly;
				break;
			case 2:
				mode = rocksdb::RateLimiter::Mode::kAllIo;
				break;
			default:
				TraceEvent(SevWarnAlways, "IncorrectRateLimiterMode")
				    .detail("Mode", SERVER_KNOBS->SHARDED_ROCKSDB_RATE_LIMITER_MODE);
				mode = rocksdb::RateLimiter::Mode::kWritesOnly;
			}

			auto rateLimiter =
			    rocksdb::NewGenericRateLimiter(SERVER_KNOBS->SHARDED_ROCKSDB_WRITE_RATE_LIMITER_BYTES_PER_SEC,
			                                   100 * 1000, // refill_period_us
			                                   10, // fairness
			                                   mode,
			                                   SERVER_KNOBS->ROCKSDB_WRITE_RATE_LIMITER_AUTO_TUNE);
			dbOptions.rate_limiter = std::shared_ptr<rocksdb::RateLimiter>(rateLimiter);
		}
		std::vector<std::string> columnFamilies;
		rocksdb::Status status = rocksdb::DB::ListColumnFamilies(dbOptions, path, &columnFamilies);

		std::vector<rocksdb::ColumnFamilyDescriptor> descriptors;
		bool foundMetadata = false;
		for (const auto& name : columnFamilies) {
			if (name == METADATA_SHARD_ID) {
				foundMetadata = true;
			}
			descriptors.push_back(rocksdb::ColumnFamilyDescriptor(name, rState->getCFOptions()));
		}

		// Add default column family if it's a newly opened database.
		if (descriptors.size() == 0) {
			descriptors.push_back(rocksdb::ColumnFamilyDescriptor("default", rState->getCFOptions()));
		}

		std::vector<rocksdb::ColumnFamilyHandle*> handles;
		status = rocksdb::DB::Open(dbOptions, path, descriptors, &handles, &db);
		if (!status.ok()) {
			logRocksDBError(status, "Open");
			return status;
		}

		TraceEvent("ShardedRocksDBOpen").detail("Duraton", now() - start).detail("NumCFs", descriptors.size());

		if (foundMetadata) {
			TraceEvent(SevInfo, "ShardedRocksInitLoadPhysicalShards", this->logId)
			    .detail("PhysicalShardCount", handles.size());

			std::shared_ptr<PhysicalShard> metadataShard = nullptr;
			for (auto handle : handles) {
				auto shard = std::make_shared<PhysicalShard>(db, handle->GetName(), handle);
				if (shard->id == METADATA_SHARD_ID) {
					metadataShard = shard;
				}
				physicalShards[shard->id] = shard;
				columnFamilyMap[handle->GetID()] = handle;
				TraceEvent(SevVerbose, "ShardedRocksInitPhysicalShard", this->logId).detail("ShardId", shard->id);
			}

			std::set<std::string> unusedShards(columnFamilies.begin(), columnFamilies.end());
			unusedShards.erase(METADATA_SHARD_ID);
			unusedShards.erase(DEFAULT_CF_NAME);

			KeyRange keyRange = prefixRange(shardMappingPrefix);
			while (true) {
				RangeResult metadata;
				const int bytes = readRangeInDb(metadataShard.get(),
				                                keyRange,
				                                std::max(2, SERVER_KNOBS->ROCKSDB_READ_RANGE_ROW_LIMIT),
				                                SERVER_KNOBS->SHARD_METADATA_SCAN_BYTES_LIMIT,
				                                &metadata,
				                                iteratorPool);
				if (bytes <= 0) {
					break;
				}

				ASSERT_GT(metadata.size(), 0);
				for (int i = 0; i < metadata.size() - 1; ++i) {
					const std::string name = metadata[i].value.toString();
					KeyRangeRef range(metadata[i].key.removePrefix(shardMappingPrefix),
					                  metadata[i + 1].key.removePrefix(shardMappingPrefix));
					TraceEvent(SevVerbose, "DecodeShardMapping", this->logId)
					    .detail("Range", range)
					    .detail("ShardId", name);

					// Empty name indicates the shard doesn't belong to the SS/KVS.
					if (name.empty()) {
						continue;
					}

					auto it = physicalShards.find(name);
					// Raise error if physical shard is missing.
					if (it == physicalShards.end()) {
						TraceEvent(SevError, "ShardedRocksDB", this->logId).detail("MissingShard", name);
						return rocksdb::Status::NotFound();
					}

					std::unique_ptr<DataShard> dataShard = std::make_unique<DataShard>(range, it->second.get());
					dataShardMap.insert(range, dataShard.get());
					it->second->dataShards[range.begin.toString()] = std::move(dataShard);
					activePhysicalShardIds.emplace(name);
					unusedShards.erase(name);
				}

				if (metadata.back().key.removePrefix(shardMappingPrefix) == specialKeys.end) {
					TraceEvent(SevVerbose, "ShardedRocksLoadShardMappingEnd", this->logId);
					break;
				}

				// Read from the current last key since the shard beginning with it hasn't been processed.
				if (metadata.size() == 1 && metadata.back().value.toString().empty()) {
					// Should not happen, just being paranoid.
					keyRange = KeyRangeRef(keyAfter(metadata.back().key), keyRange.end);
				} else {
					keyRange = KeyRangeRef(metadata.back().key, keyRange.end);
				}
			}

			for (const auto& name : unusedShards) {
				auto it = physicalShards.find(name);
				ASSERT(it != physicalShards.end());
				auto shard = it->second;
				if (shard->dataShards.size() == 0) {
					shard->deleteTimeSec = now();
					pendingDeletionShards.push_back(name);
					TraceEvent(SevInfo, "UnusedPhysicalShard", logId).detail("ShardId", name);
				}
			}
			if (unusedShards.size() > 0) {
				TraceEvent("ShardedRocksDB", logId).detail("CleanUpUnusedShards", unusedShards.size());
			}
		} else {
			// DB is opened with default shard.
			ASSERT(handles.size() == 1);
			// Clear the entire key space.
			rocksdb::WriteOptions options;
			db->DeleteRange(options, handles[0], toSlice(allKeys.begin), toSlice(specialKeys.end));

			// Add SpecialKeys range. This range should not be modified.
			std::shared_ptr<PhysicalShard> defaultShard =
			    std::make_shared<PhysicalShard>(db, DEFAULT_CF_NAME, handles[0]);
			columnFamilyMap[defaultShard->cf->GetID()] = defaultShard->cf;
			std::unique_ptr<DataShard> dataShard = std::make_unique<DataShard>(specialKeys, defaultShard.get());
			dataShardMap.insert(specialKeys, dataShard.get());
			defaultShard->dataShards[specialKeys.begin.toString()] = std::move(dataShard);
			physicalShards[defaultShard->id] = defaultShard;

			// Create metadata shard.
			auto metadataShard = std::make_shared<PhysicalShard>(db, METADATA_SHARD_ID, rState->getCFOptions());
			metadataShard->init();
			columnFamilyMap[metadataShard->cf->GetID()] = metadataShard->cf;
			physicalShards[METADATA_SHARD_ID] = metadataShard;

			// Write special key range metadata.
			writeBatch = std::make_unique<rocksdb::WriteBatch>(
			    0, // reserved_bytes default:0
			    0, // max_bytes default:0
			    SERVER_KNOBS->ROCKSDB_WRITEBATCH_PROTECTION_BYTES_PER_KEY, // protection_bytes_per_key
			    0 /* default_cf_ts_sz default:0 */);
			dirtyShards = std::make_unique<std::set<PhysicalShard*>>();
			persistRangeMapping(specialKeys, true);
			status = db->Write(options, writeBatch.get());
			if (!status.ok()) {
				return status;
			}
			TraceEvent(SevInfo, "ShardedRocksInitializeMetaDataShard", this->logId)
			    .detail("MetadataShardCF", metadataShard->cf->GetID());
		}

		writeBatch = std::make_unique<rocksdb::WriteBatch>(
		    0, // reserved_bytes default:0
		    0, // max_bytes default:0
		    SERVER_KNOBS->ROCKSDB_WRITEBATCH_PROTECTION_BYTES_PER_KEY, // protection_bytes_per_key
		    0 /* default_cf_ts_sz default:0 */);
		dirtyShards = std::make_unique<std::set<PhysicalShard*>>();
		iteratorPool->update(getMetaDataShard()->id);

		TraceEvent(SevInfo, "ShardedRocksDBInitEnd", this->logId)
		    .detail("DataPath", path)
		    .detail("Duration", now() - start);
		return status;
	}

	DataShard* getDataShard(KeyRef key) {
		DataShard* shard = dataShardMap[key];
		ASSERT(shard == nullptr || shard->range.contains(key));
		return shard;
	}

	PhysicalShard* getSpecialKeysShard() {
		auto it = physicalShards.find(DEFAULT_CF_NAME);
		ASSERT(it != physicalShards.end());
		return it->second.get();
	}

	PhysicalShard* getMetaDataShard() {
		auto it = physicalShards.find(METADATA_SHARD_ID);
		ASSERT(it != physicalShards.end());
		return it->second.get();
	}

	// Returns the physical shard that hosting all `ranges`; Returns nullptr if such a physical shard does not exists.
	PhysicalShard* getPhysicalShardForAllRanges(std::vector<KeyRange> ranges) {
		PhysicalShard* result = nullptr;
		for (const auto& range : ranges) {
			auto rangeIterator = this->dataShardMap.intersectingRanges(range);
			for (auto it = rangeIterator.begin(); it != rangeIterator.end(); ++it) {
				if (it.value() == nullptr) {
					TraceEvent(SevWarn, "ShardedRocksDBRangeNotInKVS", logId).detail("Range", range);
					return nullptr;
				} else {
					ASSERT(it.value()->physicalShard != nullptr);
					PhysicalShard* ps = it.value()->physicalShard;
					if (result == nullptr) {
						result = ps;
					} else if (ps != result) {
						TraceEvent(SevWarn, "ShardedRocksDBRangeOnMultipleShards", logId)
						    .detail("Ranges", describe(ranges))
						    .detail("PhysicalShard", result->id)
						    .detail("SecondPhysicalShard", ps->id);
						return nullptr;
					}
				}
			}
		}

		return result;
	}

	std::vector<DataShard*> getDataShardsByRange(KeyRangeRef range) {
		std::vector<DataShard*> result;
		auto rangeIterator = dataShardMap.intersectingRanges(range);

		for (auto it = rangeIterator.begin(); it != rangeIterator.end(); ++it) {
			if (it.value() == nullptr) {
				TraceEvent(SevVerbose, "ShardedRocksDB")
				    .detail("Info", "ShardNotFound")
				    .detail("BeginKey", range.begin)
				    .detail("EndKey", range.end);
				continue;
			}
			result.push_back(it.value());
		}
		return result;
	}

	PhysicalShard* addRange(KeyRange range, std::string id, bool active) {
		TraceEvent(SevVerbose, "ShardedRocksAddRangeBegin", this->logId).detail("Range", range).detail("ShardId", id);

		// Newly added range should not overlap with any existing range.
		auto ranges = dataShardMap.intersectingRanges(range);

		for (auto it = ranges.begin(); it != ranges.end(); ++it) {
			if (it.value()) {
				if (it.value()->physicalShard->id == id) {
					TraceEvent(SevError, "ShardedRocksDBAddRange")
					    .detail("ErrorType", "RangeAlreadyExist")
					    .detail("IntersectingRange", it->range())
					    .detail("DataShardRange", it->value()->range)
					    .detail("ExpectedShardId", id)
					    .detail("PhysicalShardID", it->value()->physicalShard->toString());
				} else {
					TraceEvent(SevError, "ShardedRocksDBAddRange")
					    .detail("ErrorType", "ConflictingRange")
					    .detail("IntersectingRange", it->range())
					    .detail("DataShardRange", it->value()->range)
					    .detail("ExpectedShardId", id)
					    .detail("PhysicalShardID", it->value()->physicalShard->toString());
				}
				return nullptr;
			}
		}

		auto currentCfOptions = active ? rState->getCFOptions() : rState->getCFOptionsForInactiveShard();
		auto [it, inserted] = physicalShards.emplace(id, std::make_shared<PhysicalShard>(db, id, currentCfOptions));
		std::shared_ptr<PhysicalShard>& shard = it->second;

		activePhysicalShardIds.emplace(id);

		auto dataShard = std::make_unique<DataShard>(range, shard.get());
		dataShardMap.insert(range, dataShard.get());
		shard->dataShards[range.begin.toString()] = std::move(dataShard);

		validate();

		TraceEvent(SevInfo, "ShardedRocksDBRangeAdded", this->logId)
		    .detail("Range", range)
		    .detail("ShardId", id)
		    .detail("Active", active);

		return shard.get();
	}

	std::vector<std::string> removeRange(KeyRange range) {
		TraceEvent(SevVerbose, "ShardedRocksRemoveRangeBegin", this->logId).detail("Range", range);
		std::vector<std::string> shardIds;

		std::vector<DataShard*> newShards;
		auto ranges = dataShardMap.intersectingRanges(range);

		for (auto it = ranges.begin(); it != ranges.end(); ++it) {
			if (!it.value()) {
				TraceEvent(SevDebug, "ShardedRocksDB")
				    .detail("Info", "RemoveNonExistentRange")
				    .detail("BeginKey", range.begin)
				    .detail("EndKey", range.end);
				continue;
			}
			auto existingShard = it.value()->physicalShard;
			auto shardRange = it.range();

			if (SERVER_KNOBS->ROCKSDB_EMPTY_RANGE_CHECK && existingShard->initialized()) {
				// Enable consistency validation.
				RangeResult rangeResult;
				auto bytesRead = readRangeInDb(existingShard, range, 1, UINT16_MAX, &rangeResult, iteratorPool);
				if (bytesRead > 0) {
					TraceEvent(SevError, "ShardedRocksDBRangeNotEmpty")
					    .detail("ShardId", existingShard->toString())
					    .detail("Range", range)
					    .detail("DataShardRange", shardRange);
					// Force clear range.
					writeBatch->DeleteRange(it.value()->physicalShard->cf, toSlice(range.begin), toSlice(range.end));
					dirtyShards->insert(it.value()->physicalShard);
				}
			}
			ASSERT(it.value()->range == shardRange); // Ranges should be consistent.

			if (range.contains(shardRange)) {
				existingShard->dataShards.erase(shardRange.begin.toString());
				TraceEvent(SevInfo, "ShardedRocksRemovedRange")
				    .detail("Range", range)
				    .detail("RemovedRange", shardRange)
				    .detail("ShardId", existingShard->toString());
				if (existingShard->dataShards.size() == 0) {
					TraceEvent(SevInfo, "ShardedRocksDBEmptyShard").detail("ShardId", existingShard->id);
					shardIds.push_back(existingShard->id);
					existingShard->deleteTimeSec = now();
					pendingDeletionShards.push_back(existingShard->id);
					activePhysicalShardIds.erase(existingShard->id);
				}
				continue;
			}

			// Range modification could result in more than one segments. Remove the original segment key here.
			existingShard->dataShards.erase(shardRange.begin.toString());
			if (shardRange.begin < range.begin) {
				auto dataShard =
				    std::make_unique<DataShard>(KeyRange(KeyRangeRef(shardRange.begin, range.begin)), existingShard);

				newShards.push_back(dataShard.get());
				const std::string msg = "Shrink shard from " + Traceable<KeyRangeRef>::toString(shardRange) + " to " +
				                        Traceable<KeyRangeRef>::toString(dataShard->range);

				existingShard->dataShards[shardRange.begin.toString()] = std::move(dataShard);
				logShardEvent(existingShard->id, shardRange, ShardOp::MODIFY_RANGE, SevInfo, msg);
			}

			if (shardRange.end > range.end) {
				auto dataShard =
				    std::make_unique<DataShard>(KeyRange(KeyRangeRef(range.end, shardRange.end)), existingShard);

				newShards.push_back(dataShard.get());
				const std::string msg = "Shrink shard from " + Traceable<KeyRangeRef>::toString(shardRange) + " to " +
				                        Traceable<KeyRangeRef>::toString(dataShard->range);

				existingShard->dataShards[range.end.toString()] = std::move(dataShard);
				logShardEvent(existingShard->id, shardRange, ShardOp::MODIFY_RANGE, SevInfo, msg);
			}
		}

		dataShardMap.insert(range, nullptr);
		for (DataShard* shard : newShards) {
			dataShardMap.insert(shard->range, shard);
		}

		validate();

		TraceEvent(SevInfo, "ShardedRocksRemoveRangeEnd", this->logId).detail("Range", range);

		return shardIds;
	}

	void markRangeAsActive(KeyRangeRef range) {
		auto ranges = dataShardMap.intersectingRanges(range);

		for (auto it = ranges.begin(); it != ranges.end(); ++it) {
			if (!it.value()) {
				continue;
			}

			auto beginSlice = toSlice(range.begin);
			auto endSlice = toSlice(range.end);
			db->SuggestCompactRange(it.value()->physicalShard->cf, &beginSlice, &endSlice);

			std::unordered_map<std::string, std::string> options = {
				{ "level0_file_num_compaction_trigger",
				  std::to_string(SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_FILENUM_COMPACTION_TRIGGER) },
				{ "level0_slowdown_writes_trigger",
				  std::to_string(SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_SLOWDOWN_WRITES_TRIGGER) },
				{ "level0_stop_writes_trigger",
				  std::to_string(SERVER_KNOBS->SHARDED_ROCKSDB_LEVEL0_STOP_WRITES_TRIGGER) },
				{ "soft_pending_compaction_bytes_limit",
				  std::to_string(SERVER_KNOBS->SHARD_SOFT_PENDING_COMPACT_BYTES_LIMIT) },
				{ "hard_pending_compaction_bytes_limit",
				  std::to_string(SERVER_KNOBS->SHARD_HARD_PENDING_COMPACT_BYTES_LIMIT) },
				{ "disable_auto_compactions", "false" },
				{ "num_levels", "-1" }
			};
			db->SetOptions(it.value()->physicalShard->cf, options);
			TraceEvent("ShardedRocksDBRangeActive", logId).detail("ShardId", it.value()->physicalShard->id);
		}
	}

	std::vector<std::shared_ptr<PhysicalShard>> getPendingDeletionShards(double cleanUpDelay) {
		std::vector<std::shared_ptr<PhysicalShard>> emptyShards;
		double currentTime = now();

		TraceEvent(SevInfo, "ShardedRocksDB", logId)
		    .detail("PendingDeletionShardQueueSize", pendingDeletionShards.size());
		while (!pendingDeletionShards.empty()) {
			const auto id = pendingDeletionShards.front();
			auto it = physicalShards.find(id);
			if (it == physicalShards.end() || it->second->dataShards.size() != 0) {
				pendingDeletionShards.pop_front();
				continue;
			}
			if (currentTime - it->second->deleteTimeSec > cleanUpDelay) {
				pendingDeletionShards.pop_front();
				emptyShards.push_back(it->second);
				physicalShards.erase(id);
			} else {
				break;
			}
		}
		return emptyShards;
	}

	void put(KeyRef key, ValueRef value) {
		auto it = dataShardMap.rangeContaining(key);
		if (!it.value()) {
			TraceEvent(SevError, "ShardedRocksDB").detail("Error", "write to non-exist shard").detail("WriteKey", key);
			return;
		}
		TraceEvent(SevVerbose, "ShardedRocksShardManagerPut", this->logId)
		    .detail("WriteKey", key)
		    .detail("Value", value)
		    .detail("MapRange", it.range())
		    .detail("ShardRange", it.value()->range);
		ASSERT(it.value()->range == (KeyRangeRef)it.range());
		ASSERT(writeBatch != nullptr);
		ASSERT(dirtyShards != nullptr);
		writeBatch->Put(it.value()->physicalShard->cf, toSlice(key), toSlice(value));
		dirtyShards->insert(it.value()->physicalShard);
		TraceEvent(SevVerbose, "ShardedRocksShardManagerPutEnd", this->logId)
		    .detail("WriteKey", key)
		    .detail("Value", value);
	}

	void clear(KeyRef key) {
		auto it = dataShardMap.rangeContaining(key);
		if (!it.value()) {
			return;
		}
		writeBatch->Delete(it.value()->physicalShard->cf, toSlice(key));
		dirtyShards->insert(it.value()->physicalShard);
	}

	void clearRange(KeyRangeRef range, std::set<Key>* keysSet) {
		auto rangeIterator = dataShardMap.intersectingRanges(range);

		for (auto it = rangeIterator.begin(); it != rangeIterator.end(); ++it) {
			if (it.value() == nullptr) {
				TraceEvent(SevDebug, "ShardedRocksDB").detail("ClearNonExistentRange", it.range());
				continue;
			}

			auto physicalShard = it.value()->physicalShard;

			// TODO: Disable this once RocksDB is upgraded to a version with range delete improvement.
			if (SERVER_KNOBS->ROCKSDB_USE_POINT_DELETE_FOR_SYSTEM_KEYS && systemKeys.contains(range)) {
				auto scanRange = it.range() & range;
				auto beginSlice = toSlice(scanRange.begin);
				auto endSlice = toSlice(scanRange.end);

				rocksdb::ReadOptions options = getReadOptions();
				options.iterate_lower_bound = &beginSlice;
				options.iterate_upper_bound = &endSlice;
				auto cursor = std::unique_ptr<rocksdb::Iterator>(db->NewIterator(options, physicalShard->cf));
				cursor->Seek(beginSlice);
				while (cursor->Valid() && toStringRef(cursor->key()) < toStringRef(endSlice)) {
					writeBatch->Delete(physicalShard->cf, cursor->key());
					cursor->Next();
				}
				if (!cursor->status().ok()) {
					// if readrange iteration fails, then do a deleteRange.
					writeBatch->DeleteRange(physicalShard->cf, beginSlice, endSlice);
				} else {

					auto key = keysSet->lower_bound(scanRange.begin);
					while (key != keysSet->end() && *key < scanRange.end) {
						writeBatch->Delete(physicalShard->cf, toSlice(*key));
						++key;
					}
				}
				++counters->convertedRangeDeletions;
			} else {
				writeBatch->DeleteRange(physicalShard->cf, toSlice(range.begin), toSlice(range.end));
				++physicalShard->numRangeDeletions;
			}

			// TODO: Skip clear range and compaction when entire CF is cleared.
			dirtyShards->insert(it.value()->physicalShard);
		}
	}

	void populateRangeMappingMutations(rocksdb::WriteBatch* writeBatch, KeyRangeRef range, bool isAdd) {
		TraceEvent(SevDebug, "ShardedRocksDB", this->logId)
		    .detail("Info", "RangeToPersist")
		    .detail("BeginKey", range.begin)
		    .detail("EndKey", range.end);
		PhysicalShard* metadataShard = getMetaDataShard();

		writeBatch->DeleteRange(metadataShard->cf,
		                        getShardMappingKey(range.begin, shardMappingPrefix),
		                        getShardMappingKey(range.end, shardMappingPrefix));

		KeyRef lastKey = range.end;
		if (isAdd) {
			auto ranges = dataShardMap.intersectingRanges(range);
			for (auto it = ranges.begin(); it != ranges.end(); ++it) {
				if (it.value()) {
					ASSERT(it.range() == it.value()->range);
					// Non-empty range.
					writeBatch->Put(metadataShard->cf,
					                getShardMappingKey(it.range().begin, shardMappingPrefix),
					                it.value()->physicalShard->id);
					TraceEvent(SevDebug, "ShardedRocksDB", this->logId)
					    .detail("Action", "PersistRangeMapping")
					    .detail("BeginKey", it.range().begin)
					    .detail("EndKey", it.range().end)
					    .detail("ShardId", it.value()->physicalShard->id);

				} else {
					// Empty range.
					writeBatch->Put(metadataShard->cf, getShardMappingKey(it.range().begin, shardMappingPrefix), "");
					TraceEvent(SevDebug, "ShardedRocksDB", this->logId)
					    .detail("Action", "PersistRangeMapping")
					    .detail("BeginKey", it.range().begin)
					    .detail("EndKey", it.range().end)
					    .detail("ShardId", "None");
				}
				lastKey = it.range().end;
			}
		} else {
			writeBatch->Put(metadataShard->cf, getShardMappingKey(range.begin, shardMappingPrefix), "");
			TraceEvent(SevDebug, "ShardedRocksDB", this->logId)
			    .detail("Action", "PersistRangeMapping")
			    .detail("RemoveRange", "True")
			    .detail("BeginKey", range.begin)
			    .detail("EndKey", range.end);
		}

		DataShard* nextShard = nullptr;
		if (lastKey <= allKeys.end) {
			nextShard = dataShardMap.rangeContaining(lastKey).value();
		}
		writeBatch->Put(metadataShard->cf,
		                getShardMappingKey(lastKey, shardMappingPrefix),
		                nextShard == nullptr ? "" : nextShard->physicalShard->id);
		TraceEvent(SevDebug, "ShardedRocksDB", this->logId)
		    .detail("Action", "PersistRangeMappingEnd")
		    .detail("NextShardKey", lastKey)
		    .detail("Value", nextShard == nullptr ? "" : nextShard->physicalShard->id);
	}

	void persistRangeMapping(KeyRangeRef range, bool isAdd) {
		populateRangeMappingMutations(writeBatch.get(), range, isAdd);
		dirtyShards->insert(getMetaDataShard());
	}

	std::unique_ptr<rocksdb::WriteBatch> getWriteBatch() {
		std::unique_ptr<rocksdb::WriteBatch> existingWriteBatch = std::move(writeBatch);
		writeBatch = std::make_unique<rocksdb::WriteBatch>(
		    0, // reserved_bytes default:0
		    0, // max_bytes default:0
		    SERVER_KNOBS->ROCKSDB_WRITEBATCH_PROTECTION_BYTES_PER_KEY, // protection_bytes_per_key
		    0 /* default_cf_ts_sz default:0 */);
		return existingWriteBatch;
	}

	std::unique_ptr<std::set<PhysicalShard*>> getDirtyShards() {
		std::unique_ptr<std::set<PhysicalShard*>> existingShards = std::move(dirtyShards);
		dirtyShards = std::make_unique<std::set<PhysicalShard*>>();
		return existingShards;
	}

	void flushShard(std::string shardId) {
		auto it = physicalShards.find(shardId);
		if (it == physicalShards.end()) {
			return;
		}
		rocksdb::FlushOptions fOptions;
		fOptions.wait = SERVER_KNOBS->ROCKSDB_WAIT_ON_CF_FLUSH;
		fOptions.allow_write_stall = SERVER_KNOBS->SHARDED_ROCKSDB_ALLOW_WRITE_STALL_ON_FLUSH;

		db->Flush(fOptions, it->second->cf);
	}

	void closeAllShards() {
		columnFamilyMap.clear();
		physicalShards.clear();
		// Close DB.
		auto s = db->Close();
		if (!s.ok()) {
			logRocksDBError(s, "Close");
			return;
		}
		TraceEvent("ShardedRocksDB", this->logId).detail("Info", "DBClosed");
	}

	void destroyAllShards() {
		auto metadataShard = getMetaDataShard();
		KeyRange metadataRange = prefixRange(shardMappingPrefix);
		rocksdb::WriteOptions options;
		db->DeleteRange(options, physicalShards["default"]->cf, toSlice(allKeys.begin), toSlice(specialKeys.end));
		db->DeleteRange(options, metadataShard->cf, toSlice(metadataRange.begin), toSlice(metadataRange.end));

		columnFamilyMap.clear();
		physicalShards.clear();
		// Close DB.
		auto s = db->Close();
		if (!s.ok()) {
			logRocksDBError(s, "Close");
			return;
		}
		s = rocksdb::DestroyDB(path, rocksdb::Options(dbOptions, rState->getCFOptions()));
		if (!s.ok()) {
			logRocksDBError(s, "DestroyDB");
		}
		TraceEvent("ShardedRocksDB", this->logId).detail("Info", "DBDestroyed");
	}

	rocksdb::DB* getDb() const { return db; }

	std::unordered_map<std::string, std::shared_ptr<PhysicalShard>>* getAllShards() { return &physicalShards; }

	std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*>* getColumnFamilyMap() { return &columnFamilyMap; }

	std::vector<rocksdb::ColumnFamilyHandle*> getColumnFamilies() {
		std::vector<rocksdb::ColumnFamilyHandle*> res;
		for (auto& [id, cf] : columnFamilyMap) {
			res.push_back(cf);
		}
		return res;
	}

	size_t numPhysicalShards() const { return physicalShards.size(); };

	size_t numActiveShards() const { return activePhysicalShardIds.size(); };

	std::vector<std::pair<KeyRange, std::string>> getDataMapping() {
		std::vector<std::pair<KeyRange, std::string>> dataMap;
		for (auto it : dataShardMap.ranges()) {
			if (!it.value()) {
				continue;
			}
			dataMap.push_back(std::make_pair(it.range(), it.value()->physicalShard->id));
		}
		return dataMap;
	}

	CoalescedKeyRangeMap<std::string> getExistingRanges() {
		CoalescedKeyRangeMap<std::string> existingRanges;
		existingRanges.insert(allKeys, "");
		for (auto it : dataShardMap.intersectingRanges(allKeys)) {
			if (!it.value()) {
				continue;
			}

			if (it.value()->physicalShard->id == "kvs-metadata") {
				continue;
			}

			existingRanges.insert(it.range(), it.value()->physicalShard->id);
		}
		return existingRanges;
	}

	void validate() {
		if (SERVER_KNOBS->SHARDED_ROCKSDB_VALIDATE_MAPPING_RATIO <= 0 ||
		    deterministicRandom()->random01() > SERVER_KNOBS->SHARDED_ROCKSDB_VALIDATE_MAPPING_RATIO) {
			return;
		}

		TraceEvent(SevVerbose, "ShardedRocksValidateShardManager", this->logId);
		for (auto s = dataShardMap.ranges().begin(); s != dataShardMap.ranges().end(); ++s) {
			TraceEvent e(SevVerbose, "ShardedRocksValidateDataShardMap", this->logId);
			e.detail("Range", s->range());
			const DataShard* shard = s->value();
			e.detail("ShardAddress", reinterpret_cast<std::uintptr_t>(shard));
			if (shard != nullptr) {
				e.detail("PhysicalShard", shard->physicalShard->id);
			} else {
				e.detail("Shard", "Empty");
			}
			if (shard != nullptr) {
				if (shard->range != static_cast<KeyRangeRef>(s->range())) {
					TraceEvent(SevWarnAlways, "ShardRangeMismatch").detail("Range", s->range());
				}

				ASSERT(shard->range == static_cast<KeyRangeRef>(s->range()));
				ASSERT(shard->physicalShard != nullptr);
				auto it = shard->physicalShard->dataShards.find(shard->range.begin.toString());
				ASSERT(it != shard->physicalShard->dataShards.end());
				ASSERT(it->second.get() == shard);
			}
		}
	}

private:
	const std::string path;
	const UID logId;
	std::shared_ptr<ShardedRocksDBState> rState;
	rocksdb::DBOptions dbOptions;
	rocksdb::DB* db = nullptr;
	std::unordered_map<std::string, std::shared_ptr<PhysicalShard>> physicalShards;
	std::unordered_set<std::string> activePhysicalShardIds;
	// Stores mapping between cf id and cf handle, used during compaction.
	std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*> columnFamilyMap;
	std::unique_ptr<rocksdb::WriteBatch> writeBatch;
	std::unique_ptr<std::set<PhysicalShard*>> dirtyShards;
	KeyRangeMap<DataShard*> dataShardMap;
	std::deque<std::string> pendingDeletionShards;
	Counters* counters;
	std::shared_ptr<IteratorPool> iteratorPool;
};

// FDB Reference is not thread safe and should never be copied across threads. Latency metrics should only be passed by
// reference.
struct LatencyMetrics {
	// Readers metrics.
	Reference<Histogram> readRangeLatency;
	Reference<Histogram> readValueLatency;
	Reference<Histogram> readPrefixLatency;
	Reference<Histogram> readRangeIteratorCreationTime;
	Reference<Histogram> readActionQueueWait;

	// Writers metrics
	Reference<Histogram> commitLatency;
	Reference<Histogram> addShardLatency;
	Reference<Histogram> removeShardLatency;
	Reference<Histogram> writeActionQueueWait;

	LatencyMetrics()
	  : readRangeLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                             ROCKSDB_READRANGE_LATENCY_HISTOGRAM,
	                                             Histogram::Unit::milliseconds)),
	    readValueLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                             ROCKSDB_READVALUE_LATENCY_HISTOGRAM,
	                                             Histogram::Unit::milliseconds)),
	    readPrefixLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                              ROCKSDB_READPREFIX_LATENCY_HISTOGRAM,
	                                              Histogram::Unit::milliseconds)),
	    readRangeIteratorCreationTime(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                                          ROCKSDB_ITERATOR_CREATION_TIME_HISTOGRAM,
	                                                          Histogram::Unit::milliseconds)),
	    readActionQueueWait(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                                ROCKSDB_READ_ACTION_QUEUE_WAIT_HISTOGRAM,
	                                                Histogram::Unit::milliseconds)),
	    commitLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                          ROCKSDB_COMMIT_LATENCY_HISTOGRAM,
	                                          Histogram::Unit::milliseconds)),
	    addShardLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                            ROCKSDB_ADD_SHARD_LATENCY_HISTOGRAM,
	                                            Histogram::Unit::milliseconds)),
	    removeShardLatency(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                               ROCKSDB_REMOVE_SHARD_LATENCY_HISTOGRAM,
	                                               Histogram::Unit::milliseconds)),
	    writeActionQueueWait(Histogram::getHistogram(SHARDED_ROCKSDB_HISTOGRAM_GROUP,
	                                                 ROCKSDB_WRITE_ACTION_QUEUE_WAIT_HISTOGRAM,
	                                                 Histogram::Unit::milliseconds)) {}

	// Delete copy constructors.
	LatencyMetrics(const LatencyMetrics&) = delete;
	LatencyMetrics& operator=(const LatencyMetrics&) = delete;
};

struct RocksDBMetrics {
	UID debugID;
	std::shared_ptr<ShardedRocksDBState> rState;
	std::shared_ptr<rocksdb::Statistics> stats;
	std::vector<std::tuple<std::string, int, uint64_t>> tickerStats;
	std::vector<std::pair<std::string, std::string>> intPropertyStats;

	RocksDBMetrics(UID debugID, std::shared_ptr<ShardedRocksDBState> rState, std::shared_ptr<rocksdb::Statistics> stats)
	  : debugID(debugID), rState(rState), stats(stats) {
		tickerStats = {
			{ "StallMicros", rocksdb::STALL_MICROS, 0 },
			{ "BytesRead", rocksdb::BYTES_READ, 0 },
			{ "IterBytesRead", rocksdb::ITER_BYTES_READ, 0 },
			{ "BytesWritten", rocksdb::BYTES_WRITTEN, 0 },
			{ "BlockCacheMisses", rocksdb::BLOCK_CACHE_MISS, 0 },
			{ "BlockCacheHits", rocksdb::BLOCK_CACHE_HIT, 0 },
			{ "BloomFilterUseful", rocksdb::BLOOM_FILTER_USEFUL, 0 },
			{ "BloomFilterFullPositive", rocksdb::BLOOM_FILTER_FULL_POSITIVE, 0 },
			{ "BloomFilterTruePositive", rocksdb::BLOOM_FILTER_FULL_TRUE_POSITIVE, 0 },
			// Deprecated in RocksDB 8.0
			// { "BloomFilterMicros", rocksdb::BLOOM_FILTER_MICROS, 0 },
			{ "MemtableHit", rocksdb::MEMTABLE_HIT, 0 },
			{ "MemtableMiss", rocksdb::MEMTABLE_MISS, 0 },
			{ "GetHitL0", rocksdb::GET_HIT_L0, 0 },
			{ "GetHitL1", rocksdb::GET_HIT_L1, 0 },
			{ "GetHitL2AndUp", rocksdb::GET_HIT_L2_AND_UP, 0 },
			{ "CountKeysWritten", rocksdb::NUMBER_KEYS_WRITTEN, 0 },
			{ "CountKeysRead", rocksdb::NUMBER_KEYS_READ, 0 },
			{ "CountDBSeek", rocksdb::NUMBER_DB_SEEK, 0 },
			{ "CountDBNext", rocksdb::NUMBER_DB_NEXT, 0 },
			{ "CountDBPrev", rocksdb::NUMBER_DB_PREV, 0 },
			{ "BloomFilterPrefixChecked", rocksdb::BLOOM_FILTER_PREFIX_CHECKED, 0 },
			{ "BloomFilterPrefixUseful", rocksdb::BLOOM_FILTER_PREFIX_USEFUL, 0 },
			// Deprecated in RocksDB 8.0
			// { "BlockCacheCompressedMiss", rocksdb::BLOCK_CACHE_COMPRESSED_MISS, 0 },
			// { "BlockCacheCompressedHit", rocksdb::BLOCK_CACHE_COMPRESSED_HIT, 0 },
			{ "CountWalFileSyncs", rocksdb::WAL_FILE_SYNCED, 0 },
			{ "CountWalFileBytes", rocksdb::WAL_FILE_BYTES, 0 },
			{ "CompactReadBytes", rocksdb::COMPACT_READ_BYTES, 0 },
			{ "CompactWriteBytes", rocksdb::COMPACT_WRITE_BYTES, 0 },
			{ "FlushWriteBytes", rocksdb::FLUSH_WRITE_BYTES, 0 },
			{ "CountBlocksCompressed", rocksdb::NUMBER_BLOCK_COMPRESSED, 0 },
			{ "CountBlocksDecompressed", rocksdb::NUMBER_BLOCK_DECOMPRESSED, 0 },
			{ "RowCacheHit", rocksdb::ROW_CACHE_HIT, 0 },
			{ "RowCacheMiss", rocksdb::ROW_CACHE_MISS, 0 },
			{ "CountIterSkippedKeys", rocksdb::NUMBER_ITER_SKIP, 0 },
			{ "NoIteratorCreated", rocksdb::NO_ITERATOR_CREATED, 0 },
			{ "NoIteratorDeleted", rocksdb::NO_ITERATOR_DELETED, 0 },

		};

		intPropertyStats = {
			{ "NumImmutableMemtables", rocksdb::DB::Properties::kNumImmutableMemTable },
			{ "NumImmutableMemtablesFlushed", rocksdb::DB::Properties::kNumImmutableMemTableFlushed },
			{ "IsMemtableFlushPending", rocksdb::DB::Properties::kMemTableFlushPending },
			{ "NumRunningFlushes", rocksdb::DB::Properties::kNumRunningFlushes },
			{ "IsCompactionPending", rocksdb::DB::Properties::kCompactionPending },
			{ "NumRunningCompactions", rocksdb::DB::Properties::kNumRunningCompactions },
			{ "CumulativeBackgroundErrors", rocksdb::DB::Properties::kBackgroundErrors },
			{ "CurrentSizeActiveMemtable", rocksdb::DB::Properties::kCurSizeActiveMemTable },
			{ "AllMemtablesBytes", rocksdb::DB::Properties::kCurSizeAllMemTables },
			{ "ActiveMemtableBytes", rocksdb::DB::Properties::kSizeAllMemTables },
			{ "CountEntriesActiveMemtable", rocksdb::DB::Properties::kNumEntriesActiveMemTable },
			{ "CountEntriesImmutMemtables", rocksdb::DB::Properties::kNumEntriesImmMemTables },
			{ "CountDeletesActiveMemtable", rocksdb::DB::Properties::kNumDeletesActiveMemTable },
			{ "CountDeletesImmutMemtables", rocksdb::DB::Properties::kNumDeletesImmMemTables },
			{ "EstimatedCountKeys", rocksdb::DB::Properties::kEstimateNumKeys },
			{ "EstimateSstReaderBytes", rocksdb::DB::Properties::kEstimateTableReadersMem },
			{ "CountActiveSnapshots", rocksdb::DB::Properties::kNumSnapshots },
			{ "OldestSnapshotTime", rocksdb::DB::Properties::kOldestSnapshotTime },
			{ "CountLiveVersions", rocksdb::DB::Properties::kNumLiveVersions },
			{ "EstimateLiveDataSize", rocksdb::DB::Properties::kEstimateLiveDataSize },
			{ "BaseLevel", rocksdb::DB::Properties::kBaseLevel },
			{ "EstPendCompactBytes", rocksdb::DB::Properties::kEstimatePendingCompactionBytes },
			{ "BlockCacheUsage", rocksdb::DB::Properties::kBlockCacheUsage },
			{ "BlockCachePinnedUsage", rocksdb::DB::Properties::kBlockCachePinnedUsage },
			{ "LiveSstFilesSize", rocksdb::DB::Properties::kLiveSstFilesSize },
		};
	}

	std::vector<std::pair<std::string, int64_t>> getManifestBytes(std::string manifestDirectory) {
		std::vector<std::pair<std::string, int64_t>> res;
		std::vector<std::string> returnFiles = platform::listFiles(manifestDirectory, "");
		for (const auto& fileEntry : returnFiles) {
			if (fileEntry.find(manifestFilePrefix) != std::string::npos) {
				int64_t manifestSize = fileSize(manifestDirectory + "/" + fileEntry);
				res.push_back(std::make_pair(fileEntry, manifestSize));
			}
		}
		return res;
	}

	void logStats(rocksdb::DB* db, std::string manifestDirectory) {
		TraceEvent e(SevInfo, "ShardedRocksDBMetrics", debugID);
		uint64_t stat;
		for (auto& [name, ticker, cumulation] : tickerStats) {
			stat = stats->getTickerCount(ticker);
			e.detail(name.c_str(), stat - cumulation);
			cumulation = stat;
		}
		for (auto& [name, property] : intPropertyStats) {
			stat = 0;
			ASSERT(db->GetAggregatedIntProperty(property, &stat));
			e.detail(name.c_str(), stat);
		}

		int64_t manifestBytesTotal = 0;
		auto manifests = getManifestBytes(manifestDirectory);
		int idx = 0;
		for (const auto& [fileName, fileBytes] : manifests) {
			e.detail(format("Manifest-%d", idx), format("%s-%lld", fileName.c_str(), fileBytes));
			manifestBytesTotal += fileBytes;
			idx++;
		}
		e.detail("ManifestBytes", manifestBytesTotal);

		std::string propValue = "";
		ASSERT(db->GetProperty(rocksdb::DB::Properties::kDBWriteStallStats, &propValue));
		TraceEvent(SevInfo, "DBWriteStallStats", debugID).detail("Stats", propValue);

		if (rState->blockCache) {
			e.detail("CacheUsage", rState->blockCache->GetUsage());
		}
	}
};

															#line 3130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via rocksDBAggregatedMetricsLogger()
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class RocksDBAggregatedMetricsLoggerActor>
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RocksDBAggregatedMetricsLoggerActorState {
															#line 3136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RocksDBAggregatedMetricsLoggerActorState(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,std::shared_ptr<RocksDBMetrics> const& rocksDBMetrics,ShardManager* const& shardManager,std::string const& manifestDirectory) 
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : rState(rState),
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   openFuture(openFuture),
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBMetrics(rocksDBMetrics),
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   shardManager(shardManager),
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   manifestDirectory(manifestDirectory)
															#line 3151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~RocksDBAggregatedMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = openFuture;
															#line 2213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 2213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >*>(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)));
															#line 3174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RocksDBAggregatedMetricsLoggerActorState();
		static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RocksDBAggregatedMetricsLoggerActorState(); static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 3203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RocksDBAggregatedMetricsLoggerActorState();
		static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 3216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "ShardedRocksDBMetricsError").errorUnsuppressed(e);
															#line 3220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		db = shardManager->getDb();
															#line 2215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 3238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		db = shardManager->getDb();
															#line 2215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 3249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->ROCKSDB_METRICS_DELAY);
															#line 2216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state = 2;
															#line 2216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >*>(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)));
															#line 3353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 3375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksDBMetrics->logStats(db, manifestDirectory);
															#line 2221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->compactOnRangeDeletionFactory)
															#line 3383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 2222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rState->compactOnRangeDeletionFactory->logMetrics( true);
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 3397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksDBMetrics->logStats(db, manifestDirectory);
															#line 2221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->compactOnRangeDeletionFactory)
															#line 3405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 2222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rState->compactOnRangeDeletionFactory->logMetrics( true);
															#line 3409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<ShardedRocksDBState> rState;
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<Void> openFuture;
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<RocksDBMetrics> rocksDBMetrics;
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardManager* shardManager;
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string manifestDirectory;
															#line 2214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	rocksdb::DB* db;
															#line 3515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via rocksDBAggregatedMetricsLogger()
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RocksDBAggregatedMetricsLoggerActor final : public Actor<Void>, public ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >, public ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >, public FastAllocated<RocksDBAggregatedMetricsLoggerActor>, public RocksDBAggregatedMetricsLoggerActorState<RocksDBAggregatedMetricsLoggerActor> {
															#line 3520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<RocksDBAggregatedMetricsLoggerActor>::operator new;
	using FastAllocated<RocksDBAggregatedMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17637028345551181824UL, 10355868366908233984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >;
friend struct ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >;
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RocksDBAggregatedMetricsLoggerActor(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,std::shared_ptr<RocksDBMetrics> const& rocksDBMetrics,ShardManager* const& shardManager,std::string const& manifestDirectory) 
															#line 3538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   RocksDBAggregatedMetricsLoggerActorState<RocksDBAggregatedMetricsLoggerActor>(rState, openFuture, rocksDBMetrics, shardManager, manifestDirectory),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6628422231030391040UL, 3862822343713249792UL);
		ActorExecutionContextHelper __helper(static_cast<RocksDBAggregatedMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rocksDBAggregatedMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rocksDBAggregatedMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RocksDBAggregatedMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RocksDBAggregatedMetricsLoggerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] Future<Void> rocksDBAggregatedMetricsLogger( std::shared_ptr<ShardedRocksDBState> const& rState, Future<Void> const& openFuture, std::shared_ptr<RocksDBMetrics> const& rocksDBMetrics, ShardManager* const& shardManager, std::string const& manifestDirectory ) {
															#line 2207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new RocksDBAggregatedMetricsLoggerActor(rState, openFuture, rocksDBMetrics, shardManager, manifestDirectory));
															#line 3571 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 2232 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

struct ShardedRocksDBKeyValueStore : IKeyValueStore {
	using CF = rocksdb::ColumnFamilyHandle*;

																#line 3579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via refreshIteratorPool()
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class RefreshIteratorPoolActor>
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RefreshIteratorPoolActorState {
															#line 3585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RefreshIteratorPoolActorState(std::shared_ptr<ShardedRocksDBState> const& rState,std::shared_ptr<IteratorPool> const& iteratorPool,Future<Void> const& readyToStart) 
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : rState(rState),
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   iteratorPool(iteratorPool),
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   readyToStart(readyToStart)
															#line 3596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshIteratorPool", reinterpret_cast<unsigned long>(this));

	}
	~RefreshIteratorPoolActorState() 
	{
		fdb_probe_actor_destroy("refreshIteratorPool", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!SERVER_KNOBS->SHARDED_ROCKSDB_REUSE_ITERATORS)
															#line 3611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (!static_cast<RefreshIteratorPoolActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshIteratorPoolActorState(); static_cast<RefreshIteratorPoolActor*>(this)->destroy(); return 0; }
															#line 3615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				new (&static_cast<RefreshIteratorPoolActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RefreshIteratorPoolActorState();
				static_cast<RefreshIteratorPoolActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			histogram = Histogram::getHistogram( SHARDED_ROCKSDB_HISTOGRAM_GROUP, "TimeSpentRefreshIterators"_sr, Histogram::Unit::milliseconds);
															#line 3623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			try {
															#line 2246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = readyToStart;
															#line 2246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state = 1;
															#line 2246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshIteratorPoolActor, 0, Void >*>(static_cast<RefreshIteratorPoolActor*>(this)));
															#line 3634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshIteratorPoolActorState();
		static_cast<RefreshIteratorPoolActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2263 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<RefreshIteratorPoolActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshIteratorPoolActorState(); static_cast<RefreshIteratorPoolActor*>(this)->destroy(); return 0; }
															#line 3663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<RefreshIteratorPoolActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshIteratorPoolActorState();
		static_cast<RefreshIteratorPoolActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 3676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "RefreshReadIteratorPoolError").errorUnsuppressed(e);
															#line 3680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 3705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state > 0) static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshIteratorPoolActor*>(this)->ActorCallback< RefreshIteratorPoolActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshIteratorPoolActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshIteratorPoolActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshIteratorPoolActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 2248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->ROCKSDB_READ_RANGE_ITERATOR_REFRESH_TIME);
															#line 2248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state = 2;
															#line 2248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RefreshIteratorPoolActor, 1, Void >*>(static_cast<RefreshIteratorPoolActor*>(this)));
															#line 3809 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 3831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		double startTime = timer_monotonic();
															#line 2254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iteratorPool->refresh();
															#line 2255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		histogram->sample(timer_monotonic() - startTime);
															#line 3841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 3850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		double startTime = timer_monotonic();
															#line 2254 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iteratorPool->refresh();
															#line 2255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		histogram->sample(timer_monotonic() - startTime);
															#line 3860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state > 0) static_cast<RefreshIteratorPoolActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshIteratorPoolActor*>(this)->ActorCallback< RefreshIteratorPoolActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshIteratorPoolActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RefreshIteratorPoolActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RefreshIteratorPoolActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<ShardedRocksDBState> rState;
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<IteratorPool> iteratorPool;
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<Void> readyToStart;
															#line 2242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Reference<Histogram> histogram;
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via refreshIteratorPool()
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RefreshIteratorPoolActor final : public Actor<Void>, public ActorCallback< RefreshIteratorPoolActor, 0, Void >, public ActorCallback< RefreshIteratorPoolActor, 1, Void >, public FastAllocated<RefreshIteratorPoolActor>, public RefreshIteratorPoolActorState<RefreshIteratorPoolActor> {
															#line 3966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<RefreshIteratorPoolActor>::operator new;
	using FastAllocated<RefreshIteratorPoolActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9886678335468919808UL, 4891287393913261824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshIteratorPoolActor, 0, Void >;
friend struct ActorCallback< RefreshIteratorPoolActor, 1, Void >;
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RefreshIteratorPoolActor(std::shared_ptr<ShardedRocksDBState> const& rState,std::shared_ptr<IteratorPool> const& iteratorPool,Future<Void> const& readyToStart) 
															#line 3984 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshIteratorPoolActorState<RefreshIteratorPoolActor>(rState, iteratorPool, readyToStart),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshIteratorPool", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7129586268027007232UL, 17946600463862754560UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshIteratorPoolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshIteratorPool");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshIteratorPool", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshIteratorPoolActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RefreshIteratorPoolActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> refreshIteratorPool( std::shared_ptr<ShardedRocksDBState> const& rState, std::shared_ptr<IteratorPool> const& iteratorPool, Future<Void> const& readyToStart ) {
															#line 2236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new RefreshIteratorPoolActor(rState, iteratorPool, readyToStart));
															#line 4017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 2265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

																#line 4022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via refreshRocksDBBackgroundEventCounter()
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class RefreshRocksDBBackgroundEventCounterActor>
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RefreshRocksDBBackgroundEventCounterActorState {
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RefreshRocksDBBackgroundEventCounterActorState(UID const& id,std::shared_ptr<RocksDBEventListener> const& eventListener) 
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : id(id),
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   eventListener(eventListener)
															#line 4037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this));

	}
	~RefreshRocksDBBackgroundEventCounterActorState() 
	{
		fdb_probe_actor_destroy("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!SERVER_KNOBS->LOGGING_ROCKSDB_BG_WORK_WHEN_IO_TIMEOUT && SERVER_KNOBS->LOGGING_ROCKSDB_BG_WORK_PROBABILITY <= 0.0)
															#line 4052 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (!static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshRocksDBBackgroundEventCounterActorState(); static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->destroy(); return 0; }
															#line 4056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				new (&static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RefreshRocksDBBackgroundEventCounterActorState();
				static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 2274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				;
															#line 4065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshRocksDBBackgroundEventCounterActorState();
		static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshRocksDBBackgroundEventCounterActorState(); static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->destroy(); return 0; }
															#line 4094 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshRocksDBBackgroundEventCounterActorState();
		static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "RefreshRocksDBBackgroundEventCounter").errorUnsuppressed(e);
															#line 4111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->LOGGING_ROCKSDB_BG_WORK_PERIOD_SEC);
															#line 2275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->actor_wait_state = 1;
															#line 2275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >*>(static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)));
															#line 4141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		eventListener->logRecentRocksDBBackgroundWorkStats(id);
															#line 2277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		eventListener->resetCounters();
															#line 4152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		eventListener->logRecentRocksDBBackgroundWorkStats(id);
															#line 2277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		eventListener->resetCounters();
															#line 4163 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->actor_wait_state > 0) static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UID id;
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<RocksDBEventListener> eventListener;
															#line 4247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via refreshRocksDBBackgroundEventCounter()
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class RefreshRocksDBBackgroundEventCounterActor final : public Actor<Void>, public ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >, public FastAllocated<RefreshRocksDBBackgroundEventCounterActor>, public RefreshRocksDBBackgroundEventCounterActorState<RefreshRocksDBBackgroundEventCounterActor> {
															#line 4252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<RefreshRocksDBBackgroundEventCounterActor>::operator new;
	using FastAllocated<RefreshRocksDBBackgroundEventCounterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7834082001199202304UL, 13290708766450374912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >;
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RefreshRocksDBBackgroundEventCounterActor(UID const& id,std::shared_ptr<RocksDBEventListener> const& eventListener) 
															#line 4269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshRocksDBBackgroundEventCounterActorState<RefreshRocksDBBackgroundEventCounterActor>(id, eventListener),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8576571371440065024UL, 13505688992341527040UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshRocksDBBackgroundEventCounterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshRocksDBBackgroundEventCounter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshRocksDBBackgroundEventCounter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshRocksDBBackgroundEventCounterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> refreshRocksDBBackgroundEventCounter( UID const& id, std::shared_ptr<RocksDBEventListener> const& eventListener ) {
															#line 2266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new RefreshRocksDBBackgroundEventCounterActor(id, eventListener));
															#line 4301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 2286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

																#line 4306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via doRestore()
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class DoRestoreActor>
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class DoRestoreActorState {
															#line 4312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	DoRestoreActorState(ShardedRocksDBKeyValueStore* const& self,std::string const& shardId,std::vector<KeyRange> const& ranges,std::vector<CheckpointMetaData> const& checkpoints) 
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : self(self),
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   shardId(shardId),
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   ranges(ranges),
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   checkpoints(checkpoints)
															#line 4325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("doRestore", reinterpret_cast<unsigned long>(this));

	}
	~DoRestoreActorState() 
	{
		fdb_probe_actor_destroy("doRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for( const KeyRange& range : ranges ) {
															#line 2292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::vector<DataShard*> shards = self->shardManager.getDataShardsByRange(range);
															#line 2293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (!shards.empty())
															#line 4344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				{
															#line 2294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					TraceEvent te(SevWarnAlways, "RestoreRangesNotEmpty", self->id);
															#line 2295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					te.detail("Range", range);
															#line 2296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					te.detail("RestoreShardID", shardId);
															#line 2297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					for(int i = 0;i < shards.size();++i) {
															#line 2298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
						te.detail("DataShard-" + std::to_string(i), shards[i]->range);
															#line 4356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
					}
															#line 2300 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					te.log();
															#line 2301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
					return a_body1Catch1(failed_to_restore_checkpoint(), loopDepth);
															#line 4362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				}
			}
															#line 2304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for( const KeyRange& range : ranges ) {
															#line 2305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				self->shardManager.addRange(range, shardId, true);
															#line 4369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 2307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			const Severity sevDm = static_cast<Severity>(SERVER_KNOBS->PHYSICAL_SHARD_MOVE_LOG_SEVERITY);
															#line 2308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(sevDm, "ShardedRocksRestoreAddRange", self->id) .detail("Ranges", describe(ranges)) .detail("ShardID", shardId) .detail("Checkpoints", describe(checkpoints));
															#line 2312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			PhysicalShard* ps = self->shardManager.getPhysicalShardForAllRanges(ranges);
															#line 2313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(ps != nullptr);
															#line 2314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto a = new Writer::RestoreAction(&self->shardManager, ps, self->path, shardId, ranges, checkpoints);
															#line 2315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto res = a->done.getFuture();
															#line 2316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->writeThread->post(a);
															#line 4385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			try {
															#line 2319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = res;
															#line 2319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoRestoreActor*>(this)->actor_wait_state = 1;
															#line 2319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 0, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 4396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoRestoreActorState();
		static_cast<DoRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<DoRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoRestoreActorState(); static_cast<DoRestoreActor*>(this)->destroy(); return 0; }
															#line 4425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<DoRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoRestoreActorState();
		static_cast<DoRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 2322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 2324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for( const KeyRange& range : ranges ) {
															#line 2325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				self->shardManager.removeRange(range);
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 2327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardedRocksDBKeyValueStore* self;
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string shardId;
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::vector<CheckpointMetaData> checkpoints;
															#line 4570 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via doRestore()
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class DoRestoreActor final : public Actor<Void>, public ActorCallback< DoRestoreActor, 0, Void >, public FastAllocated<DoRestoreActor>, public DoRestoreActorState<DoRestoreActor> {
															#line 4575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<DoRestoreActor>::operator new;
	using FastAllocated<DoRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7340491506054032128UL, 14234120555972915712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoRestoreActor, 0, Void >;
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	DoRestoreActor(ShardedRocksDBKeyValueStore* const& self,std::string const& shardId,std::vector<KeyRange> const& ranges,std::vector<CheckpointMetaData> const& checkpoints) 
															#line 4592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   DoRestoreActorState<DoRestoreActor>(self, shardId, ranges, checkpoints),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13842767227687580928UL, 16676647617737226496UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoRestoreActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> doRestore( ShardedRocksDBKeyValueStore* const& self, std::string const& shardId, std::vector<KeyRange> const& ranges, std::vector<CheckpointMetaData> const& checkpoints ) {
															#line 2287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new DoRestoreActor(self, shardId, ranges, checkpoints));
															#line 4624 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 2332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	struct CompactionWorker : IThreadPoolReceiver {
		const UID logId;
		explicit CompactionWorker(UID logId) : logId(logId) {}

		void init() override {}
		~CompactionWorker() override {}

		struct CompactShardsAction : TypedAction<CompactionWorker, CompactShardsAction> {
			std::vector<std::shared_ptr<PhysicalShard>> shards;
			std::shared_ptr<PhysicalShard> metadataShard;
			ThreadReturnPromise<Void> done;
			CompactShardsAction(std::vector<std::shared_ptr<PhysicalShard>> shards, PhysicalShard* metadataShard)
			  : shards(shards), metadataShard(metadataShard) {}
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
		};

		void action(CompactShardsAction& a) {
			auto start = now();
			ASSERT(a.metadataShard);
			auto db = a.metadataShard->db;
			int skipped = 0;
			for (auto& shard : a.shards) {
				if (shard->deletePending) {
					++skipped;
					continue;
				}
				std::string value;
				// TODO: Consider load last compaction time during shard init once rocksdb's start time is reduced.
				if (shard->lastCompactionTime <= 0.0) {
					auto s = db->Get(rocksdb::ReadOptions(),
					                 a.metadataShard->cf,
					                 compactionTimestampPrefix.toString() + shard->id,
					                 &value);
					if (s.ok()) {
						auto lastComapction = std::stod(value);
						if (start - lastComapction < SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_PERIOD) {
							shard->lastCompactionTime = lastComapction;
							++skipped;
							continue;
						}
					} else if (!s.IsNotFound()) {
						TraceEvent(SevError, "ShardedRocksDBReadValueError", logId).detail("Description", s.ToString());
						a.done.sendError(internal_error());
						return;
					}
				}

				rocksdb::CompactRangeOptions compactOptions;
				// Force RocksDB to rewrite file to last level.
				compactOptions.bottommost_level_compaction = rocksdb::BottommostLevelCompaction::kForceOptimized;
				shard->db->CompactRange(compactOptions, shard->cf, /*begin=*/nullptr, /*end=*/nullptr);
				shard->db->Put(rocksdb::WriteOptions(),
				               a.metadataShard->cf,
				               compactionTimestampPrefix.toString() + shard->id,
				               std::to_string(start));
				shard->lastCompactionTime = start;
				TraceEvent("ManualCompaction", logId).detail("ShardId", shard->id);
			}

			TraceEvent("CompactionCompleted", logId)
			    .detail("NumShards", a.shards.size())
			    .detail("Skipped", skipped)
			    .detail("Duration", now() - start);
			a.done.send(Void());
		}
	};

	struct Writer : IThreadPoolReceiver {
		const UID logId;
		int threadIndex;
		std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*>* columnFamilyMap;
		std::shared_ptr<LatencyMetrics> latencyMetrics;
		std::shared_ptr<IteratorPool> iteratorPool;
		double sampleStartTime;

		explicit Writer(UID logId,
		                int threadIndex,
		                std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*>* columnFamilyMap,
		                std::shared_ptr<LatencyMetrics> latencyMetrics,
		                std::shared_ptr<IteratorPool> iteratorPool)
		  : logId(logId), threadIndex(threadIndex), columnFamilyMap(columnFamilyMap), latencyMetrics(latencyMetrics),
		    iteratorPool(iteratorPool), sampleStartTime(now()) {
			ASSERT(latencyMetrics);
			ASSERT(iteratorPool);
		}

		~Writer() override {}

		void init() override {}

		struct OpenAction : TypedAction<Writer, OpenAction> {
			ShardManager* shardManager;
			ThreadReturnPromise<Void> done;
			Optional<Future<Void>>& metrics;
			const FlowLock* readLock;
			const FlowLock* fetchLock;

			OpenAction(ShardManager* shardManager,
			           Optional<Future<Void>>& metrics,
			           const FlowLock* readLock,
			           const FlowLock* fetchLock)
			  : shardManager(shardManager), metrics(metrics), readLock(readLock), fetchLock(fetchLock) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
		};

		void action(OpenAction& a) {
			auto status = a.shardManager->init();

			if (!status.ok()) {
				logRocksDBError(status, "Open");
				a.done.sendError(statusToError(status));
				return;
			}

			TraceEvent(SevInfo, "ShardedRocksDB").detail("Method", "Open");
			a.done.send(Void());
		}

		struct AddShardAction : TypedAction<Writer, AddShardAction> {
			PhysicalShard* shard;
			ThreadReturnPromise<Void> done;

			AddShardAction(PhysicalShard* shard) : shard(shard) { ASSERT(shard); }
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
		};

		void action(AddShardAction& a) {
			auto s = a.shard->init();
			if (!s.ok()) {
				TraceEvent(SevError, "AddShardError").detail("Status", s.ToString()).detail("ShardId", a.shard->id);
				a.done.sendError(statusToError(s));
				return;
			}
			ASSERT(a.shard->cf);
			(*columnFamilyMap)[a.shard->cf->GetID()] = a.shard->cf;
			a.done.send(Void());
		}

		struct RemoveShardAction : TypedAction<Writer, RemoveShardAction> {
			std::vector<std::shared_ptr<PhysicalShard>> shards;
			PhysicalShard* metadataShard;
			ThreadReturnPromise<Void> done;

			RemoveShardAction(std::vector<std::shared_ptr<PhysicalShard>>& shards, PhysicalShard* metadataShard)
			  : shards(shards), metadataShard(metadataShard) {}
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
		};

		void action(RemoveShardAction& a) {
			auto start = now();
			for (auto& shard : a.shards) {
				shard->deletePending = true;
				columnFamilyMap->erase(shard->cf->GetID());
				a.metadataShard->db->Delete(
				    rocksdb::WriteOptions(), a.metadataShard->cf, compactionTimestampPrefix.toString() + shard->id);
				iteratorPool->erase(shard->id);
			}
			TraceEvent("RemoveShardTime").detail("Duration", now() - start).detail("Size", a.shards.size());
			a.shards.clear();
			a.done.send(Void());
		}

		struct CommitAction : TypedAction<Writer, CommitAction> {
			rocksdb::DB* db;
			std::unique_ptr<rocksdb::WriteBatch> writeBatch;
			std::unique_ptr<std::set<PhysicalShard*>> dirtyShards;
			const std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*>* columnFamilyMap;
			ThreadReturnPromise<Void> done;
			double startTime;
			bool sample;
			bool logShardMemUsage;
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
			CommitAction(rocksdb::DB* db,
			             std::unique_ptr<rocksdb::WriteBatch> writeBatch,
			             std::unique_ptr<std::set<PhysicalShard*>> dirtyShards,
			             std::unordered_map<uint32_t, rocksdb::ColumnFamilyHandle*>* columnFamilyMap)
			  : db(db), writeBatch(std::move(writeBatch)), dirtyShards(std::move(dirtyShards)),
			    columnFamilyMap(columnFamilyMap), startTime(timer_monotonic()),
			    sample(deterministicRandom()->random01() < SERVER_KNOBS->SHARDED_ROCKSDB_HISTOGRAMS_SAMPLE_RATE
			               ? true
			               : false) {}
		};

		struct DeleteVisitor : public rocksdb::WriteBatch::Handler {
			std::vector<std::pair<uint32_t, KeyRange>>* deletes;

			DeleteVisitor(std::vector<std::pair<uint32_t, KeyRange>>* deletes) : deletes(deletes) { ASSERT(deletes); }

			rocksdb::Status DeleteRangeCF(uint32_t column_family_id,
			                              const rocksdb::Slice& begin,
			                              const rocksdb::Slice& end) override {
				deletes->push_back(
				    std::make_pair(column_family_id, KeyRange(KeyRangeRef(toStringRef(begin), toStringRef(end)))));
				return rocksdb::Status::OK();
			}

			rocksdb::Status PutCF(uint32_t column_family_id,
			                      const rocksdb::Slice& key,
			                      const rocksdb::Slice& value) override {
				return rocksdb::Status::OK();
			}

			rocksdb::Status DeleteCF(uint32_t column_family_id, const rocksdb::Slice& key) override {
				return rocksdb::Status::OK();
			}

			rocksdb::Status SingleDeleteCF(uint32_t column_family_id, const rocksdb::Slice& key) override {
				return rocksdb::Status::OK();
			}

			rocksdb::Status MergeCF(uint32_t column_family_id,
			                        const rocksdb::Slice& key,
			                        const rocksdb::Slice& value) override {
				return rocksdb::Status::OK();
			}
		};

		rocksdb::Status doCommit(rocksdb::WriteBatch* batch,
		                         rocksdb::DB* db,
		                         std::vector<std::pair<uint32_t, KeyRange>>* deletes,
		                         bool sample) {
			if (SERVER_KNOBS->SHARDED_ROCKSDB_SUGGEST_COMPACT_CLEAR_RANGE) {
				DeleteVisitor dv(deletes);
				rocksdb::Status s = batch->Iterate(&dv);
				if (!s.ok()) {
					logRocksDBError(s, "CommitDeleteVisitor");
					return s;
				}

				// If there are any range deletes, we should have added them to be deleted.
				ASSERT(!deletes->empty() || !batch->HasDeleteRange());
			}

			rocksdb::WriteOptions options;
			options.sync = !SERVER_KNOBS->ROCKSDB_UNSAFE_AUTO_FSYNC;

			rocksdb::Status s = db->Write(options, batch);
			if (!s.ok()) {
				logRocksDBError(s, "Commit");
				return s;
			}
			return s;
		}

		void action(CommitAction& a) {
			double commitBeginTime;
			if (a.sample) {
				commitBeginTime = timer_monotonic();
				latencyMetrics->writeActionQueueWait->sampleSeconds(commitBeginTime - a.startTime);
			}
			std::vector<std::pair<uint32_t, KeyRange>> deletes;
			auto s = doCommit(a.writeBatch.get(), a.db, &deletes, a.sample);
			if (!s.ok()) {
				TraceEvent(SevError, "CommitError").detail("Status", s.ToString());
				a.done.sendError(statusToError(s));
				return;
			}

			if (SERVER_KNOBS->SHARDED_ROCKSDB_REUSE_ITERATORS) {
				for (auto shard : *(a.dirtyShards)) {
					iteratorPool->update(shard->id);
				}
			}

			if (SERVER_KNOBS->SHARDED_ROCKSDB_SUGGEST_COMPACT_CLEAR_RANGE) {
				for (const auto& [id, range] : deletes) {
					auto cf = columnFamilyMap->find(id);
					ASSERT(cf != columnFamilyMap->end());
					auto begin = toSlice(range.begin);
					auto end = toSlice(range.end);

					ASSERT(a.db->SuggestCompactRange(cf->second, &begin, &end).ok());
				}
			}

			// Check for number of range deletes in shards.
			// TODO: Disable this once RocksDB is upgraded to a version with range delete improvement.
			if (SERVER_KNOBS->ROCKSDB_CF_RANGE_DELETION_LIMIT > 0) {
				rocksdb::FlushOptions fOptions;
				fOptions.wait = SERVER_KNOBS->ROCKSDB_WAIT_ON_CF_FLUSH;
				fOptions.allow_write_stall = SERVER_KNOBS->SHARDED_ROCKSDB_ALLOW_WRITE_STALL_ON_FLUSH;

				for (auto shard : (*a.dirtyShards)) {
					if (shard->shouldFlush()) {
						TraceEvent("FlushCF")
						    .detail("PhysicalShardId", shard->id)
						    .detail("NumRangeDeletions", shard->numRangeDeletions);
						a.db->Flush(fOptions, shard->cf);
						shard->numRangeDeletions = 0;
					}
				}
			}

			if (a.sample) {
				double currTime = timer_monotonic();
				latencyMetrics->commitLatency->sampleSeconds(currTime - commitBeginTime);
			}

			a.done.send(Void());
		}

		struct CloseAction : TypedAction<Writer, CloseAction> {
			ShardManager* shardManager;
			ThreadReturnPromise<Void> done;
			bool deleteOnClose;
			CloseAction(ShardManager* shardManager, bool deleteOnClose)
			  : shardManager(shardManager), deleteOnClose(deleteOnClose) {}
			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }
		};

		void action(CloseAction& a) {
			if (a.deleteOnClose) {
				a.shardManager->destroyAllShards();
			} else {
				a.shardManager->closeAllShards();
			}
			TraceEvent(SevInfo, "ShardedRocksDB").detail("Method", "Close");
			a.done.send(Void());
		}

		struct CheckpointAction : TypedAction<Writer, CheckpointAction> {
			CheckpointAction(ShardManager* shardManager, const CheckpointRequest& request)
			  : shardManager(shardManager), request(request) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }

			ShardManager* shardManager;
			const CheckpointRequest request;
			ThreadReturnPromise<CheckpointMetaData> reply;
		};

		void action(CheckpointAction& a) {
			TraceEvent(SevInfo, "ShardedRocksCheckpointBegin", logId)
			    .detail("CheckpointID", a.request.checkpointID)
			    .detail("Version", a.request.version)
			    .detail("Ranges", describe(a.request.ranges))
			    .detail("Format", static_cast<int>(a.request.format))
			    .detail("CheckpointDir", a.request.checkpointDir);

			rocksdb::Status s;
			rocksdb::Checkpoint* checkpoint = nullptr;

			PhysicalShard* ps = a.shardManager->getPhysicalShardForAllRanges(a.request.ranges);
			if (ps == nullptr) {
				TraceEvent(SevInfo, "ShardedRocksCheckpointInvalidPhysicalShard", logId)
				    .detail("CheckpointID", a.request.checkpointID)
				    .detail("Version", a.request.version)
				    .detail("Ranges", describe(a.request.ranges))
				    .detail("Format", static_cast<int>(a.request.format))
				    .detail("CheckpointDir", a.request.checkpointDir);
				a.reply.sendError(failed_to_create_checkpoint());
				return;
			}

			TraceEvent(SevDebug, "ShardedRocksCheckpointCF", logId)
			    .detail("CFName", ps->cf->GetName())
			    .detail("CheckpointID", a.request.checkpointID)
			    .detail("Version", a.request.version)
			    .detail("Ranges", describe(a.request.ranges))
			    .detail("PhysicalShardRanges", describe(ps->getAllRanges()))
			    .detail("Format", static_cast<int>(a.request.format))
			    .detail("CheckpointDir", a.request.checkpointDir);

			rocksdb::PinnableSlice value;
			rocksdb::ReadOptions readOptions = getReadOptions();
			s = a.shardManager->getDb()->Get(
			    readOptions, a.shardManager->getSpecialKeysShard()->cf, toSlice(persistVersion), &value);

			if (!s.ok() && !s.IsNotFound()) {
				logRocksDBError(s, "ShardedRocksCheckpointReadPersistVersion");
				a.reply.sendError(failed_to_create_checkpoint());
				return;
			}

			const Version version = s.IsNotFound()
			                            ? latestVersion
			                            : BinaryReader::fromStringRef<Version>(toStringRef(value), Unversioned());

			TraceEvent(SevDebug, "ShardedRocksCheckpointVersion", logId)
			    .detail("CheckpointVersion", a.request.version)
			    .detail("PersistVersion", version);
			ASSERT(a.request.version == version || a.request.version == latestVersion);

			CheckpointMetaData res(a.request.ranges, version, a.request.format, a.request.checkpointID);
			s = rocksdb::Checkpoint::Create(a.shardManager->getDb(), &checkpoint);
			if (!s.ok()) {
				logRocksDBError(s, "CreateRocksDBCheckpoint");
				a.reply.sendError(failed_to_create_checkpoint());
				return;
			}

			const std::string& checkpointDir = abspath(a.request.checkpointDir);
			platform::eraseDirectoryRecursive(checkpointDir);
			if (a.request.format == DataMoveRocksCF) {
				rocksdb::ExportImportFilesMetaData* pMetadata = nullptr;
				s = checkpoint->ExportColumnFamily(ps->cf, checkpointDir, &pMetadata);
				if (!s.ok()) {
					logRocksDBError(s, "CheckpointExportColumnFamily");
					a.reply.sendError(failed_to_create_checkpoint());
					return;
				}

				populateMetaData(&res, pMetadata);
				rocksdb::ExportImportFilesMetaData metadata = *pMetadata;
				delete pMetadata;
				if (!metadata.files.empty() && SERVER_KNOBS->ROCKSDB_ENABLE_CHECKPOINT_VALIDATION) {
					rocksdb::ImportColumnFamilyOptions importOptions;
					importOptions.move_files = false;
					rocksdb::ColumnFamilyHandle* handle{ nullptr };
					const std::string cfName = deterministicRandom()->randomAlphaNumeric(8);
					s = a.shardManager->getDb()->CreateColumnFamilyWithImport(
					    rocksdb::ColumnFamilyOptions(), cfName, importOptions, metadata, &handle);
					if (!s.ok()) {
						TraceEvent(SevError, "ShardedRocksCheckpointValidateImportError", logId)
						    .detail("Status", s.ToString())
						    .detail("CheckpointID", a.request.checkpointID)
						    .detail("Ranges", describe(a.request.ranges))
						    .detail("CheckDir", a.request.checkpointDir)
						    .detail("CheckpointVersion", a.request.version)
						    .detail("PersistVersion", version);
						a.reply.sendError(failed_to_create_checkpoint());
						return;
					}

					auto options = getReadOptions();
					rocksdb::Iterator* oriIter = a.shardManager->getDb()->NewIterator(options, ps->cf);
					rocksdb::Iterator* resIter = a.shardManager->getDb()->NewIterator(options, handle);
					oriIter->SeekToFirst();
					resIter->SeekToFirst();
					while (oriIter->Valid() && resIter->Valid()) {
						if (oriIter->key().compare(resIter->key()) != 0 ||
						    oriIter->value().compare(resIter->value()) != 0) {
							TraceEvent(SevError, "ShardedRocksCheckpointValidateError", logId)
							    .detail("KeyInDB", toStringRef(oriIter->key()))
							    .detail("ValueInDB", toStringRef(oriIter->value()))
							    .detail("KeyInCheckpoint", toStringRef(resIter->key()))
							    .detail("ValueInCheckpoint", toStringRef(resIter->value()));

							a.reply.sendError(failed_to_create_checkpoint());
							return;
						}
						oriIter->Next();
						resIter->Next();
					}
					if (oriIter->Valid() || resIter->Valid()) {
						a.reply.sendError(failed_to_create_checkpoint());
						return;
					}
					delete oriIter;
					delete resIter;

					s = a.shardManager->getDb()->DropColumnFamily(handle);
					if (!s.ok()) {
						logRocksDBError(s, "CheckpointDropColumnFamily");
						a.reply.sendError(failed_to_create_checkpoint());
						return;
					}
					s = a.shardManager->getDb()->DestroyColumnFamilyHandle(handle);
					if (!s.ok()) {
						logRocksDBError(s, "CheckpointDestroyColumnFamily");
						a.reply.sendError(failed_to_create_checkpoint());
						return;
					}
					TraceEvent(SevDebug, "ShardedRocksCheckpointValidateSuccess", logId)
					    .detail("CheckpointVersion", a.request.version)
					    .detail("PersistVersion", version);
				}
			} else {
				if (checkpoint != nullptr) {
					delete checkpoint;
				}
				a.reply.sendError(not_implemented());
				return;
			}

			res.setState(CheckpointMetaData::Complete);
			res.dir = a.request.checkpointDir;
			a.reply.send(res);

			if (checkpoint != nullptr) {
				delete checkpoint;
			}
			TraceEvent(SevInfo, "ShardedRocksCheckpointEnd", logId).detail("Checkpoint", res.toString());
		}

		struct RestoreAction : TypedAction<Writer, RestoreAction> {
			RestoreAction(ShardManager* shardManager,
			              PhysicalShard* ps,
			              const std::string& path,
			              const std::string& shardId,
			              const std::vector<KeyRange>& ranges,
			              const std::vector<CheckpointMetaData>& checkpoints)
			  : shardManager(shardManager), ps(ps), path(path), shardId(shardId), ranges(ranges),
			    checkpoints(checkpoints) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->COMMIT_TIME_ESTIMATE; }

			ShardManager* shardManager;
			PhysicalShard* ps;
			const std::string path;
			const std::string shardId;
			std::vector<KeyRange> ranges;
			std::vector<CheckpointMetaData> checkpoints;
			ThreadReturnPromise<Void> done;
		};

		void action(RestoreAction& a) {
			TraceEvent(SevInfo, "ShardedRocksDBRestoreBegin", logId)
			    .detail("Path", a.path)
			    .detail("Checkpoints", describe(a.checkpoints));

			ASSERT(!a.checkpoints.empty());

			// PhysicalShard* ps = a.shardManager->getPhysicalShardForAllRanges(a.ranges);
			PhysicalShard* ps = a.ps;
			ASSERT(ps != nullptr);

			const CheckpointFormat format = a.checkpoints[0].getFormat();
			for (int i = 1; i < a.checkpoints.size(); ++i) {
				if (a.checkpoints[i].getFormat() != format) {
					throw invalid_checkpoint_format();
				}
			}

			rocksdb::Status status;
			rocksdb::WriteBatch writeBatch(
			    0, // reserved_bytes default:0
			    0, // max_bytes default:0
			    SERVER_KNOBS->ROCKSDB_WRITEBATCH_PROTECTION_BYTES_PER_KEY, // protection_bytes_per_key
			    0 /* default_cf_ts_sz default:0 */);
			rocksdb::WriteOptions options;
			options.sync = !SERVER_KNOBS->ROCKSDB_UNSAFE_AUTO_FSYNC;

			if (format == DataMoveRocksCF) {
				if (a.checkpoints.size() > 1) {
					TraceEvent(SevError, "ShardedRocksDBRestoreMultipleCFs", logId)
					    .detail("Path", a.path)
					    .detail("Checkpoints", describe(a.checkpoints));
					a.done.sendError(failed_to_restore_checkpoint());
					return;
				}
				CheckpointMetaData& checkpoint = a.checkpoints.front();
				std::sort(a.ranges.begin(), a.ranges.end(), KeyRangeRef::ArbitraryOrder());
				std::sort(checkpoint.ranges.begin(), checkpoint.ranges.end(), KeyRangeRef::ArbitraryOrder());
				if (a.ranges.empty() || checkpoint.ranges.empty() || a.ranges.size() > checkpoint.ranges.size() ||
				    a.ranges.front().begin != checkpoint.ranges.front().begin) {
					TraceEvent(SevError, "ShardedRocksDBRestoreFailed", logId)
					    .detail("Path", a.path)
					    .detail("Ranges", describe(a.ranges))
					    .detail("Checkpoints", describe(a.checkpoints));
					a.done.sendError(failed_to_restore_checkpoint());
					return;
				}

				for (int i = 0; i < a.ranges.size(); ++i) {
					if (a.ranges[i] != checkpoint.ranges[i] && i != a.ranges.size() - 1) {
						TraceEvent(SevError, "ShardedRocksDBRestoreFailed", logId)
						    .detail("Path", a.path)
						    .detail("Ranges", describe(a.ranges))
						    .detail("Checkpoints", describe(a.checkpoints));
						a.done.sendError(failed_to_restore_checkpoint());
						return;
					}
				}

				ASSERT(!ps->initialized());
				TraceEvent(SevDebug, "ShardedRocksRestoringCF", logId)
				    .detail("Path", a.path)
				    .detail("Checkpoints", describe(a.checkpoints))
				    .detail("RocksDBCF", getRocksCF(a.checkpoints[0]).toString());

				status = ps->restore(a.checkpoints[0]);

				if (!status.ok()) {
					a.done.sendError(failed_to_restore_checkpoint());
					return;
				} else {
					ASSERT(ps->initialized());
					(*columnFamilyMap)[ps->cf->GetID()] = ps->cf;
					TraceEvent(SevInfo, "RocksDBRestoreCFSuccess", logId)
					    .detail("Path", a.path)
					    .detail("ColumnFaminly", ps->cf->GetName())
					    .detail("Checkpoints", describe(a.checkpoints));

					// Remove the extra data.
					KeyRangeRef cRange(a.ranges.back().end, checkpoint.ranges.back().end);
					if (!cRange.empty()) {
						TraceEvent(SevInfo, "RocksDBRestoreCFRemoveExtraRange", logId)
						    .detail("Path", a.path)
						    .detail("Checkpoints", describe(a.checkpoints))
						    .detail("RestoreRanges", describe(a.ranges))
						    .detail("ClearExtraRange", cRange);
						writeBatch.DeleteRange(ps->cf, toSlice(cRange.begin), toSlice(cRange.end));
						status = a.shardManager->getDb()->Write(options, &writeBatch);
						if (!status.ok()) {
							logRocksDBError(status, "RestoreClearnExtraRanges");
							a.done.sendError(statusToError(status));
							return;
						}
					}
				}
			} else if (format == RocksDBKeyValues) {
				// Make sure the files are complete for the desired ranges.
				std::vector<KeyRange> fetchedRanges;
				std::vector<KeyRange> intendedRanges(a.ranges.begin(), a.ranges.end());
				std::vector<RocksDBCheckpointKeyValues> rkvs;
				for (const auto& checkpoint : a.checkpoints) {
					rkvs.push_back(getRocksKeyValuesCheckpoint(checkpoint));
					ASSERT(!rkvs.back().fetchedFiles.empty());
					for (const auto& file : rkvs.back().fetchedFiles) {
						fetchedRanges.push_back(file.range);
					}
				}
				// Verify that the collective fetchedRanges is the same as the collective intendedRanges.
				std::sort(fetchedRanges.begin(), fetchedRanges.end(), KeyRangeRef::ArbitraryOrder());
				std::sort(intendedRanges.begin(), intendedRanges.end(), KeyRangeRef::ArbitraryOrder());
				int i = 0, j = 0;
				while (i < fetchedRanges.size() && j < intendedRanges.size()) {
					if (fetchedRanges[i].begin != intendedRanges[j].begin) {
						break;
					} else if (fetchedRanges[i] == intendedRanges[j]) {
						++i;
						++j;
					} else if (fetchedRanges[i].contains(intendedRanges[j])) {
						fetchedRanges[i] = KeyRangeRef(intendedRanges[j].end, fetchedRanges[i].end);
						++j;
					} else if (intendedRanges[j].contains(fetchedRanges[i])) {
						intendedRanges[j] = KeyRangeRef(fetchedRanges[i].end, intendedRanges[j].end);
						++i;
					} else {
						break;
					}
				}
				if (i != fetchedRanges.size() || j != intendedRanges.size()) {
					TraceEvent(SevError, "ShardedRocksDBRestoreFailed", logId)
					    .detail("Reason", "RestoreFilesRangesMismatch")
					    .detail("Ranges", describe(a.ranges))
					    .detail("FetchedRanges", describe(fetchedRanges))
					    .detail("IntendedRanges", describe(intendedRanges))
					    .setMaxFieldLength(1000)
					    .detail("FetchedFiles", describe(rkvs));
					a.done.sendError(failed_to_restore_checkpoint());
					return;
				}

				if (!ps->initialized()) {
					TraceEvent(SevDebug, "ShardedRocksRestoreInitPS", logId)
					    .detail("Path", a.path)
					    .detail("Checkpoints", describe(a.checkpoints))
					    .detail("PhysicalShard", ps->toString());
					status = ps->init();
					if (!status.ok()) {
						logRocksDBError(status, "RestoreInitPhysicalShard");
						a.done.sendError(statusToError(status));
						return;
					}
					(*columnFamilyMap)[ps->cf->GetID()] = ps->cf;
				}
				if (!status.ok()) {
					logRocksDBError(status, "RestoreInitPhysicalShard");
					a.done.sendError(statusToError(status));
					return;
				}

				for (const auto& checkpoint : a.checkpoints) {
					status = ps->restore(checkpoint);
					if (!status.ok()) {
						TraceEvent(SevWarnAlways, "ShardedRocksIngestFileError", logId)
						    .detail("Error", status.ToString())
						    .detail("Path", a.path)
						    .detail("Checkpoint", checkpoint.toString())
						    .detail("PhysicalShard", ps->toString());
						break;
					}
				}

				if (!status.ok()) {
					TraceEvent(SevWarnAlways, "ShardedRocksRestoreError", logId).detail("Status", status.ToString());
					for (const auto& range : a.ranges) {
						writeBatch.DeleteRange(ps->cf, toSlice(range.begin), toSlice(range.end));
					}
					TraceEvent(SevInfo, "ShardedRocksRevertRestore", logId)
					    .detail("Path", a.path)
					    .detail("Checkpoints", describe(a.checkpoints))
					    .detail("PhysicalShard", ps->toString())
					    .detail("RestoreRanges", describe(a.ranges));

					rocksdb::Status s = a.shardManager->getDb()->Write(options, &writeBatch);
					if (!s.ok()) {
						TraceEvent(SevError, "ShardedRocksRevertRestoreError", logId)
						    .detail("Error", s.ToString())
						    .detail("Path", a.path)
						    .detail("PhysicalShard", ps->toString())
						    .detail("RestoreRanges", describe(a.ranges));
					}
					a.done.sendError(failed_to_restore_checkpoint());
					return;
				}
			} else if (format == RocksDB) {
				a.done.sendError(not_implemented());
				return;
			}

			TraceEvent(SevInfo, "ShardedRocksDBRestoreEnd", logId)
			    .detail("Path", a.path)
			    .detail("Checkpoints", describe(a.checkpoints));
			a.done.send(Void());
		}
	};

	struct Reader : IThreadPoolReceiver {
		const UID logId;
		double readValueTimeout;
		double readValuePrefixTimeout;
		double readRangeTimeout;
		int threadIndex;
		std::shared_ptr<LatencyMetrics> latencyMetrics;
		std::shared_ptr<IteratorPool> iteratorPool;
		double sampleStartTime;

		explicit Reader(UID logId,
		                int threadIndex,
		                std::shared_ptr<LatencyMetrics> latencyMetrics,
		                std::shared_ptr<IteratorPool> iteratorPool)
		  : logId(logId), readValueTimeout(SERVER_KNOBS->ROCKSDB_READ_VALUE_TIMEOUT),
		    readValuePrefixTimeout(SERVER_KNOBS->ROCKSDB_READ_VALUE_PREFIX_TIMEOUT),
		    readRangeTimeout(SERVER_KNOBS->ROCKSDB_READ_RANGE_TIMEOUT), threadIndex(threadIndex),
		    latencyMetrics(latencyMetrics), iteratorPool(iteratorPool), sampleStartTime(now()) {}

		void init() override {}

		struct ReadValueAction : TypedAction<Reader, ReadValueAction> {
			Key key;
			PhysicalShard* shard;
			ReadType type;
			Optional<UID> debugID;
			double startTime;
			bool sample;
			bool logShardMemUsage;
			ThreadReturnPromise<Optional<Value>> result;

			ReadValueAction(KeyRef key, PhysicalShard* shard, ReadType type, Optional<UID> debugID)
			  : key(key), shard(shard), type(type), debugID(debugID), startTime(timer_monotonic()),
			    sample((deterministicRandom()->random01() < SERVER_KNOBS->SHARDED_ROCKSDB_HISTOGRAMS_SAMPLE_RATE)
			               ? true
			               : false) {}

			double getTimeEstimate() const override { return SERVER_KNOBS->READ_VALUE_TIME_ESTIMATE; }
		};

		void action(ReadValueAction& a) {
			double readBeginTime = timer_monotonic();
			if (a.sample) {
				latencyMetrics->readActionQueueWait->sampleSeconds(readBeginTime - a.startTime);
			}
			Optional<TraceBatch> traceBatch;
			if (a.debugID.present()) {
				traceBatch = { TraceBatch{} };
				traceBatch.get().addEvent("GetValueDebug", a.debugID.get().first(), "Reader.Before");
			}
			if (shouldThrottle(a.type, a.key) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT &&
			    readBeginTime - a.startTime > readValueTimeout) {
				TraceEvent(SevWarn, "ShardedRocksDBError")
				    .detail("Error", "Read value request timedout")
				    .detail("Method", "ReadValueAction")
				    .detail("Timeout value", readValueTimeout);
				if (SERVER_KNOBS->ROCKSDB_RETURN_OVERLOADED_ON_TIMEOUT) {
					a.result.sendError(server_overloaded());
				} else {
					a.result.sendError(key_value_store_deadline_exceeded());
				}
				return;
			}

			rocksdb::PinnableSlice value;
			auto options = getReadOptions();

			auto db = a.shard->db;
			if (shouldThrottle(a.type, a.key) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT) {
				uint64_t deadlineMircos =
				    db->GetEnv()->NowMicros() + (readValueTimeout - (timer_monotonic() - a.startTime)) * 1000000;
				std::chrono::seconds deadlineSeconds(deadlineMircos / 1000000);
				options.deadline = std::chrono::duration_cast<std::chrono::microseconds>(deadlineSeconds);
			}
			auto s = db->Get(options, a.shard->cf, toSlice(a.key), &value);

			if (a.sample) {
				latencyMetrics->readValueLatency->sampleSeconds(timer_monotonic() - a.startTime);
			}

			if (a.debugID.present()) {
				traceBatch.get().addEvent("GetValueDebug", a.debugID.get().first(), "Reader.After");
				traceBatch.get().dump();
			}
			if (s.ok()) {
				a.result.send(Value(toStringRef(value)));
			} else if (s.IsNotFound()) {
				a.result.send(Optional<Value>());
			} else {
				logRocksDBError(s, "ReadValue");
				a.result.sendError(statusToError(s));
			}
		}

		struct ReadValuePrefixAction : TypedAction<Reader, ReadValuePrefixAction> {
			Key key;
			int maxLength;
			PhysicalShard* shard;
			ReadType type;
			Optional<UID> debugID;
			double startTime;
			bool sample;
			bool logShardMemUsage;
			ThreadReturnPromise<Optional<Value>> result;

			ReadValuePrefixAction(Key key, int maxLength, PhysicalShard* shard, ReadType type, Optional<UID> debugID)
			  : key(key), maxLength(maxLength), shard(shard), type(type), debugID(debugID),
			    startTime(timer_monotonic()),
			    sample((deterministicRandom()->random01() < SERVER_KNOBS->SHARDED_ROCKSDB_HISTOGRAMS_SAMPLE_RATE)
			               ? true
			               : false) {};
			double getTimeEstimate() const override { return SERVER_KNOBS->READ_VALUE_TIME_ESTIMATE; }
		};

		void action(ReadValuePrefixAction& a) {
			double readBeginTime = timer_monotonic();
			if (a.sample) {
				latencyMetrics->readActionQueueWait->sampleSeconds(readBeginTime - a.startTime);
			}
			Optional<TraceBatch> traceBatch;
			if (a.debugID.present()) {
				traceBatch = { TraceBatch{} };
				traceBatch.get().addEvent("GetValuePrefixDebug",
				                          a.debugID.get().first(),
				                          "Reader.Before"); //.detail("TaskID", g_network->getCurrentTask());
			}
			if (shouldThrottle(a.type, a.key) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT &&
			    readBeginTime - a.startTime > readValuePrefixTimeout) {
				TraceEvent(SevWarn, "ShardedRocksDBError")
				    .detail("Error", "Read value prefix request timedout")
				    .detail("Method", "ReadValuePrefixAction")
				    .detail("Timeout value", readValuePrefixTimeout);

				if (SERVER_KNOBS->ROCKSDB_RETURN_OVERLOADED_ON_TIMEOUT) {
					a.result.sendError(server_overloaded());
				} else {
					a.result.sendError(key_value_store_deadline_exceeded());
				}
				return;
			}

			rocksdb::PinnableSlice value;
			auto options = getReadOptions();
			auto db = a.shard->db;
			if (shouldThrottle(a.type, a.key) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT) {
				uint64_t deadlineMircos =
				    db->GetEnv()->NowMicros() + (readValuePrefixTimeout - (timer_monotonic() - a.startTime)) * 1000000;
				std::chrono::seconds deadlineSeconds(deadlineMircos / 1000000);
				options.deadline = std::chrono::duration_cast<std::chrono::microseconds>(deadlineSeconds);
			}

			auto s = db->Get(options, a.shard->cf, toSlice(a.key), &value);

			if (a.sample) {
				latencyMetrics->readPrefixLatency->sampleSeconds(timer_monotonic() - readBeginTime);
			}

			if (a.debugID.present()) {
				traceBatch.get().addEvent("GetValuePrefixDebug",
				                          a.debugID.get().first(),
				                          "Reader.After"); //.detail("TaskID", g_network->getCurrentTask());
				traceBatch.get().dump();
			}
			if (s.ok()) {
				a.result.send(Value(StringRef(reinterpret_cast<const uint8_t*>(value.data()),
				                              std::min(value.size(), size_t(a.maxLength)))));
			} else if (s.IsNotFound()) {
				a.result.send(Optional<Value>());
			} else {
				logRocksDBError(s, "ReadValuePrefix");
				a.result.sendError(statusToError(s));
			}
		}

		struct ReadRangeAction : TypedAction<Reader, ReadRangeAction>, FastAllocated<ReadRangeAction> {
			KeyRange keys;
			std::vector<std::pair<PhysicalShard*, KeyRange>> shardRanges;
			int rowLimit, byteLimit;
			ReadType type;
			double startTime;
			bool sample;
			bool logShardMemUsage;
			ThreadReturnPromise<RangeResult> result;
			ReadRangeAction(KeyRange keys, std::vector<DataShard*> shards, int rowLimit, int byteLimit, ReadType type)
			  : keys(keys), rowLimit(rowLimit), byteLimit(byteLimit), type(type), startTime(timer_monotonic()),
			    sample((deterministicRandom()->random01() < SERVER_KNOBS->SHARDED_ROCKSDB_HISTOGRAMS_SAMPLE_RATE)
			               ? true
			               : false) {
				std::set<PhysicalShard*> usedShards;
				for (const DataShard* shard : shards) {
					ASSERT(shard);
					shardRanges.emplace_back(shard->physicalShard, keys & shard->range);
					usedShards.insert(shard->physicalShard);
				}
				if (usedShards.size() != shards.size()) {
					TraceEvent("ReadRangeMetrics")
					    .detail("NumPhysicalShards", usedShards.size())
					    .detail("NumDataShards", shards.size());
				}
			}
			double getTimeEstimate() const override { return SERVER_KNOBS->READ_RANGE_TIME_ESTIMATE; }
		};

		void action(ReadRangeAction& a) {
			double readBeginTime = timer_monotonic();
			if (a.sample) {
				latencyMetrics->readActionQueueWait->sampleSeconds(readBeginTime - a.startTime);
			}
			if (shouldThrottle(a.type, a.keys.begin) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT &&
			    readBeginTime - a.startTime > readRangeTimeout) {
				TraceEvent(SevWarn, "ShardedRocksKVSReadTimeout")
				    .detail("Error", "Read range request timedout")
				    .detail("Method", "ReadRangeAction")
				    .detail("Timeout value", readRangeTimeout);

				if (SERVER_KNOBS->ROCKSDB_RETURN_OVERLOADED_ON_TIMEOUT) {
					a.result.sendError(server_overloaded());
				} else {
					a.result.sendError(key_value_store_deadline_exceeded());
				}
				return;
			}

			int rowLimit = a.rowLimit;
			int byteLimit = a.byteLimit;
			RangeResult result;

			if (rowLimit == 0 || byteLimit == 0) {
				result.more = false;
				a.result.send(result);
				return;
			}
			if (rowLimit < 0) {
				// Reverses the shard order so we could read range in reverse direction.
				std::reverse(a.shardRanges.begin(), a.shardRanges.end());
			}

			// TODO: consider multi-thread reads. It's possible to read multiple shards in parallel. However, the
			// number of rows to read needs to be calculated based on the previous read result. We may read more
			// than we expected when parallel read is used when the previous result is not available. It's unlikely
			// to get to performance improvement when the actual number of rows to read is very small.
			int accumulatedBytes = 0;
			int numShards = 0;
			for (auto& [shard, range] : a.shardRanges) {
				if (shard == nullptr || !shard->initialized()) {
					TraceEvent(SevWarn, "ShardedRocksReadRangeShardNotReady", logId)
					    .detail("Range", range)
					    .detail("Reason", shard == nullptr ? "Not Exist" : "Not Initialized");
					continue;
				}
				auto bytesRead = readRangeInDb(shard, range, rowLimit, byteLimit, &result, iteratorPool);
				if (bytesRead < 0) {
					// Error reading an instance.
					a.result.sendError(internal_error());
					return;
				}
				byteLimit -= bytesRead;
				accumulatedBytes += bytesRead;
				++numShards;
				if (result.size() >= abs(a.rowLimit) || accumulatedBytes >= a.byteLimit) {
					break;
				}

				if (shouldThrottle(a.type, a.keys.begin) && SERVER_KNOBS->ROCKSDB_SET_READ_TIMEOUT &&
				    timer_monotonic() - a.startTime > readRangeTimeout) {
					TraceEvent(SevInfo, "ShardedRocksDBTimeout")
					    .detail("Action", "ReadRange")
					    .detail("ShardsRead", numShards)
					    .detail("BytesRead", accumulatedBytes);

					if (SERVER_KNOBS->ROCKSDB_RETURN_OVERLOADED_ON_TIMEOUT) {
						a.result.sendError(server_overloaded());
					} else {
						a.result.sendError(key_value_store_deadline_exceeded());
					}
					return;
				}
			}

			result.more =
			    (result.size() == a.rowLimit) || (result.size() == -a.rowLimit) || (accumulatedBytes >= a.byteLimit);
			a.result.send(result);

			if (a.sample) {
				double currTime = timer_monotonic();
				latencyMetrics->readRangeLatency->sampleSeconds(currTime - readBeginTime);
			}

			if (a.shardRanges.size() > 1) {
				TraceEvent(SevInfo, "CrossShardRead")
				    .suppressFor(300.0)
				    .detail("ReadRangeShards", a.shardRanges.size());
			}
		}
	};

	// Persist shard mappinng key range should not be in shardMap.
	explicit ShardedRocksDBKeyValueStore(const std::string& path, UID id)
	  : rState(std::make_shared<ShardedRocksDBState>()), path(path), id(id),
	    readSemaphore(SERVER_KNOBS->ROCKSDB_READ_QUEUE_SOFT_MAX),
	    fetchSemaphore(SERVER_KNOBS->ROCKSDB_FETCH_QUEUE_SOFT_MAX),
	    numReadWaiters(SERVER_KNOBS->ROCKSDB_READ_QUEUE_HARD_MAX - SERVER_KNOBS->ROCKSDB_READ_QUEUE_SOFT_MAX),
	    numFetchWaiters(SERVER_KNOBS->ROCKSDB_FETCH_QUEUE_HARD_MAX - SERVER_KNOBS->ROCKSDB_FETCH_QUEUE_SOFT_MAX),
	    errorListener(std::make_shared<RocksDBErrorListener>()),
	    eventListener(std::make_shared<RocksDBEventListener>(id)),
	    errorFuture(forwardError(errorListener->getFuture())), dbOptions(getOptions()),
	    iteratorPool(std::make_shared<IteratorPool>()),
	    shardManager(path, id, rState, dbOptions, errorListener, eventListener, &counters, iteratorPool),
	    rocksDBMetrics(std::make_shared<RocksDBMetrics>(id, rState, dbOptions.statistics)),
	    latencyMetrics(std::make_shared<LatencyMetrics>()) {
		// In simluation, run the reader/writer threads as Coro threads (i.e. in the network thread. The storage
		// engine is still multi-threaded as background compaction threads are still present. Reads/writes to disk
		// will also block the network thread in a way that would be unacceptable in production but is a necessary
		// evil here. When performing the reads in background threads in simulation, the event loop thinks there is
		// no work to do and advances time faster than 1 sec/sec. By the time the blocking read actually finishes,
		// simulation has advanced time by more than 5 seconds, so every read fails with a transaction_too_old
		// error. Doing blocking IO on the main thread solves this issue. There are almost certainly better fixes,
		// but my goal was to get a less invasive change merged first and work on a more realistic version if/when
		// we think that would provide substantially more confidence in the correctness.
		// TODO: Adapt the simulation framework to not advance time quickly when background reads/writes are
		// occurring.
		if (g_network->isSimulated()) {
			TraceEvent(SevDebug, "ShardedRocksDB").detail("Info", "Use Coro threads in simulation.");
			writeThread = CoroThreadPool::createThreadPool();
			compactionThread = CoroThreadPool::createThreadPool();
			readThreads = CoroThreadPool::createThreadPool();
		} else {
			writeThread = createGenericThreadPool(/*stackSize=*/0, SERVER_KNOBS->ROCKSDB_WRITER_THREAD_PRIORITY);
			compactionThread = createGenericThreadPool(0, SERVER_KNOBS->ROCKSDB_COMPACTION_THREAD_PRIORITY);
			readThreads = createGenericThreadPool(/*stackSize=*/0, SERVER_KNOBS->ROCKSDB_READER_THREAD_PRIORITY);
		}
		writeThread->addThread(new Writer(id, 0, shardManager.getColumnFamilyMap(), latencyMetrics, iteratorPool),
		                       "fdb-rocksdb-wr");
		compactionThread->addThread(new CompactionWorker(id), "fdb-rocksdb-cw");
		TraceEvent("ShardedRocksDBReadThreads", id)
		    .detail("KnobRocksDBReadParallelism", SERVER_KNOBS->ROCKSDB_READ_PARALLELISM);
		for (unsigned i = 0; i < SERVER_KNOBS->ROCKSDB_READ_PARALLELISM; ++i) {
			readThreads->addThread(new Reader(id, i, latencyMetrics, iteratorPool), "fdb-rocksdb-re");
		}
	}

	Future<Void> getError() const override { return errorFuture; }

																#line 5683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via doClose()
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class DoCloseActor>
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class DoCloseActorState {
															#line 5689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	DoCloseActorState(ShardedRocksDBKeyValueStore* const& self,bool const& deleteOnClose) 
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : self(self),
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   deleteOnClose(deleteOnClose)
															#line 5698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("doClose", reinterpret_cast<unsigned long>(this));

	}
	~DoCloseActorState() 
	{
		fdb_probe_actor_destroy("doClose", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->rState->closing = true;
															#line 3390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->metrics.reset();
															#line 3391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->refreshHolder.cancel();
															#line 3392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->refreshRocksDBBackgroundWorkHolder.cancel();
															#line 3393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->cleanUpJob.cancel();
															#line 3394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->counterLogger.cancel();
															#line 5723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			try {
															#line 3397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->readThreads->stop();
															#line 3397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 5729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				static_cast<DoCloseActor*>(this)->actor_wait_state = 1;
															#line 3397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 0, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 5733 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DoCloseActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent("CloseKeyValueStore").detail("DeleteKVS", deleteOnClose);
															#line 3403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		self->iteratorPool->clear();
															#line 3404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto a = new Writer::CloseAction(&self->shardManager, deleteOnClose);
															#line 3405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto f = a->done.getFuture();
															#line 3406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		self->writeThread->post(a);
															#line 5769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		try {
															#line 3408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_1 = f;
															#line 3408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 5775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			static_cast<DoCloseActor*>(this)->actor_wait_state = 2;
															#line 3408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 1, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 5779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevError, "ShardedRocksCloseReadThreadError").errorUnsuppressed(e);
															#line 5795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCloseActor*>(this)->actor_wait_state > 0) static_cast<DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<DoCloseActor*>(this)->ActorCallback< DoCloseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCloseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		try {
															#line 3414 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->writeThread->stop();
															#line 3414 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont4Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
															#line 5913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			static_cast<DoCloseActor*>(this)->actor_wait_state = 3;
															#line 3414 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 2, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 5917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevError, "ShardedRocksCloseActionError").errorUnsuppressed(e);
															#line 5933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCloseActor*>(this)->actor_wait_state > 0) static_cast<DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<DoCloseActor*>(this)->ActorCallback< DoCloseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCloseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 3420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (deleteOnClose && directoryExists(self->path))
															#line 6048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevWarn, "DirectoryNotEmpty", self->id).detail("Path", self->path);
															#line 3422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(self->path);
															#line 6054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (self->closePromise.canBeSet())
															#line 6058 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			self->closePromise.send(Void());
															#line 6062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		delete self;
															#line 6066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3417 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevError, "ShardedRocksCloseWriteThreadError").errorUnsuppressed(e);
															#line 6076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->compactionThread->stop();
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
															#line 6093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		static_cast<DoCloseActor*>(this)->actor_wait_state = 4;
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 3, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 6097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->compactionThread->stop();
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
															#line 6108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		static_cast<DoCloseActor*>(this)->actor_wait_state = 4;
															#line 3415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoCloseActor, 3, Void >*>(static_cast<DoCloseActor*>(this)));
															#line 6112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCloseActor*>(this)->actor_wait_state > 0) static_cast<DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<DoCloseActor*>(this)->ActorCallback< DoCloseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCloseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoCloseActor*>(this)->actor_wait_state > 0) static_cast<DoCloseActor*>(this)->actor_wait_state = 0;
		static_cast<DoCloseActor*>(this)->ActorCallback< DoCloseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoCloseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoCloseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		delete static_cast<DoCloseActor*>(this);
															#line 6296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardedRocksDBKeyValueStore* self;
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	bool deleteOnClose;
															#line 6305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via doClose()
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class DoCloseActor final : public Actor<void>, public ActorCallback< DoCloseActor, 0, Void >, public ActorCallback< DoCloseActor, 1, Void >, public ActorCallback< DoCloseActor, 2, Void >, public ActorCallback< DoCloseActor, 3, Void >, public FastAllocated<DoCloseActor>, public DoCloseActorState<DoCloseActor> {
															#line 6310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<DoCloseActor>::operator new;
	using FastAllocated<DoCloseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(666407068461719552UL, 16545068966140514048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DoCloseActor, 0, Void >;
friend struct ActorCallback< DoCloseActor, 1, Void >;
friend struct ActorCallback< DoCloseActor, 2, Void >;
friend struct ActorCallback< DoCloseActor, 3, Void >;
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	DoCloseActor(ShardedRocksDBKeyValueStore* const& self,bool const& deleteOnClose) 
															#line 6330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<void>(),
		   DoCloseActorState<DoCloseActor>(self, deleteOnClose),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doClose", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8249376994020974080UL, 9463511211515355904UL);
		ActorExecutionContextHelper __helper(static_cast<DoCloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doClose");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doClose", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static void doClose( ShardedRocksDBKeyValueStore* const& self, bool const& deleteOnClose ) {
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	new DoCloseActor(self, deleteOnClose);
															#line 6353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3430 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	Future<Void> onClosed() const override { return closePromise.getFuture(); }

	void dispose() override { doClose(this, true); }

	void close() override { doClose(this, false); }

	KeyValueStoreType getType() const override { return KeyValueStoreType(KeyValueStoreType::SSD_SHARDED_ROCKSDB); }

	bool shardAware() const override { return true; }

	Future<Void> init() override {
		if (openFuture.isValid()) {
			return openFuture;
			// Restore durable state if KVS is open. KVS will be re-initialized during rollback. To avoid the cost
			// of opening and closing multiple rocksdb instances, we reconcile the shard map using persist shard
			// mapping data.
		} else {
			auto a = std::make_unique<Writer::OpenAction>(&shardManager, metrics, &readSemaphore, &fetchSemaphore);
			openFuture = a->done.getFuture();
			if (SERVER_KNOBS->ROCKSDB_ENABLE_NONDETERMINISM) {
				this->metrics =
				    ShardManager::shardMetricsLogger(this->rState, openFuture, &shardManager) &&
				    rocksDBAggregatedMetricsLogger(this->rState, openFuture, rocksDBMetrics, &shardManager, this->path);
			}
			this->compactionJob = compactShards(this->rState, openFuture, &shardManager, compactionThread);
			this->refreshHolder = refreshIteratorPool(this->rState, iteratorPool, openFuture);
			this->refreshRocksDBBackgroundWorkHolder =
			    refreshRocksDBBackgroundEventCounter(this->id, this->eventListener);
			this->cleanUpJob = emptyShardCleaner(this->rState, openFuture, &shardManager, writeThread);
			writeThread->post(a.release());
			counterLogger = counters.cc.traceCounters("RocksDBCounters", id, SERVER_KNOBS->ROCKSDB_METRICS_DELAY);
			return openFuture;
		}
	}

	Future<Void> addRange(KeyRangeRef range, std::string id, bool active) override {
		auto shard = shardManager.addRange(range, id, active);
		if (shard->initialized()) {
			return Void();
		}
		auto a = new Writer::AddShardAction(shard);
		Future<Void> res = a->done.getFuture();
		writeThread->post(a);
		return res;
	}

	void markRangeAsActive(KeyRangeRef range) override { shardManager.markRangeAsActive(range); }

	void set(KeyValueRef kv, const Arena*) override {
		shardManager.put(kv.key, kv.value);
		if (SERVER_KNOBS->ROCKSDB_USE_POINT_DELETE_FOR_SYSTEM_KEYS && systemKeys.contains(kv.key)) {
			keysSet.insert(kv.key);
		}
	}

	void clear(KeyRangeRef range, const Arena*) override {
		if (range.singleKeyRange()) {
			shardManager.clear(range.begin);
			keysSet.erase(range.begin);
		} else {
			shardManager.clearRange(range, &keysSet);
		}
	}

	static bool overloaded(const uint64_t estPendCompactBytes) {
		// Rocksdb metadata estPendCompactBytes is not deterministic so we don't use it in simulation. We still want to
		// exercise the overload functionality for test coverage, so we return overloaded = true 5% of the time.
		if (g_network->isSimulated()) {
			return deterministicRandom()->randomInt(0, 100) < 5;
		}
		return estPendCompactBytes > SERVER_KNOBS->ROCKSDB_CAN_COMMIT_COMPACT_BYTES_LIMIT;
	}

	// Checks and waits for few seconds if rocskdb is overloaded.
																#line 6432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via checkRocksdbState()
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class CheckRocksdbStateActor>
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class CheckRocksdbStateActorState {
															#line 6438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	CheckRocksdbStateActorState(rocksdb::DB* const& db) 
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : db(db),
															#line 3506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   estPendCompactBytes(),
															#line 3507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   count(SERVER_KNOBS->ROCKSDB_CAN_COMMIT_DELAY_TIMES_ON_OVERLOAD)
															#line 6449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRocksdbState", reinterpret_cast<unsigned long>(this));

	}
	~CheckRocksdbStateActorState() 
	{
		fdb_probe_actor_destroy("checkRocksdbState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			db->GetAggregatedIntProperty(rocksdb::DB::Properties::kEstimatePendingCompactionBytes, &estPendCompactBytes);
															#line 3509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			;
															#line 6466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRocksdbStateActorState();
		static_cast<CheckRocksdbStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<CheckRocksdbStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckRocksdbStateActorState(); static_cast<CheckRocksdbStateActor*>(this)->destroy(); return 0; }
															#line 6489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<CheckRocksdbStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckRocksdbStateActorState();
		static_cast<CheckRocksdbStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!(count && overloaded(estPendCompactBytes)))
															#line 6508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->ROCKSDB_CAN_COMMIT_DELAY_ON_OVERLOAD);
															#line 3510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<CheckRocksdbStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRocksdbStateActor*>(this)->actor_wait_state = 1;
															#line 3510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRocksdbStateActor, 0, Void >*>(static_cast<CheckRocksdbStateActor*>(this)));
															#line 6521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		count--;
															#line 3512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		db->GetAggregatedIntProperty(rocksdb::DB::Properties::kEstimatePendingCompactionBytes, &estPendCompactBytes);
															#line 6545 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		count--;
															#line 3512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		db->GetAggregatedIntProperty(rocksdb::DB::Properties::kEstimatePendingCompactionBytes, &estPendCompactBytes);
															#line 6556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRocksdbStateActor*>(this)->actor_wait_state > 0) static_cast<CheckRocksdbStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRocksdbStateActor*>(this)->ActorCallback< CheckRocksdbStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRocksdbStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRocksdbStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRocksdbStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRocksdbStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRocksdbStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRocksdbStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRocksdbState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	rocksdb::DB* db;
															#line 3506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	uint64_t estPendCompactBytes;
															#line 3507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	int count;
															#line 6642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via checkRocksdbState()
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class CheckRocksdbStateActor final : public Actor<Void>, public ActorCallback< CheckRocksdbStateActor, 0, Void >, public FastAllocated<CheckRocksdbStateActor>, public CheckRocksdbStateActorState<CheckRocksdbStateActor> {
															#line 6647 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<CheckRocksdbStateActor>::operator new;
	using FastAllocated<CheckRocksdbStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6050616474307848192UL, 13491605889633893376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRocksdbStateActor, 0, Void >;
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	CheckRocksdbStateActor(rocksdb::DB* const& db) 
															#line 6664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRocksdbStateActorState<CheckRocksdbStateActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRocksdbState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12911928222912983808UL, 6268774229734680576UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRocksdbStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRocksdbState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRocksdbState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRocksdbStateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] Future<Void> checkRocksdbState( rocksdb::DB* const& db ) {
															#line 3505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new CheckRocksdbStateActor(db));
															#line 6696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	Future<Void> canCommit() override { return checkRocksdbState(shardManager.getDb()); }

	Future<Void> commit(bool) override {
		auto a = new Writer::CommitAction(shardManager.getDb(),
		                                  shardManager.getWriteBatch(),
		                                  shardManager.getDirtyShards(),
		                                  shardManager.getColumnFamilyMap());
		keysSet.clear();
		auto res = a->done.getFuture();
		writeThread->post(a);
		return res;
	}

	void flushShard(std::string shardId) { return shardManager.flushShard(shardId); }

	void checkWaiters(const FlowLock& semaphore, int maxWaiters) {
		if (semaphore.waiters() > maxWaiters) {
			++counters.immediateThrottle;
			throw server_overloaded();
		}
	}

	// We don't throttle eager reads and reads to the FF keyspace because FDB struggles when those reads fail.
	// Thus far, they have been low enough volume to not cause an issue.
	static bool shouldThrottle(ReadType type, KeyRef key) {
		return type != ReadType::EAGER && !(key.startsWith(systemKeys.begin));
	}

																#line 6729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via read()
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class Action, class ReadActor>
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ReadActorState {
															#line 6735 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ReadActorState(Action* const& action,FlowLock* const& semaphore,IThreadPool* const& pool,Counter* const& counter) 
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : action(action),
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   semaphore(semaphore),
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   pool(pool),
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   counter(counter),
															#line 3549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   a(action)
															#line 6750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActorState() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(semaphore->take(), SERVER_KNOBS->ROCKSDB_READ_QUEUE_WAIT);
															#line 3550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadActor*>(this)->actor_wait_state = 1;
															#line 3550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 0, Optional<Void> >*>(static_cast<ReadActor*>(this)));
															#line 6772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!slot.present())
															#line 6795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++(*counter);
															#line 3553 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			return a_body1Catch1(server_overloaded(), loopDepth);
															#line 6801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		release = FlowLock::Releaser(*semaphore);
															#line 3558 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto fut = a->result.getFuture();
															#line 3559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		pool->post(a.release());
															#line 3560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = fut;
															#line 3560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6813 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadActor*>(this)->actor_wait_state = 2;
															#line 3560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 1, Optional<Value> >*>(static_cast<ReadActor*>(this)));
															#line 6818 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Void> const& __slot,int loopDepth) 
	{
															#line 3550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		slot = __slot;
															#line 6827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Void> && __slot,int loopDepth) 
	{
		slot = std::move(__slot);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& result,int loopDepth) 
	{
															#line 3562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Optional<Value>>::futures) { (void)(result); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 6906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(result);
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && result,int loopDepth) 
	{
															#line 3562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Optional<Value>>::futures) { (void)(result); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 6918 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(result);
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Action* action;
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLock* semaphore;
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IThreadPool* pool;
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Counter* counter;
															#line 3549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unique_ptr<Action> a;
															#line 3550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Optional<Void> slot;
															#line 3556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLock::Releaser release;
															#line 7015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class Action>
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ReadActor final : public Actor<Optional<Value>>, public ActorCallback< ReadActor<Action>, 0, Optional<Void> >, public ActorCallback< ReadActor<Action>, 1, Optional<Value> >, public FastAllocated<ReadActor<Action>>, public ReadActorState<Action, ReadActor<Action>> {
															#line 7022 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<ReadActor<Action>>::operator new;
	using FastAllocated<ReadActor<Action>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12108401404560797696UL, 12060817830962042624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor<Action>, 0, Optional<Void> >;
friend struct ActorCallback< ReadActor<Action>, 1, Optional<Value> >;
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ReadActor(Action* const& action,FlowLock* const& semaphore,IThreadPool* const& pool,Counter* const& counter) 
															#line 7040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   ReadActorState<Action, ReadActor<Action>>(action, semaphore, pool, counter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3377648328873480704UL, 6210503387287458048UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor<Action>, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor<Action>, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class Action>
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> read( Action* const& action, FlowLock* const& semaphore, IThreadPool* const& pool, Counter* const& counter ) {
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Optional<Value>>(new ReadActor<Action>(action, semaphore, pool, counter));
															#line 7075 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	Future<Optional<Value>> readValue(KeyRef key, Optional<ReadOptions> options) override {
		auto* shard = shardManager.getDataShard(key);
		if (shard == nullptr || !shard->physicalShard->initialized()) {
			// TODO: read non-exist system key range should not cause an error.
			TraceEvent(SevWarn, "ShardedRocksDB", this->id)
			    .detail("Detail", "Read non-exist key range")
			    .detail("ReadKey", key);
			return Optional<Value>();
		}

		ReadType type = ReadType::NORMAL;
		Optional<UID> debugID;

		if (options.present()) {
			type = options.get().type;
			debugID = options.get().debugID;
		}

		if (!shouldThrottle(type, key)) {
			auto a = new Reader::ReadValueAction(key, shard->physicalShard, type, debugID);
			auto res = a->result.getFuture();
			readThreads->post(a);
			return res;
		}

		auto& semaphore = (type == ReadType::FETCH) ? fetchSemaphore : readSemaphore;
		int maxWaiters = (type == ReadType::FETCH) ? numFetchWaiters : numReadWaiters;

		checkWaiters(semaphore, maxWaiters);
		auto a = std::make_unique<Reader::ReadValueAction>(key, shard->physicalShard, type, debugID);
		return read(a.release(), &semaphore, readThreads.getPtr(), &counters.failedToAcquire);
	}

	Future<Optional<Value>> readValuePrefix(KeyRef key, int maxLength, Optional<ReadOptions> options) override {
		auto* shard = shardManager.getDataShard(key);
		if (shard == nullptr || !shard->physicalShard->initialized()) {
			// TODO: read non-exist system key range should not cause an error.
			TraceEvent(SevWarn, "ShardedRocksDB", this->id)
			    .detail("Detail", "Read non-exist key range")
			    .detail("ReadKey", key);
			return Optional<Value>();
		}

		ReadType type = ReadType::NORMAL;
		Optional<UID> debugID;

		if (options.present()) {
			type = options.get().type;
			debugID = options.get().debugID;
		}

		if (!shouldThrottle(type, key)) {
			auto a = new Reader::ReadValuePrefixAction(key, maxLength, shard->physicalShard, type, debugID);
			auto res = a->result.getFuture();
			readThreads->post(a);
			return res;
		}

		auto& semaphore = (type == ReadType::FETCH) ? fetchSemaphore : readSemaphore;
		int maxWaiters = (type == ReadType::FETCH) ? numFetchWaiters : numReadWaiters;

		checkWaiters(semaphore, maxWaiters);
		auto a = std::make_unique<Reader::ReadValuePrefixAction>(key, maxLength, shard->physicalShard, type, debugID);
		return read(a.release(), &semaphore, readThreads.getPtr(), &counters.failedToAcquire);
	}

																#line 7146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via read()
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class ReadActor1>
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ReadActor1State {
															#line 7152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ReadActor1State(Reader::ReadRangeAction* const& action,FlowLock* const& semaphore,IThreadPool* const& pool,Counter* const& counter) 
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : action(action),
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   semaphore(semaphore),
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   pool(pool),
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   counter(counter),
															#line 3635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   a(action)
															#line 7167 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActor1State() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(semaphore->take(), SERVER_KNOBS->ROCKSDB_READ_QUEUE_WAIT);
															#line 3636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadActor1*>(this)->actor_wait_state = 1;
															#line 3636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 0, Optional<Void> >*>(static_cast<ReadActor1*>(this)));
															#line 7189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!slot.present())
															#line 7212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++(*counter);
															#line 3639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			return a_body1Catch1(server_overloaded(), loopDepth);
															#line 7218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		release = FlowLock::Releaser(*semaphore);
															#line 3644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto fut = a->result.getFuture();
															#line 3645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		pool->post(a.release());
															#line 3646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Standalone<RangeResultRef>> __when_expr_1 = fut;
															#line 3646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadActor1*>(this)->actor_wait_state = 2;
															#line 3646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >*>(static_cast<ReadActor1*>(this)));
															#line 7235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Void> const& __slot,int loopDepth) 
	{
															#line 3636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		slot = __slot;
															#line 7244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Void> && __slot,int loopDepth) 
	{
		slot = std::move(__slot);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor1*>(this)->actor_wait_state > 0) static_cast<ReadActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadActor1*>(this)->ActorCallback< ReadActor1, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor1, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Standalone<RangeResultRef> const& result,int loopDepth) 
	{
															#line 3648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<ReadActor1*>(this)->SAV<Standalone<RangeResultRef>>::futures) { (void)(result); this->~ReadActor1State(); static_cast<ReadActor1*>(this)->destroy(); return 0; }
															#line 7323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<ReadActor1*>(this)->SAV< Standalone<RangeResultRef> >::value()) Standalone<RangeResultRef>(result);
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<RangeResultRef> && result,int loopDepth) 
	{
															#line 3648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<ReadActor1*>(this)->SAV<Standalone<RangeResultRef>>::futures) { (void)(result); this->~ReadActor1State(); static_cast<ReadActor1*>(this)->destroy(); return 0; }
															#line 7335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<ReadActor1*>(this)->SAV< Standalone<RangeResultRef> >::value()) Standalone<RangeResultRef>(result);
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<RangeResultRef> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<RangeResultRef> && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor1*>(this)->actor_wait_state > 0) static_cast<ReadActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadActor1*>(this)->ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Reader::ReadRangeAction* action;
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLock* semaphore;
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IThreadPool* pool;
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Counter* counter;
															#line 3635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unique_ptr<Reader::ReadRangeAction> a;
															#line 3636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Optional<Void> slot;
															#line 3642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowLock::Releaser release;
															#line 7432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class ReadActor1 final : public Actor<Standalone<RangeResultRef>>, public ActorCallback< ReadActor1, 0, Optional<Void> >, public ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >, public FastAllocated<ReadActor1>, public ReadActor1State<ReadActor1> {
															#line 7437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<ReadActor1>::operator new;
	using FastAllocated<ReadActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12108401404560797696UL, 12060817830962042624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<RangeResultRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor1, 0, Optional<Void> >;
friend struct ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >;
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ReadActor1(Reader::ReadRangeAction* const& action,FlowLock* const& semaphore,IThreadPool* const& pool,Counter* const& counter) 
															#line 7455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Standalone<RangeResultRef>>(),
		   ReadActor1State<ReadActor1>(action, semaphore, pool, counter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13045688915661361920UL, 7552795543224692992UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor1, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor1, 1, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Standalone<RangeResultRef>> read( Reader::ReadRangeAction* const& action, FlowLock* const& semaphore, IThreadPool* const& pool, Counter* const& counter ) {
															#line 3631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Standalone<RangeResultRef>>(new ReadActor1(action, semaphore, pool, counter));
															#line 7488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	Future<RangeResult> readRange(KeyRangeRef keys,
	                              int rowLimit,
	                              int byteLimit,
	                              Optional<ReadOptions> options = Optional<ReadOptions>()) override {
		TraceEvent(SevVerbose, "ShardedRocksReadRangeBegin", this->id).detail("Range", keys);
		auto shards = shardManager.getDataShardsByRange(keys);

		ReadType type = ReadType::NORMAL;
		if (options.present()) {
			type = options.get().type;
		}

		if (!shouldThrottle(type, keys.begin)) {
			auto a = new Reader::ReadRangeAction(keys, shards, rowLimit, byteLimit, type);
			auto res = a->result.getFuture();
			readThreads->post(a);
			return res;
		}

		auto& semaphore = (type == ReadType::FETCH) ? fetchSemaphore : readSemaphore;
		int maxWaiters = (type == ReadType::FETCH) ? numFetchWaiters : numReadWaiters;
		checkWaiters(semaphore, maxWaiters);

		auto a = std::make_unique<Reader::ReadRangeAction>(keys, shards, rowLimit, byteLimit, type);
		return read(a.release(), &semaphore, readThreads.getPtr(), &counters.failedToAcquire);
	}

	static bool shouldCompactShard(const std::shared_ptr<PhysicalShard> shard,
	                               const uint64_t liveDataSize,
	                               const size_t fileCount) {
		// Rocksdb metadata kEstimateLiveDataSize and cfMetadata.file_count is not deterministic so we don't
		// use it in simulation. We still want to exercise the compact shard functionality for test coverage, so we
		// return shouldCompactShard = true 25% of the time.
		if (g_network->isSimulated()) {
			return deterministicRandom()->randomInt(0, 100) < 25;
		}
		if (fileCount <= 5) {
			return false;
		}
		if (liveDataSize / fileCount >= SERVER_KNOBS->SHARDED_ROCKSDB_AVERAGE_FILE_SIZE) {
			return false;
		}
		return true;
	}

																#line 7538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via compactShards()
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class CompactShardsActor>
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class CompactShardsActorState {
															#line 7544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	CompactShardsActorState(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager,Reference<IThreadPool> const& thread) 
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : rState(rState),
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   openFuture(openFuture),
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   shardManager(shardManager),
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   thread(thread)
															#line 7557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("compactShards", reinterpret_cast<unsigned long>(this));

	}
	~CompactShardsActorState() 
	{
		fdb_probe_actor_destroy("compactShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = openFuture;
															#line 3701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<CompactShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CompactShardsActor*>(this)->actor_wait_state = 1;
															#line 3701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompactShardsActor, 0, Void >*>(static_cast<CompactShardsActor*>(this)));
															#line 7580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompactShardsActorState();
		static_cast<CompactShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3757 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<CompactShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactShardsActorState(); static_cast<CompactShardsActor*>(this)->destroy(); return 0; }
															#line 7609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<CompactShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactShardsActorState();
		static_cast<CompactShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 7622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 3754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "ShardedRocksDBCompactionActorError").errorUnsuppressed(e);
															#line 7626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		physicalShards = shardManager->getAllShards();
															#line 3704 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 7644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		physicalShards = shardManager->getAllShards();
															#line 3704 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 7655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompactShardsActor*>(this)->actor_wait_state > 0) static_cast<CompactShardsActor*>(this)->actor_wait_state = 0;
		static_cast<CompactShardsActor*>(this)->ActorCallback< CompactShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompactShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 3705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 7752 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_ACTOR_DELAY);
															#line 3708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<CompactShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7760 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CompactShardsActor*>(this)->actor_wait_state = 2;
															#line 3708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompactShardsActor, 1, Void >*>(static_cast<CompactShardsActor*>(this)));
															#line 7765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3709 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		int count = 0;
															#line 3710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		double start = now();
															#line 3711 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<std::shared_ptr<PhysicalShard>> shards;
															#line 3712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( auto& [id, shard] : *physicalShards ) {
															#line 3713 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (count > SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_SHARD_LIMIT)
															#line 7795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				break;
			}
															#line 3716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shard->initialized() || shard->deletePending)
															#line 7801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (shard->lastCompactionTime > 0.0 && start - shard->lastCompactionTime < SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_PERIOD)
															#line 7807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			uint64_t liveDataSize = 0;
															#line 3725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(shard->db->GetIntProperty( shard->cf, rocksdb::DB::Properties::kEstimateLiveDataSize, &liveDataSize));
															#line 3727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdb::ColumnFamilyMetaData cfMetadata;
															#line 3728 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shard->db->GetColumnFamilyMetaData(shard->cf, &cfMetadata);
															#line 3730 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shouldCompactShard(shard, liveDataSize, cfMetadata.file_count))
															#line 7821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shards.push_back(shard);
															#line 3736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent("CompactionScheduled") .detail("ShardId", id) .detail("NumFiles", cfMetadata.file_count) .detail("ShardSize", liveDataSize);
															#line 3740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++count;
															#line 7831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3743 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (shards.size() > 0)
															#line 7835 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto a = new CompactionWorker::CompactShardsAction(shards, shardManager->getMetaDataShard());
															#line 3745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto res = a->done.getFuture();
															#line 3746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			thread->post(a);
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = res;
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<CompactShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactShardsActor*>(this)->actor_wait_state = 3;
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactShardsActor, 2, Void >*>(static_cast<CompactShardsActor*>(this)));
															#line 7852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 3749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent("CompactionSkipped").detail("Reason", "NoCandidate");
															#line 7859 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3709 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		int count = 0;
															#line 3710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		double start = now();
															#line 3711 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<std::shared_ptr<PhysicalShard>> shards;
															#line 3712 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( auto& [id, shard] : *physicalShards ) {
															#line 3713 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (count > SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_SHARD_LIMIT)
															#line 7877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				break;
			}
															#line 3716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shard->initialized() || shard->deletePending)
															#line 7883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (shard->lastCompactionTime > 0.0 && start - shard->lastCompactionTime < SERVER_KNOBS->SHARDED_ROCKSDB_COMPACTION_PERIOD)
															#line 7889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3724 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			uint64_t liveDataSize = 0;
															#line 3725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(shard->db->GetIntProperty( shard->cf, rocksdb::DB::Properties::kEstimateLiveDataSize, &liveDataSize));
															#line 3727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdb::ColumnFamilyMetaData cfMetadata;
															#line 3728 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shard->db->GetColumnFamilyMetaData(shard->cf, &cfMetadata);
															#line 3730 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (!shouldCompactShard(shard, liveDataSize, cfMetadata.file_count))
															#line 7903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
				continue;
			}
															#line 3734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shards.push_back(shard);
															#line 3736 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent("CompactionScheduled") .detail("ShardId", id) .detail("NumFiles", cfMetadata.file_count) .detail("ShardSize", liveDataSize);
															#line 3740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++count;
															#line 7913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3743 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (shards.size() > 0)
															#line 7917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3744 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto a = new CompactionWorker::CompactShardsAction(shards, shardManager->getMetaDataShard());
															#line 3745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto res = a->done.getFuture();
															#line 3746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			thread->post(a);
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = res;
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<CompactShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactShardsActor*>(this)->actor_wait_state = 3;
															#line 3747 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactShardsActor, 2, Void >*>(static_cast<CompactShardsActor*>(this)));
															#line 7934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 3749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent("CompactionSkipped").detail("Reason", "NoCandidate");
															#line 7941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompactShardsActor*>(this)->actor_wait_state > 0) static_cast<CompactShardsActor*>(this)->actor_wait_state = 0;
		static_cast<CompactShardsActor*>(this)->ActorCallback< CompactShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompactShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CompactShardsActor*>(this)->actor_wait_state > 0) static_cast<CompactShardsActor*>(this)->actor_wait_state = 0;
		static_cast<CompactShardsActor*>(this)->ActorCallback< CompactShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CompactShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CompactShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<ShardedRocksDBState> rState;
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<Void> openFuture;
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardManager* shardManager;
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Reference<IThreadPool> thread;
															#line 3702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unordered_map<std::string, std::shared_ptr<PhysicalShard>>* physicalShards;
															#line 8138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via compactShards()
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class CompactShardsActor final : public Actor<Void>, public ActorCallback< CompactShardsActor, 0, Void >, public ActorCallback< CompactShardsActor, 1, Void >, public ActorCallback< CompactShardsActor, 2, Void >, public FastAllocated<CompactShardsActor>, public CompactShardsActorState<CompactShardsActor> {
															#line 8143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<CompactShardsActor>::operator new;
	using FastAllocated<CompactShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11164144670123511296UL, 15676716255505480448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompactShardsActor, 0, Void >;
friend struct ActorCallback< CompactShardsActor, 1, Void >;
friend struct ActorCallback< CompactShardsActor, 2, Void >;
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	CompactShardsActor(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager,Reference<IThreadPool> const& thread) 
															#line 8162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   CompactShardsActorState<CompactShardsActor>(rState, openFuture, shardManager, thread),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compactShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2031939593118641920UL, 12652109280430447104UL);
		ActorExecutionContextHelper __helper(static_cast<CompactShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compactShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compactShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompactShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompactShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CompactShardsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> compactShards( std::shared_ptr<ShardedRocksDBState> const& rState, Future<Void> const& openFuture, ShardManager* const& shardManager, Reference<IThreadPool> const& thread ) {
															#line 3696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new CompactShardsActor(rState, openFuture, shardManager, thread));
															#line 8196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
																#line 8200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via emptyShardCleaner()
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class EmptyShardCleanerActor>
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class EmptyShardCleanerActorState {
															#line 8206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	EmptyShardCleanerActorState(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager,Reference<IThreadPool> const& writeThread) 
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : rState(rState),
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   openFuture(openFuture),
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   shardManager(shardManager),
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   writeThread(writeThread),
															#line 3763 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   cleanUpDelay(SERVER_KNOBS->ROCKSDB_PHYSICAL_SHARD_CLEAN_UP_DELAY),
															#line 3764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   cleanUpPeriod(cleanUpDelay * 2)
															#line 8223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("emptyShardCleaner", reinterpret_cast<unsigned long>(this));

	}
	~EmptyShardCleanerActorState() 
	{
		fdb_probe_actor_destroy("emptyShardCleaner", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				StrictFuture<Void> __when_expr_0 = openFuture;
															#line 3766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8241 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 1;
															#line 3766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EmptyShardCleanerActor, 0, Void >*>(static_cast<EmptyShardCleanerActor*>(this)));
															#line 8246 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EmptyShardCleanerActorState();
		static_cast<EmptyShardCleanerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3786 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<EmptyShardCleanerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EmptyShardCleanerActorState(); static_cast<EmptyShardCleanerActor*>(this)->destroy(); return 0; }
															#line 8275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<EmptyShardCleanerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EmptyShardCleanerActorState();
		static_cast<EmptyShardCleanerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3782 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 8288 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			{
															#line 3783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				TraceEvent(SevError, "DeleteEmptyShardsError").errorUnsuppressed(e);
															#line 8292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 8308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3767 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 8317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state > 0) static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<EmptyShardCleanerActor*>(this)->ActorCallback< EmptyShardCleanerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EmptyShardCleanerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 3768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(cleanUpPeriod);
															#line 3768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8416 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 2;
															#line 3768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EmptyShardCleanerActor, 1, Void >*>(static_cast<EmptyShardCleanerActor*>(this)));
															#line 8421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 8443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto shards = shardManager->getPendingDeletionShards(cleanUpDelay);
															#line 3773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (shards.size() > 0)
															#line 8451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3774 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto a = new Writer::RemoveShardAction(shards, shardManager->getMetaDataShard());
															#line 3775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> f = a->done.getFuture();
															#line 3776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			writeThread->post(a);
															#line 3777 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevInfo, "ShardedRocksDB").detail("DeleteEmptyShards", shards.size());
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = f;
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 3;
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EmptyShardCleanerActor, 2, Void >*>(static_cast<EmptyShardCleanerActor*>(this)));
															#line 8470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3769 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (rState->closing)
															#line 8484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto shards = shardManager->getPendingDeletionShards(cleanUpDelay);
															#line 3773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (shards.size() > 0)
															#line 8492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3774 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto a = new Writer::RemoveShardAction(shards, shardManager->getMetaDataShard());
															#line 3775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> f = a->done.getFuture();
															#line 3776 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			writeThread->post(a);
															#line 3777 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevInfo, "ShardedRocksDB").detail("DeleteEmptyShards", shards.size());
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = f;
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 3;
															#line 3778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EmptyShardCleanerActor, 2, Void >*>(static_cast<EmptyShardCleanerActor*>(this)));
															#line 8511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state > 0) static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<EmptyShardCleanerActor*>(this)->ActorCallback< EmptyShardCleanerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EmptyShardCleanerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state > 0) static_cast<EmptyShardCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<EmptyShardCleanerActor*>(this)->ActorCallback< EmptyShardCleanerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EmptyShardCleanerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EmptyShardCleanerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::shared_ptr<ShardedRocksDBState> rState;
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Future<Void> openFuture;
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardManager* shardManager;
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Reference<IThreadPool> writeThread;
															#line 3763 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	double cleanUpDelay;
															#line 3764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	double cleanUpPeriod;
															#line 8714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via emptyShardCleaner()
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class EmptyShardCleanerActor final : public Actor<Void>, public ActorCallback< EmptyShardCleanerActor, 0, Void >, public ActorCallback< EmptyShardCleanerActor, 1, Void >, public ActorCallback< EmptyShardCleanerActor, 2, Void >, public FastAllocated<EmptyShardCleanerActor>, public EmptyShardCleanerActorState<EmptyShardCleanerActor> {
															#line 8719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<EmptyShardCleanerActor>::operator new;
	using FastAllocated<EmptyShardCleanerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8789752991118837760UL, 5551007499541535232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EmptyShardCleanerActor, 0, Void >;
friend struct ActorCallback< EmptyShardCleanerActor, 1, Void >;
friend struct ActorCallback< EmptyShardCleanerActor, 2, Void >;
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	EmptyShardCleanerActor(std::shared_ptr<ShardedRocksDBState> const& rState,Future<Void> const& openFuture,ShardManager* const& shardManager,Reference<IThreadPool> const& writeThread) 
															#line 8738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   EmptyShardCleanerActorState<EmptyShardCleanerActor>(rState, openFuture, shardManager, writeThread),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyShardCleaner", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9035935868287286272UL, 16468063220071461632UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyShardCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyShardCleaner");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyShardCleaner", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EmptyShardCleanerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EmptyShardCleanerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EmptyShardCleanerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] static Future<Void> emptyShardCleaner( std::shared_ptr<ShardedRocksDBState> const& rState, Future<Void> const& openFuture, ShardManager* const& shardManager, Reference<IThreadPool> const& writeThread ) {
															#line 3759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new EmptyShardCleanerActor(rState, openFuture, shardManager, writeThread));
															#line 8772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

	StorageBytes getStorageBytes() const override {
		uint64_t live = 0;
		ASSERT(shardManager.getDb()->GetAggregatedIntProperty(rocksdb::DB::Properties::kLiveSstFilesSize, &live));

		int64_t free;
		int64_t total;
		g_network->getDiskBytes(path, free, total);

		// Rocksdb metadata kLiveSstFilesSize is not deterministic so don't rely on it for simulation. Instead, we pick
		// a sane value that is deterministically random.
		if (g_network->isSimulated()) {
			live = (total - free) * deterministicRandom()->random01();
		}

		return StorageBytes(free, total, live, free);
	}

	Future<CheckpointMetaData> checkpoint(const CheckpointRequest& request) override {
		// ShardedRocks with checkpoint is known to be non-deterministic
		// so setting noUnseed=true. See https://github.com/apple/foundationdb/pull/11841
		// for more context.
		if (g_network->isSimulated() && !noUnseed) {
			noUnseed = true;
		}
		auto a = new Writer::CheckpointAction(&shardManager, request);

		auto res = a->reply.getFuture();
		writeThread->post(a);
		return res;
	}

	Future<Void> restore(const std::string& shardId,
	                     const std::vector<KeyRange>& ranges,
	                     const std::vector<CheckpointMetaData>& checkpoints) override {
		return doRestore(this, shardId, ranges, checkpoints);
	}

	std::vector<std::string> removeRange(KeyRangeRef range) override { return shardManager.removeRange(range); }

	void persistRangeMapping(KeyRangeRef range, bool isAdd) override {
		return shardManager.persistRangeMapping(range, isAdd);
	}

	// Used for debugging shard mapping issue.
	std::vector<std::pair<KeyRange, std::string>> getDataMapping() { return shardManager.getDataMapping(); }

	Future<EncryptionAtRestMode> encryptionMode() override {
		return EncryptionAtRestMode(EncryptionAtRestMode::DISABLED);
	}

	CoalescedKeyRangeMap<std::string> getExistingRanges() override { return shardManager.getExistingRanges(); }

	void logRecentRocksDBBackgroundWorkStats(UID ssId, std::string logReason) override {
		return eventListener->logRecentRocksDBBackgroundWorkStats(ssId, logReason);
	}

	std::shared_ptr<ShardedRocksDBState> rState;
	rocksdb::DBOptions dbOptions;
	std::shared_ptr<RocksDBErrorListener> errorListener;
	std::shared_ptr<RocksDBEventListener> eventListener;
	std::shared_ptr<IteratorPool> iteratorPool;
	ShardManager shardManager;
	std::shared_ptr<RocksDBMetrics> rocksDBMetrics;
	std::shared_ptr<LatencyMetrics> latencyMetrics;
	std::string path;
	UID id;
	std::set<Key> keysSet;
	Reference<IThreadPool> writeThread;
	Reference<IThreadPool> compactionThread;
	Reference<IThreadPool> readThreads;
	Future<Void> errorFuture;
	Promise<Void> closePromise;
	Future<Void> openFuture;
	Optional<Future<Void>> metrics;
	FlowLock readSemaphore;
	int numReadWaiters;
	FlowLock fetchSemaphore;
	int numFetchWaiters;
	Counters counters;
	Future<Void> compactionJob;
	Future<Void> refreshHolder;
	Future<Void> refreshRocksDBBackgroundWorkHolder;
	Future<Void> cleanUpJob;
	Future<Void> counterLogger;
};

															#line 8863 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via testCheckpointRestore()
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class TestCheckpointRestoreActor>
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class TestCheckpointRestoreActorState {
															#line 8869 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	TestCheckpointRestoreActorState(IKeyValueStore* const& kvStore,std::vector<KeyRange> const& ranges) 
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : kvStore(kvStore),
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   ranges(ranges),
															#line 3876 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   checkpointDir("checkpoint" + deterministicRandom()->randomAlphaNumeric(5))
															#line 8880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("testCheckpointRestore", reinterpret_cast<unsigned long>(this));

	}
	~TestCheckpointRestoreActorState() 
	{
		fdb_probe_actor_destroy("testCheckpointRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(checkpointDir);
															#line 3878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			CheckpointRequest request( latestVersion, ranges, DataMoveRocksCF, deterministicRandom()->randomUniqueID(), checkpointDir);
															#line 3880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<CheckpointMetaData> __when_expr_0 = kvStore->checkpoint(request);
															#line 3880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 1;
															#line 3880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 8906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCheckpointRestoreActorState();
		static_cast<TestCheckpointRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3881 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		RocksDBColumnFamilyCheckpoint rocksCF = getRocksCF(checkpoint);
															#line 3883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent(SevDebug, "ShardedRocksCheckpointTest") .detail("Checkpoint", checkpoint.toString()) .detail("ColumnFamily", rocksCF.toString());
															#line 3887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksDBRestoreDir = "sharded-rocks-restore" + deterministicRandom()->randomAlphaNumeric(5);
															#line 3888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBRestoreDir);
															#line 3889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		restoreKv = keyValueStoreShardedRocksDB( rocksDBRestoreDir, deterministicRandom()->randomUniqueID(), KeyValueStoreType::SSD_SHARDED_ROCKSDB);
															#line 3891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = restoreKv->init();
															#line 3891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 2;
															#line 3891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 1, Void >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 8946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(CheckpointMetaData const& __checkpoint,int loopDepth) 
	{
															#line 3880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		checkpoint = __checkpoint;
															#line 8955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(CheckpointMetaData && __checkpoint,int loopDepth) 
	{
		checkpoint = std::move(__checkpoint);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >*,CheckpointMetaData const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >*,CheckpointMetaData && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		try {
															#line 3893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			const std::string shardId = "restoredShard";
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = restoreKv->restore(shardId, ranges, { checkpoint });
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 9039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 3;
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 2, Void >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 9044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		try {
															#line 3893 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			const std::string shardId = "restoredShard";
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = restoreKv->restore(shardId, ranges, { checkpoint });
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 9064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 3;
															#line 3894 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 2, Void >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 9069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		i = 0;
															#line 3903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		;
															#line 9161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevWarnAlways, "TestRestoreCheckpointError") .errorUnsuppressed(e) .detail("Checkpoint", checkpoint.toString());
															#line 3899 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 3919 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> restoreKvClose = restoreKv->onClosed();
															#line 3920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		restoreKv->close();
															#line 3921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = restoreKvClose;
															#line 3921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 6;
															#line 3921 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 5, Void >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 9298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 3903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!(i < ranges.size()))
															#line 9314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = restoreKv->readRange(ranges[i]);
															#line 3904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 4;
															#line 3904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 9327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 3905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = kvStore->readRange(ranges[i]);
															#line 3905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 5;
															#line 3905 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >*>(static_cast<TestCheckpointRestoreActor*>(this)));
															#line 9356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(RangeResult const& __restoreResult,int loopDepth) 
	{
															#line 3904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		restoreResult = __restoreResult;
															#line 9365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(RangeResult && __restoreResult,int loopDepth) 
	{
		restoreResult = std::move(__restoreResult);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont3(RangeResult const& result,int loopDepth) 
	{
															#line 3906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!restoreResult.more && !result.more);
															#line 3907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(restoreResult.size() == result.size());
															#line 3908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 3909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevDebug, "ReadKeyValueFromRestoredRocks") .detail("Key", result[i].key) .detail("Value", result[i].value) .detail("RestoreKey", restoreResult[i].key) .detail("RestoreValue", restoreResult[i].value);
															#line 3914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i].key == restoreResult[i].key);
															#line 3915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i].value == restoreResult[i].value);
															#line 9454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		++i;
															#line 9458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(RangeResult && result,int loopDepth) 
	{
															#line 3906 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!restoreResult.more && !result.more);
															#line 3907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(restoreResult.size() == result.size());
															#line 3908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 3909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			TraceEvent(SevDebug, "ReadKeyValueFromRestoredRocks") .detail("Key", result[i].key) .detail("Value", result[i].value) .detail("RestoreKey", restoreResult[i].key) .detail("RestoreValue", restoreResult[i].value);
															#line 3914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i].key == restoreResult[i].key);
															#line 3915 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i].value == restoreResult[i].value);
															#line 9477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 3903 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		++i;
															#line 9481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 3922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<TestCheckpointRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCheckpointRestoreActorState(); static_cast<TestCheckpointRestoreActor*>(this)->destroy(); return 0; }
															#line 9565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<TestCheckpointRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCheckpointRestoreActorState();
		static_cast<TestCheckpointRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 3922 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<TestCheckpointRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCheckpointRestoreActorState(); static_cast<TestCheckpointRestoreActor*>(this)->destroy(); return 0; }
															#line 9577 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<TestCheckpointRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCheckpointRestoreActorState();
		static_cast<TestCheckpointRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<TestCheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestCheckpointRestoreActor*>(this)->ActorCallback< TestCheckpointRestoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestCheckpointRestoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestCheckpointRestoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 3876 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string checkpointDir;
															#line 3880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	CheckpointMetaData checkpoint;
															#line 3887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string rocksDBRestoreDir;
															#line 3889 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* restoreKv;
															#line 3902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	int i;
															#line 3904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RangeResult restoreResult;
															#line 9676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via testCheckpointRestore()
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class TestCheckpointRestoreActor final : public Actor<Void>, public ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >, public ActorCallback< TestCheckpointRestoreActor, 1, Void >, public ActorCallback< TestCheckpointRestoreActor, 2, Void >, public ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >, public ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >, public ActorCallback< TestCheckpointRestoreActor, 5, Void >, public FastAllocated<TestCheckpointRestoreActor>, public TestCheckpointRestoreActorState<TestCheckpointRestoreActor> {
															#line 9681 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<TestCheckpointRestoreActor>::operator new;
	using FastAllocated<TestCheckpointRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12585295964828292608UL, 488042798897287168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >;
friend struct ActorCallback< TestCheckpointRestoreActor, 1, Void >;
friend struct ActorCallback< TestCheckpointRestoreActor, 2, Void >;
friend struct ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >;
friend struct ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >;
friend struct ActorCallback< TestCheckpointRestoreActor, 5, Void >;
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	TestCheckpointRestoreActor(IKeyValueStore* const& kvStore,std::vector<KeyRange> const& ranges) 
															#line 9703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   TestCheckpointRestoreActorState<TestCheckpointRestoreActor>(kvStore, ranges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCheckpointRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(729730280491737856UL, 9098601116118233600UL);
		ActorExecutionContextHelper __helper(static_cast<TestCheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCheckpointRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCheckpointRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 0, CheckpointMetaData >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestCheckpointRestoreActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
[[nodiscard]] Future<Void> testCheckpointRestore( IKeyValueStore* const& kvStore, std::vector<KeyRange> const& ranges ) {
															#line 3875 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new TestCheckpointRestoreActor(kvStore, ranges));
															#line 9740 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}

#line 3924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
} // namespace

#endif // WITH_ROCKSDB

IKeyValueStore* keyValueStoreShardedRocksDB(std::string const& path,
                                            UID logID,
                                            KeyValueStoreType storeType,
                                            bool checkChecksums,
                                            bool checkIntegrity) {
#ifdef WITH_ROCKSDB
	return new ShardedRocksDBKeyValueStore(path, logID);
#else
	TraceEvent(SevError, "ShardedRocksDBEngineInitFailure").detail("Reason", "Built without RocksDB");
	ASSERT(false);
	return nullptr;
#endif // WITH_ROCKSDB
}

#ifdef WITH_ROCKSDB
#include "flow/UnitTest.h"

namespace {
															#line 9766 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase3946()
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase3946Actor>
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3946ActorState {
															#line 9772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3946ActorState(UnitTestParameters const& params) 
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 3947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocksdb-test-db")
															#line 9781 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase3946", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase3946ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase3946", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3948 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 3950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 3952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 3952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9802 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state = 1;
															#line 3952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3946Actor, 0, Void >*>(static_cast<FlowTestCase3946Actor*>(this)));
															#line 9807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase3946ActorState();
		static_cast<FlowTestCase3946Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 3955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->dispose();
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = closed;
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state = 2;
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3946Actor, 1, Void >*>(static_cast<FlowTestCase3946Actor*>(this)));
															#line 9841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 3955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->dispose();
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = closed;
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state = 2;
															#line 3956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3946Actor, 1, Void >*>(static_cast<FlowTestCase3946Actor*>(this)));
															#line 9861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3946Actor*>(this)->ActorCallback< FlowTestCase3946Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3946Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3946Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase3946Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 3958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase3946Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase3946ActorState(); static_cast<FlowTestCase3946Actor*>(this)->destroy(); return 0; }
															#line 9947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase3946Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase3946ActorState();
		static_cast<FlowTestCase3946Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 3958 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase3946Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase3946ActorState(); static_cast<FlowTestCase3946Actor*>(this)->destroy(); return 0; }
															#line 9961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase3946Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase3946ActorState();
		static_cast<FlowTestCase3946Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3946Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3946Actor*>(this)->ActorCallback< FlowTestCase3946Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3946Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3946Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase3946Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 3947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	const std::string rocksDBTestDir;
															#line 3950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 10050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase3946()
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3946Actor final : public Actor<Void>, public ActorCallback< FlowTestCase3946Actor, 0, Void >, public ActorCallback< FlowTestCase3946Actor, 1, Void >, public FastAllocated<FlowTestCase3946Actor>, public FlowTestCase3946ActorState<FlowTestCase3946Actor> {
															#line 10055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase3946Actor>::operator new;
	using FastAllocated<FlowTestCase3946Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1128078647819027968UL, 5682759339154985728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase3946Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase3946Actor, 1, Void >;
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3946Actor(UnitTestParameters const& params) 
															#line 10073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase3946ActorState<FlowTestCase3946Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase3946", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11079998180932971520UL, 6847343790660697088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3946Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase3946");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase3946", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase3946Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase3946Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase3946( UnitTestParameters const& params ) {
															#line 3946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase3946Actor(params));
															#line 10106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase3946, "noSim/ShardedRocksDB/Initialization")

#line 3960 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 10112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase3961()
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase3961Actor>
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3961ActorState {
															#line 10118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3961ActorState(UnitTestParameters const& params) 
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 3962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocksdb-test-db")
															#line 10127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase3961", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase3961ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase3961", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 3965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 3967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 3967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 1;
															#line 3967 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 0, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase3961ActorState();
		static_cast<FlowTestCase3961Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		KeyRangeRef range("a"_sr, "b"_sr);
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = kvStore->addRange(range, "shard-1");
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10180 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 2;
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 1, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		KeyRangeRef range("a"_sr, "b"_sr);
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = kvStore->addRange(range, "shard-1");
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 2;
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 1, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 3972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set({ "a"_sr, "foo"_sr });
															#line 3973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set({ "ac"_sr, "bar"_sr });
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 3;
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 2, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 3972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set({ "a"_sr, "foo"_sr });
															#line 3973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set({ "ac"_sr, "bar"_sr });
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 3;
															#line 3974 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 2, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = kvStore->readValue("a"_sr);
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 4;
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = kvStore->readValue("a"_sr);
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 4;
															#line 3976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Optional<Value> const& val,int loopDepth) 
	{
															#line 3977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(Optional<Value>("foo"_sr) == val);
															#line 10509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = kvStore->readValue("ac"_sr);
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 5;
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont4(Optional<Value> && val,int loopDepth) 
	{
															#line 3977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(Optional<Value>("foo"_sr) == val);
															#line 10530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = kvStore->readValue("ac"_sr);
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
			static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 5;
															#line 3979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont4(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 3983 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 3984 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->dispose();
															#line 3985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = closed;
															#line 3985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10632 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 6;
															#line 3985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3961Actor, 5, Void >*>(static_cast<FlowTestCase3961Actor*>(this)));
															#line 10637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> const& val,int loopDepth) 
	{
															#line 3980 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(Optional<Value>("bar"_sr) == val);
															#line 10646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> && val,int loopDepth) 
	{
															#line 3980 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(Optional<Value>("bar"_sr) == val);
															#line 10655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont6(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 3986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 3987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase3961Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase3961ActorState(); static_cast<FlowTestCase3961Actor*>(this)->destroy(); return 0; }
															#line 10741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase3961Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase3961ActorState();
		static_cast<FlowTestCase3961Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 3986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 3987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase3961Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase3961ActorState(); static_cast<FlowTestCase3961Actor*>(this)->destroy(); return 0; }
															#line 10755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase3961Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase3961ActorState();
		static_cast<FlowTestCase3961Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3961Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3961Actor*>(this)->ActorCallback< FlowTestCase3961Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3961Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase3961Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 3962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	const std::string rocksDBTestDir;
															#line 3965 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 10844 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase3961()
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3961Actor final : public Actor<Void>, public ActorCallback< FlowTestCase3961Actor, 0, Void >, public ActorCallback< FlowTestCase3961Actor, 1, Void >, public ActorCallback< FlowTestCase3961Actor, 2, Void >, public ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >, public ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >, public ActorCallback< FlowTestCase3961Actor, 5, Void >, public FastAllocated<FlowTestCase3961Actor>, public FlowTestCase3961ActorState<FlowTestCase3961Actor> {
															#line 10849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase3961Actor>::operator new;
	using FastAllocated<FlowTestCase3961Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10196321540825505536UL, 12680367541642772992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase3961Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase3961Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase3961Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >;
friend struct ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >;
friend struct ActorCallback< FlowTestCase3961Actor, 5, Void >;
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3961Actor(UnitTestParameters const& params) 
															#line 10871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase3961ActorState<FlowTestCase3961Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase3961", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5497763182005564672UL, 7606217158592418816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3961Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase3961");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase3961", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase3961Actor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase3961( UnitTestParameters const& params ) {
															#line 3961 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase3961Actor(params));
															#line 10908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase3961, "noSim/ShardedRocksDB/SingleShardRead")

#line 3989 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 10914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase3990()
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase3990Actor>
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3990ActorState {
															#line 10920 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3990ActorState(UnitTestParameters const& params) 
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 3991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocksdb-kvs-test-db")
															#line 10929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase3990", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase3990ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase3990", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 3994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 3996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 3996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10950 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 1;
															#line 3996 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 0, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 10955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase3990ActorState();
		static_cast<FlowTestCase3990Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 3999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("0"_sr, "3"_sr), "shard-1"));
															#line 4000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("4"_sr, "7"_sr), "shard-2"));
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures);
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 2;
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 1, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 10991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3998 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 3999 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("0"_sr, "3"_sr), "shard-1"));
															#line 4000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("4"_sr, "7"_sr), "shard-2"));
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures);
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11008 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 2;
															#line 4002 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 1, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 4004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("0"_sr, "7"_sr), true);
															#line 4007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		expectedRows = RangeResult();
															#line 4008 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < 30;++i) {
															#line 4009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 11109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 40;i < 70;++i) {
															#line 4017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 11121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 3;
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 2, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 4004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("0"_sr, "7"_sr), true);
															#line 4007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		expectedRows = RangeResult();
															#line 4008 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < 30;++i) {
															#line 4009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 11153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 40;i < 70;++i) {
															#line 4017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 11165 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 3;
															#line 4023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 2, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 4024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_3 = closed;
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 4;
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 3, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 4024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_3 = closed;
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 4;
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 3, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 4027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = kvStore->init();
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 5;
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 4, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 4027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = kvStore->init();
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 5;
															#line 4028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 4, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 4031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		i = 0;
															#line 4032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		i = 0;
															#line 11488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 4031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		i = 0;
															#line 4032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		i = 0;
															#line 11499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 4039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), 1000, 10000);
															#line 4039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11585 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 7;
															#line 4039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 6, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 4032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!(i < expectedRows.size()))
															#line 11606 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 4033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = kvStore->readValue(expectedRows[i].key);
															#line 4033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 6;
															#line 4033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 4034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>(expectedRows[i].value));
															#line 4032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		++i;
															#line 11643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 4034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>(expectedRows[i].value));
															#line 4032 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		++i;
															#line 11654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(RangeResult const& result,int loopDepth) 
	{
															#line 4040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4042 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[i]);
															#line 11742 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), -1000, 10000);
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 8;
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont9(RangeResult && result,int loopDepth) 
	{
															#line 4040 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4042 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[i]);
															#line 11768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), -1000, 10000);
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 8;
															#line 4047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont9(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
		{
															#line 4056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_8 = kvStore->readRange(KeyRangeRef("2"_sr, "6"_sr), 10, 10000);
															#line 4056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 9;
															#line 4056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 8, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11873 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont12(RangeResult const& result,int loopDepth) 
	{
															#line 4048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[59 - i]);
															#line 11887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(RangeResult && result,int loopDepth) 
	{
															#line 4048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[59 - i]);
															#line 11901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont12(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 4064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_9 = kvStore->addRange(KeyRangeRef("7"_sr, "9"_sr), "shard-1");
															#line 4064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11988 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 10;
															#line 4064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 9, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 11993 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(RangeResult const& result,int loopDepth) 
	{
															#line 4057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 10);
															#line 4058 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 4059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[20 + i]);
															#line 12006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(RangeResult && result,int loopDepth) 
	{
															#line 4057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 10);
															#line 4058 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 4059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[20 + i]);
															#line 12020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 8, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 8, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 8, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 8, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 4065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("7"_sr, "9"_sr), true);
															#line 4067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(i = 70;i < 90;++i) {
															#line 4068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 12115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_10 = kvStore->commit(false);
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_10.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 11;
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 10, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 4065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("7"_sr, "9"_sr), true);
															#line 4067 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(i = 70;i < 90;++i) {
															#line 4068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string key = format("%02d", i);
															#line 4069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::string value = std::to_string(i);
															#line 4070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set({ key, value });
															#line 4071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			expectedRows.push_back_deep(expectedRows.arena(), { key, value });
															#line 12145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_10 = kvStore->commit(false);
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_10.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 11;
															#line 4074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 10, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont6(Void const& _,int loopDepth) 
	{
		{
															#line 4077 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_11 = closed;
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont6when1(__when_expr_11.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 12;
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 11, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont6(Void && _,int loopDepth) 
	{
		{
															#line 4077 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_11 = closed;
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont6when1(__when_expr_11.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 12;
															#line 4079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 11, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont8(int loopDepth) 
	{
															#line 4081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4082 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_12 = kvStore->init();
															#line 4082 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont8when1(__when_expr_12.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 13;
															#line 4082 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 12, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont10(Void const& _,int loopDepth) 
	{
		{
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), 1000, 10000);
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12467 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 14;
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10(Void && _,int loopDepth) 
	{
		{
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), 1000, 10000);
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12485 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 14;
															#line 4086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont10cont1(int loopDepth) 
	{
		{
															#line 4095 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_14 = kvStore->readRange(KeyRangeRef("5"_sr, ":"_sr), 35, 10000);
															#line 4095 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12578 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont10cont1when1(__when_expr_14.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 15;
															#line 4095 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 14, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12583 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont2(RangeResult const& result,int loopDepth) 
	{
															#line 4087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4089 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[i]);
															#line 12597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont2(RangeResult && result,int loopDepth) 
	{
															#line 4087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), expectedRows.size());
															#line 4088 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < expectedRows.size();++i) {
															#line 4089 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[i]);
															#line 12611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 13, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont10cont5(int loopDepth) 
	{
															#line 4103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->clear(KeyRangeRef("40"_sr, "45"_sr));
															#line 4104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_15 = kvStore->commit(false);
															#line 4104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12700 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont10cont5when1(__when_expr_15.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 16;
															#line 4104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 15, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12705 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont6(RangeResult const& result,int loopDepth) 
	{
															#line 4096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 35);
															#line 4097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 4098 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[40 + i]);
															#line 12718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont6(RangeResult && result,int loopDepth) 
	{
															#line 4096 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 35);
															#line 4097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 4098 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(result[i] == expectedRows[40 + i]);
															#line 12732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont6(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont6(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 14, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 14, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 14, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 14, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont10cont9(Void const& _,int loopDepth) 
	{
		{
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_16 = kvStore->readRange(KeyRangeRef("4"_sr, "5"_sr), 20, 10000);
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont10cont9when1(__when_expr_16.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 17;
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont9(Void && _,int loopDepth) 
	{
		{
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_16 = kvStore->readRange(KeyRangeRef("4"_sr, "5"_sr), 20, 10000);
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont10cont9when1(__when_expr_16.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 17;
															#line 4107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont10cont10(int loopDepth) 
	{
															#line 4112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->clear(KeyRangeRef("01"_sr, keyAfter("01"_sr)));
															#line 4113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_17 = kvStore->commit(false);
															#line 4113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont10cont10when1(__when_expr_17.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 18;
															#line 4113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 17, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 12937 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont11(RangeResult const& result,int loopDepth) 
	{
															#line 4108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 5);
															#line 12946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont11(RangeResult && result,int loopDepth) 
	{
															#line 4108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 5);
															#line 12955 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont9when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont11(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont9when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont11(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 16, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont10cont10cont10cont1(Void const& _,int loopDepth) 
	{
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_18 = kvStore->readValue("01"_sr);
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont10cont10cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 19;
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont1(Void && _,int loopDepth) 
	{
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_18 = kvStore->readValue("01"_sr);
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont10cont10cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 19;
															#line 4115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont10cont10cont10cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 4116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 4119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->clear(KeyRangeRef("1"_sr, "8"_sr));
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_19 = kvStore->commit(false);
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont10cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 20;
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 19, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13157 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 4116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 4119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->clear(KeyRangeRef("1"_sr, "8"_sr));
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_19 = kvStore->commit(false);
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont10cont2when1(__when_expr_19.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 20;
															#line 4120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 19, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont10cont10cont10cont3(Void const& _,int loopDepth) 
	{
		{
															#line 4123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_20 = closed;
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont10cont10cont10cont3when1(__when_expr_20.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 21;
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 20, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13273 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3(Void && _,int loopDepth) 
	{
		{
															#line 4123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_20 = closed;
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont10cont10cont10cont3when1(__when_expr_20.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 21;
															#line 4125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 20, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont10cont10cont10cont4(int loopDepth) 
	{
															#line 4127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_21 = kvStore->init();
															#line 4128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont10cont10cont10cont4when1(__when_expr_21.get(), loopDepth); };
		static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 22;
															#line 4128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 21, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont10cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont10cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont10cont10cont10cont6(Void const& _,int loopDepth) 
	{
		{
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_22 = kvStore->readRange(KeyRangeRef("1"_sr, "8"_sr), 1000, 10000);
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont10cont10cont6when1(__when_expr_22.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 23;
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont6(Void && _,int loopDepth) 
	{
		{
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_22 = kvStore->readRange(KeyRangeRef("1"_sr, "8"_sr), 1000, 10000);
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13506 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont10cont10cont6when1(__when_expr_22.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 23;
															#line 4131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont10cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont10cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont10cont10cont10cont7(int loopDepth) 
	{
		{
															#line 4136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<RangeResult> __when_expr_23 = kvStore->readRange(KeyRangeRef("0"_sr, ":"_sr), 1000, 10000);
															#line 4136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont10cont10cont10cont7when1(__when_expr_23.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 24;
															#line 4136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 23, RangeResult >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13604 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont8(RangeResult const& result,int loopDepth) 
	{
															#line 4132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 0);
															#line 13614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont8(RangeResult && result,int loopDepth) 
	{
															#line 4132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 0);
															#line 13623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont6when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont8(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont6when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont8(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 22, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont10cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont10cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont10cont10cont10cont10(int loopDepth) 
	{
		{
															#line 4141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->dispose();
															#line 4143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_24 = closed;
															#line 4143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13714 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont10cont10cont10cont10when1(__when_expr_24.get(), loopDepth); };
			static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 25;
															#line 4143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase3990Actor, 24, Void >*>(static_cast<FlowTestCase3990Actor*>(this)));
															#line 13719 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont11(RangeResult const& result,int loopDepth) 
	{
															#line 4137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 19);
															#line 13729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont11(RangeResult && result,int loopDepth) 
	{
															#line 4137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(result.size(), 19);
															#line 13738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont7when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont11(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont7when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont11(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 23, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 23, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont10cont10cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 23, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont10cont10cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 23, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont10cont10cont10cont10cont1(int loopDepth) 
	{
															#line 4145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 4146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase3990Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase3990ActorState(); static_cast<FlowTestCase3990Actor*>(this)->destroy(); return 0; }
															#line 13824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase3990Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase3990ActorState();
		static_cast<FlowTestCase3990Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase3990Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase3990Actor*>(this)->ActorCallback< FlowTestCase3990Actor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont10cont10cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< FlowTestCase3990Actor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont10cont10cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< FlowTestCase3990Actor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), 24);

	}
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 3991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string rocksDBTestDir;
															#line 3994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 4007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	RangeResult expectedRows;
															#line 4031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	int i;
															#line 13929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase3990()
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase3990Actor final : public Actor<Void>, public ActorCallback< FlowTestCase3990Actor, 0, Void >, public ActorCallback< FlowTestCase3990Actor, 1, Void >, public ActorCallback< FlowTestCase3990Actor, 2, Void >, public ActorCallback< FlowTestCase3990Actor, 3, Void >, public ActorCallback< FlowTestCase3990Actor, 4, Void >, public ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >, public ActorCallback< FlowTestCase3990Actor, 6, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 7, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 8, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 9, Void >, public ActorCallback< FlowTestCase3990Actor, 10, Void >, public ActorCallback< FlowTestCase3990Actor, 11, Void >, public ActorCallback< FlowTestCase3990Actor, 12, Void >, public ActorCallback< FlowTestCase3990Actor, 13, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 14, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 15, Void >, public ActorCallback< FlowTestCase3990Actor, 16, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 17, Void >, public ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >, public ActorCallback< FlowTestCase3990Actor, 19, Void >, public ActorCallback< FlowTestCase3990Actor, 20, Void >, public ActorCallback< FlowTestCase3990Actor, 21, Void >, public ActorCallback< FlowTestCase3990Actor, 22, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 23, RangeResult >, public ActorCallback< FlowTestCase3990Actor, 24, Void >, public FastAllocated<FlowTestCase3990Actor>, public FlowTestCase3990ActorState<FlowTestCase3990Actor> {
															#line 13934 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase3990Actor>::operator new;
	using FastAllocated<FlowTestCase3990Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10476872258572419840UL, 15029783329173541120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase3990Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >;
friend struct ActorCallback< FlowTestCase3990Actor, 6, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 7, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 8, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 9, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 10, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 11, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 12, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 13, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 14, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 15, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 16, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 17, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >;
friend struct ActorCallback< FlowTestCase3990Actor, 19, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 20, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 21, Void >;
friend struct ActorCallback< FlowTestCase3990Actor, 22, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 23, RangeResult >;
friend struct ActorCallback< FlowTestCase3990Actor, 24, Void >;
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase3990Actor(UnitTestParameters const& params) 
															#line 13975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase3990ActorState<FlowTestCase3990Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase3990", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16911131626253852416UL, 10771795307765128960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase3990Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase3990");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase3990", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 8, RangeResult >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 13, RangeResult >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 14, RangeResult >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 16, RangeResult >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 18, Optional<Value> >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 22, RangeResult >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 23, RangeResult >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< FlowTestCase3990Actor, 24, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase3990( UnitTestParameters const& params ) {
															#line 3990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase3990Actor(params));
															#line 14031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase3990, "noSim/ShardedRocksDB/RangeOps")

#line 4148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 14037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase4149()
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase4149Actor>
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4149ActorState {
															#line 14043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4149ActorState(UnitTestParameters const& params) 
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 4150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocksdb-kvs-test-db")
															#line 14052 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase4149", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase4149ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase4149", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 4153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = rocksdbStore;
															#line 4156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 4156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14075 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 1;
															#line 4156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 0, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase4149ActorState();
		static_cast<FlowTestCase4149Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		{
															#line 4160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::vector<Future<Void>> addRangeFutures;
															#line 4161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("a"_sr, "c"_sr), "shard-1"));
															#line 4162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("c"_sr, "f"_sr), "shard-2"));
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures);
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 2;
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 1, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		{
															#line 4160 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::vector<Future<Void>> addRangeFutures;
															#line 4161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("a"_sr, "c"_sr), "shard-1"));
															#line 4162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("c"_sr, "f"_sr), "shard-2"));
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures);
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 2;
															#line 4164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 1, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 4168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::vector<Future<Void>> addRangeFutures;
															#line 4169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("x"_sr, "z"_sr), "shard-1"));
															#line 4170 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("l"_sr, "n"_sr), "shard-3"));
															#line 4172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(addRangeFutures);
															#line 4172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 3;
															#line 4172 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 2, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 4176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<std::string> shardsToCleanUp;
															#line 4177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto shardIds = kvStore->removeRange(KeyRangeRef("b"_sr, "c"_sr));
															#line 4179 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(shardIds.size(), 0);
															#line 4182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		shardIds = kvStore->removeRange(KeyRangeRef("c"_sr, "m"_sr));
															#line 4183 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		sort(shardIds.begin(), shardIds.end());
															#line 4184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		int count = std::unique(shardIds.begin(), shardIds.end()) - shardIds.begin();
															#line 4185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT_EQ(count, 1);
															#line 4186 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(shardIds[0] == "shard-2");
															#line 4189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("b"_sr, "g"_sr), "shard-1"));
															#line 4191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("l"_sr, "m"_sr), "shard-2"));
															#line 4192 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("u"_sr, "v"_sr), "shard-3"));
															#line 4194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(addRangeFutures);
															#line 4194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 4;
															#line 4194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 3, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 4196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto dataMap = rocksdbStore->getDataMapping();
															#line 4197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping = std::vector<std::pair<KeyRange, std::string>>();
															#line 4198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("a"_sr, "b"_sr)), "shard-1"));
															#line 4199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("b"_sr, "g"_sr)), "shard-1"));
															#line 4200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("l"_sr, "m"_sr)), "shard-2"));
															#line 4201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("m"_sr, "n"_sr)), "shard-3"));
															#line 4202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("u"_sr, "v"_sr)), "shard-3"));
															#line 4203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("x"_sr, "z"_sr)), "shard-1"));
															#line 4204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(specialKeys, DEFAULT_CF_NAME));
															#line 4206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(auto it = dataMap.begin();it != dataMap.end();++it) {
															#line 4207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 14484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(dataMap == mapping);
															#line 4212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "z"_sr), true);
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = kvStore->commit(false);
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 5;
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 4, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 4196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto dataMap = rocksdbStore->getDataMapping();
															#line 4197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping = std::vector<std::pair<KeyRange, std::string>>();
															#line 4198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("a"_sr, "b"_sr)), "shard-1"));
															#line 4199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("b"_sr, "g"_sr)), "shard-1"));
															#line 4200 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("l"_sr, "m"_sr)), "shard-2"));
															#line 4201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("m"_sr, "n"_sr)), "shard-3"));
															#line 4202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("u"_sr, "v"_sr)), "shard-3"));
															#line 4203 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(KeyRange(KeyRangeRef("x"_sr, "z"_sr)), "shard-1"));
															#line 4204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping.push_back(std::make_pair(specialKeys, DEFAULT_CF_NAME));
															#line 4206 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for(auto it = dataMap.begin();it != dataMap.end();++it) {
															#line 4207 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 14528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(dataMap == mapping);
															#line 4212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "z"_sr), true);
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = kvStore->commit(false);
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 5;
															#line 4213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 4, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 4216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = closed;
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 6;
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 5, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 4216 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = closed;
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 6;
															#line 4218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 5, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 4220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_6 = kvStore->init();
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14748 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 7;
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 6, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14753 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 4220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_6 = kvStore->init();
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14768 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 7;
															#line 4222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 6, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14773 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		{
															#line 4225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto dataMap = rocksdbStore->getDataMapping();
															#line 4226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = dataMap.begin();it != dataMap.end();++it) {
															#line 4227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 14862 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 4230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(dataMap == mapping);
															#line 14866 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shardsToCleanUp = kvStore->removeRange(KeyRangeRef("a"_sr, "z"_sr));
															#line 4236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT_EQ(shardsToCleanUp.size(), 3);
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_7 = kvStore->addRange(KeyRangeRef("h"_sr, "i"_sr), "shard-2");
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14877 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 8;
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 7, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		{
															#line 4225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto dataMap = rocksdbStore->getDataMapping();
															#line 4226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = dataMap.begin();it != dataMap.end();++it) {
															#line 4227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 14897 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 4230 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(dataMap == mapping);
															#line 14901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			shardsToCleanUp = kvStore->removeRange(KeyRangeRef("a"_sr, "z"_sr));
															#line 4236 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT_EQ(shardsToCleanUp.size(), 3);
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_7 = kvStore->addRange(KeyRangeRef("h"_sr, "i"_sr), "shard-2");
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14912 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10when1(__when_expr_7.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 8;
															#line 4239 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 7, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 14917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		{
															#line 4242 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto dataMap = rocksdbStore->getDataMapping();
															#line 4243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT_EQ(dataMap.size(), 2);
															#line 4244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(dataMap[0].second == "shard-2");
															#line 15007 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4248 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->dispose();
															#line 4250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_8 = closed;
															#line 4250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 9;
															#line 4250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4149Actor, 8, Void >*>(static_cast<FlowTestCase4149Actor*>(this)));
															#line 15023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont5(int loopDepth) 
	{
															#line 4252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 4253 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase4149Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase4149ActorState(); static_cast<FlowTestCase4149Actor*>(this)->destroy(); return 0; }
															#line 15122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase4149Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase4149ActorState();
		static_cast<FlowTestCase4149Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4149Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4149Actor*>(this)->ActorCallback< FlowTestCase4149Actor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4149Actor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FlowTestCase4149Actor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 4150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string rocksDBTestDir;
															#line 4153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardedRocksDBKeyValueStore* rocksdbStore;
															#line 4155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 4197 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::vector<std::pair<KeyRange, std::string>> mapping;
															#line 4235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::vector<std::string> shardsToCleanUp;
															#line 15229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase4149()
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4149Actor final : public Actor<Void>, public ActorCallback< FlowTestCase4149Actor, 0, Void >, public ActorCallback< FlowTestCase4149Actor, 1, Void >, public ActorCallback< FlowTestCase4149Actor, 2, Void >, public ActorCallback< FlowTestCase4149Actor, 3, Void >, public ActorCallback< FlowTestCase4149Actor, 4, Void >, public ActorCallback< FlowTestCase4149Actor, 5, Void >, public ActorCallback< FlowTestCase4149Actor, 6, Void >, public ActorCallback< FlowTestCase4149Actor, 7, Void >, public ActorCallback< FlowTestCase4149Actor, 8, Void >, public FastAllocated<FlowTestCase4149Actor>, public FlowTestCase4149ActorState<FlowTestCase4149Actor> {
															#line 15234 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase4149Actor>::operator new;
	using FastAllocated<FlowTestCase4149Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18351742007431793152UL, 8131528526936105472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase4149Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 6, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 7, Void >;
friend struct ActorCallback< FlowTestCase4149Actor, 8, Void >;
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4149Actor(UnitTestParameters const& params) 
															#line 15259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase4149ActorState<FlowTestCase4149Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase4149", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12297598171155845120UL, 6262492194990058752UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4149Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase4149");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase4149", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FlowTestCase4149Actor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase4149( UnitTestParameters const& params ) {
															#line 4149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase4149Actor(params));
															#line 15299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase4149, "noSim/ShardedRocksDB/ShardOps")

#line 4255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 15305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase4256()
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase4256Actor>
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4256ActorState {
															#line 15311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4256ActorState(UnitTestParameters const& params) 
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 4257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocksdb-kvs-test-db"),
															#line 4258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   testSpecialKey("\xff\xff/TestKey"_sr),
															#line 4259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   testSpecialValue("\xff\xff/TestValue"_sr)
															#line 15324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase4256", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase4256ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase4256", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 4262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = rocksdbStore;
															#line 4265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 4265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 1;
															#line 4265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 0, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase4256ActorState();
		static_cast<FlowTestCase4256Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = kvStore->readValue(testSpecialKey);
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 2;
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = kvStore->readValue(testSpecialKey);
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 2;
															#line 4267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 4268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 4270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef(testSpecialKey, testSpecialValue));
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 3;
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 2, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 4268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 4270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef(testSpecialKey, testSpecialValue));
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 3;
															#line 4271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 2, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		{
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = kvStore->readValue(testSpecialKey);
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15600 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 4;
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		{
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_3 = kvStore->readValue(testSpecialKey);
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15618 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 4;
															#line 4274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15623 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 4279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("a"_sr, "c"_sr), "shard-1"));
															#line 4281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("c"_sr, "f"_sr), "shard-2"));
															#line 4282 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "f"_sr), true);
															#line 4284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(addRangeFutures);
															#line 4284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15718 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 5;
															#line 4284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 4, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15723 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> const& val,int loopDepth) 
	{
															#line 4275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val.get() == testSpecialValue);
															#line 15732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Optional<Value> && val,int loopDepth) 
	{
															#line 4275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val.get() == testSpecialValue);
															#line 15741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont5(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 4285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef("a1"_sr, "foo"_sr));
															#line 4286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef("d1"_sr, "bar"_sr));
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = kvStore->commit(false);
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 6;
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 5, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 4285 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef("a1"_sr, "foo"_sr));
															#line 4286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->set(KeyValueRef("d1"_sr, "bar"_sr));
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_5 = kvStore->commit(false);
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15851 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 6;
															#line 4287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 5, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15856 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 4290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_6 = closed;
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15946 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 7;
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 6, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15951 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 4290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		Future<Void> closed = kvStore->onClosed();
															#line 4291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->close();
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_6 = closed;
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 7;
															#line 4292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 6, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 15971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 4293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_7 = kvStore->init();
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 8;
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 7, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 4293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_7 = kvStore->init();
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 8;
															#line 4295 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 7, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		{
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_8 = kvStore->readValue(testSpecialKey);
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 9;
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16178 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		{
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_8 = kvStore->readValue(testSpecialKey);
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 9;
															#line 4298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		{
															#line 4304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_9 = kvStore->readValue("a1"_sr);
															#line 4304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 10;
															#line 4304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 4299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val.get() == testSpecialValue);
															#line 16299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 4299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val.get() == testSpecialValue);
															#line 16308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
		{
															#line 4308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_10 = kvStore->readValue("d1"_sr);
															#line 4308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16395 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_10.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 11;
															#line 4308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Optional<Value> const& val,int loopDepth) 
	{
															#line 4305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("foo"_sr));
															#line 16410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5(Optional<Value> && val,int loopDepth) 
	{
															#line 4305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("foo"_sr));
															#line 16419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont7(int loopDepth) 
	{
															#line 4313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "b"_sr), false);
															#line 4314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto shardIds = kvStore->removeRange(KeyRangeRef("a"_sr, "b"_sr));
															#line 4315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_11 = kvStore->commit(false);
															#line 4315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_11.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 12;
															#line 4315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 11, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont8(Optional<Value> const& val,int loopDepth) 
	{
															#line 4309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("bar"_sr));
															#line 16523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8(Optional<Value> && val,int loopDepth) 
	{
															#line 4309 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("bar"_sr));
															#line 16532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont10(Void const& _,int loopDepth) 
	{
		{
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_12 = kvStore->readValue("a1"_sr);
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_12.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 13;
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16624 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10(Void && _,int loopDepth) 
	{
		{
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_12 = kvStore->readValue("a1"_sr);
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont10when1(__when_expr_12.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 13;
															#line 4319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont10cont1(int loopDepth) 
	{
		{
															#line 4325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_13 = closed;
															#line 4327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont10cont1when1(__when_expr_13.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 14;
															#line 4327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 13, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16739 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 4320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 16749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 4320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 16758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont10cont4(int loopDepth) 
	{
															#line 4329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_14 = kvStore->init();
															#line 4331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont10cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 15;
															#line 4331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 14, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont10cont6(Void const& _,int loopDepth) 
	{
		{
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_15 = kvStore->readValue("a1"_sr);
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont10cont6when1(__when_expr_15.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 16;
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont6(Void && _,int loopDepth) 
	{
		{
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_15 = kvStore->readValue("a1"_sr);
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont10cont6when1(__when_expr_15.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 16;
															#line 4335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 16975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont10cont7(int loopDepth) 
	{
		{
															#line 4339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_16 = kvStore->readValue("d1"_sr);
															#line 4339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17063 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont10cont7when1(__when_expr_16.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 17;
															#line 4339 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont8(Optional<Value> const& val,int loopDepth) 
	{
															#line 4336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 17078 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont8(Optional<Value> && val,int loopDepth) 
	{
															#line 4336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!val.present());
															#line 17087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont6when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont8(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont6when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont8(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont10cont10(int loopDepth) 
	{
															#line 4343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		auto mapping = rocksdbStore->getDataMapping();
															#line 4344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(mapping.size() == 3);
															#line 4347 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->removeRange(KeyRangeRef("a"_sr, "f"_sr));
															#line 4348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		mapping = rocksdbStore->getDataMapping();
															#line 4349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(mapping.size() == 1);
															#line 17179 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		{
															#line 4353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_17 = closed;
															#line 4355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont10cont10when1(__when_expr_17.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 18;
															#line 4355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 17, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont11(Optional<Value> const& val,int loopDepth) 
	{
															#line 4340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("bar"_sr));
															#line 17204 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont11(Optional<Value> && val,int loopDepth) 
	{
															#line 4340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(val == Optional<Value>("bar"_sr));
															#line 17213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = a_body1cont10cont10cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont7when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont11(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont7when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont11(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont10cont10cont10cont1(int loopDepth) 
	{
															#line 4357 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_18 = kvStore->init();
															#line 4359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont10cont10cont1when1(__when_expr_18.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 19;
															#line 4359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 18, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont10cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont10cont10cont10cont3(Void const& _,int loopDepth) 
	{
		{
															#line 4363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto mapping = rocksdbStore->getDataMapping();
															#line 4364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 3);
															#line 4367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "f"_sr), false);
															#line 4368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->removeRange(KeyRangeRef("a"_sr, "f"_sr));
															#line 4370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			mapping = rocksdbStore->getDataMapping();
															#line 4371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 1);
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_19 = kvStore->commit(false);
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont10cont3when1(__when_expr_19.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 20;
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 19, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3(Void && _,int loopDepth) 
	{
		{
															#line 4363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto mapping = rocksdbStore->getDataMapping();
															#line 4364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 3);
															#line 4367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "f"_sr), false);
															#line 4368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->removeRange(KeyRangeRef("a"_sr, "f"_sr));
															#line 4370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			mapping = rocksdbStore->getDataMapping();
															#line 4371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 1);
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_19 = kvStore->commit(false);
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont10cont10cont3when1(__when_expr_19.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 20;
															#line 4373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 19, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont10cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont10cont10cont10cont4(int loopDepth) 
	{
		{
															#line 4378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->close();
															#line 4380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_20 = closed;
															#line 4380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont10cont10cont10cont4when1(__when_expr_20.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 21;
															#line 4380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 20, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont10cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont10cont10cont10cont6(int loopDepth) 
	{
															#line 4383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rocksdbStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore = rocksdbStore;
															#line 4385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_21 = kvStore->init();
															#line 4385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont10cont10cont10cont6when1(__when_expr_21.get(), loopDepth); };
		static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 22;
															#line 4385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 21, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont10cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont10cont10cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont10cont10cont10cont8(Void const& _,int loopDepth) 
	{
		{
															#line 4389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto mapping = rocksdbStore->getDataMapping();
															#line 4390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = mapping.begin();it != mapping.end();++it) {
															#line 4391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 17760 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 4394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 1);
															#line 17764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->dispose();
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_22 = closed;
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont10cont10cont8when1(__when_expr_22.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 23;
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 22, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont8(Void && _,int loopDepth) 
	{
		{
															#line 4389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			auto mapping = rocksdbStore->getDataMapping();
															#line 4390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			for(auto it = mapping.begin();it != mapping.end();++it) {
															#line 4391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
				std::cout << "Begin " << it->first.begin.toString() << ", End " << it->first.end.toString() << ", id " << it->second << "\n";
															#line 17795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			}
															#line 4394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(mapping.size() == 1);
															#line 17799 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		{
															#line 4398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			Future<Void> closed = kvStore->onClosed();
															#line 4399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->dispose();
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_22 = closed;
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont10cont10cont10cont8when1(__when_expr_22.get(), loopDepth); };
			static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 23;
															#line 4400 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4256Actor, 22, Void >*>(static_cast<FlowTestCase4256Actor*>(this)));
															#line 17815 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont10cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont10cont10cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont10cont10cont10cont9(int loopDepth) 
	{
															#line 4402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 4403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase4256Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase4256ActorState(); static_cast<FlowTestCase4256Actor*>(this)->destroy(); return 0; }
															#line 17902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase4256Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase4256ActorState();
		static_cast<FlowTestCase4256Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10cont10cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont10cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4256Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4256Actor*>(this)->ActorCallback< FlowTestCase4256Actor, 22, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont10cont10cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4256Actor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont10cont10cont10cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< FlowTestCase4256Actor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), 22);

	}
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 4257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string rocksDBTestDir;
															#line 4258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Key testSpecialKey;
															#line 4259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Value testSpecialValue;
															#line 4262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ShardedRocksDBKeyValueStore* rocksdbStore;
															#line 4264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 18009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase4256()
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4256Actor final : public Actor<Void>, public ActorCallback< FlowTestCase4256Actor, 0, Void >, public ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 2, Void >, public ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 4, Void >, public ActorCallback< FlowTestCase4256Actor, 5, Void >, public ActorCallback< FlowTestCase4256Actor, 6, Void >, public ActorCallback< FlowTestCase4256Actor, 7, Void >, public ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 11, Void >, public ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 13, Void >, public ActorCallback< FlowTestCase4256Actor, 14, Void >, public ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >, public ActorCallback< FlowTestCase4256Actor, 17, Void >, public ActorCallback< FlowTestCase4256Actor, 18, Void >, public ActorCallback< FlowTestCase4256Actor, 19, Void >, public ActorCallback< FlowTestCase4256Actor, 20, Void >, public ActorCallback< FlowTestCase4256Actor, 21, Void >, public ActorCallback< FlowTestCase4256Actor, 22, Void >, public FastAllocated<FlowTestCase4256Actor>, public FlowTestCase4256ActorState<FlowTestCase4256Actor> {
															#line 18014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase4256Actor>::operator new;
	using FastAllocated<FlowTestCase4256Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15436032339675532032UL, 14840758360863633408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase4256Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 5, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 6, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 7, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 11, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 13, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 14, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >;
friend struct ActorCallback< FlowTestCase4256Actor, 17, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 18, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 19, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 20, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 21, Void >;
friend struct ActorCallback< FlowTestCase4256Actor, 22, Void >;
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4256Actor(UnitTestParameters const& params) 
															#line 18053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase4256ActorState<FlowTestCase4256Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase4256", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3566457091643066368UL, 1481743093565089792UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4256Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase4256");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase4256", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 8, Optional<Value> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 10, Optional<Value> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 12, Optional<Value> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 15, Optional<Value> >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 16, Optional<Value> >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< FlowTestCase4256Actor, 22, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase4256( UnitTestParameters const& params ) {
															#line 4256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase4256Actor(params));
															#line 18107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase4256, "noSim/ShardedRocksDB/Metadata")

#line 4405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 18113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase4406()
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase4406Actor>
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4406ActorState {
															#line 18119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4406ActorState(UnitTestParameters const& params) 
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 4407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocks-checkpoint-restore"),
															#line 4408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   kvs({ { "a"_sr, "TestValueA"_sr }, { "ab"_sr, "TestValueAB"_sr }, { "ad"_sr, "TestValueAD"_sr }, { "b"_sr, "TestValueB"_sr }, { "ba"_sr, "TestValueBA"_sr }, { "c"_sr, "TestValueC"_sr }, { "d"_sr, "TestValueD"_sr }, { "e"_sr, "TestValueE"_sr }, { "h"_sr, "TestValueH"_sr }, { "ha"_sr, "TestValueHA"_sr } })
															#line 18130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase4406", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase4406ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase4406", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 4419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 4421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 1;
															#line 4421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 0, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase4406ActorState();
		static_cast<FlowTestCase4406Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 4424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("a"_sr, "c"_sr), "shard-1"));
															#line 4426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("c"_sr, "f"_sr), "shard-2"));
															#line 4427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("h"_sr, "k"_sr), "shard-1"));
															#line 4428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "f"_sr), true);
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures) && kvStore->commit(false);
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 2;
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 1, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18196 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 4424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("a"_sr, "c"_sr), "shard-1"));
															#line 4426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("c"_sr, "f"_sr), "shard-2"));
															#line 4427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(KeyRangeRef("h"_sr, "k"_sr), "shard-1"));
															#line 4428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(KeyRangeRef("a"_sr, "f"_sr), true);
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures) && kvStore->commit(false);
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18217 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 2;
															#line 4429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 1, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 4431 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& [k, v] : kvs ) {
															#line 4432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set(KeyValueRef(k, v));
															#line 18308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 3;
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 2, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 4431 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& [k, v] : kvs ) {
															#line 4432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore->set(KeyValueRef(k, v));
															#line 18330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_2 = kvStore->commit(false);
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 3;
															#line 4434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 2, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 4436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		checkpointDir = "checkpoint";
															#line 4437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 4440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		CheckpointRequest request(latestVersion, { KeyRangeRef("a"_sr, "c"_sr), KeyRangeRef("h"_sr, "k"_sr) }, DataMoveRocksCF, deterministicRandom()->randomUniqueID(), checkpointDir);
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<CheckpointMetaData> __when_expr_3 = kvStore->checkpoint(request);
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18433 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 4;
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 4436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		checkpointDir = "checkpoint";
															#line 4437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 4440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		CheckpointRequest request(latestVersion, { KeyRangeRef("a"_sr, "c"_sr), KeyRangeRef("h"_sr, "k"_sr) }, DataMoveRocksCF, deterministicRandom()->randomUniqueID(), checkpointDir);
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<CheckpointMetaData> __when_expr_3 = kvStore->checkpoint(request);
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18455 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 4;
															#line 4445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(CheckpointMetaData const& metaData,int loopDepth) 
	{
															#line 4447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		token = BinaryWriter::toValue(KeyRangeRef("a"_sr, "k"_sr), IncludeVersion());
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		cpReader = newCheckpointReader(metaData, CheckpointAsKeyValues::True, deterministicRandom()->randomUniqueID());
															#line 4450 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(cpReader != nullptr);
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cpReader->init(token);
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 5;
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 4, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(CheckpointMetaData && metaData,int loopDepth) 
	{
															#line 4447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		token = BinaryWriter::toValue(KeyRangeRef("a"_sr, "k"_sr), IncludeVersion());
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		cpReader = newCheckpointReader(metaData, CheckpointAsKeyValues::True, deterministicRandom()->randomUniqueID());
															#line 4450 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(cpReader != nullptr);
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cpReader->init(token);
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18574 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 5;
															#line 4451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 4, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(CheckpointMetaData const& metaData,int loopDepth) 
	{
		loopDepth = a_body1cont5(metaData, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(CheckpointMetaData && metaData,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(metaData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*,CheckpointMetaData const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*,CheckpointMetaData && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 4452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		testRange = KeyRange(KeyRangeRef("ab"_sr, "b"_sr));
															#line 4453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iter0 = cpReader->getIterator(testRange);
															#line 4454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		numKeys = 0;
															#line 18667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		try {
															#line 4456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			;
															#line 18671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 4452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		testRange = KeyRange(KeyRangeRef("ab"_sr, "b"_sr));
															#line 4453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iter0 = cpReader->getIterator(testRange);
															#line 4454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		numKeys = 0;
															#line 18690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		try {
															#line 4456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			;
															#line 18694 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 4469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		testRange = KeyRangeRef("a"_sr, "k"_sr);
															#line 4470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iter1 = cpReader->getIterator(testRange);
															#line 18786 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		try {
															#line 4472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			numKeys = 0;
															#line 4473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			;
															#line 18792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont7loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream);
															#line 4466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(numKeys == 2);
															#line 18810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 4457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<RangeResult> __when_expr_5 = iter0->nextBatch(CLIENT_KNOBS->REPLY_BYTE_LIMIT, CLIENT_KNOBS->REPLY_BYTE_LIMIT);
															#line 4457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 6;
															#line 4457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 5, RangeResult >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18839 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 4458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& kv : res ) {
															#line 4459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(testRange.contains(kv.key));
															#line 4460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(kvs[kv.key] == kv.value);
															#line 4461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++numKeys;
															#line 18854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 4458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& kv : res ) {
															#line 4459 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(testRange.contains(kv.key));
															#line 4460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(kvs[kv.key] == kv.value);
															#line 4461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++numKeys;
															#line 18870 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 5, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 5, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 5, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 5, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 4486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iter0.reset();
															#line 4487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		iter1.reset();
															#line 4488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!cpReader->inUse());
															#line 4489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		TraceEvent(SevDebug, "ShardedRocksCheckpointReaaderTested");
															#line 4490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> closes;
															#line 4491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		closes.push_back(cpReader->close());
															#line 4492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		closes.push_back(kvStore->onClosed());
															#line 4493 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->dispose();
															#line 4494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(closes);
															#line 4494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 8;
															#line 4494 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 7, Void >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 18978 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 4482 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream);
															#line 4483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(numKeys == 7);
															#line 18990 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 4474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = iter1->nextBatch(CLIENT_KNOBS->REPLY_BYTE_LIMIT, CLIENT_KNOBS->REPLY_BYTE_LIMIT);
															#line 4474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont7Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 7;
															#line 4474 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4406Actor, 6, RangeResult >*>(static_cast<FlowTestCase4406Actor*>(this)));
															#line 19019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 4475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& kv : res ) {
															#line 4476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(testRange.contains(kv.key));
															#line 4477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(kvs[kv.key] == kv.value);
															#line 4478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++numKeys;
															#line 19034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 4475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		for( const auto& kv : res ) {
															#line 4476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(testRange.contains(kv.key));
															#line 4477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			ASSERT(kvs[kv.key] == kv.value);
															#line 4478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			++numKeys;
															#line 19050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 4496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 4497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 4499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase4406Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase4406ActorState(); static_cast<FlowTestCase4406Actor*>(this)->destroy(); return 0; }
															#line 19139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase4406Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase4406ActorState();
		static_cast<FlowTestCase4406Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 4496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		ASSERT(!directoryExists(rocksDBTestDir));
															#line 4497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 4499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (!static_cast<FlowTestCase4406Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase4406ActorState(); static_cast<FlowTestCase4406Actor*>(this)->destroy(); return 0; }
															#line 19155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		new (&static_cast<FlowTestCase4406Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase4406ActorState();
		static_cast<FlowTestCase4406Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase4406Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase4406Actor*>(this)->ActorCallback< FlowTestCase4406Actor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FlowTestCase4406Actor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FlowTestCase4406Actor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	UnitTestParameters params;
															#line 4407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string rocksDBTestDir;
															#line 4408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::map<Key, Value> kvs;
															#line 4419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	IKeyValueStore* kvStore;
															#line 4436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::string checkpointDir;
															#line 4447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	Standalone<StringRef> token;
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	ICheckpointReader* cpReader;
															#line 4452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	KeyRange testRange;
															#line 4453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unique_ptr<ICheckpointIterator> iter0;
															#line 4454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	int numKeys;
															#line 4470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	std::unique_ptr<ICheckpointIterator> iter1;
															#line 19260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase4406()
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4406Actor final : public Actor<Void>, public ActorCallback< FlowTestCase4406Actor, 0, Void >, public ActorCallback< FlowTestCase4406Actor, 1, Void >, public ActorCallback< FlowTestCase4406Actor, 2, Void >, public ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >, public ActorCallback< FlowTestCase4406Actor, 4, Void >, public ActorCallback< FlowTestCase4406Actor, 5, RangeResult >, public ActorCallback< FlowTestCase4406Actor, 6, RangeResult >, public ActorCallback< FlowTestCase4406Actor, 7, Void >, public FastAllocated<FlowTestCase4406Actor>, public FlowTestCase4406ActorState<FlowTestCase4406Actor> {
															#line 19265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase4406Actor>::operator new;
	using FastAllocated<FlowTestCase4406Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1472487001155701504UL, 6807824315626560256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase4406Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase4406Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase4406Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >;
friend struct ActorCallback< FlowTestCase4406Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase4406Actor, 5, RangeResult >;
friend struct ActorCallback< FlowTestCase4406Actor, 6, RangeResult >;
friend struct ActorCallback< FlowTestCase4406Actor, 7, Void >;
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4406Actor(UnitTestParameters const& params) 
															#line 19289 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase4406ActorState<FlowTestCase4406Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase4406", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12805630638273081856UL, 11874097477614774528UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase4406Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase4406");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase4406", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 3, CheckpointMetaData >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 5, RangeResult >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FlowTestCase4406Actor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
static Future<Void> flowTestCase4406( UnitTestParameters const& params ) {
															#line 4406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	return Future<Void>(new FlowTestCase4406Actor(params));
															#line 19328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase4406, "noSim/ShardedRocksDBCheckpoint/CheckpointBasic")

#line 4501 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"

															#line 19334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
// This generated class is to be used only via flowTestCase4502()
															#line 4502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
template <class FlowTestCase4502Actor>
															#line 4502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
class FlowTestCase4502ActorState {
															#line 19340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
public:
															#line 4502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
	FlowTestCase4502ActorState(UnitTestParameters const& params) 
															#line 4502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
															#line 4502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		 : params(params),
															#line 4503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   rocksDBTestDir("sharded-rocks-checkpoint" + deterministicRandom()->randomAlphaNumeric(5)),
															#line 4504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		   kvs({ { "ab"_sr, "TestValueAB"_sr }, { "ad"_sr, "TestValueAD"_sr }, { "b"_sr, "TestValueB"_sr }, { "ba"_sr, "TestValueBA"_sr }, { "c"_sr, "TestValueC"_sr }, { "d"_sr, "TestValueD"_sr }, { "e"_sr, "TestValueE"_sr }, { "h"_sr, "TestValueH"_sr }, { "ha"_sr, "TestValueHA"_sr } })
															#line 19351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase4502", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase4502ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase4502", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 4513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 4514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			kvStore = new ShardedRocksDBKeyValueStore(rocksDBTestDir, deterministicRandom()->randomUniqueID());
															#line 4516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			StrictFuture<Void> __when_expr_0 = kvStore->init();
															#line 4516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			if (static_cast<FlowTestCase4502Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase4502Actor*>(this)->actor_wait_state = 1;
															#line 4516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4502Actor, 0, Void >*>(static_cast<FlowTestCase4502Actor*>(this)));
															#line 19377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase4502ActorState();
		static_cast<FlowTestCase4502Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 4518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		shardId = "shard_1";
															#line 4519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		emptyShardId = "shard_2";
															#line 4520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rangeK = KeyRangeRef(""_sr, "k"_sr);
															#line 4521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rangeKz = KeyRangeRef("z1"_sr, "z3"_sr);
															#line 4523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(rangeK, shardId));
															#line 4525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(rangeKz, emptyShardId));
															#line 4526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(rangeK, true);
															#line 4527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(rangeKz, true);
															#line 4528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addRangeFutures);
															#line 4528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		if (static_cast<FlowTestCase4502Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase4502Actor*>(this)->actor_wait_state = 2;
															#line 4528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase4502Actor, 1, Void >*>(static_cast<FlowTestCase4502Actor*>(this)));
															#line 19425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/KeyValueStoreShardedRocksDB.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 4518 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		shardId = "shard_1";
															#line 4519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		emptyShardId = "shard_2";
															#line 4520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rangeK = KeyRangeRef(""_sr, "k"_sr);
															#line 4521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		rangeKz = KeyRangeRef("z1"_sr, "z3"_sr);
															#line 4523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		std::vector<Future<Void>> addRangeFutures;
															#line 4524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(rangeK, shardId));
															#line 4525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		addRangeFutures.push_back(kvStore->addRange(rangeKz, emptyShardId));
															#line 4526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/KeyValueStoreShardedRocksDB.actor.cpp"
		kvStore->persistRangeMapping(rangeK, true);
															#line 4527 "/codebuild/output/src3820056588/src/github.com/apple/foundatio