#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
/*
 * DDTxnProcessor.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/DDTxnProcessor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

static void updateServersAndCompleteSources(std::set<UID>& servers,
                                            std::vector<UID>& completeSources,
                                            int shard,
                                            const std::vector<UID>& src) {
	servers.insert(src.begin(), src.end());
	if (shard == 0) {
		completeSources = src;
	} else {
		for (int i = 0; i < completeSources.size(); i++) {
			if (std::find(src.begin(), src.end(), completeSources[i]) == src.end()) {
				swapAndPop(&completeSources, i--);
			}
		}
	}
}

class DDTxnProcessorImpl {
	friend class DDTxnProcessor;

																#line 50 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getServerListAndProcessClasses()
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetServerListAndProcessClassesActor>
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetServerListAndProcessClassesActorState {
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetServerListAndProcessClassesActorState(Database const& cx) 
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 49 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx),
															#line 50 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   res()
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~GetServerListAndProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 82 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 52 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 53 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 54 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(res.servers, NativeAPI::getServerListAndProcessClasses(&tr));
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*>(static_cast<GetServerListAndProcessClassesActor*>(this)));
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*>(static_cast<GetServerListAndProcessClassesActor*>(this)));
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.readVersion = tr.getReadVersion().get();
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetServerListAndProcessClassesActor*>(this)->SAV<ServerWorkerInfos>::futures) { (void)(res); this->~GetServerListAndProcessClassesActorState(); static_cast<GetServerListAndProcessClassesActor*>(this)->destroy(); return 0; }
															#line 173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetServerListAndProcessClassesActor*>(this)->SAV< ServerWorkerInfos >::value()) ServerWorkerInfos(std::move(res)); // state_var_RVO
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.readVersion = tr.getReadVersion().get();
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetServerListAndProcessClassesActor*>(this)->SAV<ServerWorkerInfos>::futures) { (void)(res); this->~GetServerListAndProcessClassesActorState(); static_cast<GetServerListAndProcessClassesActor*>(this)->destroy(); return 0; }
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetServerListAndProcessClassesActor*>(this)->SAV< ServerWorkerInfos >::value()) ServerWorkerInfos(std::move(res)); // state_var_RVO
		this->~GetServerListAndProcessClassesActorState();
		static_cast<GetServerListAndProcessClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerListAndProcessClassesActor*>(this)->ActorCallback< GetServerListAndProcessClassesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<GetServerListAndProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetServerListAndProcessClassesActor*>(this)->ActorCallback< GetServerListAndProcessClassesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 49 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 50 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ServerWorkerInfos res;
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getServerListAndProcessClasses()
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetServerListAndProcessClassesActor final : public Actor<ServerWorkerInfos>, public ActorCallback< GetServerListAndProcessClassesActor, 0, Void >, public ActorCallback< GetServerListAndProcessClassesActor, 1, Void >, public FastAllocated<GetServerListAndProcessClassesActor>, public GetServerListAndProcessClassesActorState<GetServerListAndProcessClassesActor> {
															#line 368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetServerListAndProcessClassesActor>::operator new;
	using FastAllocated<GetServerListAndProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7260114556544013824UL, 10537481506418166528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ServerWorkerInfos>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetServerListAndProcessClassesActor, 0, Void >;
friend struct ActorCallback< GetServerListAndProcessClassesActor, 1, Void >;
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetServerListAndProcessClassesActor(Database const& cx) 
															#line 386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<ServerWorkerInfos>(),
		   GetServerListAndProcessClassesActorState<GetServerListAndProcessClassesActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4960532463770230016UL, 4395093134379451392UL);
		ActorExecutionContextHelper __helper(static_cast<GetServerListAndProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getServerListAndProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getServerListAndProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetServerListAndProcessClassesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetServerListAndProcessClassesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<ServerWorkerInfos> getServerListAndProcessClasses( Database const& cx ) {
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<ServerWorkerInfos>(new GetServerListAndProcessClassesActor(cx));
															#line 419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 64 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// return {sourceServers, completeSources}
																#line 425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getSourceServersForRange()
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetSourceServersForRangeActor>
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServersForRangeActorState {
															#line 431 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServersForRangeActorState(Database const& cx,KeyRangeRef const& keys) 
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys(keys),
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   servers(),
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   completeSources(),
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getSourceServersForRange", reinterpret_cast<unsigned long>(this));

	}
	~GetSourceServersForRangeActorState() 
	{
		fdb_probe_actor_destroy("getSourceServersForRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSourceServersForRangeActorState();
		static_cast<GetSourceServersForRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetSourceServersForRangeActor*>(this)->SAV<IDDTxnProcessor::SourceServers>::futures) { (void)(IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources }); this->~GetSourceServersForRangeActorState(); static_cast<GetSourceServersForRangeActor*>(this)->destroy(); return 0; }
															#line 484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetSourceServersForRangeActor*>(this)->SAV< IDDTxnProcessor::SourceServers >::value()) IDDTxnProcessor::SourceServers(IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources });
		this->~GetSourceServersForRangeActorState();
		static_cast<GetSourceServersForRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		servers.clear();
															#line 73 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		completeSources.clear();
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 76 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 77 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 4;
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 3, Void >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(lastLessOrEqual(keyServersKey(keys.begin)), firstGreaterOrEqual(keyServersKey(keys.end)), SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS);
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& keyServersEntries,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (keyServersEntries.size() < SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS)
															#line 676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < keyServersEntries.size();shard++) {
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				std::vector<UID> src, dest;
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				decodeKeyServersValue(UIDtoTagMap, keyServersEntries[shard].value, src, dest);
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(src.size());
															#line 90 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				updateServersAndCompleteSources(servers, completeSources, shard, src);
															#line 688 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(servers.size() > 0);
															#line 692 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		else
		{
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 701 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && keyServersEntries,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (keyServersEntries.size() < SERVER_KNOBS->DD_QUEUE_MAX_KEY_SERVERS)
															#line 716 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < keyServersEntries.size();shard++) {
															#line 87 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				std::vector<UID> src, dest;
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				decodeKeyServersValue(UIDtoTagMap, keyServersEntries[shard].value, src, dest);
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(src.size());
															#line 90 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				updateServersAndCompleteSources(servers, completeSources, shard, src);
															#line 728 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(servers.size() > 0);
															#line 732 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}
		else
		{
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*>(static_cast<GetSourceServersForRangeActor*>(this)));
															#line 746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& keyServersEntries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(keyServersEntries, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && keyServersEntries,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(keyServersEntries), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7(RangeResult const& serverList,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto s = serverList.begin();s != serverList.end();++s) {
															#line 105 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			servers.insert(decodeServerListValue(s->value).id());
															#line 841 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(servers.size() > 0);
															#line 845 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(RangeResult && serverList,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 104 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto s = serverList.begin();s != serverList.end();++s) {
															#line 105 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			servers.insert(decodeServerListValue(s->value).id());
															#line 858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(servers.size() > 0);
															#line 862 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServersForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServersForRangeActor*>(this)->ActorCallback< GetSourceServersForRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSourceServersForRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef keys;
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::set<UID> servers;
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> completeSources;
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 79 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1041 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getSourceServersForRange()
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServersForRangeActor final : public Actor<IDDTxnProcessor::SourceServers>, public ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >, public ActorCallback< GetSourceServersForRangeActor, 3, Void >, public FastAllocated<GetSourceServersForRangeActor>, public GetSourceServersForRangeActorState<GetSourceServersForRangeActor> {
															#line 1046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetSourceServersForRangeActor>::operator new;
	using FastAllocated<GetSourceServersForRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13881435797704930304UL, 6532774091367334144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<IDDTxnProcessor::SourceServers>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >;
friend struct ActorCallback< GetSourceServersForRangeActor, 3, Void >;
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServersForRangeActor(Database const& cx,KeyRangeRef const& keys) 
															#line 1066 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<IDDTxnProcessor::SourceServers>(),
		   GetSourceServersForRangeActorState<GetSourceServersForRangeActor>(cx, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSourceServersForRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7022398268476599552UL, 5262681254722997504UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServersForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSourceServersForRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSourceServersForRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSourceServersForRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<IDDTxnProcessor::SourceServers> getSourceServersForRange( Database const& cx, KeyRangeRef const& keys ) {
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<IDDTxnProcessor::SourceServers>(new GetSourceServersForRangeActor(cx, keys));
															#line 1101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 1106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getSourceServerInterfacesForRange()
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetSourceServerInterfacesForRangeActor>
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServerInterfacesForRangeActorState {
															#line 1112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServerInterfacesForRangeActorState(Database const& cx,KeyRangeRef const& range) 
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   range(range),
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   res(),
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 1125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this));

	}
	~GetSourceServerInterfacesForRangeActorState() 
	{
		fdb_probe_actor_destroy("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 128 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 1146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSourceServerInterfacesForRangeActorState();
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetSourceServerInterfacesForRangeActor*>(this)->SAV<std::vector<IDDTxnProcessor::DDRangeLocations>>::futures) { (void)(res); this->~GetSourceServerInterfacesForRangeActorState(); static_cast<GetSourceServerInterfacesForRangeActor*>(this)->destroy(); return 0; }
															#line 1169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetSourceServerInterfacesForRangeActor*>(this)->SAV< std::vector<IDDTxnProcessor::DDRangeLocations> >::value()) std::vector<IDDTxnProcessor::DDRangeLocations>(std::move(res)); // state_var_RVO
		this->~GetSourceServerInterfacesForRangeActorState();
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.clear();
															#line 1188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, range, SERVER_KNOBS->MOVE_SHARD_KRM_ROW_LIMIT, SERVER_KNOBS->MOVE_SHARD_KRM_BYTE_LIMIT);
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 1;
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 168 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevWarnAlways, "GetSourceServerInterfacesError").errorUnsuppressed(e).detail("Range", range);
															#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1238 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 4;
															#line 169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1243 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!shards.empty());
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1262 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __shards,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		shards = __shards;
															#line 1276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __shards,int loopDepth) 
	{
		shards = std::move(__shards);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		i = 0;
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		i = 0;
															#line 1359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 1368 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!(i < shards.size() - 1))
															#line 1460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		src = std::vector<UID>();
															#line 144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> dest;
															#line 145 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shards[i].value, src, dest, srcId, destId);
															#line 148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<Future<Optional<Value>>> serverListEntries;
															#line 149 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < src.size();++j) {
															#line 150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			serverListEntries.push_back(tr.get(serverListKeyFor(src[j])));
															#line 1478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_2 = getAll(serverListEntries);
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*>(static_cast<GetSourceServerInterfacesForRangeActor*>(this)));
															#line 1489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		IDDTxnProcessor::DDRangeLocations current(KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < serverListValues.size();++j) {
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!serverListValues[j].present())
															#line 1515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevWarnAlways, "GetSourceServerInterfacesMissing") .detail("StorageServer", src[j]) .detail("Range", KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 1519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[j].get());
															#line 162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			current.servers[ssi.locality.describeDcId()].push_back(ssi);
															#line 1526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.push_back(current);
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		++i;
															#line 1532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		IDDTxnProcessor::DDRangeLocations current(KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int j = 0;j < serverListValues.size();++j) {
															#line 155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!serverListValues[j].present())
															#line 1545 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevWarnAlways, "GetSourceServerInterfacesMissing") .detail("StorageServer", src[j]) .detail("Range", KeyRangeRef(shards[i].key, shards[i + 1].key));
															#line 1549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StorageServerInterface ssi = decodeServerListValue(serverListValues[j].get());
															#line 162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			current.servers[ssi.locality.describeDcId()].push_back(ssi);
															#line 1556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		res.push_back(current);
															#line 142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		++i;
															#line 1562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(std::vector<Optional<Value>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(std::vector<Optional<Value>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state > 0) static_cast<GetSourceServerInterfacesForRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSourceServerInterfacesForRangeActor*>(this)->ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef range;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<IDDTxnProcessor::DDRangeLocations> res;
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 131 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult shards;
															#line 138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 141 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int i;
															#line 143 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> src;
															#line 1745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getSourceServerInterfacesForRange()
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetSourceServerInterfacesForRangeActor final : public Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>, public ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >, public ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >, public FastAllocated<GetSourceServerInterfacesForRangeActor>, public GetSourceServerInterfacesForRangeActorState<GetSourceServerInterfacesForRangeActor> {
															#line 1750 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetSourceServerInterfacesForRangeActor>::operator new;
	using FastAllocated<GetSourceServerInterfacesForRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16550699832311004160UL, 17989745446604598784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >;
friend struct ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetSourceServerInterfacesForRangeActor(Database const& cx,KeyRangeRef const& range) 
															#line 1770 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<std::vector<IDDTxnProcessor::DDRangeLocations>>(),
		   GetSourceServerInterfacesForRangeActorState<GetSourceServerInterfacesForRangeActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12691934073115157248UL, 5954822088203531776UL);
		ActorExecutionContextHelper __helper(static_cast<GetSourceServerInterfacesForRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSourceServerInterfacesForRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSourceServerInterfacesForRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 2, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetSourceServerInterfacesForRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<std::vector<IDDTxnProcessor::DDRangeLocations>> getSourceServerInterfacesForRange( Database const& cx, KeyRangeRef const& range ) {
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<std::vector<IDDTxnProcessor::DDRangeLocations>>(new GetSourceServerInterfacesForRangeActor(cx, range));
															#line 1805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// set the system key space
																#line 1811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via updateReplicaKeys()
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class UpdateReplicaKeysActor>
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class UpdateReplicaKeysActorState {
															#line 1817 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UpdateReplicaKeysActorState(Database const& cx,std::vector<Optional<Key>> const& primaryDcId,std::vector<Optional<Key>> const& remoteDcIds,DatabaseConfiguration const& configuration) 
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   primaryDcId(primaryDcId),
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   remoteDcIds(remoteDcIds),
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   configuration(configuration),
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 1832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("updateReplicaKeys", reinterpret_cast<unsigned long>(this));

	}
	~UpdateReplicaKeysActorState() 
	{
		fdb_probe_actor_destroy("updateReplicaKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 1847 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateReplicaKeysActorState();
		static_cast<UpdateReplicaKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<UpdateReplicaKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateReplicaKeysActorState(); static_cast<UpdateReplicaKeysActor*>(this)->destroy(); return 0; }
															#line 1870 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<UpdateReplicaKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateReplicaKeysActorState();
		static_cast<UpdateReplicaKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(datacenterReplicasKeys, CLIENT_KNOBS->TOO_MANY);
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 1;
															#line 187 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1901 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 3;
															#line 205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 2, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& replicaKeys,int loopDepth) 
	{
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& kv : replicaKeys ) {
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dcId = decodeDatacenterReplicasKey(kv.key);
															#line 191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto replicas = decodeDatacenterReplicasValue(kv.value);
															#line 192 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if ((primaryDcId.size() && primaryDcId.at(0) == dcId) || (remoteDcIds.size() && remoteDcIds.at(0) == dcId && configuration.usableRegions > 1))
															#line 1964 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (replicas > configuration.storageTeamSize)
															#line 1968 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					tr.set(kv.key, datacenterReplicasValue(configuration.storageTeamSize));
															#line 1972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
			else
			{
															#line 198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tr.clear(kv.key);
															#line 1979 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 1, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 1991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && replicaKeys,int loopDepth) 
	{
															#line 189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& kv : replicaKeys ) {
															#line 190 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dcId = decodeDatacenterReplicasKey(kv.key);
															#line 191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto replicas = decodeDatacenterReplicasValue(kv.value);
															#line 192 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if ((primaryDcId.size() && primaryDcId.at(0) == dcId) || (remoteDcIds.size() && remoteDcIds.at(0) == dcId && configuration.usableRegions > 1))
															#line 2006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (replicas > configuration.storageTeamSize)
															#line 2010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					tr.set(kv.key, datacenterReplicasValue(configuration.storageTeamSize));
															#line 2014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
			else
			{
															#line 198 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tr.clear(kv.key);
															#line 2021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 2;
															#line 202 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateReplicaKeysActor, 1, Void >*>(static_cast<UpdateReplicaKeysActor*>(this)));
															#line 2033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& replicaKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(replicaKeys, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && replicaKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(replicaKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state > 0) static_cast<UpdateReplicaKeysActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateReplicaKeysActor*>(this)->ActorCallback< UpdateReplicaKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateReplicaKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> primaryDcId;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> remoteDcIds;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DatabaseConfiguration configuration;
															#line 181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 2297 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via updateReplicaKeys()
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class UpdateReplicaKeysActor final : public Actor<Void>, public ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >, public ActorCallback< UpdateReplicaKeysActor, 1, Void >, public ActorCallback< UpdateReplicaKeysActor, 2, Void >, public FastAllocated<UpdateReplicaKeysActor>, public UpdateReplicaKeysActorState<UpdateReplicaKeysActor> {
															#line 2302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<UpdateReplicaKeysActor>::operator new;
	using FastAllocated<UpdateReplicaKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17800199986647059200UL, 2783262462400806400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >;
friend struct ActorCallback< UpdateReplicaKeysActor, 1, Void >;
friend struct ActorCallback< UpdateReplicaKeysActor, 2, Void >;
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UpdateReplicaKeysActor(Database const& cx,std::vector<Optional<Key>> const& primaryDcId,std::vector<Optional<Key>> const& remoteDcIds,DatabaseConfiguration const& configuration) 
															#line 2321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateReplicaKeysActorState<UpdateReplicaKeysActor>(cx, primaryDcId, remoteDcIds, configuration),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateReplicaKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12167027471290647296UL, 8900329054216317952UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateReplicaKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateReplicaKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateReplicaKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateReplicaKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> updateReplicaKeys( Database const& cx, std::vector<Optional<Key>> const& primaryDcId, std::vector<Optional<Key>> const& remoteDcIds, DatabaseConfiguration const& configuration ) {
															#line 177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new UpdateReplicaKeysActor(cx, primaryDcId, remoteDcIds, configuration));
															#line 2355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 210 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 2360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via tryUpdateReplicasKeyForDc()
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class TryUpdateReplicasKeyForDcActor>
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class TryUpdateReplicasKeyForDcActorState {
															#line 2366 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TryUpdateReplicasKeyForDcActorState(Database const& cx,Optional<Key> const& dcId,int const& storageTeamSize) 
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   dcId(dcId),
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   storageTeamSize(storageTeamSize),
															#line 212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 2379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this));

	}
	~TryUpdateReplicasKeyForDcActorState() 
	{
		fdb_probe_actor_destroy("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 2394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 215 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(datacenterReplicasKeyFor(dcId));
															#line 218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 3;
															#line 231 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		oldReplicas = val.present() ? decodeDatacenterReplicasValue(val.get()) : 0;
															#line 220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas == storageTeamSize)
															#line 2483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
			this->~TryUpdateReplicasKeyForDcActorState();
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas < storageTeamSize)
															#line 2495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.set(rebootWhenDurableKey, StringRef());
															#line 2499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.set(datacenterReplicasKeyFor(dcId), datacenterReplicasValue(storageTeamSize));
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		oldReplicas = val.present() ? decodeDatacenterReplicasValue(val.get()) : 0;
															#line 220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas == storageTeamSize)
															#line 2523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
			this->~TryUpdateReplicasKeyForDcActorState();
			static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 223 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (oldReplicas < storageTeamSize)
															#line 2535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.set(rebootWhenDurableKey, StringRef());
															#line 2539 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 226 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.set(datacenterReplicasKeyFor(dcId), datacenterReplicasValue(storageTeamSize));
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*>(static_cast<TryUpdateReplicasKeyForDcActor*>(this)));
															#line 2552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2636 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 229 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV<int>::futures) { (void)(oldReplicas); this->~TryUpdateReplicasKeyForDcActorState(); static_cast<TryUpdateReplicasKeyForDcActor*>(this)->destroy(); return 0; }
															#line 2648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<TryUpdateReplicasKeyForDcActor*>(this)->SAV< int >::value()) int(std::move(oldReplicas)); // state_var_RVO
		this->~TryUpdateReplicasKeyForDcActorState();
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state > 0) static_cast<TryUpdateReplicasKeyForDcActor*>(this)->actor_wait_state = 0;
		static_cast<TryUpdateReplicasKeyForDcActor*>(this)->ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Optional<Key> dcId;
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int storageTeamSize;
															#line 212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int oldReplicas;
															#line 2828 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via tryUpdateReplicasKeyForDc()
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class TryUpdateReplicasKeyForDcActor final : public Actor<int>, public ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >, public ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >, public ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >, public FastAllocated<TryUpdateReplicasKeyForDcActor>, public TryUpdateReplicasKeyForDcActorState<TryUpdateReplicasKeyForDcActor> {
															#line 2833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<TryUpdateReplicasKeyForDcActor>::operator new;
	using FastAllocated<TryUpdateReplicasKeyForDcActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17594989824365942784UL, 10338047597511721728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >;
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >;
friend struct ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >;
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TryUpdateReplicasKeyForDcActor(Database const& cx,Optional<Key> const& dcId,int const& storageTeamSize) 
															#line 2852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<int>(),
		   TryUpdateReplicasKeyForDcActorState<TryUpdateReplicasKeyForDcActor>(cx, dcId, storageTeamSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14015056509346087168UL, 12566327531761134080UL);
		ActorExecutionContextHelper __helper(static_cast<TryUpdateReplicasKeyForDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryUpdateReplicasKeyForDc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryUpdateReplicasKeyForDc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TryUpdateReplicasKeyForDcActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<int> tryUpdateReplicasKeyForDc( Database const& cx, Optional<Key> const& dcId, int const& storageTeamSize ) {
															#line 211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<int>(new TryUpdateReplicasKeyForDcActor(cx, dcId, storageTeamSize));
															#line 2886 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 235 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	// Read keyservers, return unique set of teams
																#line 2892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via getInitialDataDistribution()
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class GetInitialDataDistributionActor>
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetInitialDataDistributionActorState {
															#line 2898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetInitialDataDistributionActorState(Database const& cx,UID const& distributorId,MoveKeysLock const& moveKeysLock,std::vector<Optional<Key>> const& remoteDcIds,const DDEnabledState* const& ddEnabledState,SkipDDModeCheck const& skipDDModeCheck) 
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   distributorId(distributorId),
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   moveKeysLock(moveKeysLock),
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   remoteDcIds(remoteDcIds),
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   skipDDModeCheck(skipDDModeCheck),
															#line 244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   result(makeReference<InitialDataDistribution>()),
															#line 245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   beginKey(allKeys.begin),
															#line 247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   succeeded(),
															#line 249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 2923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("getInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	~GetInitialDataDistributionActorState() 
	{
		fdb_probe_actor_destroy("getInitialDataDistribution", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 251 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (ddLargeTeamEnabled())
															#line 2938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(result->userRangeConfig, DDConfiguration().userRangeConfig().getSnapshot( SystemDBWriteLockedNow(cx.getReference()), allKeys.begin, allKeys.end));
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2944 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 1;
															#line 252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 0, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 2949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetInitialDataDistributionActorState();
		static_cast<GetInitialDataDistributionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		server_dc = std::map<UID, Optional<Key>>();
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		team_cache = std::map<std::vector<UID>, std::pair<std::vector<UID>, std::vector<UID>>>();
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tss_servers = std::vector<std::pair<StorageServerInterface, ProcessClass>>();
															#line 259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		numDataMoves = 0;
															#line 261 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		CODE_PROBE((bool)skipDDModeCheck, "DD Mode won't prevent read initial data distribution.");
															#line 264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 2987 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 3083 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		numDataMoves = 0;
															#line 266 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		server_dc.clear();
															#line 267 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->allServers.clear();
															#line 268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->dataMoveMap = KeyRangeMap<std::shared_ptr<DataMove>>(std::make_shared<DataMove>());
															#line 269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->auditStates.clear();
															#line 270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tss_servers.clear();
															#line 271 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		team_cache.clear();
															#line 272 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = false;
															#line 3113 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 276 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(healthyZoneKey);
															#line 278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3125 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3130 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("GetInitialTeamsRetry", distributorId).error(e);
															#line 388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 8;
															#line 388 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 7, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3174 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (val.present())
															#line 3189 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto p = decodeHealthyZoneValue(val.get());
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (p.second > tr.getReadVersion().get() || p.first == ignoreSSFailuresZoneString)
															#line 3195 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 282 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->initHealthyZoneValue = Optional<Key>(p.first);
															#line 3199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->initHealthyZoneValue = Optional<Key>();
															#line 3205 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
		else
		{
															#line 287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->initHealthyZoneValue = Optional<Key>();
															#line 3212 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->mode = 1;
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataDistributionModeKey);
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 3;
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3225 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (val.present())
															#line 3234 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 280 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto p = decodeHealthyZoneValue(val.get());
															#line 281 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (p.second > tr.getReadVersion().get() || p.first == ignoreSSFailuresZoneString)
															#line 3240 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 282 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->initHealthyZoneValue = Optional<Key>(p.first);
															#line 3244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->initHealthyZoneValue = Optional<Key>();
															#line 3250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
		else
		{
															#line 287 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->initHealthyZoneValue = Optional<Key>();
															#line 3257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->mode = 1;
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr.get(dataDistributionModeKey);
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3265 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 3;
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3270 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& mode,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 3354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->mode;
															#line 3360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if ((!skipDDModeCheck && !result->mode) || !ddEnabledState->isEnabled())
															#line 3364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "GetInitialDataDistribution_DisabledDD").log();
															#line 299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 3370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
			this->~GetInitialDataDistributionActorState();
			static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkLoadMode = 0;
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(bulkLoadModeKey);
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 4;
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && mode,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 3396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 293 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 294 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->mode;
															#line 3402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 296 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if ((!skipDDModeCheck && !result->mode) || !ddEnabledState->isEnabled())
															#line 3406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 298 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "GetInitialDataDistribution_DisabledDD").log();
															#line 299 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 3412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
			this->~GetInitialDataDistributionActorState();
			static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 302 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkLoadMode = 0;
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr.get(bulkLoadModeKey);
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 4;
															#line 303 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(mode, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont8(Optional<Value> const& bulkLoadMode,int loopDepth) 
	{
															#line 304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkLoadMode.present())
															#line 3513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkLoadMode.get(), Unversioned());
															#line 306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkLoadMode;
															#line 3519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkLoadEngineInitMode").detail("Mode", result->bulkLoadMode);
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkDumpMode = 0;
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(bulkDumpModeKey);
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 5;
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3534 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Optional<Value> && bulkLoadMode,int loopDepth) 
	{
															#line 304 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkLoadMode.present())
															#line 3543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 305 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkLoadMode.get(), Unversioned());
															#line 306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkLoadMode;
															#line 3549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 308 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkLoadEngineInitMode").detail("Mode", result->bulkLoadMode);
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->bulkDumpMode = 0;
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = tr.get(bulkDumpModeKey);
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 5;
															#line 311 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Optional<Value> const& bulkLoadMode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(bulkLoadMode, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Optional<Value> && bulkLoadMode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(bulkLoadMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(Optional<Value> const& bulkDumpMode,int loopDepth) 
	{
															#line 312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkDumpMode.present())
															#line 3648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkDumpMode.get(), Unversioned());
															#line 314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkDumpMode;
															#line 3654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkDumpInitMode").detail("Mode", result->bulkDumpMode);
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		workers = getWorkers(&tr);
															#line 319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		serverList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(workers) && success(serverList);
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3666 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 6;
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 5, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Optional<Value> && bulkDumpMode,int loopDepth) 
	{
															#line 312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (bulkDumpMode.present())
															#line 3680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(bulkDumpMode.get(), Unversioned());
															#line 314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> result->bulkDumpMode;
															#line 3686 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevInfo, "DDBulkDumpInitMode").detail("Mode", result->bulkDumpMode);
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		workers = getWorkers(&tr);
															#line 319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		serverList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_5 = success(workers) && success(serverList);
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 6;
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 5, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3703 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Optional<Value> const& bulkDumpMode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(bulkDumpMode, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Optional<Value> && bulkDumpMode,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(bulkDumpMode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.get().more && serverList.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, ProcessData> id_data;
															#line 324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < workers.get().size();i++) {
															#line 325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			id_data[workers.get()[i].locality.processId()] = workers.get()[i];
															#line 3793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < serverList.get().size();i++) {
															#line 328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ssi = decodeServerListValue(serverList.get()[i].value);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!ssi.isTss())
															#line 3801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->allServers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				server_dc[ssi.id()] = ssi.locality.dcId();
															#line 3807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tss_servers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 3813 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr.getRange(dataMoveKeys, CLIENT_KNOBS->TOO_MANY);
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 7;
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3825 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1(Void && _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!serverList.get().more && serverList.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, ProcessData> id_data;
															#line 324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < workers.get().size();i++) {
															#line 325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			id_data[workers.get()[i].locality.processId()] = workers.get()[i];
															#line 3840 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < serverList.get().size();i++) {
															#line 328 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ssi = decodeServerListValue(serverList.get()[i].value);
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!ssi.isTss())
															#line 3848 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->allServers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				server_dc[ssi.id()] = ssi.locality.dcId();
															#line 3854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				tss_servers.emplace_back(ssi, id_data[ssi.locality.processId()].processClass);
															#line 3860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr.getRange(dataMoveKeys, CLIENT_KNOBS->TOO_MANY);
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3867 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 7;
															#line 337 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 3872 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont11cont3(RangeResult const& dms,int loopDepth) 
	{
															#line 338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!dms.more && dms.size() < CLIENT_KNOBS->TOO_MANY);
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < dms.size();++i) {
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dataMove = std::make_shared<DataMove>(decodeDataMoveValue(dms[i].value), true);
															#line 342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			const DataMoveMetaData& meta = dataMove->meta;
															#line 343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (meta.ranges.empty())
															#line 3964 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(meta.getPhase() == DataMoveMetaData::Deleting);
															#line 350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->toCleanDataMoveTombstone.push_back(meta.id);
															#line 3970 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(!meta.ranges.empty());
															#line 354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.src ) {
															#line 355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 3981 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 357 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteSrc.push_back(id);
															#line 3985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primarySrc.push_back(id);
															#line 3991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.dest ) {
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteDest.push_back(id);
															#line 4004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primaryDest.push_back(id);
															#line 4010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primarySrc.begin(), dataMove->primarySrc.end());
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteSrc.begin(), dataMove->remoteSrc.end());
															#line 372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primaryDest.begin(), dataMove->primaryDest.end());
															#line 373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteDest.begin(), dataMove->remoteDest.end());
															#line 375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ranges = result->dataMoveMap.intersectingRanges(meta.ranges.front());
															#line 376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( auto& r : ranges ) {
															#line 377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(!r.value()->valid);
															#line 4027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->dataMoveMap.insert(meta.ranges.front(), std::move(dataMove));
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			++numDataMoves;
															#line 4033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 4037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont3(RangeResult && dms,int loopDepth) 
	{
															#line 338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!dms.more && dms.size() < CLIENT_KNOBS->TOO_MANY);
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < dms.size();++i) {
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto dataMove = std::make_shared<DataMove>(decodeDataMoveValue(dms[i].value), true);
															#line 342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			const DataMoveMetaData& meta = dataMove->meta;
															#line 343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (meta.ranges.empty())
															#line 4054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(meta.getPhase() == DataMoveMetaData::Deleting);
															#line 350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->toCleanDataMoveTombstone.push_back(meta.id);
															#line 4060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				continue;
			}
															#line 353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(!meta.ranges.empty());
															#line 354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.src ) {
															#line 355 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 357 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteSrc.push_back(id);
															#line 4075 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primarySrc.push_back(id);
															#line 4081 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( const UID& id : meta.dest ) {
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto& dc = server_dc[id];
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4090 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->remoteDest.push_back(id);
															#line 4094 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					dataMove->primaryDest.push_back(id);
															#line 4100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
			}
															#line 370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primarySrc.begin(), dataMove->primarySrc.end());
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteSrc.begin(), dataMove->remoteSrc.end());
															#line 372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->primaryDest.begin(), dataMove->primaryDest.end());
															#line 373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(dataMove->remoteDest.begin(), dataMove->remoteDest.end());
															#line 375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto ranges = result->dataMoveMap.intersectingRanges(meta.ranges.front());
															#line 376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for( auto& r : ranges ) {
															#line 377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(!r.value()->valid);
															#line 4117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->dataMoveMap.insert(meta.ranges.front(), std::move(dataMove));
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			++numDataMoves;
															#line 4123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 4127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1when1(RangeResult const& dms,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont3(dms, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11cont1when1(RangeResult && dms,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont3(std::move(dms), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 4211 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 4220 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		result->shards.push_back(DDShardInfo(allKeys.end));
															#line 498 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && numDataMoves > 0)
															#line 4306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			for(int shard = 0;shard < result->shards.size() - 1;++shard) {
															#line 500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				const DDShardInfo& iShard = result->shards[shard];
															#line 501 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				KeyRangeRef keys = KeyRangeRef(iShard.key, result->shards[shard + 1].key);
															#line 502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				result->dataMoveMap[keys.begin]->validateShard(iShard, keys);
															#line 4316 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& it : tss_servers ) {
															#line 508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->allServers.push_back(it);
															#line 4323 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<GetInitialDataDistributionActor*>(this)->SAV<Reference<InitialDataDistribution>>::futures) { (void)(result); this->~GetInitialDataDistributionActorState(); static_cast<GetInitialDataDistributionActor*>(this)->destroy(); return 0; }
															#line 4327 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<GetInitialDataDistributionActor*>(this)->SAV< Reference<InitialDataDistribution> >::value()) Reference<InitialDataDistribution>(std::move(result)); // state_var_RVO
		this->~GetInitialDataDistributionActorState();
		static_cast<GetInitialDataDistributionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 396 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!(beginKey < allKeys.end))
															#line 4346 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		CODE_PROBE(beginKey > allKeys.begin, "Multi-transactional getInitialDataDistribution");
															#line 398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 4354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 4376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1(int loopDepth) 
	{
															#line 399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = false;
															#line 4392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_8 = checkMoveKeysLockReadOnly(&tr, moveKeysLock, ddEnabledState);
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 9;
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 8, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("GetInitialTeamsKeyServersRetry", distributorId).error(e);
															#line 486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont3loopBody1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 12;
															#line 486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 11, Void >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_9 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 10;
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_9 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 10;
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont3loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 406 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<RangeResult> __when_expr_10 = krmGetRanges(&tr, keyServersPrefix, KeyRangeRef(beginKey, allKeys.end), SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4579 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 11;
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*>(static_cast<GetInitialDataDistributionActor*>(this)));
															#line 4584 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 4593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont3loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont3loopBody1loopBody1cont4(RangeResult const& keyServers,int loopDepth) 
	{
															#line 412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 414 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> src, dest, last;
															#line 415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;i++) {
															#line 419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			DDShardInfo info(keyServers[i].key, srcId, destId);
															#line 421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (remoteDcIds.size())
															#line 4684 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 423 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 4690 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					for( auto& id : src ) {
															#line 425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						auto& dc = server_dc[id];
															#line 426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4698 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						{
															#line 427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.remoteSrc.push_back(id);
															#line 4702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
						else
						{
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.primarySrc.push_back(id);
															#line 4708 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
					}
															#line 432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(info.primarySrc);
															#line 433 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->remoteTeams.insert(info.remoteSrc);
															#line 434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::make_pair(info.primarySrc, info.remoteSrc);
															#line 4717 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primarySrc = srcIter->second.first;
															#line 437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.remoteSrc = srcIter->second.second;
															#line 4725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 4729 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 441 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 4737 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						for( auto& id : dest ) {
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							auto& dc = server_dc[id];
															#line 445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4745 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							{
															#line 447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.remoteDest.push_back(id);
															#line 4749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
							else
							{
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.primaryDest.push_back(id);
															#line 4755 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
						}
															#line 452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(info.primaryDest);
															#line 453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->remoteTeams.insert(info.remoteDest);
															#line 454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::make_pair(info.primaryDest, info.remoteDest);
															#line 4764 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
					else
					{
															#line 456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.primaryDest = destIter->second.first;
															#line 457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.remoteDest = destIter->second.second;
															#line 4772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				info.primarySrc = src;
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 4784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(src);
															#line 465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 4790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 467 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 4794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primaryDest = dest;
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 4804 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(dest);
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 4810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
															#line 477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->shards.push_back(info);
															#line 4816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GT(keyServers.size(), 0);
															#line 481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		beginKey = keyServers.end()[-1].key;
															#line 4822 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont4(RangeResult && keyServers,int loopDepth) 
	{
															#line 412 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		succeeded = true;
															#line 414 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<UID> src, dest, last;
															#line 415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID srcId, destId;
															#line 418 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(int i = 0;i < keyServers.size() - 1;i++) {
															#line 419 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, keyServers[i].value, src, dest, srcId, destId);
															#line 420 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			DDShardInfo info(keyServers[i].key, srcId, destId);
															#line 421 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (remoteDcIds.size())
															#line 4843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 423 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 4849 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					for( auto& id : src ) {
															#line 425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						auto& dc = server_dc[id];
															#line 426 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						{
															#line 427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.remoteSrc.push_back(id);
															#line 4861 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
						else
						{
															#line 429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							info.primarySrc.push_back(id);
															#line 4867 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
						}
					}
															#line 432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(info.primarySrc);
															#line 433 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->remoteTeams.insert(info.remoteSrc);
															#line 434 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::make_pair(info.primarySrc, info.remoteSrc);
															#line 4876 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
				else
				{
															#line 436 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primarySrc = srcIter->second.first;
															#line 437 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.remoteSrc = srcIter->second.second;
															#line 4884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 4888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 441 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 442 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 4896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						for( auto& id : dest ) {
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							auto& dc = server_dc[id];
															#line 445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
							if (std::find(remoteDcIds.begin(), remoteDcIds.end(), dc) != remoteDcIds.end())
															#line 4904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							{
															#line 447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.remoteDest.push_back(id);
															#line 4908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
							else
							{
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
								info.primaryDest.push_back(id);
															#line 4914 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
							}
						}
															#line 452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(info.primaryDest);
															#line 453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->remoteTeams.insert(info.remoteDest);
															#line 454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::make_pair(info.primaryDest, info.remoteDest);
															#line 4923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
					else
					{
															#line 456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.primaryDest = destIter->second.first;
															#line 457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						info.remoteDest = destIter->second.second;
															#line 4931 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				info.primarySrc = src;
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				auto srcIter = team_cache.find(src);
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (srcIter == team_cache.end())
															#line 4943 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					result->primaryTeams.insert(src);
															#line 465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					team_cache[src] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 4949 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				}
															#line 467 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (dest.size())
															#line 4953 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				{
															#line 468 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.hasDest = true;
															#line 469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					info.primaryDest = dest;
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					auto destIter = team_cache.find(dest);
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
					if (destIter == team_cache.end())
															#line 4963 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					{
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						result->primaryTeams.insert(dest);
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
						team_cache[dest] = std::pair<std::vector<UID>, std::vector<UID>>();
															#line 4969 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
					}
				}
			}
															#line 477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			result->shards.push_back(info);
															#line 4975 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GT(keyServers.size(), 0);
															#line 481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		beginKey = keyServers.end()[-1].key;
															#line 4981 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont3when1(RangeResult const& keyServers,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont4(keyServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont3when1(RangeResult && keyServers,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont4(std::move(keyServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 5065 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(!succeeded);
															#line 5074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state > 0) static_cast<GetInitialDataDistributionActor*>(this)->actor_wait_state = 0;
		static_cast<GetInitialDataDistributionActor*>(this)->ActorCallback< GetInitialDataDistributionActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< GetInitialDataDistributionActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UID distributorId;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysLock moveKeysLock;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<Optional<Key>> remoteDcIds;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	SkipDDModeCheck skipDDModeCheck;
															#line 244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<InitialDataDistribution> result;
															#line 245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Key beginKey;
															#line 247 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	bool succeeded;
															#line 249 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 256 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, Optional<Key>> server_dc;
															#line 257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<std::vector<UID>, std::pair<std::vector<UID>, std::vector<UID>>> team_cache;
															#line 258 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<std::pair<StorageServerInterface, ProcessClass>> tss_servers;
															#line 259 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	int numDataMoves;
															#line 318 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<std::vector<ProcessData>> workers;
															#line 319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<RangeResult> serverList;
															#line 405 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 5188 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via getInitialDataDistribution()
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class GetInitialDataDistributionActor final : public Actor<Reference<InitialDataDistribution>>, public ActorCallback< GetInitialDataDistributionActor, 0, Void >, public ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >, public ActorCallback< GetInitialDataDistributionActor, 5, Void >, public ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 7, Void >, public ActorCallback< GetInitialDataDistributionActor, 8, Void >, public ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >, public ActorCallback< GetInitialDataDistributionActor, 11, Void >, public FastAllocated<GetInitialDataDistributionActor>, public GetInitialDataDistributionActorState<GetInitialDataDistributionActor> {
															#line 5193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<GetInitialDataDistributionActor>::operator new;
	using FastAllocated<GetInitialDataDistributionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5266744408689175552UL, 15006672381253432576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<InitialDataDistribution>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetInitialDataDistributionActor, 0, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >;
friend struct ActorCallback< GetInitialDataDistributionActor, 5, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 7, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 8, Void >;
friend struct ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >;
friend struct ActorCallback< GetInitialDataDistributionActor, 11, Void >;
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	GetInitialDataDistributionActor(Database const& cx,UID const& distributorId,MoveKeysLock const& moveKeysLock,std::vector<Optional<Key>> const& remoteDcIds,const DDEnabledState* const& ddEnabledState,SkipDDModeCheck const& skipDDModeCheck) 
															#line 5221 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Reference<InitialDataDistribution>>(),
		   GetInitialDataDistributionActorState<GetInitialDataDistributionActor>(cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10463857597529131008UL, 248268333580752640UL);
		ActorExecutionContextHelper __helper(static_cast<GetInitialDataDistributionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getInitialDataDistribution");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getInitialDataDistribution", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 9, RangeResult >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 10, RangeResult >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< GetInitialDataDistributionActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Reference<InitialDataDistribution>> getInitialDataDistribution( Database const& cx, UID const& distributorId, MoveKeysLock const& moveKeysLock, std::vector<Optional<Key>> const& remoteDcIds, const DDEnabledState* const& ddEnabledState, SkipDDModeCheck const& skipDDModeCheck ) {
															#line 237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Reference<InitialDataDistribution>>(new GetInitialDataDistributionActor(cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck));
															#line 5264 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 513 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 5269 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitForDataDistributionEnabled()
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitForDataDistributionEnabledActor>
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForDataDistributionEnabledActorState {
															#line 5275 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForDataDistributionEnabledActorState(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 5286 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	~WaitForDataDistributionEnabledActorState() 
	{
		fdb_probe_actor_destroy("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 5301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForDataDistributionEnabledActorState();
		static_cast<WaitForDataDistributionEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_ENABLED_CHECK_DELAY, TaskPriority::DataDistribution);
															#line 517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 1;
															#line 517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5338 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(dataDistributionModeKey);
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5357 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5362 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 5381 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(dataDistributionModeKey);
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5387 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 524 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5392 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 3;
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*>(static_cast<WaitForDataDistributionEnabledActor*>(this)));
															#line 5496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> const& mode,int loopDepth) 
	{
															#line 525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 5511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5517 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForDataDistributionEnabledActorState();
			static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 5525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 533 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "WaitForDDEnabled") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 5537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitForDataDistributionEnabledActorState();
				static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 5552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && mode,int loopDepth) 
	{
															#line 525 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 5561 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 526 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForDataDistributionEnabledActorState();
			static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 5575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 530 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 533 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "WaitForDDEnabled") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 536 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 5587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent("WaitForDDEnabledSucceeded").log();
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForDataDistributionEnabledActorState(); static_cast<WaitForDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<WaitForDataDistributionEnabledActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitForDataDistributionEnabledActorState();
				static_cast<WaitForDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 542 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.reset();
															#line 5602 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<WaitForDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForDataDistributionEnabledActor*>(this)->ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 515 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 5788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitForDataDistributionEnabled()
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForDataDistributionEnabledActor final : public Actor<Void>, public ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >, public ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >, public ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >, public FastAllocated<WaitForDataDistributionEnabledActor>, public WaitForDataDistributionEnabledActorState<WaitForDataDistributionEnabledActor> {
															#line 5793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitForDataDistributionEnabledActor>::operator new;
	using FastAllocated<WaitForDataDistributionEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9290189383451350272UL, 228326403184086272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >;
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >;
friend struct ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >;
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForDataDistributionEnabledActor(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 5812 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForDataDistributionEnabledActorState<WaitForDataDistributionEnabledActor>(cx, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15564198525845133568UL, 7701605132217084160UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForDataDistributionEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForDataDistributionEnabledActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitForDataDistributionEnabled( Database const& cx, const DDEnabledState* const& ddEnabledState ) {
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitForDataDistributionEnabledActor(cx, ddEnabledState));
															#line 5846 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 548 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 5851 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via isDataDistributionEnabled()
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class IsDataDistributionEnabledActor>
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class IsDataDistributionEnabledActorState {
															#line 5857 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	IsDataDistributionEnabledActorState(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 5868 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	~IsDataDistributionEnabledActorState() 
	{
		fdb_probe_actor_destroy("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 5883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 553 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 554 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 5917 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(dataDistributionModeKey);
															#line 557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5923 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 5928 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5952 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 3;
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 2, Void >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 5957 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& mode,int loopDepth) 
	{
															#line 558 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 5972 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 5976 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 5984 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 561 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 5994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
				this->~IsDataDistributionEnabledActorState();
				static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(moveKeysLockOwnerKey);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6016 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && mode,int loopDepth) 
	{
															#line 558 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!mode.present() && ddEnabledState->isEnabled())
															#line 6025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 560 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (mode.present())
															#line 6037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 561 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			BinaryReader rd(mode.get(), Unversioned());
															#line 562 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			int m;
															#line 563 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			rd >> m;
															#line 564 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (m && ddEnabledState->isEnabled())
															#line 6047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 565 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("Mode", m) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 568 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
				this->~IsDataDistributionEnabledActorState();
				static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(moveKeysLockOwnerKey);
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6064 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 2;
															#line 572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*>(static_cast<IsDataDistributionEnabledActor*>(this)));
															#line 6069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(mode, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && mode,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 573 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ddEnabledState->isEnabled() && (currentOwner != dataDistributionModeLock))
															#line 6155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6161 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, "IsDDEnabledFailed") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6171 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(false);
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && readVal,int loopDepth) 
	{
															#line 573 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 575 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ddEnabledState->isEnabled() && (currentOwner != dataDistributionModeLock))
															#line 6185 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, "IsDDEnabledSucceeded") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 580 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6191 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(true);
			this->~IsDataDistributionEnabledActorState();
			static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, "IsDDEnabledFailed") .detail("CurrentOwner", currentOwner) .detail("DDModeLock", dataDistributionModeLock) .detail("IsDDEnabled", ddEnabledState->isEnabled());
															#line 586 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<IsDataDistributionEnabledActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IsDataDistributionEnabledActorState(); static_cast<IsDataDistributionEnabledActor*>(this)->destroy(); return 0; }
															#line 6201 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<IsDataDistributionEnabledActor*>(this)->SAV< bool >::value()) bool(false);
		this->~IsDataDistributionEnabledActorState();
		static_cast<IsDataDistributionEnabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state > 0) static_cast<IsDataDistributionEnabledActor*>(this)->actor_wait_state = 0;
		static_cast<IsDataDistributionEnabledActor*>(this)->ActorCallback< IsDataDistributionEnabledActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IsDataDistributionEnabledActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 6377 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via isDataDistributionEnabled()
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class IsDataDistributionEnabledActor final : public Actor<bool>, public ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >, public ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >, public ActorCallback< IsDataDistributionEnabledActor, 2, Void >, public FastAllocated<IsDataDistributionEnabledActor>, public IsDataDistributionEnabledActorState<IsDataDistributionEnabledActor> {
															#line 6382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<IsDataDistributionEnabledActor>::operator new;
	using FastAllocated<IsDataDistributionEnabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4596044518030911232UL, 11567619834176889344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >;
friend struct ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >;
friend struct ActorCallback< IsDataDistributionEnabledActor, 2, Void >;
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	IsDataDistributionEnabledActor(Database const& cx,const DDEnabledState* const& ddEnabledState) 
															#line 6401 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<bool>(),
		   IsDataDistributionEnabledActorState<IsDataDistributionEnabledActor>(cx, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10262884121966814464UL, 6357713925423661312UL);
		ActorExecutionContextHelper __helper(static_cast<IsDataDistributionEnabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("isDataDistributionEnabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("isDataDistributionEnabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IsDataDistributionEnabledActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<bool> isDataDistributionEnabled( Database const& cx, const DDEnabledState* const& ddEnabledState ) {
															#line 549 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<bool>(new IsDataDistributionEnabledActor(cx, ddEnabledState));
															#line 6435 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 6440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via pollMoveKeysLock()
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class PollMoveKeysLockActor>
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class PollMoveKeysLockActorState {
															#line 6446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	PollMoveKeysLockActorState(Database const& cx,MoveKeysLock const& lock,const DDEnabledState* const& ddEnabledState) 
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   lock(lock),
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ddEnabledState(ddEnabledState)
															#line 6457 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("pollMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	~PollMoveKeysLockActorState() 
	{
		fdb_probe_actor_destroy("pollMoveKeysLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 594 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 6472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PollMoveKeysLockActorState();
		static_cast<PollMoveKeysLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->MOVEKEYS_LOCK_POLLING_DELAY);
															#line 595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6504 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 1;
															#line 595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 0, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 6509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr = Transaction(cx);
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 6520 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr = Transaction(cx);
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		;
															#line 6531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 600 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 6632 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		try {
															#line 602 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkMoveKeysLockReadOnly(&tr, lock, ddEnabledState);
															#line 602 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 2;
															#line 602 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 1, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 6643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6680 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 3;
															#line 605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollMoveKeysLockActor, 2, Void >*>(static_cast<PollMoveKeysLockActor*>(this)));
															#line 6685 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state > 0) static_cast<PollMoveKeysLockActor*>(this)->actor_wait_state = 0;
		static_cast<PollMoveKeysLockActor*>(this)->ActorCallback< PollMoveKeysLockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PollMoveKeysLockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysLock lock;
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 596 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 6878 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via pollMoveKeysLock()
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class PollMoveKeysLockActor final : public Actor<Void>, public ActorCallback< PollMoveKeysLockActor, 0, Void >, public ActorCallback< PollMoveKeysLockActor, 1, Void >, public ActorCallback< PollMoveKeysLockActor, 2, Void >, public FastAllocated<PollMoveKeysLockActor>, public PollMoveKeysLockActorState<PollMoveKeysLockActor> {
															#line 6883 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<PollMoveKeysLockActor>::operator new;
	using FastAllocated<PollMoveKeysLockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(892420312008860672UL, 5762388057918923008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PollMoveKeysLockActor, 0, Void >;
friend struct ActorCallback< PollMoveKeysLockActor, 1, Void >;
friend struct ActorCallback< PollMoveKeysLockActor, 2, Void >;
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	PollMoveKeysLockActor(Database const& cx,MoveKeysLock const& lock,const DDEnabledState* const& ddEnabledState) 
															#line 6902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   PollMoveKeysLockActorState<PollMoveKeysLockActor>(cx, lock, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1354989846012357376UL, 3295455225436393472UL);
		ActorExecutionContextHelper __helper(static_cast<PollMoveKeysLockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pollMoveKeysLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pollMoveKeysLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PollMoveKeysLockActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> pollMoveKeysLock( Database const& cx, MoveKeysLock const& lock, const DDEnabledState* const& ddEnabledState ) {
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new PollMoveKeysLockActor(cx, lock, ddEnabledState));
															#line 6936 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 610 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 6941 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via readRebalanceDDIgnoreKey()
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class ReadRebalanceDDIgnoreKeyActor>
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class ReadRebalanceDDIgnoreKeyActorState {
															#line 6947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadRebalanceDDIgnoreKeyActorState(Database const& cx) 
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 6956 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this));

	}
	~ReadRebalanceDDIgnoreKeyActorState() 
	{
		fdb_probe_actor_destroy("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 6971 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 617 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(rebalanceDDIgnoreKey);
															#line 619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7010 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 1;
															#line 619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*>(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)));
															#line 7015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7039 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 2;
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*>(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)));
															#line 7044 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res,int loopDepth) 
	{
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadRebalanceDDIgnoreKeyActorState(); static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->destroy(); return 0; }
															#line 7059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(res);
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res,int loopDepth) 
	{
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadRebalanceDDIgnoreKeyActorState(); static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->destroy(); return 0; }
															#line 7071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(res);
		this->~ReadRebalanceDDIgnoreKeyActorState();
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 612 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Transaction tr;
															#line 7245 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via readRebalanceDDIgnoreKey()
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class ReadRebalanceDDIgnoreKeyActor final : public Actor<Optional<Value>>, public ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >, public ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >, public FastAllocated<ReadRebalanceDDIgnoreKeyActor>, public ReadRebalanceDDIgnoreKeyActorState<ReadRebalanceDDIgnoreKeyActor> {
															#line 7250 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<ReadRebalanceDDIgnoreKeyActor>::operator new;
	using FastAllocated<ReadRebalanceDDIgnoreKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16257435944511626496UL, 1760280072875895808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >;
friend struct ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >;
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadRebalanceDDIgnoreKeyActor(Database const& cx) 
															#line 7268 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   ReadRebalanceDDIgnoreKeyActorState<ReadRebalanceDDIgnoreKeyActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11304031174234803712UL, 14849188401685608704UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRebalanceDDIgnoreKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRebalanceDDIgnoreKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRebalanceDDIgnoreKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRebalanceDDIgnoreKeyActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRebalanceDDIgnoreKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> readRebalanceDDIgnoreKey( Database const& cx ) {
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Optional<Value>>(new ReadRebalanceDDIgnoreKeyActor(cx));
															#line 7301 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 626 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 7306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitDDTeamInfoPrintSignal()
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitDDTeamInfoPrintSignalActor>
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitDDTeamInfoPrintSignalActorState {
															#line 7312 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitDDTeamInfoPrintSignalActorState(Database const& cx) 
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(cx)
															#line 7321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this));

	}
	~WaitDDTeamInfoPrintSignalActorState() 
	{
		fdb_probe_actor_destroy("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 7336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 632 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			watchFuture = tr.watch(triggerDDTeamInfoPrintKey);
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7373 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 1;
															#line 633 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 3;
															#line 637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watchFuture;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7424 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 2;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7429 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watchFuture;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7440 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 2;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*>(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)));
															#line 7445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitDDTeamInfoPrintSignalActorState(); static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->destroy(); return 0; }
															#line 7529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitDDTeamInfoPrintSignalActorState(); static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->destroy(); return 0; }
															#line 7541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitDDTeamInfoPrintSignalActorState();
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state > 0) static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->actor_wait_state = 0;
		static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 632 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Future<Void> watchFuture;
															#line 7717 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitDDTeamInfoPrintSignal()
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitDDTeamInfoPrintSignalActor final : public Actor<Void>, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >, public ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >, public FastAllocated<WaitDDTeamInfoPrintSignalActor>, public WaitDDTeamInfoPrintSignalActorState<WaitDDTeamInfoPrintSignalActor> {
															#line 7722 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitDDTeamInfoPrintSignalActor>::operator new;
	using FastAllocated<WaitDDTeamInfoPrintSignalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11663098398724839168UL, 18118295227753550336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >;
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >;
friend struct ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >;
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitDDTeamInfoPrintSignalActor(Database const& cx) 
															#line 7741 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitDDTeamInfoPrintSignalActorState<WaitDDTeamInfoPrintSignalActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9369237719149148416UL, 5611890522281058048UL);
		ActorExecutionContextHelper __helper(static_cast<WaitDDTeamInfoPrintSignalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitDDTeamInfoPrintSignal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitDDTeamInfoPrintSignal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitDDTeamInfoPrintSignalActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitDDTeamInfoPrintSignal( Database const& cx ) {
															#line 627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitDDTeamInfoPrintSignalActor(cx));
															#line 7775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 641 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

																#line 7780 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via waitForAllDataRemoved()
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class WaitForAllDataRemovedActor>
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForAllDataRemovedActorState {
															#line 7786 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForAllDataRemovedActorState(Database const& cx,UID const& serverID,Version const& addedVersion,Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure) 
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : cx(cx),
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   serverID(serverID),
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   addedVersion(addedVersion),
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   shardsAffectedByTeamFailure(shardsAffectedByTeamFailure),
															#line 647 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 7801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this));

	}
	~WaitForAllDataRemovedActorState() 
	{
		fdb_probe_actor_destroy("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 7816 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForAllDataRemovedActorState();
		static_cast<WaitForAllDataRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7853 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 1;
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 0, Version >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 7858 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7882 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 4;
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 3, Void >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 7887 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& ver,int loopDepth) 
	{
															#line 656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ver > addedVersion + SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 7902 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<bool> __when_expr_1 = canRemoveStorageServer(tr, serverID);
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7908 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 2;
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 1, bool >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 7913 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && ver,int loopDepth) 
	{
															#line 656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (ver > addedVersion + SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
															#line 7927 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<bool> __when_expr_1 = canRemoveStorageServer(tr, serverID);
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7933 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 2;
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 1, bool >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 7938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->ALL_DATA_REMOVED_DELAY, TaskPriority::DataDistribution);
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8029 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 3;
															#line 670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForAllDataRemovedActor, 2, Void >*>(static_cast<WaitForAllDataRemovedActor*>(this)));
															#line 8034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool const& canRemove,int loopDepth) 
	{
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto shards = shardsAffectedByTeamFailure->getNumberOfShards(serverID);
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevVerbose, "WaitForAllDataRemoved") .detail("Server", serverID) .detail("CanRemove", canRemove) .detail("Shards", shards);
															#line 663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GE(shards, 0);
															#line 664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (canRemove && shards == 0)
															#line 8049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForAllDataRemovedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllDataRemovedActorState(); static_cast<WaitForAllDataRemovedActor*>(this)->destroy(); return 0; }
															#line 8053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForAllDataRemovedActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllDataRemovedActorState();
			static_cast<WaitForAllDataRemovedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(bool && canRemove,int loopDepth) 
	{
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto shards = shardsAffectedByTeamFailure->getNumberOfShards(serverID);
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevVerbose, "WaitForAllDataRemoved") .detail("Server", serverID) .detail("CanRemove", canRemove) .detail("Shards", shards);
															#line 663 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_GE(shards, 0);
															#line 664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (canRemove && shards == 0)
															#line 8073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!static_cast<WaitForAllDataRemovedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForAllDataRemovedActorState(); static_cast<WaitForAllDataRemovedActor*>(this)->destroy(); return 0; }
															#line 8077 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			new (&static_cast<WaitForAllDataRemovedActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForAllDataRemovedActorState();
			static_cast<WaitForAllDataRemovedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool const& canRemove,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(canRemove, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(bool && canRemove,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(canRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr->reset();
															#line 8166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		tr->reset();
															#line 8175 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state > 0) static_cast<WaitForAllDataRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForAllDataRemovedActor*>(this)->ActorCallback< WaitForAllDataRemovedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForAllDataRemovedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Database cx;
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	UID serverID;
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Version addedVersion;
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure;
															#line 647 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 8365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via waitForAllDataRemoved()
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class WaitForAllDataRemovedActor final : public Actor<Void>, public ActorCallback< WaitForAllDataRemovedActor, 0, Version >, public ActorCallback< WaitForAllDataRemovedActor, 1, bool >, public ActorCallback< WaitForAllDataRemovedActor, 2, Void >, public ActorCallback< WaitForAllDataRemovedActor, 3, Void >, public FastAllocated<WaitForAllDataRemovedActor>, public WaitForAllDataRemovedActorState<WaitForAllDataRemovedActor> {
															#line 8370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<WaitForAllDataRemovedActor>::operator new;
	using FastAllocated<WaitForAllDataRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2971965290224285440UL, 10232527181976992256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForAllDataRemovedActor, 0, Version >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 1, bool >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 2, Void >;
friend struct ActorCallback< WaitForAllDataRemovedActor, 3, Void >;
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	WaitForAllDataRemovedActor(Database const& cx,UID const& serverID,Version const& addedVersion,Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure) 
															#line 8390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForAllDataRemovedActorState<WaitForAllDataRemovedActor>(cx, serverID, addedVersion, shardsAffectedByTeamFailure),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4895686793057212672UL, 12269977046920561920UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForAllDataRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForAllDataRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForAllDataRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitForAllDataRemovedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> waitForAllDataRemoved( Database const& cx, UID const& serverID, Version const& addedVersion, Reference<ShardsAffectedByTeamFailure> const& shardsAffectedByTeamFailure ) {
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new WaitForAllDataRemovedActor(cx, serverID, addedVersion, shardsAffectedByTeamFailure));
															#line 8425 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
};

Future<Void> DDTxnProcessor::waitForAllDataRemoved(
    const UID& serverID,
    const Version& addedVersion,
    Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure) const {
	return DDTxnProcessorImpl::waitForAllDataRemoved(cx, serverID, addedVersion, shardsAffectedByTeamFailure);
}

Future<IDDTxnProcessor::SourceServers> DDTxnProcessor::getSourceServersForRange(const KeyRangeRef range) {
	return DDTxnProcessorImpl::getSourceServersForRange(cx, range);
}

Future<std::vector<IDDTxnProcessor::DDRangeLocations>> DDTxnProcessor::getSourceServerInterfacesForRange(
    const KeyRangeRef range) {
	return DDTxnProcessorImpl::getSourceServerInterfacesForRange(cx, range);
}

Future<ServerWorkerInfos> DDTxnProcessor::getServerListAndProcessClasses() {
	return DDTxnProcessorImpl::getServerListAndProcessClasses(cx);
}

Future<MoveKeysLock> DDTxnProcessor::takeMoveKeysLock(const UID& ddId) const {
	return ::takeMoveKeysLock(cx, ddId);
}

Future<DatabaseConfiguration> DDTxnProcessor::getDatabaseConfiguration() const {
	return ::getDatabaseConfiguration(cx);
}

Future<Void> DDTxnProcessor::updateReplicaKeys(const std::vector<Optional<Key>>& primaryIds,
                                               const std::vector<Optional<Key>>& remoteIds,
                                               const DatabaseConfiguration& configuration) const {
	return DDTxnProcessorImpl::updateReplicaKeys(cx, primaryIds, remoteIds, configuration);
}

Future<Reference<InitialDataDistribution>> DDTxnProcessor::getInitialDataDistribution(
    const UID& distributorId,
    const MoveKeysLock& moveKeysLock,
    const std::vector<Optional<Key>>& remoteDcIds,
    const DDEnabledState* ddEnabledState,
    SkipDDModeCheck skipDDModeCheck) {
	return DDTxnProcessorImpl::getInitialDataDistribution(
	    cx, distributorId, moveKeysLock, remoteDcIds, ddEnabledState, skipDDModeCheck);
}

Future<Void> DDTxnProcessor::waitForDataDistributionEnabled(const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::waitForDataDistributionEnabled(cx, ddEnabledState);
}

Future<bool> DDTxnProcessor::isDataDistributionEnabled(const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::isDataDistributionEnabled(cx, ddEnabledState);
}

Future<Void> DDTxnProcessor::pollMoveKeysLock(const MoveKeysLock& lock, const DDEnabledState* ddEnabledState) const {
	return DDTxnProcessorImpl::pollMoveKeysLock(cx, lock, ddEnabledState);
}

Future<std::pair<Optional<StorageMetrics>, int>> DDTxnProcessor::waitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& min,
    const StorageMetrics& max,
    const StorageMetrics& permittedError,
    int shardLimit,
    int expectedShardCount) const {
	return cx->waitStorageMetrics(keys, min, max, permittedError, shardLimit, expectedShardCount);
}

Future<Standalone<VectorRef<KeyRef>>> DDTxnProcessor::splitStorageMetrics(const KeyRange& keys,
                                                                          const StorageMetrics& limit,
                                                                          const StorageMetrics& estimated,
                                                                          const Optional<int>& minSplitBytes) const {
	return cx->splitStorageMetrics(keys, limit, estimated, minSplitBytes);
}

Future<Standalone<VectorRef<ReadHotRangeWithMetrics>>> DDTxnProcessor::getReadHotRanges(const KeyRange& keys) const {
	return cx->getReadHotRanges(keys);
}

Future<HealthMetrics> DDTxnProcessor::getHealthMetrics(bool detailed) const {
	return cx->getHealthMetrics(detailed);
}

Future<Optional<Value>> DDTxnProcessor::readRebalanceDDIgnoreKey() const {
	return DDTxnProcessorImpl::readRebalanceDDIgnoreKey(cx);
}

Future<int> DDTxnProcessor::tryUpdateReplicasKeyForDc(const Optional<Key>& dcId, const int& storageTeamSize) const {
	return DDTxnProcessorImpl::tryUpdateReplicasKeyForDc(cx, dcId, storageTeamSize);
}

Future<Void> DDTxnProcessor::waitDDTeamInfoPrintSignal() const {
	return DDTxnProcessorImpl::waitDDTeamInfoPrintSignal(cx);
}

Future<std::vector<ProcessData>> DDTxnProcessor::getWorkers() const {
	return ::getWorkers(cx);
}

Future<Void> DDTxnProcessor::rawStartMovement(const MoveKeysParams& params,
                                              std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawStartMovement(cx, params, tssMapping);
}

Future<Void> DDTxnProcessor::rawFinishMovement(const MoveKeysParams& params,
                                               const std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawFinishMovement(cx, params, tssMapping);
}

struct DDMockTxnProcessorImpl {
	// return when all status become FETCHED
																#line 8540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via checkFetchingState()
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class CheckFetchingStateActor>
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class CheckFetchingStateActorState {
															#line 8546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	CheckFetchingStateActorState(DDMockTxnProcessor* const& self,std::vector<UID> const& ids,KeyRangeRef const& range) 
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : self(self),
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   ids(ids),
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   range(range),
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("MockCheckFetchingState")
															#line 8559 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	~CheckFetchingStateActorState() 
	{
		fdb_probe_actor_destroy("checkFetchingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 790 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Range", range);
															#line 791 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			;
															#line 8576 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 805 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end()).log();
															#line 806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<CheckFetchingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckFetchingStateActorState(); static_cast<CheckFetchingStateActor*>(this)->destroy(); return 0; }
															#line 8601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<CheckFetchingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckFetchingStateActorState();
		static_cast<CheckFetchingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(1.0, TaskPriority::FetchKeys);
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 1;
															#line 792 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckFetchingStateActor, 0, Void >*>(static_cast<CheckFetchingStateActor*>(this)));
															#line 8627 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		bool done = true;
															#line 794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : ids ) {
															#line 795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = self->mgs->allServers.at(id);
															#line 796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!server->allShardStatusIn(range, { MockShardStatus::FETCHED, MockShardStatus::COMPLETED }))
															#line 8655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				done = false;
															#line 8659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				break;
			}
		}
															#line 801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (done)
															#line 8665 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 793 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		bool done = true;
															#line 794 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : ids ) {
															#line 795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = self->mgs->allServers.at(id);
															#line 796 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!server->allShardStatusIn(range, { MockShardStatus::FETCHED, MockShardStatus::COMPLETED }))
															#line 8683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 797 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				done = false;
															#line 8687 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
				break;
			}
		}
															#line 801 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (done)
															#line 8693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckFetchingStateActor*>(this)->actor_wait_state > 0) static_cast<CheckFetchingStateActor*>(this)->actor_wait_state = 0;
		static_cast<CheckFetchingStateActor*>(this)->ActorCallback< CheckFetchingStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckFetchingStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckFetchingStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DDMockTxnProcessor* self;
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::vector<UID> ids;
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRangeRef range;
															#line 789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 8784 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via checkFetchingState()
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class CheckFetchingStateActor final : public Actor<Void>, public ActorCallback< CheckFetchingStateActor, 0, Void >, public FastAllocated<CheckFetchingStateActor>, public CheckFetchingStateActorState<CheckFetchingStateActor> {
															#line 8789 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<CheckFetchingStateActor>::operator new;
	using FastAllocated<CheckFetchingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4920656738088610560UL, 12973313293697975552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckFetchingStateActor, 0, Void >;
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	CheckFetchingStateActor(DDMockTxnProcessor* const& self,std::vector<UID> const& ids,KeyRangeRef const& range) 
															#line 8806 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   CheckFetchingStateActorState<CheckFetchingStateActor>(self, ids, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13605890424979058688UL, 18070830385337103360UL);
		ActorExecutionContextHelper __helper(static_cast<CheckFetchingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkFetchingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkFetchingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckFetchingStateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> checkFetchingState( DDMockTxnProcessor* const& self, std::vector<UID> const& ids, KeyRangeRef const& range ) {
															#line 788 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new CheckFetchingStateActor(self, ids, range));
															#line 8838 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 808 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

	static Future<Void> rawCheckFetchingState(DDMockTxnProcessor* self, const MoveKeysParams& params) {
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA) {
			ASSERT(params.ranges.present());
			// TODO: make startMoveShards work with multiple ranges.
			ASSERT(params.ranges.get().size() == 1);
			return checkFetchingState(self, params.destinationTeam, params.ranges.get().at(0));
		}
		ASSERT(params.keys.present());
		return checkFetchingState(self, params.destinationTeam, params.keys.get());
	}

																#line 8854 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
// This generated class is to be used only via moveKeys()
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class MoveKeysActor>
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class MoveKeysActorState {
															#line 8860 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysActorState(DDMockTxnProcessor* const& self,MoveKeysParams const& params) 
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : self(self),
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping()
															#line 8871 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("moveKeys", reinterpret_cast<unsigned long>(this));

	}
	~MoveKeysActorState() 
	{
		fdb_probe_actor_destroy("moveKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(params.destinationTeam.begin(), params.destinationTeam.end());
															#line 824 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			std::sort(params.healthyDestinations.begin(), params.healthyDestinations.end());
															#line 826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->rawStartMovement(params, tssMapping);
															#line 826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8892 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveKeysActor*>(this)->actor_wait_state = 1;
															#line 826 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 0, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 8897 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(tssMapping.empty());
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = rawCheckFetchingState(self, params);
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8924 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 2;
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 1, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 8929 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 827 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT(tssMapping.empty());
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = rawCheckFetchingState(self, params);
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 2;
															#line 829 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 1, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 8947 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->rawFinishMovement(params, tssMapping);
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 3;
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 2, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9038 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->rawFinishMovement(params, tssMapping);
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveKeysActor*>(this)->actor_wait_state = 3;
															#line 831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveKeysActor, 2, Void >*>(static_cast<MoveKeysActor*>(this)));
															#line 9054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!params.dataMovementComplete.isSet())
															#line 9138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			params.dataMovementComplete.send(Void());
															#line 9142 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<MoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeysActorState(); static_cast<MoveKeysActor*>(this)->destroy(); return 0; }
															#line 9146 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<MoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 832 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!params.dataMovementComplete.isSet())
															#line 9158 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			params.dataMovementComplete.send(Void());
															#line 9162 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 834 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<MoveKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MoveKeysActorState(); static_cast<MoveKeysActor*>(this)->destroy(); return 0; }
															#line 9166 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<MoveKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MoveKeysActorState();
		static_cast<MoveKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveKeysActor*>(this)->actor_wait_state > 0) static_cast<MoveKeysActor*>(this)->actor_wait_state = 0;
		static_cast<MoveKeysActor*>(this)->ActorCallback< MoveKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	DDMockTxnProcessor* self;
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 821 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 9255 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via moveKeys()
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class MoveKeysActor final : public Actor<Void>, public ActorCallback< MoveKeysActor, 0, Void >, public ActorCallback< MoveKeysActor, 1, Void >, public ActorCallback< MoveKeysActor, 2, Void >, public FastAllocated<MoveKeysActor>, public MoveKeysActorState<MoveKeysActor> {
															#line 9260 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<MoveKeysActor>::operator new;
	using FastAllocated<MoveKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8262005532363709440UL, 15878800903911996672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveKeysActor, 0, Void >;
friend struct ActorCallback< MoveKeysActor, 1, Void >;
friend struct ActorCallback< MoveKeysActor, 2, Void >;
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysActor(DDMockTxnProcessor* const& self,MoveKeysParams const& params) 
															#line 9279 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   MoveKeysActorState<MoveKeysActor>(self, params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8336242837745545216UL, 15245897084024434688UL);
		ActorExecutionContextHelper __helper(static_cast<MoveKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] static Future<Void> moveKeys( DDMockTxnProcessor* const& self, MoveKeysParams const& params ) {
															#line 820 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new MoveKeysActor(self, params));
															#line 9313 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
};

Future<ServerWorkerInfos> DDMockTxnProcessor::getServerListAndProcessClasses() {
	ServerWorkerInfos res;
	for (auto& [_, mss] : mgs->allServers) {
		res.servers.emplace_back(mss->ssi, ProcessClass(ProcessClass::StorageClass, ProcessClass::DBSource));
	}
	// FIXME(xwang): possible generate version from time?
	res.readVersion = 0;
	return res;
}

std::pair<std::set<std::vector<UID>>, std::set<std::vector<UID>>> getAllTeamsInRegion(
    const std::vector<DDShardInfo>& shards) {
	std::set<std::vector<UID>> primary, remote;
	for (auto& info : shards) {
		if (!info.primarySrc.empty())
			primary.emplace(info.primarySrc);
		if (!info.primaryDest.empty())
			primary.emplace(info.primaryDest);
		if (!info.remoteSrc.empty())
			remote.emplace(info.remoteSrc);
		if (!info.remoteDest.empty())
			remote.emplace(info.remoteDest);
	}
	return { primary, remote };
}

inline void transformTeamsToServerIds(std::vector<ShardsAffectedByTeamFailure::Team>& teams,
                                      std::vector<UID>& primaryIds,
                                      std::vector<UID>& remoteIds) {
	std::set<UID> primary, remote;
	for (auto& team : teams) {
		team.primary ? primary.insert(team.servers.begin(), team.servers.end())
		             : remote.insert(team.servers.begin(), team.servers.end());
	}
	primaryIds = std::vector<UID>(primary.begin(), primary.end());
	remoteIds = std::vector<UID>(remote.begin(), remote.end());
}

// reconstruct DDShardInfos from shardMapping
std::vector<DDShardInfo> DDMockTxnProcessor::getDDShardInfos() const {
	std::vector<DDShardInfo> res;
	res.reserve(mgs->shardMapping->getNumberOfShards());
	auto allRange = mgs->shardMapping->getAllRanges();
	ASSERT(allRange.end().begin() == allKeys.end);
	for (auto it = allRange.begin(); it != allRange.end(); ++it) {
		// FIXME: now just use anonymousShardId
		KeyRangeRef curRange = it->range();
		DDShardInfo info(curRange.begin);

		auto teams = mgs->shardMapping->getTeamsForFirstShard(curRange);
		if (!teams.first.empty() && !teams.second.empty()) {
			CODE_PROBE(true, "Mock InitialDataDistribution In-Flight shard");
			info.hasDest = true;
			info.destId = anonymousShardId;
			info.srcId = anonymousShardId;
			transformTeamsToServerIds(teams.second, info.primarySrc, info.remoteSrc);
			transformTeamsToServerIds(teams.first, info.primaryDest, info.remoteDest);
		} else if (!teams.first.empty()) {
			CODE_PROBE(true, "Mock InitialDataDistribution Static shard");
			info.srcId = anonymousShardId;
			transformTeamsToServerIds(teams.first, info.primarySrc, info.remoteSrc);
		} else {
			ASSERT(false);
		}

		res.push_back(std::move(info));
	}
	res.emplace_back(allKeys.end);

	return res;
}

Future<Reference<InitialDataDistribution>> DDMockTxnProcessor::getInitialDataDistribution(
    const UID& distributorId,
    const MoveKeysLock& moveKeysLock,
    const std::vector<Optional<Key>>& remoteDcIds,
    const DDEnabledState* ddEnabledState,
    SkipDDModeCheck skipDDModeCheck) {

	// FIXME: now we just ignore ddEnabledState and moveKeysLock, will fix it in the future
	Reference<InitialDataDistribution> res = makeReference<InitialDataDistribution>();
	res->mode = 1;
	res->allServers = getServerListAndProcessClasses().get().servers;
	res->shards = getDDShardInfos();
	std::tie(res->primaryTeams, res->remoteTeams) = getAllTeamsInRegion(res->shards);
	return res;
}

Future<Void> DDMockTxnProcessor::removeKeysFromFailedServer(const UID& serverID,
                                                            const std::vector<UID>& teamForDroppedRange,
                                                            const MoveKeysLock& lock,
                                                            const DDEnabledState* ddEnabledState) const {

	// This function only takes effect when user exclude failed IP:PORT in the fdbcli. In the first version , the mock
	// class won’t support this.
	UNREACHABLE();
}

Future<Void> DDMockTxnProcessor::removeStorageServer(const UID& serverID,
                                                     const Optional<UID>& tssPairID,
                                                     const MoveKeysLock& lock,
                                                     const DDEnabledState* ddEnabledState) const {
	ASSERT(mgs->allShardsRemovedFromServer(serverID));
	mgs->allServers.erase(serverID);
	return Void();
}

void DDMockTxnProcessor::setupMockGlobalState(Reference<InitialDataDistribution> initData) {
	for (auto& [ssi, pInfo] : initData->allServers) {
		mgs->addStorageServer(ssi);
	}
	mgs->shardMapping->setCheckMode(ShardsAffectedByTeamFailure::CheckMode::ForceNoCheck);

	for (int i = 0; i < initData->shards.size() - 1; ++i) {
		// insert to keyServers
		auto& shardInfo = initData->shards[i];
		ASSERT(shardInfo.remoteSrc.empty() && shardInfo.remoteDest.empty());

		uint64_t shardBytes =
		    deterministicRandom()->randomInt(SERVER_KNOBS->MIN_SHARD_BYTES, SERVER_KNOBS->MAX_SHARD_BYTES);
		KeyRangeRef keys(shardInfo.key, initData->shards[i + 1].key);
		mgs->shardMapping->assignRangeToTeams(keys, { { shardInfo.primarySrc, true } });
		if (shardInfo.hasDest) {
			mgs->shardMapping->moveShard(keys, { { shardInfo.primaryDest, true } });
		}
		// insert to serverKeys
		for (auto& id : shardInfo.primarySrc) {
			mgs->allServers.at(id)->serverKeys.insert(keys, { MockShardStatus::COMPLETED, shardBytes });
		}
		for (auto& id : shardInfo.primaryDest) {
			mgs->allServers.at(id)->serverKeys.insert(keys, { MockShardStatus::INFLIGHT, shardBytes });
		}
	}

	mgs->shardMapping->setCheckMode(ShardsAffectedByTeamFailure::CheckMode::Normal);
}

Future<Void> DDMockTxnProcessor::moveKeys(const MoveKeysParams& params) {
	// Not support location metadata yet
	ASSERT(!SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	return DDMockTxnProcessorImpl::moveKeys(this, params);
}

// FIXME: finish implementation
Future<HealthMetrics> DDMockTxnProcessor::getHealthMetrics(bool detailed) const {
	return Future<HealthMetrics>();
}

Future<Standalone<VectorRef<KeyRef>>> DDMockTxnProcessor::splitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& limit,
    const StorageMetrics& estimated,
    const Optional<int>& minSplitBytes) const {
	return mgs->splitStorageMetrics(keys, limit, estimated, minSplitBytes);
}

Future<std::pair<Optional<StorageMetrics>, int>> DDMockTxnProcessor::waitStorageMetrics(
    const KeyRange& keys,
    const StorageMetrics& min,
    const StorageMetrics& max,
    const StorageMetrics& permittedError,
    int shardLimit,
    int expectedShardCount) const {
	return mgs->waitStorageMetrics(keys, min, max, permittedError, shardLimit, expectedShardCount);
}

// FIXME: finish implementation
Future<std::vector<ProcessData>> DDMockTxnProcessor::getWorkers() const {
	return Future<std::vector<ProcessData>>();
}

															#line 9490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
namespace {
// This generated class is to be used only via rawStartMovement()
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class RawStartMovementActor>
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawStartMovementActorState {
															#line 9497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawStartMovementActorState(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : mgs(mgs),
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping(tssMapping),
															#line 1012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("RelocateShard_MockStartMoveKeys"),
															#line 1013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys()
															#line 9512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("rawStartMovement", reinterpret_cast<unsigned long>(this));

	}
	~RawStartMovementActorState() 
	{
		fdb_probe_actor_destroy("rawStartMovement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1014 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 9527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.present());
															#line 1017 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.get().size() == 1);
															#line 1018 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.ranges.get().at(0);
															#line 9535 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 1020 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.keys.present());
															#line 1021 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.keys.get();
															#line 9543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 1023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Keys", keys);
															#line 1024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = params.startMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<RawStartMovementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9551 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RawStartMovementActor*>(this)->actor_wait_state = 1;
															#line 1024 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RawStartMovementActor, 0, Void >*>(static_cast<RawStartMovementActor*>(this)));
															#line 9556 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.startMoveKeysParallelismLock);
															#line 1027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<ShardsAffectedByTeamFailure::Team> destTeams;
															#line 1028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		destTeams.emplace_back(params.destinationTeam, true);
															#line 1031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (intersectRanges.begin().range().contains(keys))
															#line 9587 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->defineShard(keys);
															#line 9591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1038 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		fmt::print("Keys: {}; intersect: {} {}\n", keys.toString(), intersectRanges.begin().begin(), intersectRanges.end().begin());
															#line 1046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		int totalRangeSize = 0;
															#line 1047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto it = intersectRanges.begin();it != intersectRanges.end();++it) {
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto teamPair = mgs->shardMapping->getTeamsFor(it->begin());
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& srcTeams = teamPair.second.empty() ? teamPair.first : teamPair.second;
															#line 1050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			totalRangeSize += mgs->getRangeSize(it->range());
															#line 1051 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->rawMoveShard(it->range(), srcTeams, destTeams);
															#line 9609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = mgs->allServers.at(id);
															#line 1056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::INFLIGHT);
															#line 1057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->signalFetchKeys(keys, totalRangeSize);
															#line 9619 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawStartMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawStartMovementActorState(); static_cast<RawStartMovementActor*>(this)->destroy(); return 0; }
															#line 9625 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawStartMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.startMoveKeysParallelismLock);
															#line 1027 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		std::vector<ShardsAffectedByTeamFailure::Team> destTeams;
															#line 1028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		destTeams.emplace_back(params.destinationTeam, true);
															#line 1031 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (intersectRanges.begin().range().contains(keys))
															#line 9645 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->defineShard(keys);
															#line 9649 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1037 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		intersectRanges = mgs->shardMapping->intersectingRanges(keys);
															#line 1038 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		fmt::print("Keys: {}; intersect: {} {}\n", keys.toString(), intersectRanges.begin().begin(), intersectRanges.end().begin());
															#line 1046 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		int totalRangeSize = 0;
															#line 1047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for(auto it = intersectRanges.begin();it != intersectRanges.end();++it) {
															#line 1048 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto teamPair = mgs->shardMapping->getTeamsFor(it->begin());
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& srcTeams = teamPair.second.empty() ? teamPair.first : teamPair.second;
															#line 1050 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			totalRangeSize += mgs->getRangeSize(it->range());
															#line 1051 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			mgs->shardMapping->rawMoveShard(it->range(), srcTeams, destTeams);
															#line 9667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1055 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto& server = mgs->allServers.at(id);
															#line 1056 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::INFLIGHT);
															#line 1057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->signalFetchKeys(keys, totalRangeSize);
															#line 9677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1059 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawStartMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawStartMovementActorState(); static_cast<RawStartMovementActor*>(this)->destroy(); return 0; }
															#line 9683 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawStartMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawStartMovementActorState();
		static_cast<RawStartMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RawStartMovementActor*>(this)->actor_wait_state > 0) static_cast<RawStartMovementActor*>(this)->actor_wait_state = 0;
		static_cast<RawStartMovementActor*>(this)->ActorCallback< RawStartMovementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RawStartMovementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RawStartMovementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RawStartMovementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1012 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 1013 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRange keys;
															#line 1025 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	FlowLock::Releaser releaser;
															#line 9778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via rawStartMovement()
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawStartMovementActor final : public Actor<Void>, public ActorCallback< RawStartMovementActor, 0, Void >, public FastAllocated<RawStartMovementActor>, public RawStartMovementActorState<RawStartMovementActor> {
															#line 9783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<RawStartMovementActor>::operator new;
	using FastAllocated<RawStartMovementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4370462264452707584UL, 16976412225348724480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RawStartMovementActor, 0, Void >;
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawStartMovementActor(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 9800 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   RawStartMovementActorState<RawStartMovementActor>(mgs, params, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rawStartMovement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11716611356202757888UL, 6335144292502135552UL);
		ActorExecutionContextHelper __helper(static_cast<RawStartMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rawStartMovement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rawStartMovement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RawStartMovementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] Future<Void> rawStartMovement( std::shared_ptr<MockGlobalState> const& mgs, MoveKeysParams const& params, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new RawStartMovementActor(mgs, params, tssMapping));
															#line 9833 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 1062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

Future<Void> DDMockTxnProcessor::rawStartMovement(const MoveKeysParams& params,
                                                  std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawStartMovement(mgs, params, tssMapping);
}

															#line 9843 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
namespace {
// This generated class is to be used only via rawFinishMovement()
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
template <class RawFinishMovementActor>
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawFinishMovementActorState {
															#line 9850 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawFinishMovementActorState(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		 : mgs(mgs),
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   params(params),
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   tssMapping(tssMapping),
															#line 1071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   interval("RelocateShard_MockFinishMoveKeys"),
															#line 1072 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		   keys()
															#line 9865 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
	{
		fdb_probe_actor_create("rawFinishMovement", reinterpret_cast<unsigned long>(this));

	}
	~RawFinishMovementActorState() 
	{
		fdb_probe_actor_destroy("rawFinishMovement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1073 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA)
															#line 9880 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1074 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.present());
															#line 1076 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.ranges.get().size() == 1);
															#line 1077 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.ranges.get().at(0);
															#line 9888 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
			else
			{
															#line 1079 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				ASSERT(params.keys.present());
															#line 1080 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				keys = params.keys.get();
															#line 9896 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
															#line 1083 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevDebug, interval.begin()).detail("Keys", keys);
															#line 1085 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = params.finishMoveKeysParallelismLock->take(TaskPriority::DataDistributionLaunch);
															#line 1085 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (static_cast<RawFinishMovementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9904 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RawFinishMovementActor*>(this)->actor_wait_state = 1;
															#line 1085 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RawFinishMovementActor, 0, Void >*>(static_cast<RawFinishMovementActor*>(this)));
															#line 9909 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.finishMoveKeysParallelismLock);
															#line 1089 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto [destTeams, srcTeams] = mgs->shardMapping->getTeamsForFirstShard(keys);
															#line 1091 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(destTeams.size(), 1);
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (destTeams.front() != ShardsAffectedByTeamFailure::Team{ params.destinationTeam, true })
															#line 9938 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevError, "MockRawFinishMovementError") .detail("Reason", "InconsistentDestinations") .detail("ShardMappingDest", describe(destTeams.front().servers)) .detail("ParamDest", describe(params.destinationTeam));
															#line 1097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(false);
															#line 9944 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto server = mgs->allServers.at(id);
															#line 1102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::COMPLETED);
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->coalesceCompletedRange(keys);
															#line 9954 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(srcTeams.size(), 1);
															#line 1108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : srcTeams.front().servers ) {
															#line 1110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!std::binary_search(params.destinationTeam.begin(), params.destinationTeam.end(), id))
															#line 9962 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				mgs->allServers.at(id)->removeShard(keys);
															#line 9966 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 1114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->finishMove(keys);
															#line 1115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->defineShard(keys);
															#line 1116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawFinishMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawFinishMovementActorState(); static_cast<RawFinishMovementActor*>(this)->destroy(); return 0; }
															#line 9977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawFinishMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		releaser = FlowLock::Releaser(*params.finishMoveKeysParallelismLock);
															#line 1089 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		auto [destTeams, srcTeams] = mgs->shardMapping->getTeamsForFirstShard(keys);
															#line 1091 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(destTeams.size(), 1);
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (destTeams.front() != ShardsAffectedByTeamFailure::Team{ params.destinationTeam, true })
															#line 9995 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		{
															#line 1093 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			TraceEvent(SevError, "MockRawFinishMovementError") .detail("Reason", "InconsistentDestinations") .detail("ShardMappingDest", describe(destTeams.front().servers)) .detail("ParamDest", describe(params.destinationTeam));
															#line 1097 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			ASSERT(false);
															#line 10001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1100 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : params.destinationTeam ) {
															#line 1101 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			auto server = mgs->allServers.at(id);
															#line 1102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->setShardStatus(keys, MockShardStatus::COMPLETED);
															#line 1103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			server->coalesceCompletedRange(keys);
															#line 10011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		}
															#line 1107 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		ASSERT_EQ(srcTeams.size(), 1);
															#line 1108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		for( auto& id : srcTeams.front().servers ) {
															#line 1110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
			if (!std::binary_search(params.destinationTeam.begin(), params.destinationTeam.end(), id))
															#line 10019 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			{
															#line 1111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
				mgs->allServers.at(id)->removeShard(keys);
															#line 10023 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
			}
		}
															#line 1114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->finishMove(keys);
															#line 1115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		mgs->shardMapping->defineShard(keys);
															#line 1116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		TraceEvent(SevDebug, interval.end());
															#line 1117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
		if (!static_cast<RawFinishMovementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RawFinishMovementActorState(); static_cast<RawFinishMovementActor*>(this)->destroy(); return 0; }
															#line 10034 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		new (&static_cast<RawFinishMovementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RawFinishMovementActorState();
		static_cast<RawFinishMovementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RawFinishMovementActor*>(this)->actor_wait_state > 0) static_cast<RawFinishMovementActor*>(this)->actor_wait_state = 0;
		static_cast<RawFinishMovementActor*>(this)->ActorCallback< RawFinishMovementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RawFinishMovementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RawFinishMovementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RawFinishMovementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::shared_ptr<MockGlobalState> mgs;
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	MoveKeysParams params;
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1071 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	TraceInterval interval;
															#line 1072 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	KeyRange keys;
															#line 1086 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	FlowLock::Releaser releaser;
															#line 10129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
};
// This generated class is to be used only via rawFinishMovement()
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
class RawFinishMovementActor final : public Actor<Void>, public ActorCallback< RawFinishMovementActor, 0, Void >, public FastAllocated<RawFinishMovementActor>, public RawFinishMovementActorState<RawFinishMovementActor> {
															#line 10134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
public:
	using FastAllocated<RawFinishMovementActor>::operator new;
	using FastAllocated<RawFinishMovementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6108011312232599296UL, 13438317871026748672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RawFinishMovementActor, 0, Void >;
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	RawFinishMovementActor(std::shared_ptr<MockGlobalState> const& mgs,MoveKeysParams const& params,std::map<UID, StorageServerInterface> const& tssMapping) 
															#line 10151 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
		 : Actor<Void>(),
		   RawFinishMovementActorState<RawFinishMovementActor>(mgs, params, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rawFinishMovement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13532843008458784768UL, 10632593791075846656UL);
		ActorExecutionContextHelper __helper(static_cast<RawFinishMovementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rawFinishMovement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rawFinishMovement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RawFinishMovementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
[[nodiscard]] Future<Void> rawFinishMovement( std::shared_ptr<MockGlobalState> const& mgs, MoveKeysParams const& params, std::map<UID, StorageServerInterface> const& tssMapping ) {
															#line 1068 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"
	return Future<Void>(new RawFinishMovementActor(mgs, params, tssMapping));
															#line 10184 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/DDTxnProcessor.actor.g.cpp"
}

#line 1119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/DDTxnProcessor.actor.cpp"

Future<Void> DDMockTxnProcessor::rawFinishMovement(const MoveKeysParams& params,
                                                   const std::map<UID, StorageServerInterface>& tssMapping) {
	return ::rawFinishMovement(mgs, params, tssMapping);
}

Future<Optional<HealthMetrics::StorageStats>> DDTxnProcessor::getStorageStats(const UID& id,
                                                                              double maxStaleness) const {
	return cx->getStorageStats(id, maxStaleness);
}

Future<Optional<HealthMetrics::StorageStats>> DDMockTxnProcessor::getStorageStats(const UID& id,
                                                                                  double maxStaleness) const {
	auto it = mgs->allServers.find(id);
	if (it == mgs->allServers.end()) {
		return Optional<HealthMetrics::StorageStats>();
	}
	return Optional<HealthMetrics::StorageStats>(it->second->getStorageStats());
}

Future<DatabaseConfiguration> DDMockTxnProcessor::getDatabaseConfiguration() const {
	return mgs->configuration;
}

Future<IDDTxnProcessor::SourceServers> DDMockTxnProcessor::getSourceServersForRange(const KeyRangeRef keys) {
	std::set<UID> servers;
	std::vector<UID> completeSources;
	auto ranges = mgs->shardMapping->intersectingRanges(keys);
	int count = 0;
	for (auto it = ranges.begin(); it != ranges.end(); ++it, ++count) {
		auto sources = mgs->shardMapping->getSourceServerIdsFor(it->begin());
		ASSERT(!sources.empty());
		updateServersAndCompleteSources(servers, completeSources, count, sources);
	}
	ASSERT(!servers.empty());
	return IDDTxnProcessor::SourceServers{ std::vector<UID>(servers.begin(), servers.end()), completeSources };
}

Future<Void> DDMockTxnProcessor::waitForAllDataRemoved(
    const UID& serverID,
    const Version& addedVersion,
    Reference<ShardsAffectedByTeamFailure> shardsAffectedByTeamFailure) const {
	return checkUntil(
	    SERVER_KNOBS->ALL_DATA_REMOVED_DELAY,
	    [&, this]() -> bool {
		    return mgs->allShardsRemovedFromServer(serverID) &&
		           shardsAffectedByTeamFailure->getNumberOfShards(serverID) == 0;
	    },
	    TaskPriority::DataDistribution);
}