#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
/*
 * BlobGranuleServerCommon.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Arena.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // has to be last include

// serialize change feed key as UID bytes, to use 16 bytes on disk
Key granuleIDToCFKey(UID granuleID) {
	BinaryWriter wr(Unversioned());
	wr << granuleID;
	return wr.toValue();
}

// parse change feed key back to UID, to be human-readable
UID cfKeyToGranuleID(Key cfKey) {
	return BinaryReader::fromStringRef<UID>(cfKey, Unversioned());
}

// Gets the latest granule history node for range that was persisted
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via getLatestGranuleHistory()
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class GetLatestGranuleHistoryActor>
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetLatestGranuleHistoryActorState {
															#line 55 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetLatestGranuleHistoryActorState(Transaction* const& tr,KeyRange const& range) 
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : tr(tr),
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   range(range),
															#line 47 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   historyRange(blobGranuleHistoryKeyRangeFor(range))
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this));

	}
	~GetLatestGranuleHistoryActorState() 
	{
		fdb_probe_actor_destroy("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(historyRange, 1, Snapshot::False, Reverse::True);
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<GetLatestGranuleHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 83 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLatestGranuleHistoryActor*>(this)->actor_wait_state = 1;
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >*>(static_cast<GetLatestGranuleHistoryActor*>(this)));
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLatestGranuleHistoryActorState();
		static_cast<GetLatestGranuleHistoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 50 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(result.size() <= 1);
															#line 52 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		Optional<GranuleHistory> history;
															#line 53 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!result.empty())
															#line 115 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 54 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(result[0].key);
															#line 55 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(range == decodedKey.first);
															#line 56 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			history = GranuleHistory(range, decodedKey.second, decodeBlobGranuleHistoryValue(result[0].value));
															#line 123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 58 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<GetLatestGranuleHistoryActor*>(this)->SAV<Optional<GranuleHistory>>::futures) { (void)(history); this->~GetLatestGranuleHistoryActorState(); static_cast<GetLatestGranuleHistoryActor*>(this)->destroy(); return 0; }
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<GetLatestGranuleHistoryActor*>(this)->SAV< Optional<GranuleHistory> >::value()) Optional<GranuleHistory>(history);
		this->~GetLatestGranuleHistoryActorState();
		static_cast<GetLatestGranuleHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __result,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		result = __result;
															#line 139 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLatestGranuleHistoryActor*>(this)->actor_wait_state > 0) static_cast<GetLatestGranuleHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestGranuleHistoryActor*>(this)->ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestGranuleHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestGranuleHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestGranuleHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Transaction* tr;
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange range;
															#line 47 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange historyRange;
															#line 48 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	RangeResult result;
															#line 222 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via getLatestGranuleHistory()
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetLatestGranuleHistoryActor final : public Actor<Optional<GranuleHistory>>, public ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >, public FastAllocated<GetLatestGranuleHistoryActor>, public GetLatestGranuleHistoryActorState<GetLatestGranuleHistoryActor> {
															#line 227 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<GetLatestGranuleHistoryActor>::operator new;
	using FastAllocated<GetLatestGranuleHistoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13234039283683277312UL, 17317262725328098816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<GranuleHistory>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >;
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetLatestGranuleHistoryActor(Transaction* const& tr,KeyRange const& range) 
															#line 244 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Optional<GranuleHistory>>(),
		   GetLatestGranuleHistoryActorState<GetLatestGranuleHistoryActor>(tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2183602440051214080UL, 5736629264918465024UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestGranuleHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLatestGranuleHistory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLatestGranuleHistory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLatestGranuleHistoryActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Optional<GranuleHistory>> getLatestGranuleHistory( Transaction* const& tr, KeyRange const& range ) {
															#line 46 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Optional<GranuleHistory>>(new GetLatestGranuleHistoryActor(tr, range));
															#line 277 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 60 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

// Gets the files based on the file key range [startKey, endKey)
// and populates the files object accordingly
															#line 284 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via readGranuleFiles()
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class ReadGranuleFilesActor>
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class ReadGranuleFilesActorState {
															#line 291 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	ReadGranuleFilesActorState(Transaction* const& tr,Key* const& startKey,Key const& endKey,GranuleFiles* const& files,UID const& granuleID) 
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : tr(tr),
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   startKey(startKey),
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   endKey(endKey),
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   files(files),
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   granuleID(granuleID)
															#line 306 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("readGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	~ReadGranuleFilesActorState() 
	{
		fdb_probe_actor_destroy("readGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			;
															#line 321 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadGranuleFilesActorState();
		static_cast<ReadGranuleFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<ReadGranuleFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadGranuleFilesActorState(); static_cast<ReadGranuleFilesActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<ReadGranuleFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadGranuleFilesActorState();
		static_cast<ReadGranuleFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		int lim = BUGGIFY ? 2 : 1000;
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr->getRange(KeyRangeRef(*startKey, endKey), lim);
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (static_cast<ReadGranuleFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 367 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ReadGranuleFilesActor*>(this)->actor_wait_state = 1;
															#line 67 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadGranuleFilesActor, 0, RangeResult >*>(static_cast<ReadGranuleFilesActor*>(this)));
															#line 372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& it : res ) {
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			UID gid;
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			uint8_t fileType;
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Version version;
															#line 73 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Standalone<StringRef> filename;
															#line 74 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t offset;
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t length;
															#line 76 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t fullFileLength;
															#line 77 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t logicalSize;
															#line 78 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Optional<BlobGranuleCipherKeysMeta> cipherKeysMeta;
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			std::tie(gid, version, fileType) = decodeBlobGranuleFileKey(it.key);
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(gid == granuleID);
															#line 83 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			std::tie(filename, offset, length, fullFileLength, logicalSize, cipherKeysMeta) = decodeBlobGranuleFileValue(it.value);
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			BlobFileIndex idx( version, filename.toString(), offset, length, fullFileLength, logicalSize, cipherKeysMeta);
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (fileType == 'S')
															#line 422 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(files->snapshotFiles.empty() || files->snapshotFiles.back().version < idx.version);
															#line 90 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				files->snapshotFiles.push_back(idx);
															#line 428 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
			else
			{
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(fileType == 'D');
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(files->deltaFiles.empty() || files->deltaFiles.back().version < idx.version);
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				files->deltaFiles.push_back(idx);
															#line 438 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
		}
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (res.more)
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			*startKey = keyAfter(res.back().key);
															#line 447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 68 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& it : res ) {
															#line 69 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			UID gid;
															#line 70 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			uint8_t fileType;
															#line 71 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Version version;
															#line 73 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Standalone<StringRef> filename;
															#line 74 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t offset;
															#line 75 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t length;
															#line 76 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t fullFileLength;
															#line 77 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			int64_t logicalSize;
															#line 78 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			Optional<BlobGranuleCipherKeysMeta> cipherKeysMeta;
															#line 80 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			std::tie(gid, version, fileType) = decodeBlobGranuleFileKey(it.key);
															#line 81 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(gid == granuleID);
															#line 83 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			std::tie(filename, offset, length, fullFileLength, logicalSize, cipherKeysMeta) = decodeBlobGranuleFileValue(it.value);
															#line 86 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			BlobFileIndex idx( version, filename.toString(), offset, length, fullFileLength, logicalSize, cipherKeysMeta);
															#line 88 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (fileType == 'S')
															#line 489 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 89 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(files->snapshotFiles.empty() || files->snapshotFiles.back().version < idx.version);
															#line 90 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				files->snapshotFiles.push_back(idx);
															#line 495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
			else
			{
															#line 92 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(fileType == 'D');
															#line 93 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				ASSERT(files->deltaFiles.empty() || files->deltaFiles.back().version < idx.version);
															#line 94 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				files->deltaFiles.push_back(idx);
															#line 505 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
		}
															#line 97 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (res.more)
															#line 510 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			*startKey = keyAfter(res.back().key);
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadGranuleFilesActor*>(this)->actor_wait_state > 0) static_cast<ReadGranuleFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadGranuleFilesActor*>(this)->ActorCallback< ReadGranuleFilesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadGranuleFilesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadGranuleFilesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadGranuleFilesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Transaction* tr;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Key* startKey;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Key endKey;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GranuleFiles* files;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	UID granuleID;
															#line 609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via readGranuleFiles()
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class ReadGranuleFilesActor final : public Actor<Void>, public ActorCallback< ReadGranuleFilesActor, 0, RangeResult >, public FastAllocated<ReadGranuleFilesActor>, public ReadGranuleFilesActorState<ReadGranuleFilesActor> {
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<ReadGranuleFilesActor>::operator new;
	using FastAllocated<ReadGranuleFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16512982593654410240UL, 8110724503731191552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadGranuleFilesActor, 0, RangeResult >;
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	ReadGranuleFilesActor(Transaction* const& tr,Key* const& startKey,Key const& endKey,GranuleFiles* const& files,UID const& granuleID) 
															#line 631 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Void>(),
		   ReadGranuleFilesActorState<ReadGranuleFilesActor>(tr, startKey, endKey, files, granuleID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readGranuleFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(161696672104358656UL, 13237169423430932992UL);
		ActorExecutionContextHelper __helper(static_cast<ReadGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readGranuleFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readGranuleFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadGranuleFilesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Void> readGranuleFiles( Transaction* const& tr, Key* const& startKey, Key const& endKey, GranuleFiles* const& files, UID const& granuleID ) {
															#line 63 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Void>(new ReadGranuleFilesActor(tr, startKey, endKey, files, granuleID));
															#line 664 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 105 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

// Wrapper around readGranuleFiles
// Gets all files belonging to the granule with id granule ID
															#line 671 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via loadHistoryFiles()
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class LoadHistoryFilesActor>
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadHistoryFilesActorState {
															#line 678 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadHistoryFilesActorState(Database const& cx,UID const& granuleID) 
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : cx(cx),
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   granuleID(granuleID),
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   range(blobGranuleFileKeyRangeFor(granuleID)),
															#line 110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   startKey(range.begin),
															#line 111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   files(),
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   tr(cx)
															#line 695 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("loadHistoryFiles", reinterpret_cast<unsigned long>(this));

	}
	~LoadHistoryFilesActorState() 
	{
		fdb_probe_actor_destroy("loadHistoryFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			;
															#line 710 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadHistoryFilesActorState();
		static_cast<LoadHistoryFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 116 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readGranuleFiles(&tr, &startKey, range.end, &files, granuleID);
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 749 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadHistoryFilesActor, 0, Void >*>(static_cast<LoadHistoryFilesActor*>(this)));
															#line 754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 778 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadHistoryFilesActor, 1, Void >*>(static_cast<LoadHistoryFilesActor*>(this)));
															#line 783 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadHistoryFilesActor*>(this)->SAV<GranuleFiles>::futures) { (void)(files); this->~LoadHistoryFilesActorState(); static_cast<LoadHistoryFilesActor*>(this)->destroy(); return 0; }
															#line 798 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadHistoryFilesActor*>(this)->SAV< GranuleFiles >::value()) GranuleFiles(std::move(files)); // state_var_RVO
		this->~LoadHistoryFilesActorState();
		static_cast<LoadHistoryFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadHistoryFilesActor*>(this)->SAV<GranuleFiles>::futures) { (void)(files); this->~LoadHistoryFilesActorState(); static_cast<LoadHistoryFilesActor*>(this)->destroy(); return 0; }
															#line 810 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadHistoryFilesActor*>(this)->SAV< GranuleFiles >::value()) GranuleFiles(std::move(files)); // state_var_RVO
		this->~LoadHistoryFilesActorState();
		static_cast<LoadHistoryFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state > 0) static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadHistoryFilesActor*>(this)->ActorCallback< LoadHistoryFilesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadHistoryFilesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadHistoryFilesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadHistoryFilesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state > 0) static_cast<LoadHistoryFilesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadHistoryFilesActor*>(this)->ActorCallback< LoadHistoryFilesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadHistoryFilesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadHistoryFilesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadHistoryFilesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Database cx;
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	UID granuleID;
															#line 109 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange range;
															#line 110 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Key startKey;
															#line 111 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GranuleFiles files;
															#line 112 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Transaction tr;
															#line 992 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via loadHistoryFiles()
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadHistoryFilesActor final : public Actor<GranuleFiles>, public ActorCallback< LoadHistoryFilesActor, 0, Void >, public ActorCallback< LoadHistoryFilesActor, 1, Void >, public FastAllocated<LoadHistoryFilesActor>, public LoadHistoryFilesActorState<LoadHistoryFilesActor> {
															#line 997 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<LoadHistoryFilesActor>::operator new;
	using FastAllocated<LoadHistoryFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17401635469065401600UL, 10222873409491490560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GranuleFiles>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadHistoryFilesActor, 0, Void >;
friend struct ActorCallback< LoadHistoryFilesActor, 1, Void >;
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadHistoryFilesActor(Database const& cx,UID const& granuleID) 
															#line 1015 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<GranuleFiles>(),
		   LoadHistoryFilesActorState<LoadHistoryFilesActor>(cx, granuleID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadHistoryFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853450806983765504UL, 8569546073562004992UL);
		ActorExecutionContextHelper __helper(static_cast<LoadHistoryFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadHistoryFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadHistoryFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadHistoryFilesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadHistoryFilesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<GranuleFiles> loadHistoryFiles( Database const& cx, UID const& granuleID ) {
															#line 108 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<GranuleFiles>(new LoadHistoryFilesActor(cx, granuleID));
															#line 1049 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

															#line 1054 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via getForcePurgedState()
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class GetForcePurgedStateActor>
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetForcePurgedStateActorState {
															#line 1061 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetForcePurgedStateActorState(Transaction* const& tr,KeyRange const& keyRange) 
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : tr(tr),
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   keyRange(keyRange)
															#line 1070 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getForcePurgedState", reinterpret_cast<unsigned long>(this));

	}
	~GetForcePurgedStateActorState() 
	{
		fdb_probe_actor_destroy("getForcePurgedState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(tr, blobGranuleForcePurgedKeys.begin, keyRange, 3, GetRangeLimits::BYTE_LIMIT_UNLIMITED);
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<GetForcePurgedStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1087 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetForcePurgedStateActor*>(this)->actor_wait_state = 1;
															#line 129 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetForcePurgedStateActor, 0, RangeResult >*>(static_cast<GetForcePurgedStateActor*>(this)));
															#line 1092 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetForcePurgedStateActorState();
		static_cast<GetForcePurgedStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(!values.empty());
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (values.size() > 2)
															#line 1117 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(values[0].value != values[1].value);
															#line 135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetForcePurgedStateActor*>(this)->SAV<ForcedPurgeState>::futures) { (void)(ForcedPurgeState::SomePurged); this->~GetForcePurgedStateActorState(); static_cast<GetForcePurgedStateActor*>(this)->destroy(); return 0; }
															#line 1123 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetForcePurgedStateActor*>(this)->SAV< ForcedPurgeState >::value()) ForcedPurgeState(ForcedPurgeState::SomePurged);
			this->~GetForcePurgedStateActorState();
			static_cast<GetForcePurgedStateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetForcePurgedStateActor*>(this)->SAV<ForcedPurgeState>::futures) { (void)(values[0].value == "1"_sr ? ForcedPurgeState::AllPurged : ForcedPurgeState::NonePurged); this->~GetForcePurgedStateActorState(); static_cast<GetForcePurgedStateActor*>(this)->destroy(); return 0; }
															#line 1133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetForcePurgedStateActor*>(this)->SAV< ForcedPurgeState >::value()) ForcedPurgeState(values[0].value == "1"_sr ? ForcedPurgeState::AllPurged : ForcedPurgeState::NonePurged);
			this->~GetForcePurgedStateActorState();
			static_cast<GetForcePurgedStateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(!values.empty());
															#line 133 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (values.size() > 2)
															#line 1148 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 134 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(values[0].value != values[1].value);
															#line 135 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetForcePurgedStateActor*>(this)->SAV<ForcedPurgeState>::futures) { (void)(ForcedPurgeState::SomePurged); this->~GetForcePurgedStateActorState(); static_cast<GetForcePurgedStateActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetForcePurgedStateActor*>(this)->SAV< ForcedPurgeState >::value()) ForcedPurgeState(ForcedPurgeState::SomePurged);
			this->~GetForcePurgedStateActorState();
			static_cast<GetForcePurgedStateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 137 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetForcePurgedStateActor*>(this)->SAV<ForcedPurgeState>::futures) { (void)(values[0].value == "1"_sr ? ForcedPurgeState::AllPurged : ForcedPurgeState::NonePurged); this->~GetForcePurgedStateActorState(); static_cast<GetForcePurgedStateActor*>(this)->destroy(); return 0; }
															#line 1164 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetForcePurgedStateActor*>(this)->SAV< ForcedPurgeState >::value()) ForcedPurgeState(values[0].value == "1"_sr ? ForcedPurgeState::AllPurged : ForcedPurgeState::NonePurged);
			this->~GetForcePurgedStateActorState();
			static_cast<GetForcePurgedStateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetForcePurgedStateActor*>(this)->actor_wait_state > 0) static_cast<GetForcePurgedStateActor*>(this)->actor_wait_state = 0;
		static_cast<GetForcePurgedStateActor*>(this)->ActorCallback< GetForcePurgedStateActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetForcePurgedStateActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetForcePurgedStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetForcePurgedStateActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetForcePurgedStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetForcePurgedStateActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetForcePurgedStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getForcePurgedState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Transaction* tr;
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange keyRange;
															#line 1252 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via getForcePurgedState()
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetForcePurgedStateActor final : public Actor<ForcedPurgeState>, public ActorCallback< GetForcePurgedStateActor, 0, RangeResult >, public FastAllocated<GetForcePurgedStateActor>, public GetForcePurgedStateActorState<GetForcePurgedStateActor> {
															#line 1257 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<GetForcePurgedStateActor>::operator new;
	using FastAllocated<GetForcePurgedStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9997066022624386816UL, 9834922768190814464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ForcedPurgeState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetForcePurgedStateActor, 0, RangeResult >;
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetForcePurgedStateActor(Transaction* const& tr,KeyRange const& keyRange) 
															#line 1274 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<ForcedPurgeState>(),
		   GetForcePurgedStateActorState<GetForcePurgedStateActor>(tr, keyRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getForcePurgedState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(187464819424473600UL, 6012940692475196928UL);
		ActorExecutionContextHelper __helper(static_cast<GetForcePurgedStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getForcePurgedState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getForcePurgedState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetForcePurgedStateActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<ForcedPurgeState> getForcePurgedState( Transaction* const& tr, KeyRange const& keyRange ) {
															#line 127 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<ForcedPurgeState>(new GetForcePurgedStateActor(tr, keyRange));
															#line 1307 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 140 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

// Normally a beginVersion != 0 means the caller wants all mutations between beginVersion and readVersion, instead of
// the latest snapshot before readVersion + deltas after the snapshot. When canCollapse is set, the beginVersion is
// essentially just an optimization hint. The caller is still concerned with reconstructing rows at readVersion, it just
// knows it doesn't need anything before beginVersion.
// Normally this can eliminate the need for a snapshot and just return a small amount of deltas. But in a highly active
// key range, the granule may have a snapshot file at version X, where beginVersion < X <= readVersion. In this case, if
// the number of bytes in delta files between beginVersion and X is larger than the snapshot file at version X, it is
// strictly more efficient (in terms of files and bytes read) to just use the snapshot file at version X instead.
//
// To assist BlobGranule file (snapshot and/or delta) file encryption, the routine while populating snapshot and/or
// delta files, constructs BlobFilePointerRef->cipherKeysMeta field. Approach avoids this method to be defined as an
// ACTOR, as fetching desired EncryptionKey may potentially involve reaching out to EncryptKeyProxy or external KMS.
void GranuleFiles::getFiles(Version beginVersion,
                            Version readVersion,
                            bool canCollapse,
                            BlobGranuleChunkRef& chunk,
                            Arena& replyArena,
                            int64_t& deltaBytesCounter,
                            bool summarize) const {
	BlobFileIndex dummyIndex; // for searching
	ASSERT(!snapshotFiles.empty());
	// if beginVersion == 0 or we can collapse, find the latest snapshot <= readVersion
	auto snapshotF = snapshotFiles.end();
	if (beginVersion == 0 || canCollapse) {
		dummyIndex.version = readVersion;
		snapshotF = std::lower_bound(snapshotFiles.begin(), snapshotFiles.end(), dummyIndex);
		if (snapshotF == snapshotFiles.end() || snapshotF->version > readVersion) {
			ASSERT(snapshotF != snapshotFiles.begin());
			snapshotF--;
		}
		ASSERT(snapshotF != snapshotFiles.end());
		ASSERT(snapshotF->version <= readVersion);
	}

	auto deltaF = deltaFiles.end();
	if (beginVersion > 0) {
		dummyIndex.version = beginVersion;
		deltaF = std::lower_bound(deltaFiles.begin(), deltaFiles.end(), dummyIndex);
		if (canCollapse) {
			ASSERT(snapshotF != snapshotFiles.end());
			// If we can collapse, see if delta files up to snapshotVersion are smaller or larger than snapshotBytes in
			// total
			auto deltaFCopy = deltaF;
			int64_t snapshotBytes = snapshotF->length;
			while (deltaFCopy != deltaFiles.end() && deltaFCopy->version <= snapshotF->version && snapshotBytes > 0) {
				snapshotBytes -= deltaFCopy->length;
				deltaFCopy++;
			}
			// if delta files contain the same or more bytes as the snapshot with collapse, do the collapse
			if (snapshotBytes > 0) {
				// don't collapse, clear snapshotF and just do delta files
				snapshotF = snapshotFiles.end();
			} else {
				// do snapshot instead of previous deltas
				dummyIndex.version = snapshotF->version;
				deltaF = std::upper_bound(deltaFiles.begin(), deltaFiles.end(), dummyIndex);
				ASSERT(deltaF == deltaFiles.end() || deltaF->version > snapshotF->version);
			}
		}
	} else {
		dummyIndex.version = snapshotF->version;
		deltaF = std::upper_bound(deltaFiles.begin(), deltaFiles.end(), dummyIndex);
		ASSERT(deltaF == deltaFiles.end() || deltaF->version > snapshotF->version);
	}

	Version lastIncluded = invalidVersion;
	if (snapshotF != snapshotFiles.end()) {
		chunk.snapshotVersion = snapshotF->version;
		chunk.snapshotFile =
		    BlobFilePointerRef(replyArena,
		                       summarize ? "" : snapshotF->filename,
		                       snapshotF->offset,
		                       snapshotF->length,
		                       snapshotF->fullFileLength,
		                       snapshotF->version,
		                       summarize ? Optional<BlobGranuleCipherKeysMeta>() : snapshotF->cipherKeysMeta);
		lastIncluded = chunk.snapshotVersion;
	} else {
		chunk.snapshotVersion = invalidVersion;
	}

	while (deltaF != deltaFiles.end() && deltaF->version < readVersion) {
		chunk.deltaFiles.emplace_back_deep(replyArena,
		                                   summarize ? "" : deltaF->filename,
		                                   deltaF->offset,
		                                   deltaF->length,
		                                   deltaF->fullFileLength,
		                                   deltaF->version,
		                                   summarize ? Optional<BlobGranuleCipherKeysMeta>() : deltaF->cipherKeysMeta);
		deltaBytesCounter += deltaF->length;
		ASSERT(lastIncluded < deltaF->version);
		lastIncluded = deltaF->version;
		deltaF++;
	}
	// include last delta file that passes readVersion, if it exists
	if (deltaF != deltaFiles.end() &&
	    ((!summarize && lastIncluded < readVersion) || (summarize && deltaF->version == readVersion))) {
		chunk.deltaFiles.emplace_back_deep(replyArena,
		                                   deltaF->filename,
		                                   deltaF->offset,
		                                   deltaF->length,
		                                   deltaF->fullFileLength,
		                                   deltaF->version,
		                                   deltaF->cipherKeysMeta);
		deltaBytesCounter += deltaF->length;
		lastIncluded = deltaF->version;
	}
	chunk.includedVersion = lastIncluded;
}

static std::string makeTestFileName(Version v) {
	return "test" + std::to_string(v);
}

static BlobFileIndex makeTestFile(Version v, int64_t len) {
	return BlobFileIndex(v, makeTestFileName(v), 0, len, len, len);
}

static void checkFile(int expectedVersion, const BlobFilePointerRef& actualFile) {
	ASSERT(makeTestFileName(expectedVersion) == actualFile.filename.toString());
}

static void checkFiles(const GranuleFiles& f,
                       Version beginVersion,
                       Version readVersion,
                       bool canCollapse,
                       Optional<int> expectedSnapshotVersion,
                       std::vector<int> expectedDeltaVersions) {
	Arena a;
	BlobGranuleChunkRef chunk;
	int64_t deltaBytes = 0;
	f.getFiles(beginVersion, readVersion, canCollapse, chunk, a, deltaBytes, false);
	fmt::print("results({0}, {1}, {2}):\nEXPECTED:\n    snapshot={3}\n    deltas ({4}):\n",
	           beginVersion,
	           readVersion,
	           canCollapse ? "T" : "F",
	           expectedSnapshotVersion.present() ? makeTestFileName(expectedSnapshotVersion.get()).c_str() : "<N/A>",
	           expectedDeltaVersions.size());
	for (int d : expectedDeltaVersions) {
		fmt::print("        {}\n", makeTestFileName(d));
	}
	fmt::print("ACTUAL:\n    snapshot={0}\n    deltas ({1}):\n",
	           chunk.snapshotFile.present() ? chunk.snapshotFile.get().filename.toString().c_str() : "<N/A>",
	           chunk.deltaFiles.size());
	for (auto& it : chunk.deltaFiles) {
		fmt::print("        {}\n", it.filename.toString());
	}
	printf("\n\n\n");
	ASSERT(expectedSnapshotVersion.present() == chunk.snapshotFile.present());
	if (expectedSnapshotVersion.present()) {
		checkFile(expectedSnapshotVersion.get(), chunk.snapshotFile.get());
	}
	ASSERT(expectedDeltaVersions.size() == chunk.deltaFiles.size());
	for (int i = 0; i < expectedDeltaVersions.size(); i++) {
		checkFile(expectedDeltaVersions[i], chunk.deltaFiles[i]);
	}
}

/*
 * Files:
 * S @ 100 (10 bytes)
 * D @ 150 (5 bytes)
 * D @ 200 (6 bytes)
 * S @ 200 (15 bytes)
 * D @ 250 (7 bytes)
 * D @ 300 (8 bytes)
 * S @ 300 (10 bytes)
 * D @ 350 (4 bytes)
 */
															#line 1481 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase310()
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class FlowTestCase310Actor>
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class FlowTestCase310ActorState {
															#line 1488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	FlowTestCase310ActorState(UnitTestParameters const& params) 
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : params(params)
															#line 1495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase310", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase310ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase310", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			GranuleFiles files;
															#line 315 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.snapshotFiles.push_back(makeTestFile(100, 10));
															#line 317 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			printf("Just snapshot\n");
															#line 319 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 100, false, 100, {});
															#line 320 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 200, false, 100, {});
															#line 322 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			printf("Small test\n");
															#line 324 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(150, 5));
															#line 325 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(200, 6));
															#line 326 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.snapshotFiles.push_back(makeTestFile(200, 15));
															#line 329 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 100, false, 100, {});
															#line 330 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 101, false, 100, { 150 });
															#line 331 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 149, false, 100, { 150 });
															#line 332 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 150, false, 100, { 150 });
															#line 333 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 151, false, 100, { 150, 200 });
															#line 334 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 199, false, 100, { 150, 200 });
															#line 335 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 200, false, 200, {});
															#line 336 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 300, false, 200, {});
															#line 340 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 200, false, Optional<int>(), { 150, 200 });
															#line 341 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 300, false, Optional<int>(), { 150, 200 });
															#line 342 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 101, 199, false, Optional<int>(), { 150, 200 });
															#line 343 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 149, 151, false, Optional<int>(), { 150, 200 });
															#line 344 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 149, 150, false, Optional<int>(), { 150 });
															#line 345 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 150, 151, false, Optional<int>(), { 150, 200 });
															#line 346 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 200, false, Optional<int>(), { 200 });
															#line 348 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 200, true, Optional<int>(), { 150, 200 });
															#line 349 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 300, true, Optional<int>(), { 150, 200 });
															#line 350 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 101, 199, true, Optional<int>(), { 150, 200 });
															#line 351 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 149, 151, true, Optional<int>(), { 150, 200 });
															#line 352 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 149, 150, true, Optional<int>(), { 150 });
															#line 353 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 150, 151, true, Optional<int>(), { 150, 200 });
															#line 354 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 200, true, Optional<int>(), { 200 });
															#line 356 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			printf("Larger test\n");
															#line 358 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(250, 7));
															#line 359 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(300, 8));
															#line 360 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.snapshotFiles.push_back(makeTestFile(300, 10));
															#line 361 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(350, 4));
															#line 363 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 300, false, 300, {});
															#line 364 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 301, false, 300, { 350 });
															#line 365 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 0, 400, false, 300, { 350 });
															#line 369 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 301, false, Optional<int>(), { 150, 200, 250, 300, 350 });
															#line 370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 300, false, Optional<int>(), { 150, 200, 250, 300 });
															#line 371 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 251, false, Optional<int>(), { 150, 200, 250, 300 });
															#line 372 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 250, false, Optional<int>(), { 150, 200, 250 });
															#line 374 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 300, false, Optional<int>(), { 200, 250, 300 });
															#line 375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 301, false, Optional<int>(), { 200, 250, 300, 350 });
															#line 376 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 400, false, Optional<int>(), { 200, 250, 300, 350 });
															#line 378 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 300, false, Optional<int>(), { 250, 300 });
															#line 379 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 301, false, Optional<int>(), { 250, 300, 350 });
															#line 380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 400, false, Optional<int>(), { 250, 300, 350 });
															#line 382 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 300, false, Optional<int>(), { 300 });
															#line 383 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 301, false, Optional<int>(), { 300, 350 });
															#line 384 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 400, false, Optional<int>(), { 300, 350 });
															#line 385 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 301, 400, false, Optional<int>(), { 350 });
															#line 386 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 351, 400, false, Optional<int>(), {});
															#line 390 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 301, true, 300, { 350 });
															#line 391 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 300, true, 300, {});
															#line 393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 251, true, Optional<int>(), { 150, 200, 250, 300 });
															#line 394 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 100, 250, true, Optional<int>(), { 150, 200, 250 });
															#line 397 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 300, true, 300, {});
															#line 398 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 301, true, 300, { 350 });
															#line 399 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 151, 400, true, 300, { 350 });
															#line 402 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 300, true, 300, {});
															#line 403 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 301, true, 300, { 350 });
															#line 404 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 201, 400, true, 300, { 350 });
															#line 407 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 300, true, Optional<int>(), { 300 });
															#line 408 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 301, true, Optional<int>(), { 300, 350 });
															#line 409 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 251, 400, true, Optional<int>(), { 300, 350 });
															#line 410 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 301, 400, true, Optional<int>(), { 350 });
															#line 411 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkFiles(files, 351, 400, true, Optional<int>(), {});
															#line 413 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<FlowTestCase310Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase310ActorState(); static_cast<FlowTestCase310Actor*>(this)->destroy(); return 0; }
															#line 1648 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<FlowTestCase310Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase310ActorState();
			static_cast<FlowTestCase310Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase310ActorState();
		static_cast<FlowTestCase310Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	UnitTestParameters params;
															#line 1672 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase310()
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class FlowTestCase310Actor final : public Actor<Void>, public FastAllocated<FlowTestCase310Actor>, public FlowTestCase310ActorState<FlowTestCase310Actor> {
															#line 1677 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase310Actor>::operator new;
	using FastAllocated<FlowTestCase310Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15084842715463204608UL, 17608671699727417856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	FlowTestCase310Actor(UnitTestParameters const& params) 
															#line 1693 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase310ActorState<FlowTestCase310Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase310", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7067232702339686144UL, 16456496449529723904UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase310Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase310");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase310", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
static Future<Void> flowTestCase310( UnitTestParameters const& params ) {
															#line 310 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Void>(new FlowTestCase310Actor(params));
															#line 1725 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase310, "/blobgranule/server/common/granulefiles")

#line 415 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

static void checkSummary(const GranuleFiles& f,
                         Version summaryVersion,
                         Version expectedSnapshotVersion,
                         int64_t expectedSnapshotSize,
                         Version expectedDeltaVersion,
                         Version expectedDeltaSize) {
	Arena fileArena, summaryArena;
	BlobGranuleChunkRef chunk;
	int64_t deltaBytes = 0;
	f.getFiles(0, summaryVersion, true, chunk, fileArena, deltaBytes, true);

	BlobGranuleSummaryRef summary = summarizeGranuleChunk(summaryArena, chunk);

	ASSERT(expectedSnapshotVersion == summary.snapshotVersion);
	ASSERT(expectedSnapshotSize == summary.snapshotSize);
	ASSERT(expectedDeltaVersion == summary.deltaVersion);
	ASSERT(expectedDeltaSize == summary.deltaSize);
	ASSERT(deltaBytes == expectedDeltaSize);
}

/*
 * This should technically be in client unit tests but we don't have a unit test there
 * Files:
 * S @ 100 (10 bytes)
 * D @ 150 (5 bytes)
 * D @ 200 (6 bytes)
 */
															#line 1758 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase443()
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class FlowTestCase443Actor>
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class FlowTestCase443ActorState {
															#line 1765 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	FlowTestCase443ActorState(UnitTestParameters const& params) 
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : params(params)
															#line 1772 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase443", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase443ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase443", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 444 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			GranuleFiles files;
															#line 445 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.snapshotFiles.push_back(makeTestFile(100, 10));
															#line 446 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(150, 5));
															#line 447 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			files.deltaFiles.push_back(makeTestFile(200, 6));
															#line 449 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 100, 100, 10, 100, 0);
															#line 450 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 149, 100, 10, 100, 0);
															#line 451 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 150, 100, 10, 150, 5);
															#line 452 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 199, 100, 10, 150, 5);
															#line 453 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 200, 100, 10, 200, 11);
															#line 454 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			checkSummary(files, 700, 100, 10, 200, 11);
															#line 456 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<FlowTestCase443Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase443ActorState(); static_cast<FlowTestCase443Actor*>(this)->destroy(); return 0; }
															#line 1807 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<FlowTestCase443Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase443ActorState();
			static_cast<FlowTestCase443Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase443ActorState();
		static_cast<FlowTestCase443Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	UnitTestParameters params;
															#line 1831 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase443()
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class FlowTestCase443Actor final : public Actor<Void>, public FastAllocated<FlowTestCase443Actor>, public FlowTestCase443ActorState<FlowTestCase443Actor> {
															#line 1836 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase443Actor>::operator new;
	using FastAllocated<FlowTestCase443Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7445538570882073344UL, 16640360730096788224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	FlowTestCase443Actor(UnitTestParameters const& params) 
															#line 1852 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase443ActorState<FlowTestCase443Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase443", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14548518421085425920UL, 14805426602917748480UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase443Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase443");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase443", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
static Future<Void> flowTestCase443( UnitTestParameters const& params ) {
															#line 443 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Void>(new FlowTestCase443Actor(params));
															#line 1884 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase443, "/blobgranule/server/common/granulesummary")

#line 458 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

// FIXME: if credentials can expire, refresh periodically
															#line 1891 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via loadBlobMetadataForTenants()
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class LoadBlobMetadataForTenantsActor>
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBlobMetadataForTenantsActorState {
															#line 1898 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBlobMetadataForTenantsActorState(BGTenantMap* const& self,std::vector<BlobMetadataDomainId> const& tenantsToLoad) 
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : self(self),
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   tenantsToLoad(tenantsToLoad)
															#line 1907 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this));

	}
	~LoadBlobMetadataForTenantsActorState() 
	{
		fdb_probe_actor_destroy("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 461 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(SERVER_KNOBS->BG_METADATA_SOURCE == "tenant");
															#line 462 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(!tenantsToLoad.empty());
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			req = EKPGetLatestBlobMetadataRequest();
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			retrySleep = 0.1;
															#line 465 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			for( const auto tenantId : tenantsToLoad ) {
															#line 466 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				req.domainIds.emplace_back(tenantId);
															#line 1932 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			startTime = now();
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			prevEKPID = UID();
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			requestFuture = Never();
															#line 473 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			;
															#line 1942 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadBlobMetadataForTenantsActorState();
		static_cast<LoadBlobMetadataForTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 475 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (self->dbInfo.isValid() && self->dbInfo->get().client.encryptKeyProxy.present())
															#line 1973 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				if (self->dbInfo->get().client.encryptKeyProxy.get().myId != prevEKPID)
															#line 1977 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				{
															#line 477 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					prevEKPID = self->dbInfo->get().client.encryptKeyProxy.get().myId;
															#line 478 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					req.reply.reset();
															#line 479 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					requestFuture = brokenPromiseToNever( self->dbInfo->get().client.encryptKeyProxy.get().getLatestBlobMetadata.getReply(req));
															#line 1985 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				}
			}
			else
			{
															#line 483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				prevEKPID = UID();
															#line 484 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				requestFuture = Never();
															#line 1994 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
															#line 487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<EKPGetLatestBlobMetadataReply> __when_expr_0 = requestFuture;
															#line 486 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2000 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 2004 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state = 1;
															#line 487 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >*>(static_cast<LoadBlobMetadataForTenantsActor*>(this)));
															#line 531 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >*>(static_cast<LoadBlobMetadataForTenantsActor*>(this)));
															#line 2011 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(retrySleep);
															#line 546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2028 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state = 2;
															#line 546 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >*>(static_cast<LoadBlobMetadataForTenantsActor*>(this)));
															#line 2033 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 537 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 2043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 538 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2047 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			}
															#line 540 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			CODE_PROBE(true, "blob metadata fetch error", probe::decoration::rare);
															#line 541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			TraceEvent(SevWarn, "BlobMetadataFetchError").errorUnsuppressed(e).suppressFor(30.0);
															#line 543 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			prevEKPID = UID();
															#line 544 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			requestFuture = Never();
															#line 2057 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetLatestBlobMetadataReply const& rep,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(rep.blobMetadataDetails.size() <= req.domainIds.size());
															#line 490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& metadata : rep.blobMetadataDetails ) {
															#line 491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			auto info = self->tenantInfoById.find(metadata.domainId);
															#line 492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (info == self->tenantInfoById.end())
															#line 2084 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
				continue;
			}
															#line 495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			auto dataEntry = self->tenantData.rangeContaining(info->second.prefix);
															#line 496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(dataEntry.begin() == info->second.prefix);
															#line 497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			dataEntry.cvalue()->updateBStore(metadata);
															#line 2094 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		double elapsed = now() - startTime;
															#line 500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		BlobCipherMetrics::getInstance()->getBlobMetadataLatency.addMeasurement(elapsed);
															#line 502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (rep.blobMetadataDetails.size() == req.domainIds.size())
															#line 2102 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<LoadBlobMetadataForTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadBlobMetadataForTenantsActorState(); static_cast<LoadBlobMetadataForTenantsActor*>(this)->destroy(); return 0; }
															#line 2106 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<LoadBlobMetadataForTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadBlobMetadataForTenantsActorState();
			static_cast<LoadBlobMetadataForTenantsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		std::unordered_set<BlobMetadataDomainId> missingIds;
															#line 508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& id : req.domainIds ) {
															#line 509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			missingIds.insert(id);
															#line 2118 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& metadata : rep.blobMetadataDetails ) {
															#line 512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			missingIds.erase(metadata.domainId);
															#line 2124 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(missingIds.size() > 0);
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		TraceEvent(SevWarn, "BlobMetadataFetchMissingTenants") .suppressFor(30.0) .detail("Count", missingIds.size());
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		CODE_PROBE(true, "blob metadata fetch missing tenants", probe::decoration::rare);
															#line 521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		req.domainIds.clear();
															#line 522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& id : missingIds ) {
															#line 523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			req.domainIds.push_back(id);
															#line 2138 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		prevEKPID = UID();
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		requestFuture = Never();
															#line 2144 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(EKPGetLatestBlobMetadataReply && rep,int loopDepth) 
	{
															#line 488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(rep.blobMetadataDetails.size() <= req.domainIds.size());
															#line 490 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& metadata : rep.blobMetadataDetails ) {
															#line 491 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			auto info = self->tenantInfoById.find(metadata.domainId);
															#line 492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (info == self->tenantInfoById.end())
															#line 2159 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
				continue;
			}
															#line 495 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			auto dataEntry = self->tenantData.rangeContaining(info->second.prefix);
															#line 496 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			ASSERT(dataEntry.begin() == info->second.prefix);
															#line 497 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			dataEntry.cvalue()->updateBStore(metadata);
															#line 2169 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 499 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		double elapsed = now() - startTime;
															#line 500 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		BlobCipherMetrics::getInstance()->getBlobMetadataLatency.addMeasurement(elapsed);
															#line 502 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (rep.blobMetadataDetails.size() == req.domainIds.size())
															#line 2177 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<LoadBlobMetadataForTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadBlobMetadataForTenantsActorState(); static_cast<LoadBlobMetadataForTenantsActor*>(this)->destroy(); return 0; }
															#line 2181 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<LoadBlobMetadataForTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadBlobMetadataForTenantsActorState();
			static_cast<LoadBlobMetadataForTenantsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		std::unordered_set<BlobMetadataDomainId> missingIds;
															#line 508 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& id : req.domainIds ) {
															#line 509 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			missingIds.insert(id);
															#line 2193 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 511 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& metadata : rep.blobMetadataDetails ) {
															#line 512 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			missingIds.erase(metadata.domainId);
															#line 2199 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 514 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(missingIds.size() > 0);
															#line 516 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		TraceEvent(SevWarn, "BlobMetadataFetchMissingTenants") .suppressFor(30.0) .detail("Count", missingIds.size());
															#line 519 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		CODE_PROBE(true, "blob metadata fetch missing tenants", probe::decoration::rare);
															#line 521 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		req.domainIds.clear();
															#line 522 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		for( auto& id : missingIds ) {
															#line 523 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			req.domainIds.push_back(id);
															#line 2213 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		}
															#line 528 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		prevEKPID = UID();
															#line 529 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		requestFuture = Never();
															#line 2219 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 533 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		retrySleep = 0.1;
															#line 2228 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 533 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		retrySleep = 0.1;
															#line 2237 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state > 0) static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBlobMetadataForTenantsActor*>(this)->ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >::remove();
		static_cast<LoadBlobMetadataForTenantsActor*>(this)->ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >*,EKPGetLatestBlobMetadataReply const& value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >*,EKPGetLatestBlobMetadataReply && value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >*,Error err) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		retrySleep = std::min(10.0, retrySleep * 1.5);
															#line 2380 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		retrySleep = std::min(10.0, retrySleep * 1.5);
															#line 2389 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state > 0) static_cast<LoadBlobMetadataForTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBlobMetadataForTenantsActor*>(this)->ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	BGTenantMap* self;
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	std::vector<BlobMetadataDomainId> tenantsToLoad;
															#line 463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	EKPGetLatestBlobMetadataRequest req;
															#line 464 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	double retrySleep;
															#line 470 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	double startTime;
															#line 471 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	UID prevEKPID;
															#line 472 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Future<EKPGetLatestBlobMetadataReply> requestFuture;
															#line 2483 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via loadBlobMetadataForTenants()
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBlobMetadataForTenantsActor final : public Actor<Void>, public ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >, public ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >, public ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >, public FastAllocated<LoadBlobMetadataForTenantsActor>, public LoadBlobMetadataForTenantsActorState<LoadBlobMetadataForTenantsActor> {
															#line 2488 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<LoadBlobMetadataForTenantsActor>::operator new;
	using FastAllocated<LoadBlobMetadataForTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13513582680694833920UL, 12983773412881187328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >;
friend struct ActorCallback< LoadBlobMetadataForTenantsActor, 1, Void >;
friend struct ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >;
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBlobMetadataForTenantsActor(BGTenantMap* const& self,std::vector<BlobMetadataDomainId> const& tenantsToLoad) 
															#line 2507 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Void>(),
		   LoadBlobMetadataForTenantsActorState<LoadBlobMetadataForTenantsActor>(self, tenantsToLoad),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11041572499332529152UL, 13500544524279404032UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBlobMetadataForTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadBlobMetadataForTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadBlobMetadataForTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadBlobMetadataForTenantsActor, 0, EKPGetLatestBlobMetadataReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadBlobMetadataForTenantsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Void> loadBlobMetadataForTenants( BGTenantMap* const& self, std::vector<BlobMetadataDomainId> const& tenantsToLoad ) {
															#line 460 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Void>(new LoadBlobMetadataForTenantsActor(self, tenantsToLoad));
															#line 2541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 550 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

Future<Void> loadBlobMetadataForTenant(BGTenantMap* self, BlobMetadataDomainId domainId) {
	std::vector<BlobMetadataDomainId> toLoad;
	toLoad.push_back(domainId);
	return loadBlobMetadataForTenants(self, toLoad);
}

// list of tenants that may or may not already exist
void BGTenantMap::addTenants(std::vector<std::pair<int64_t, TenantMapEntry>> tenants) {
	for (auto entry : tenants) {
		if (tenantInfoById.insert({ entry.first, entry.second }).second) {
			auto r = makeReference<GranuleTenantData>(entry.second);
			tenantData.insert(KeyRangeRef(entry.second.prefix, entry.second.prefix.withSuffix(normalKeys.end)), r);
			if (SERVER_KNOBS->BG_METADATA_SOURCE != "tenant") {
				r->startedLoadingBStore = true;
				r->bstoreLoaded.send(Void());
			}
		}
	}
}

// TODO: implement
void BGTenantMap::removeTenants(std::vector<int64_t> tenantIds) {
	throw not_implemented();
}

Optional<TenantMapEntry> BGTenantMap::getTenantById(int64_t id) {
	auto tenant = tenantInfoById.find(id);
	if (tenant == tenantInfoById.end()) {
		return {};
	} else {
		return tenant->second;
	}
}

// FIXME: batch requests for refresh?
// FIXME: don't double fetch if multiple accesses to refreshing/expired metadata
// FIXME: log warning if after refresh, data is still expired!
															#line 2583 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataForGranuleActor()
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class GetDataForGranuleActorActor>
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetDataForGranuleActorActorState {
															#line 2590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetDataForGranuleActorActorState(BGTenantMap* const& self,KeyRange const& keyRange) 
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : self(self),
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   keyRange(keyRange),
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   loopCount(0)
															#line 2601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataForGranuleActor", reinterpret_cast<unsigned long>(this));

	}
	~GetDataForGranuleActorActorState() 
	{
		fdb_probe_actor_destroy("getDataForGranuleActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 590 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			;
															#line 2616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataForGranuleActorActorState();
		static_cast<GetDataForGranuleActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 591 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		loopCount++;
															#line 592 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		auto tenantRange = self->tenantData.rangeContaining(keyRange.begin);
															#line 593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenantRange.begin() <= keyRange.begin);
															#line 594 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenantRange.end() >= keyRange.end);
															#line 595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		tenant = tenantRange.cvalue();
															#line 597 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!tenant.isValid())
															#line 2656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 598 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetDataForGranuleActorActor*>(this)->SAV<Reference<GranuleTenantData>>::futures) { (void)(tenant); this->~GetDataForGranuleActorActorState(); static_cast<GetDataForGranuleActorActor*>(this)->destroy(); return 0; }
															#line 2660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetDataForGranuleActorActor*>(this)->SAV< Reference<GranuleTenantData> >::value()) Reference<GranuleTenantData>(std::move(tenant)); // state_var_RVO
			this->~GetDataForGranuleActorActorState();
			static_cast<GetDataForGranuleActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 599 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!tenant->startedLoadingBStore || (tenant->bstore.isValid() && tenant->bstore->isExpired()))
															#line 2670 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 600 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				tenant->startedLoadingBStore = true;
															#line 601 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				CODE_PROBE(true, "re-fetching expired blob metadata", probe::decoration::rare);
															#line 605 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				Future<Void> loadFuture = loadBlobMetadataForTenant(self, tenant->entry.id);
															#line 606 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				self->addActor.send(loadFuture);
															#line 607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				StrictFuture<Void> __when_expr_0 = loadFuture;
															#line 607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				if (static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2684 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state = 1;
															#line 607 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataForGranuleActorActor, 0, Void >*>(static_cast<GetDataForGranuleActorActor*>(this)));
															#line 2689 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 620 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				if (tenant->bstore.isValid() && tenant->bstore->needsRefresh())
															#line 2696 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				{
															#line 621 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					Future<Void> reload = loadBlobMetadataForTenant(self, tenant->entry.id);
															#line 622 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					self->addActor.send(reload);
															#line 2702 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				}
															#line 624 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				if (!static_cast<GetDataForGranuleActorActor*>(this)->SAV<Reference<GranuleTenantData>>::futures) { (void)(tenant); this->~GetDataForGranuleActorActorState(); static_cast<GetDataForGranuleActorActor*>(this)->destroy(); return 0; }
															#line 2706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				new (&static_cast<GetDataForGranuleActorActor*>(this)->SAV< Reference<GranuleTenantData> >::value()) Reference<GranuleTenantData>(std::move(tenant)); // state_var_RVO
				this->~GetDataForGranuleActorActorState();
				static_cast<GetDataForGranuleActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenant->bstore.isValid());
															#line 610 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!tenant->bstore->isExpired())
															#line 2734 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetDataForGranuleActorActor*>(this)->SAV<Reference<GranuleTenantData>>::futures) { (void)(tenant); this->~GetDataForGranuleActorActorState(); static_cast<GetDataForGranuleActorActor*>(this)->destroy(); return 0; }
															#line 2738 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetDataForGranuleActorActor*>(this)->SAV< Reference<GranuleTenantData> >::value()) Reference<GranuleTenantData>(std::move(tenant)); // state_var_RVO
			this->~GetDataForGranuleActorActorState();
			static_cast<GetDataForGranuleActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (tenant->bstore->isExpired() && loopCount > 1)
															#line 2746 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			TraceEvent(SevWarn, "BlobMetadataStillExpired").suppressFor(5.0).detail("LoopCount", loopCount);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.001);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2754 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state = 2;
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataForGranuleActorActor, 1, Void >*>(static_cast<GetDataForGranuleActorActor*>(this)));
															#line 2759 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 609 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenant->bstore.isValid());
															#line 610 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!tenant->bstore->isExpired())
															#line 2775 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 611 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (!static_cast<GetDataForGranuleActorActor*>(this)->SAV<Reference<GranuleTenantData>>::futures) { (void)(tenant); this->~GetDataForGranuleActorActorState(); static_cast<GetDataForGranuleActorActor*>(this)->destroy(); return 0; }
															#line 2779 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			new (&static_cast<GetDataForGranuleActorActor*>(this)->SAV< Reference<GranuleTenantData> >::value()) Reference<GranuleTenantData>(std::move(tenant)); // state_var_RVO
			this->~GetDataForGranuleActorActorState();
			static_cast<GetDataForGranuleActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 614 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (tenant->bstore->isExpired() && loopCount > 1)
															#line 2787 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 615 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			TraceEvent(SevWarn, "BlobMetadataStillExpired").suppressFor(5.0).detail("LoopCount", loopCount);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.001);
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2795 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state = 2;
															#line 616 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataForGranuleActorActor, 1, Void >*>(static_cast<GetDataForGranuleActorActor*>(this)));
															#line 2800 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state > 0) static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataForGranuleActorActor*>(this)->ActorCallback< GetDataForGranuleActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataForGranuleActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataForGranuleActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataForGranuleActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state > 0) static_cast<GetDataForGranuleActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataForGranuleActorActor*>(this)->ActorCallback< GetDataForGranuleActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataForGranuleActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDataForGranuleActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDataForGranuleActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	BGTenantMap* self;
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange keyRange;
															#line 589 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	int loopCount;
															#line 595 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Reference<GranuleTenantData> tenant;
															#line 2986 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via getDataForGranuleActor()
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class GetDataForGranuleActorActor final : public Actor<Reference<GranuleTenantData>>, public ActorCallback< GetDataForGranuleActorActor, 0, Void >, public ActorCallback< GetDataForGranuleActorActor, 1, Void >, public FastAllocated<GetDataForGranuleActorActor>, public GetDataForGranuleActorActorState<GetDataForGranuleActorActor> {
															#line 2991 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<GetDataForGranuleActorActor>::operator new;
	using FastAllocated<GetDataForGranuleActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11556179176189319424UL, 16570846572855449600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<GranuleTenantData>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataForGranuleActorActor, 0, Void >;
friend struct ActorCallback< GetDataForGranuleActorActor, 1, Void >;
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	GetDataForGranuleActorActor(BGTenantMap* const& self,KeyRange const& keyRange) 
															#line 3009 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Reference<GranuleTenantData>>(),
		   GetDataForGranuleActorActorState<GetDataForGranuleActorActor>(self, keyRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6150635342370901504UL, 14471615250724509184UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataForGranuleActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataForGranuleActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataForGranuleActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataForGranuleActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDataForGranuleActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Reference<GranuleTenantData>> getDataForGranuleActor( BGTenantMap* const& self, KeyRange const& keyRange ) {
															#line 588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Reference<GranuleTenantData>>(new GetDataForGranuleActorActor(self, keyRange));
															#line 3043 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 628 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

// TODO: handle case where tenant isn't loaded yet
Future<Reference<GranuleTenantData>> BGTenantMap::getDataForGranule(const KeyRangeRef& keyRange) {
	return getDataForGranuleActor(this, keyRange);
}

															#line 3053 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via loadBGTenantMap()
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class LoadBGTenantMapActor>
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBGTenantMapActorState {
															#line 3060 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBGTenantMapActorState(BGTenantMap* const& tenantData,Transaction* const& tr) 
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : tenantData(tenantData),
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   tr(tr)
															#line 3069 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("loadBGTenantMap", reinterpret_cast<unsigned long>(this));

	}
	~LoadBGTenantMapActorState() 
	{
		fdb_probe_actor_destroy("loadBGTenantMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			;
															#line 3084 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadBGTenantMapActorState();
		static_cast<LoadBGTenantMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 637 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			tenantResults = KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>();
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(tenantResults, TenantMetadata::tenantMap().getRange(tr, {}, {}, CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER + 1));
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3121 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state = 1;
															#line 639 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadBGTenantMapActor, 0, Void >*>(static_cast<LoadBGTenantMapActor*>(this)));
															#line 3126 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3150 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state = 2;
															#line 646 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBGTenantMapActor, 1, Void >*>(static_cast<LoadBGTenantMapActor*>(this)));
															#line 3155 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenantResults.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER && !tenantResults.more);
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		tenantData->addTenants(tenantResults.results);
															#line 643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		TraceEvent("LoadedBGTenantMap").detail("Size", tenantResults.results.size());
															#line 644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadBGTenantMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadBGTenantMapActorState(); static_cast<LoadBGTenantMapActor*>(this)->destroy(); return 0; }
															#line 3176 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadBGTenantMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadBGTenantMapActorState();
		static_cast<LoadBGTenantMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 641 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		ASSERT(tenantResults.results.size() <= CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER && !tenantResults.more);
															#line 642 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		tenantData->addTenants(tenantResults.results);
															#line 643 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		TraceEvent("LoadedBGTenantMap").detail("Size", tenantResults.results.size());
															#line 644 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadBGTenantMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadBGTenantMapActorState(); static_cast<LoadBGTenantMapActor*>(this)->destroy(); return 0; }
															#line 3194 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadBGTenantMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadBGTenantMapActorState();
		static_cast<LoadBGTenantMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state > 0) static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBGTenantMapActor*>(this)->ActorCallback< LoadBGTenantMapActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBGTenantMapActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBGTenantMapActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadBGTenantMapActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state > 0) static_cast<LoadBGTenantMapActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBGTenantMapActor*>(this)->ActorCallback< LoadBGTenantMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBGTenantMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadBGTenantMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadBGTenantMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	BGTenantMap* tenantData;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Transaction* tr;
															#line 638 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> tenantResults;
															#line 3370 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via loadBGTenantMap()
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBGTenantMapActor final : public Actor<Void>, public ActorCallback< LoadBGTenantMapActor, 0, Void >, public ActorCallback< LoadBGTenantMapActor, 1, Void >, public FastAllocated<LoadBGTenantMapActor>, public LoadBGTenantMapActorState<LoadBGTenantMapActor> {
															#line 3375 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<LoadBGTenantMapActor>::operator new;
	using FastAllocated<LoadBGTenantMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12439821396247035904UL, 14669456382999572480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadBGTenantMapActor, 0, Void >;
friend struct ActorCallback< LoadBGTenantMapActor, 1, Void >;
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBGTenantMapActor(BGTenantMap* const& tenantData,Transaction* const& tr) 
															#line 3393 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Void>(),
		   LoadBGTenantMapActorState<LoadBGTenantMapActor>(tenantData, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadBGTenantMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16927245574860050432UL, 13395812563150391808UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBGTenantMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadBGTenantMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadBGTenantMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadBGTenantMapActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadBGTenantMapActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Void> loadBGTenantMap( BGTenantMap* const& tenantData, Transaction* const& tr ) {
															#line 634 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Void>(new LoadBGTenantMapActor(tenantData, tr));
															#line 3427 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 650 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"

															#line 3432 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
namespace {
// This generated class is to be used only via loadBStoreForTenant()
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
template <class LoadBStoreForTenantActor>
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBStoreForTenantActorState {
															#line 3439 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBStoreForTenantActorState(BGTenantMap* const& tenantData,KeyRange const& keyRange) 
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		 : tenantData(tenantData),
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		   keyRange(keyRange)
															#line 3448 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
	{
		fdb_probe_actor_create("loadBStoreForTenant", reinterpret_cast<unsigned long>(this));

	}
	~LoadBStoreForTenantActorState() 
	{
		fdb_probe_actor_destroy("loadBStoreForTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 652 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (SERVER_KNOBS->BG_METADATA_SOURCE == "tenant")
															#line 3463 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			{
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				retryCount = 0;
															#line 654 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				;
															#line 3469 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 672 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
				if (!SERVER_KNOBS->BG_URL.empty())
															#line 3476 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				{
															#line 673 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					if (!static_cast<LoadBStoreForTenantActor*>(this)->SAV<Reference<BlobConnectionProvider>>::futures) { (void)(BlobConnectionProvider::newBlobConnectionProvider(SERVER_KNOBS->BG_URL)); this->~LoadBStoreForTenantActorState(); static_cast<LoadBStoreForTenantActor*>(this)->destroy(); return 0; }
															#line 3480 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
					new (&static_cast<LoadBStoreForTenantActor*>(this)->SAV< Reference<BlobConnectionProvider> >::value()) Reference<BlobConnectionProvider>(BlobConnectionProvider::newBlobConnectionProvider(SERVER_KNOBS->BG_URL));
					this->~LoadBStoreForTenantActorState();
					static_cast<LoadBStoreForTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 675 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					TraceEvent(SevError, "MissingBlobStoreConfig").detail("KeyRange", keyRange);
															#line 676 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
					return a_body1Catch1(restore_error(), loopDepth);
															#line 3492 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadBStoreForTenantActorState();
		static_cast<LoadBStoreForTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		data = Reference<GranuleTenantData>();
															#line 656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		StrictFuture<Void> __when_expr_0 = store(data, tenantData->getDataForGranule(keyRange));
															#line 656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3527 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 1;
															#line 656 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 0, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3532 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (data.isValid())
															#line 3541 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = data->bstoreLoaded.getFuture();
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3547 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 2;
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 1, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3552 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 662 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			CODE_PROBE(true, "bstore for unknown tenant", probe::decoration::rare);
															#line 666 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			retryCount++;
															#line 667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			TraceEvent(retryCount <= 10 ? SevDebug : SevWarn, "UnknownTenantForGranule") .detail("KeyRange", keyRange);
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.1);
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3567 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 4;
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 3, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3572 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 657 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (data.isValid())
															#line 3582 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		{
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_1 = data->bstoreLoaded.getFuture();
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3588 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 2;
															#line 658 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 1, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3593 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 662 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			CODE_PROBE(true, "bstore for unknown tenant", probe::decoration::rare);
															#line 666 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			retryCount++;
															#line 667 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			TraceEvent(retryCount <= 10 ? SevDebug : SevWarn, "UnknownTenantForGranule") .detail("KeyRange", keyRange);
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.1);
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3608 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 4;
															#line 669 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 3, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3613 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state > 0) static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBStoreForTenantActor*>(this)->ActorCallback< LoadBStoreForTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadBStoreForTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3706 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 3;
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 2, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3711 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0);
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3722 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 3;
															#line 659 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadBStoreForTenantActor, 2, Void >*>(static_cast<LoadBStoreForTenantActor*>(this)));
															#line 3727 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state > 0) static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBStoreForTenantActor*>(this)->ActorCallback< LoadBStoreForTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadBStoreForTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadBStoreForTenantActor*>(this)->SAV<Reference<BlobConnectionProvider>>::futures) { (void)(data->bstore); this->~LoadBStoreForTenantActorState(); static_cast<LoadBStoreForTenantActor*>(this)->destroy(); return 0; }
															#line 3811 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadBStoreForTenantActor*>(this)->SAV< Reference<BlobConnectionProvider> >::value()) Reference<BlobConnectionProvider>(data->bstore);
		this->~LoadBStoreForTenantActorState();
		static_cast<LoadBStoreForTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 660 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
		if (!static_cast<LoadBStoreForTenantActor*>(this)->SAV<Reference<BlobConnectionProvider>>::futures) { (void)(data->bstore); this->~LoadBStoreForTenantActorState(); static_cast<LoadBStoreForTenantActor*>(this)->destroy(); return 0; }
															#line 3823 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		new (&static_cast<LoadBStoreForTenantActor*>(this)->SAV< Reference<BlobConnectionProvider> >::value()) Reference<BlobConnectionProvider>(data->bstore);
		this->~LoadBStoreForTenantActorState();
		static_cast<LoadBStoreForTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state > 0) static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBStoreForTenantActor*>(this)->ActorCallback< LoadBStoreForTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadBStoreForTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state > 0) static_cast<LoadBStoreForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBStoreForTenantActor*>(this)->ActorCallback< LoadBStoreForTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadBStoreForTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadBStoreForTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	BGTenantMap* tenantData;
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	KeyRange keyRange;
															#line 653 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	int retryCount;
															#line 655 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	Reference<GranuleTenantData> data;
															#line 4001 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
};
// This generated class is to be used only via loadBStoreForTenant()
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
class LoadBStoreForTenantActor final : public Actor<Reference<BlobConnectionProvider>>, public ActorCallback< LoadBStoreForTenantActor, 0, Void >, public ActorCallback< LoadBStoreForTenantActor, 1, Void >, public ActorCallback< LoadBStoreForTenantActor, 2, Void >, public ActorCallback< LoadBStoreForTenantActor, 3, Void >, public FastAllocated<LoadBStoreForTenantActor>, public LoadBStoreForTenantActorState<LoadBStoreForTenantActor> {
															#line 4006 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
public:
	using FastAllocated<LoadBStoreForTenantActor>::operator new;
	using FastAllocated<LoadBStoreForTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16822042957831629312UL, 11612869372126684672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<BlobConnectionProvider>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadBStoreForTenantActor, 0, Void >;
friend struct ActorCallback< LoadBStoreForTenantActor, 1, Void >;
friend struct ActorCallback< LoadBStoreForTenantActor, 2, Void >;
friend struct ActorCallback< LoadBStoreForTenantActor, 3, Void >;
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	LoadBStoreForTenantActor(BGTenantMap* const& tenantData,KeyRange const& keyRange) 
															#line 4026 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
		 : Actor<Reference<BlobConnectionProvider>>(),
		   LoadBStoreForTenantActorState<LoadBStoreForTenantActor>(tenantData, keyRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8748814536009531136UL, 16637856522952190464UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBStoreForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadBStoreForTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadBStoreForTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadBStoreForTenantActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadBStoreForTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadBStoreForTenantActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadBStoreForTenantActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
[[nodiscard]] Future<Reference<BlobConnectionProvider>> loadBStoreForTenant( BGTenantMap* const& tenantData, KeyRange const& keyRange ) {
															#line 651 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
	return Future<Reference<BlobConnectionProvider>>(new LoadBStoreForTenantActor(tenantData, keyRange));
															#line 4062 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/build_output/fdbserver/BlobGranuleServerCommon.actor.g.cpp"
}

#line 679 "/codebuild/output/src3820056588/src/github.com/apple/foundationdb/fdbserver/BlobGranuleServerCommon.actor.cpp"
