/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.MappedRangeResultDirectBufferIterator;
import com.apple.foundationdb.RangeResultSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MappedRangeResult {
    final List<MappedKeyValue> values;
    final boolean more;

    public MappedRangeResult(MappedKeyValue[] mappedKeyValueArray, boolean bl) {
        this.values = Arrays.asList(mappedKeyValueArray);
        this.more = bl;
    }

    MappedRangeResult(MappedRangeResultDirectBufferIterator mappedRangeResultDirectBufferIterator) {
        mappedRangeResultDirectBufferIterator.readResultsSummary();
        this.more = mappedRangeResultDirectBufferIterator.hasMore();
        int n = mappedRangeResultDirectBufferIterator.count();
        this.values = new ArrayList<MappedKeyValue>(n);
        for (int i = 0; i < n; ++i) {
            this.values.add(mappedRangeResultDirectBufferIterator.next());
        }
    }

    public RangeResultSummary getSummary() {
        int n = this.values.size();
        byte[] byArray = n > 0 ? this.values.get(n - 1).getKey() : null;
        return new RangeResultSummary(byArray, n, this.more);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MappedRangeResult{");
        stringBuilder.append("values=").append(this.values);
        stringBuilder.append(", more=").append(this.more);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

